/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.util.Format;

public class RuleValidatorWrapper
extends DirtyableComposite
implements SaveEventListener,
EditorWidget {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private VerticalPanel layout = new VerticalPanel();
    private Widget editor;

    public RuleValidatorWrapper(Widget editor) {
        this.editor = editor;
        this.layout.add(editor);
        this.layout.setWidth("100%");
        this.layout.setHeight("100%");
        this.initWidget((Widget)this.layout);
    }

    public static void showBuilderErrors(BuilderResult result) {
        if (result == null || result.getLines() == null || result.getLines().length == 0) {
            FormStylePopup pop = new FormStylePopup();
            pop.setWidth("200px");
            pop.setTitle(constants.ValidationResultsDotDot());
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)new SmallLabel(Format.format((String)"<img src='{0}'/><i>{1}</i>", (String[])new String[]{new Image(images.greenTick()).getUrl(), constants.ItemValidatedSuccessfully()})));
            pop.addRow((Widget)h);
            pop.show();
        } else {
            FormStylePopup pop = new FormStylePopup(images.packageBuilder(), constants.ValidationResults());
            FlexTable errTable = new FlexTable();
            errTable.setStyleName("build-Results");
            for (int i = 0; i < result.getLines().length; ++i) {
                int row = i;
                BuilderResultLine res = result.getLines()[i];
                errTable.setWidget(row, 0, (Widget)new Image(images.error()));
                if (res.assetFormat.equals("package")) {
                    errTable.setText(row, 1, constants.packageConfigurationProblem() + res.message);
                    continue;
                }
                errTable.setText(row, 1, "[" + res.assetName + "] " + res.message);
            }
            ScrollPanel scroll = new ScrollPanel((Widget)errTable);
            scroll.setWidth("100%");
            pop.addRow((Widget)scroll);
            pop.show();
        }
        LoadingPopup.close();
    }

    public void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    public void onAfterSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onAfterSave();
        }
    }
}

