/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.packages.WorkingSetManager;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.VerificationServiceAsync;
import org.drools.guvnor.client.ruleeditor.CheckinPopup;
import org.drools.guvnor.client.ruleeditor.EditorLauncher;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MessageWidget;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.RuleDocumentWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.RuleViewerSettings;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.ruleeditor.WorkingSetSelectorPopup;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.ruleeditor.toolbar.DefaultActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.rulelist.OpenItemCommand;
import org.drools.guvnor.client.util.Format;

public class RuleViewer
extends GuvnorEditor {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private static RuleViewerBinder uiBinder = (RuleViewerBinder)GWT.create(RuleViewerBinder.class);
    @UiField(provided=true)
    final MetaDataWidget metaWidget;
    @UiField(provided=true)
    final RuleDocumentWidget ruleDocumentWidget;
    @UiField(provided=true)
    final Widget editor;
    @UiField(provided=true)
    final ActionToolbar toolbar;
    @UiField
    MessageWidget messageWidget;
    private Command afterCheckinEvent;
    private Command closeCommand;
    private Command archiveCommand;
    public Command checkedInCommand;
    protected RuleAsset asset;
    private boolean readOnly;
    private final RuleViewerSettings ruleViewerSettings;
    private long lastSaved = System.currentTimeMillis();
    private final OpenItemCommand editEvent;
    private ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider;

    public RuleViewer(RuleAsset asset, OpenItemCommand event) {
        this(asset, event, false, null, null);
    }

    public RuleViewer(RuleAsset asset, OpenItemCommand event, boolean historicalReadOnly) {
        this(asset, event, historicalReadOnly, null, null);
    }

    public RuleViewer(RuleAsset asset, OpenItemCommand event, boolean historicalReadOnly, ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider, RuleViewerSettings ruleViewerSettings) {
        this.editEvent = event;
        this.asset = asset;
        this.readOnly = historicalReadOnly && asset.isreadonly;
        this.ruleViewerSettings = ruleViewerSettings == null ? new RuleViewerSettings() : ruleViewerSettings;
        this.actionToolbarButtonsConfigurationProvider = actionToolbarButtonsConfigurationProvider;
        this.ruleDocumentWidget = new RuleDocumentWidget(asset, this.ruleViewerSettings.isDocoVisible());
        this.metaWidget = this.createMetaWidget();
        this.metaWidget.setVisible(this.ruleViewerSettings.isMetaVisible());
        this.editor = EditorLauncher.getEditorViewer((RuleAsset)asset, (RuleViewer)this);
        if (this.editor.getClass().getName().equals("org.drools.guvnor.client.processeditor.BusinessProcessEditor")) {
            this.editor.setWidth("1100px");
            this.editor.setHeight("480px");
        }
        this.toolbar = new ActionToolbar(this.getConfiguration(), asset.metaData.status);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.doWidgets();
        LoadingPopup.close();
    }

    public void setDocoVisible(boolean docoVisible) {
        this.ruleViewerSettings.setDocoVisible(docoVisible);
        this.ruleDocumentWidget.setVisible(docoVisible);
    }

    public void setMetaVisible(boolean metaVisible) {
        this.ruleViewerSettings.setMetaVisible(metaVisible);
        this.metaWidget.setVisible(metaVisible);
    }

    public boolean isDirty() {
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    private ActionToolbarButtonsConfigurationProvider getConfiguration() {
        if (this.actionToolbarButtonsConfigurationProvider == null) {
            return new DefaultActionToolbarButtonsConfigurationProvider(this.asset, (EditorWidget)this.editor);
        }
        return this.actionToolbarButtonsConfigurationProvider;
    }

    private void doWidgets() {
        if (this.readOnly || this.asset.isreadonly) {
            this.toolbar.setVisible(false);
        } else {
            this.toolbar.setPromtToGlobalCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setDeleteCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setCopyCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setArchiveCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.afterCheckinEvent = new /* Unavailable Anonymous Inner Class!! */;
            this.toolbar.setSelectWorkingSetsCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setViewSourceCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setVerifyCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setValidateCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setSaveChangesCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setSaveChangesAndCloseCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.setChangeStatusCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void showStatusChanger() {
        StatusChangePopup pop = new StatusChangePopup(this.asset.uuid, false);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void verifyAndDoCheckinConfirm(boolean closeAfter) {
        if (this.editor instanceof RuleModeller) {
            ((RuleModeller)this.editor).verifyRule((Command)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.doCheckinConfirm(closeAfter);
        }
    }

    protected void doCheckinConfirm(boolean closeAfter) {
        CheckinPopup pop = new CheckinPopup(this.constants.CheckInChanges());
        pop.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    public void doCheckin(String comment) {
        if (this.editor instanceof SaveEventListener) {
            ((SaveEventListener)this.editor).onSave();
        }
        this.performCheckIn(comment);
        if (this.editor instanceof SaveEventListener) {
            ((SaveEventListener)this.editor).onAfterSave();
        }
        if (this.checkedInCommand != null) {
            this.checkedInCommand.execute();
        }
        this.lastSaved = System.currentTimeMillis();
        this.resetDirty();
    }

    private void doVerify() {
        this.onSave();
        LoadingPopup.showMessage((String)this.constants.VerifyingItemPleaseWait());
        Set activeWorkingSets = null;
        activeWorkingSets = WorkingSetManager.getInstance().getActiveAssetUUIDs(this.asset.metaData.packageName);
        VerificationServiceAsync verificationService = (VerificationServiceAsync)GWT.create(VerificationService.class);
        verificationService.verifyAsset(this.asset, activeWorkingSets, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showSource(String src) {
        PackageBuilderWidget.showSource((String)src, (String)this.asset.metaData.name);
        LoadingPopup.close();
    }

    private void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    protected void showWorkingSetsSelection(RuleModeller modeller) {
        new WorkingSetSelectorPopup(modeller, this.asset).show();
    }

    private MetaDataWidget createMetaWidget() {
        return new MetaDataWidget(this.asset.metaData, this.readOnly, this.asset.uuid, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean hasDirty() {
        return false;
    }

    private void close() {
        this.closeCommand.execute();
    }

    void doDelete() {
        this.readOnly = true;
        RepositoryServiceFactory.getService().deleteUncheckedRule(this.asset.uuid, this.asset.metaData.packageName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doArchive() {
        RepositoryServiceFactory.getService().archiveAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void performCheckIn(String comment) {
        this.asset.metaData.checkinComment = comment;
        boolean[] saved = new boolean[]{false};
        if (!saved[0]) {
            LoadingPopup.showMessage((String)this.constants.SavingPleaseWait());
        }
        RepositoryServiceFactory.getService().checkinVersion(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showInfoMessage(String message) {
        this.messageWidget.showMessage(message);
    }

    public void flushSuggestionCompletionCache() {
        if (AssetFormats.isPackageDependency((String)this.asset.metaData.format)) {
            LoadingPopup.showMessage((String)this.constants.RefreshingContentAssistance());
            SuggestionCompletionCache.getInstance().refreshPackage(this.asset.metaData.packageName, (Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void refreshDataAndView() {
        LoadingPopup.showMessage((String)this.constants.RefreshingItem());
        RepositoryServiceFactory.getService().loadRuleAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshMetaWidgetOnly() {
        this.refreshMetaWidgetOnly(true);
    }

    private void refreshMetaWidgetOnly(boolean showBusy) {
        if (showBusy) {
            LoadingPopup.showMessage((String)this.constants.RefreshingItem());
        }
        RepositoryServiceFactory.getService().loadRuleAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCloseCommand(Command c) {
        this.closeCommand = c;
    }

    public void setCheckedInCommand(Command c) {
        this.checkedInCommand = c;
    }

    public void setArchiveCommand(Command c) {
        this.archiveCommand = c;
    }

    protected void doCloseUnsavedWarning() {
        FormStylePopup pop = new FormStylePopup(images.warningLarge(), this.constants.WARNINGUnCommittedChanges());
        Button dis = new Button(this.constants.Discard());
        Button can = new Button(this.constants.Cancel());
        HorizontalPanel hor = new HorizontalPanel();
        hor.add((Widget)dis);
        hor.add((Widget)can);
        pop.addRow((Widget)new HTML(this.constants.AreYouSureYouWantToDiscardChanges()));
        pop.addRow((Widget)hor);
        dis.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        can.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doCopy() {
        FormStylePopup form = new FormStylePopup(images.ruleAsset(), this.constants.CopyThisItem());
        TextBox newName = new TextBox();
        form.addAttribute(this.constants.NewName(), (Widget)newName);
        RulePackageSelector sel = new RulePackageSelector();
        form.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.CreateCopy());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute("", (Widget)ok);
        form.show();
    }

    private void completedCopying(String name, String pkg, String newAssetUUID) {
        Window.alert((String)Format.format((String)this.constants.CreatedANewItemSuccess(), (String[])new String[]{name, pkg}));
        if (this.editEvent != null) {
            this.editEvent.open(newAssetUUID);
        }
    }

    private void doPromptToGlobal() {
        if (this.asset.metaData.packageName.equals("globalArea")) {
            Window.alert((String)this.constants.ItemAlreadyInGlobalArea());
            return;
        }
        if (Window.confirm((String)this.constants.PromoteAreYouSure())) {
            RepositoryServiceFactory.getService().promoteAssetToGlobalArea(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ void access$000(RuleViewer x0) {
        x0.doPromptToGlobal();
    }

    static /* synthetic */ void access$100(RuleViewer x0) {
        x0.doCopy();
    }

    static /* synthetic */ void access$200(RuleViewer x0) {
        x0.doArchive();
    }

    static /* synthetic */ void access$300(RuleViewer x0) {
        x0.onSave();
    }

    static /* synthetic */ Constants access$400(RuleViewer x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$500(RuleViewer x0, String x1) {
        x0.showSource(x1);
    }

    static /* synthetic */ void access$600(RuleViewer x0) {
        x0.doVerify();
    }

    static /* synthetic */ void access$700(RuleViewer x0) {
        x0.showStatusChanger();
    }

    static /* synthetic */ Command access$800(RuleViewer x0) {
        return x0.afterCheckinEvent;
    }

    static /* synthetic */ void access$900(RuleViewer x0) {
        x0.close();
    }

    static /* synthetic */ Images access$1000() {
        return images;
    }

    static /* synthetic */ Command access$1100(RuleViewer x0) {
        return x0.archiveCommand;
    }

    static /* synthetic */ void access$1200(RuleViewer x0, boolean x1) {
        x0.refreshMetaWidgetOnly(x1);
    }

    static /* synthetic */ void access$1300(RuleViewer x0) {
        x0.doWidgets();
    }

    static /* synthetic */ void access$1400(RuleViewer x0, String x1, String x2, String x3) {
        x0.completedCopying(x1, x2, x3);
    }
}

