/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rulefloweditor;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.drools.guvnor.client.rulefloweditor.ActionNode;
import org.drools.guvnor.client.rulefloweditor.CompositeNode;
import org.drools.guvnor.client.rulefloweditor.DefaultWorkItemNode;
import org.drools.guvnor.client.rulefloweditor.ElementContainerNode;
import org.drools.guvnor.client.rulefloweditor.ElementContainerTransferNode;
import org.drools.guvnor.client.rulefloweditor.EmailNode;
import org.drools.guvnor.client.rulefloweditor.EndNode;
import org.drools.guvnor.client.rulefloweditor.EventNode;
import org.drools.guvnor.client.rulefloweditor.FaultNode;
import org.drools.guvnor.client.rulefloweditor.ForEachNode;
import org.drools.guvnor.client.rulefloweditor.HumanTaskNode;
import org.drools.guvnor.client.rulefloweditor.HumanTaskTransferNode;
import org.drools.guvnor.client.rulefloweditor.JoinNode;
import org.drools.guvnor.client.rulefloweditor.LogNode;
import org.drools.guvnor.client.rulefloweditor.MileStoneNode;
import org.drools.guvnor.client.rulefloweditor.RuleFlowBaseNode;
import org.drools.guvnor.client.rulefloweditor.RuleFlowConnectionFactory;
import org.drools.guvnor.client.rulefloweditor.RuleFlowNodeFactory;
import org.drools.guvnor.client.rulefloweditor.RuleFlowRoundPanel;
import org.drools.guvnor.client.rulefloweditor.RuleFlowRoundedPanel;
import org.drools.guvnor.client.rulefloweditor.RuleSetNode;
import org.drools.guvnor.client.rulefloweditor.SplitNode;
import org.drools.guvnor.client.rulefloweditor.SplitTransferNode;
import org.drools.guvnor.client.rulefloweditor.StartNode;
import org.drools.guvnor.client.rulefloweditor.SubProcessNode;
import org.drools.guvnor.client.rulefloweditor.TimerNode;
import org.drools.guvnor.client.rulefloweditor.TransferConnection;
import org.drools.guvnor.client.rulefloweditor.TransferNode;
import org.drools.guvnor.client.rulefloweditor.WorkItemTransferNode;
import pl.balon.gwt.diagrams.client.connection.Connection;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuleFlowNodeFactory {
    public static RuleFlowBaseNode createNode(TransferNode tn) {
        StartNode n;
        if (tn.getType() == TransferNode.Type.START) {
            n = new StartNode();
        } else if (tn.getType() == TransferNode.Type.HUMANTASK) {
            n = RuleFlowNodeFactory.createHumanTask((HumanTaskTransferNode)((HumanTaskTransferNode)tn));
        } else if (tn.getType() == TransferNode.Type.JOIN) {
            n = new JoinNode();
        } else if (tn.getType() == TransferNode.Type.SUB_PROCESS) {
            n = new SubProcessNode();
        } else if (tn.getType() == TransferNode.Type.MILESTONE) {
            n = new MileStoneNode();
        } else if (tn.getType() == TransferNode.Type.TIMER) {
            n = new TimerNode();
        } else if (tn.getType() == TransferNode.Type.ACTION_NODE) {
            n = new ActionNode();
        } else if (tn.getType() == TransferNode.Type.WORK_ITEM) {
            n = RuleFlowNodeFactory.createWorkItemNode((WorkItemTransferNode)((WorkItemTransferNode)tn));
        } else if (tn.getType() == TransferNode.Type.RULESET) {
            n = new RuleSetNode();
        } else if (tn.getType() == TransferNode.Type.SPLIT) {
            n = RuleFlowNodeFactory.createSplit((SplitTransferNode)((SplitTransferNode)tn));
        } else if (tn.getType() == TransferNode.Type.FOR_EACH) {
            n = RuleFlowNodeFactory.createElementContainerNode((ElementContainerNode)new ForEachNode(), (ElementContainerTransferNode)((ElementContainerTransferNode)tn));
        } else if (tn.getType() == TransferNode.Type.FAULT) {
            n = new FaultNode();
        } else if (tn.getType() == TransferNode.Type.EVENT) {
            n = new EventNode();
        } else if (tn.getType() == TransferNode.Type.COMPOSITE) {
            n = RuleFlowNodeFactory.createElementContainerNode((ElementContainerNode)new CompositeNode(), (ElementContainerTransferNode)((ElementContainerTransferNode)tn));
        } else if (tn.getType() == TransferNode.Type.END) {
            n = new EndNode();
        } else {
            throw new IllegalArgumentException("Unkown node type " + tn);
        }
        RuleFlowNodeFactory.fillRuleFlowBaseNode((RuleFlowBaseNode)n, (TransferNode)tn);
        return n;
    }

    private static RuleFlowBaseNode createElementContainerNode(ElementContainerNode node, ElementContainerTransferNode tn) {
        for (TransferNode subNode : tn.getContentModel().getNodes()) {
            RuleFlowBaseNode baseNode = RuleFlowNodeFactory.createNode((TransferNode)subNode);
            node.getNodes().put(baseNode.getId(), baseNode);
        }
        for (TransferConnection c : tn.getContentModel().getConnections()) {
            try {
                node.getConnections().add(RuleFlowConnectionFactory.createConnection((TransferConnection)c, (Map)node.getNodes()));
            }
            catch (RuntimeException e) {}
        }
        return node;
    }

    private static RuleFlowBaseNode createWorkItemNode(WorkItemTransferNode node) {
        Object workItemNode = null;
        workItemNode = node.getWorkName().equals("Email") ? new EmailNode() : (node.getWorkName().equals("Log") ? new LogNode() : new DefaultWorkItemNode());
        workItemNode.setAttributes(node.getParameters());
        return workItemNode;
    }

    private static RuleFlowBaseNode createSplit(SplitTransferNode tn) {
        SplitNode splitNode = new SplitNode();
        splitNode.type = tn.getSplitType();
        splitNode.constraints = tn.getConstraints();
        return splitNode;
    }

    private static RuleFlowBaseNode createHumanTask(HumanTaskTransferNode node) {
        HumanTaskNode n = new HumanTaskNode();
        n.setAttributes(node.getParameters());
        return n;
    }

    private static void fillRuleFlowBaseNode(RuleFlowBaseNode node, TransferNode tn) {
        RuleFlowNodeFactory.fillIdAndCoordinates((RuleFlowBaseNode)node, (TransferNode)tn);
        Widget panel = node.getImagePath() == null ? RuleFlowNodeFactory.createContentWithoutImage((String)tn.getName(), (RuleFlowBaseNode)node, (int)tn.getWidth()) : RuleFlowNodeFactory.createContentWithImage((String)tn.getName(), (RuleFlowBaseNode)node, (int)tn.getWidth());
        if (node.getCorners() == RuleFlowBaseNode.Corners.ROUNDED) {
            int cornerHeight = LayoutCalculator.calculateCornerHeight((int)tn.getWidth());
            panel.setHeight(LayoutCalculator.calculateNodeHeight((int)tn.getHeight(), (int)cornerHeight) + "px");
            RuleFlowRoundedPanel rp = new RuleFlowRoundedPanel(15, 8);
            rp.setTopAndBottomRowColor("Black");
            rp.setCornerStyleName(node.getStyle());
            rp.add(panel);
            node.add((Widget)rp);
        } else if (node.getCorners() == RuleFlowBaseNode.Corners.ROUND) {
            int cornerHeight = LayoutCalculator.calculateRoundCornerHeight((int)tn.getWidth());
            panel.setHeight("1px");
            RuleFlowRoundPanel rp = new RuleFlowRoundPanel(cornerHeight);
            rp.setTopAndBottomRowColor("Black");
            rp.setCornerStyleName(node.getStyle());
            rp.add(panel);
            node.add((Widget)rp);
        } else {
            panel.setHeight(tn.getHeight() + "px");
            if (node instanceof ElementContainerNode) {
                AbsolutePanel ap = new AbsolutePanel();
                ElementContainerNode fen = (ElementContainerNode)node;
                for (RuleFlowBaseNode baseNode : fen.getNodes().values()) {
                    ap.add((Widget)baseNode, baseNode.getX(), baseNode.getY());
                }
                for (Connection c : fen.getConnections()) {
                    c.appendTo(ap);
                }
                ap.add(panel);
                node.add((Widget)ap);
            } else {
                node.add(panel);
            }
        }
    }

    private static Widget createContentWithoutImage(String name, RuleFlowBaseNode node, int width) {
        Label label = new Label(name);
        label.setStyleName(node.getStyle());
        label.setWidth(width + "px");
        return label;
    }

    private static Widget createContentWithImage(String name, RuleFlowBaseNode node, int width) {
        Label label = new Label(name);
        Image image = new Image();
        image.setStyleName("ruleflow-image");
        image.setResource(node.getImagePath());
        HorizontalPanel panel = new HorizontalPanel();
        panel.setStyleName(node.getStyle());
        panel.add((Widget)image);
        panel.add((Widget)label);
        panel.setWidth(width + "px");
        return panel;
    }

    protected static void fillIdAndCoordinates(RuleFlowBaseNode node, TransferNode tn) {
        node.addClickHandler((ClickHandler)node);
        node.setId(tn.getId());
        node.setX(tn.getX());
        node.setY(tn.getY());
    }
}

