/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rulelist;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.ruleeditor.MultiViewRow;
import org.drools.guvnor.client.rulelist.AssetTable;
import org.drools.guvnor.client.rulelist.OpenItemCommand;
import org.drools.guvnor.client.table.ColumnPicker;
import org.drools.guvnor.client.table.SelectionColumn;
import org.drools.guvnor.client.table.SortableHeader;
import org.drools.guvnor.client.table.SortableHeaderGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetTable
extends Composite {
    private static final Constants constants = (Constants)GWT.create(Constants.class);
    private static AssetTableBinder uiBinder = (AssetTableBinder)GWT.create(AssetTableBinder.class);
    private RepositoryServiceAsync repositoryService = RepositoryServiceFactory.getService();
    private final String packageUuid;
    private final List<String> formatInList;
    private final Boolean formatIsRegistered;
    private final OpenItemCommand editEvent;
    private int pageSize = 25;
    private String feedURL;
    private Set<Command> unloadListenerSet = new HashSet();
    @UiField(provided=true)
    ToggleButton columnPickerButton;
    @UiField
    Image feedImage;
    @UiField(provided=true)
    CellTable<AssetPageRow> cellTable;
    private AsyncDataProvider<AssetPageRow> dataProvider;
    @UiField(provided=true)
    SimplePager pager;
    private MultiSelectionModel<AssetPageRow> selectionModel;

    public AssetTable(String packageUuid, List<String> formatInList, Boolean formatIsRegistered, OpenItemCommand event) {
        this(packageUuid, formatInList, formatIsRegistered, event, null);
    }

    public AssetTable(String packageUuid, List<String> formatInList, Boolean formatIsRegistered, OpenItemCommand event, String feedURL) {
        this.packageUuid = packageUuid;
        this.formatInList = formatInList;
        this.formatIsRegistered = formatIsRegistered;
        this.editEvent = event;
        this.feedURL = feedURL;
        this.doCellTable();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (feedURL == null) {
            this.feedImage.setVisible(false);
        }
    }

    private void doCellTable() {
        1 providesKey = new /* Unavailable Anonymous Inner Class!! */;
        this.cellTable = new CellTable((ProvidesKey)providesKey);
        this.selectionModel = new MultiSelectionModel((ProvidesKey)providesKey);
        this.cellTable.setSelectionModel((SelectionModel)this.selectionModel);
        SelectionColumn.createAndAddSelectionColumn((CellTable)this.cellTable);
        ColumnPicker columnPicker = new ColumnPicker(this.cellTable);
        SortableHeaderGroup sortableHeaderGroup = new SortableHeaderGroup(this.cellTable);
        2 uuidNumberColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)uuidNumberColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.uuid(), (Column)uuidNumberColumn), false);
        3 formatColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)formatColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.Format(), (Column)formatColumn), true);
        4 packageNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)packageNameColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.PackageName(), (Column)packageNameColumn), false);
        5 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)nameColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.Name(), (Column)nameColumn), true);
        6 descriptionColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)descriptionColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.Description(), (Column)descriptionColumn), true);
        7 stateNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)stateNameColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.Status(), (Column)stateNameColumn), true);
        8 creatorColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)creatorColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.Creator(), (Column)creatorColumn), false);
        9 createdDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)createdDateColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.CreatedDate(), (Column)createdDateColumn), false);
        10 lastContributorColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)lastContributorColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.LastContributor(), (Column)lastContributorColumn), false);
        11 lastModifiedColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)lastModifiedColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.LastModified(), (Column)lastModifiedColumn), true);
        12 categorySummaryColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)categorySummaryColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.Categories(), (Column)categorySummaryColumn), false);
        13 externalSourceColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)externalSourceColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.ExternalSource(), (Column)externalSourceColumn), false);
        14 openColumn = new /* Unavailable Anonymous Inner Class!! */;
        openColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        columnPicker.addColumn((Column)openColumn, (Header)new TextHeader(constants.Open()), true);
        this.cellTable.setPageSize(this.pageSize);
        this.cellTable.setWidth("100%");
        this.pager = new SimplePager();
        this.pager.setDisplay((HasRows)this.cellTable);
        this.dataProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.dataProvider.addDataDisplay((HasData)this.cellTable);
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    @UiHandler(value={"feedImage"})
    void openFeed(ClickEvent e) {
        Window.open((String)this.feedURL, (String)"_blank", null);
    }

    @UiHandler(value={"refreshButton"})
    void refresh(ClickEvent e) {
        this.refresh();
    }

    @UiHandler(value={"openSelectedButton"})
    void openSelected(ClickEvent e) {
        Set selectedSet = this.selectionModel.getSelectedSet();
        for (AssetPageRow selected : selectedSet) {
            this.editEvent.open(selected.getUuid());
        }
    }

    @UiHandler(value={"openSelectedToSingleTabButton"})
    public void openSelectedToSingleTab(ClickEvent e) {
        Set selectedSet = this.selectionModel.getSelectedSet();
        ArrayList<MultiViewRow> multiViewRowList = new ArrayList<MultiViewRow>(selectedSet.size());
        for (AssetPageRow selected : selectedSet) {
            MultiViewRow row = new MultiViewRow();
            row.uuid = selected.getUuid();
            row.format = selected.getFormat();
            row.name = selected.getName();
            multiViewRowList.add(row);
        }
        this.editEvent.open(multiViewRowList.toArray(new MultiViewRow[multiViewRowList.size()]));
    }

    public void refresh() {
        this.cellTable.setVisibleRangeAndClearData(this.cellTable.getVisibleRange(), true);
    }

    public void addUnloadListener(Command unloadListener) {
        this.unloadListenerSet.add(unloadListener);
    }

    protected void onUnload() {
        super.onUnload();
        for (Command unloadListener : this.unloadListenerSet) {
            unloadListener.execute();
        }
    }

    static /* synthetic */ Constants access$000() {
        return constants;
    }

    static /* synthetic */ OpenItemCommand access$100(AssetTable x0) {
        return x0.editEvent;
    }

    static /* synthetic */ String access$200(AssetTable x0) {
        return x0.packageUuid;
    }

    static /* synthetic */ List access$300(AssetTable x0) {
        return x0.formatInList;
    }

    static /* synthetic */ Boolean access$400(AssetTable x0) {
        return x0.formatIsRegistered;
    }

    static /* synthetic */ int access$500(AssetTable x0) {
        return x0.pageSize;
    }

    static /* synthetic */ RepositoryServiceAsync access$600(AssetTable x0) {
        return x0.repositoryService;
    }
}

