/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.admin.ArchivedAssetManager;
import org.drools.guvnor.client.admin.BackupManager;
import org.drools.guvnor.client.admin.CategoryManager;
import org.drools.guvnor.client.admin.LogViewer;
import org.drools.guvnor.client.admin.PermissionViewer;
import org.drools.guvnor.client.admin.RepoConfigManager;
import org.drools.guvnor.client.admin.RuleVerifierManager;
import org.drools.guvnor.client.admin.StateManager;
import org.drools.guvnor.client.admin.WorkspaceManager;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.qa.AnalysisView;
import org.drools.guvnor.client.qa.ScenarioPackageView;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.ruleeditor.MultiViewEditor;
import org.drools.guvnor.client.ruleeditor.MultiViewRow;
import org.drools.guvnor.client.rulelist.AssetItemGrid;
import org.drools.guvnor.client.rulelist.AssetItemGridDataLoader;
import org.drools.guvnor.client.rulelist.AssetTable;
import org.drools.guvnor.client.rulelist.OpenItemCommand;
import org.drools.guvnor.client.rulelist.QueryWidget;
import org.drools.guvnor.client.util.Format;
import org.drools.guvnor.client.util.TabOpener;
import org.drools.guvnor.client.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabOpener {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private static final String REPOCONFIG = "repoconfig";
    private static final String RULE_VERIFIER_MANAGER = "ruleVerifierManager";
    private static final String SECURITY_PERMISSIONS = "securityPermissions";
    private static final String ERROR_LOG = "errorLog";
    private static final String BAKMAN = "bakman";
    private static final String STATEMAN = "stateman";
    private static final String ARCHMAN = "archman";
    private static final String CATMAN = "catman";
    private static final String WORKSPACES = "workspaces";
    private final ExplorerViewCenterPanel explorerViewCenterPanel;
    private static TabOpener instance;

    private TabOpener(ExplorerViewCenterPanel explorerViewCenterPanel) {
        this.explorerViewCenterPanel = explorerViewCenterPanel;
    }

    public static void initIstance(ExplorerViewCenterPanel centertabbedPanel) {
        instance = new TabOpener(centertabbedPanel);
    }

    public static TabOpener getInstance() {
        return instance;
    }

    public void openAsset(String uuid) {
        if (uuid.contains("<")) {
            return;
        }
        History.newItem((String)("asset=" + uuid));
        if (!this.explorerViewCenterPanel.showIfOpen(uuid)) {
            boolean[] loading = new boolean[]{true};
            1 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(200);
            this.loadRuleAsset(uuid, loading);
        }
    }

    private void loadRuleAsset(String uuid, boolean[] loading) {
        RepositoryServiceFactory.getService().loadRuleAsset(uuid, (AsyncCallback)this.createGenericCallback(uuid, loading));
    }

    private GenericCallback<RuleAsset> createGenericCallback(String uuid, boolean[] loading) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void openAssetsToMultiView(MultiViewRow[] rows) {
        String blockingAssetName = null;
        String[] uuids = new String[rows.length];
        Object[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            if (this.explorerViewCenterPanel.showIfOpen(rows[i].uuid)) {
                blockingAssetName = rows[i].name;
                break;
            }
            uuids[i] = rows[i].uuid;
            names[i] = rows[i].name;
        }
        if (blockingAssetName != null) {
            FormStylePopup popup = new FormStylePopup(images.information(), Format.format((String)this.constants.Asset0IsAlreadyOpenPleaseCloseItBeforeOpeningMultiview(), (String[])new String[]{blockingAssetName}));
            popup.show();
            return;
        }
        MultiViewEditor multiview = new MultiViewEditor(rows, (OpenItemCommand)new /* Unavailable Anonymous Inner Class!! */);
        multiview.setCloseCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.explorerViewCenterPanel.addTab(Arrays.toString(names), (Widget)multiview, uuids);
    }

    public void openPackageEditor(String uuid, Command refPackageList) {
        if (!this.explorerViewCenterPanel.showIfOpen(uuid)) {
            LoadingPopup.showMessage((String)this.constants.LoadingPackageInformation());
            RepositoryServiceFactory.getService().loadPackageConfig(uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openFind() {
        if (!this.explorerViewCenterPanel.showIfOpen("FIND")) {
            this.explorerViewCenterPanel.addTab(this.constants.Find(), (Widget)new QueryWidget((OpenItemCommand)new /* Unavailable Anonymous Inner Class!! */), "FIND");
        }
    }

    public void openSnapshot(SnapshotInfo snap) {
        if (!this.explorerViewCenterPanel.showIfOpen(snap.name + snap.uuid)) {
            LoadingPopup.showMessage((String)this.constants.LoadingSnapshot());
            RepositoryServiceFactory.getService().loadPackageConfig(snap.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openAdministrationSelection(int id) {
        switch (id) {
            case 0: {
                if (this.explorerViewCenterPanel.showIfOpen(CATMAN)) break;
                this.explorerViewCenterPanel.addTab(this.constants.CategoryManager(), (Widget)new CategoryManager(), CATMAN);
                break;
            }
            case 1: {
                if (this.explorerViewCenterPanel.showIfOpen(ARCHMAN)) break;
                this.explorerViewCenterPanel.addTab(this.constants.ArchivedManager(), (Widget)new ArchivedAssetManager(), ARCHMAN);
                break;
            }
            case 2: {
                if (this.explorerViewCenterPanel.showIfOpen(STATEMAN)) break;
                this.explorerViewCenterPanel.addTab(this.constants.StateManager(), (Widget)new StateManager(), STATEMAN);
                break;
            }
            case 3: {
                if (this.explorerViewCenterPanel.showIfOpen(BAKMAN)) break;
                this.explorerViewCenterPanel.addTab(this.constants.ImportExport(), (Widget)new BackupManager(), BAKMAN);
                break;
            }
            case 4: {
                if (this.explorerViewCenterPanel.showIfOpen(ERROR_LOG)) break;
                this.explorerViewCenterPanel.addTab(this.constants.EventLog(), (Widget)new LogViewer(), ERROR_LOG);
                break;
            }
            case 5: {
                if (this.explorerViewCenterPanel.showIfOpen(SECURITY_PERMISSIONS)) break;
                this.explorerViewCenterPanel.addTab(this.constants.UserPermissionMappings(), (Widget)new PermissionViewer(), SECURITY_PERMISSIONS);
                break;
            }
            case 6: {
                Frame aboutInfoFrame = new Frame("../AboutInfo.html");
                FormStylePopup aboutPop = new FormStylePopup();
                aboutPop.setWidth("600px");
                aboutPop.setTitle(this.constants.About());
                String hhurl = GWT.getModuleBaseURL() + "webdav";
                aboutPop.addAttribute(this.constants.WebDAVURL() + ":", (Widget)new SmallLabel("<b>" + hhurl + "</b>"));
                aboutPop.addAttribute(this.constants.Version() + ":", (Widget)aboutInfoFrame);
                aboutPop.show();
                break;
            }
            case 7: {
                if (this.explorerViewCenterPanel.showIfOpen(RULE_VERIFIER_MANAGER)) break;
                this.explorerViewCenterPanel.addTab(this.constants.RulesVerificationManager(), (Widget)new RuleVerifierManager(), RULE_VERIFIER_MANAGER);
                break;
            }
            case 8: {
                if (this.explorerViewCenterPanel.showIfOpen(REPOCONFIG)) break;
                this.explorerViewCenterPanel.addTab(this.constants.RepositoryConfig(), (Widget)new RepoConfigManager(), REPOCONFIG);
                break;
            }
            case 9: {
                if (this.explorerViewCenterPanel.showIfOpen(WORKSPACES)) break;
                this.explorerViewCenterPanel.addTab(this.constants.Workspaces(), (Widget)new WorkspaceManager(), WORKSPACES);
            }
        }
    }

    public void openInbox(String title, String widgetID) {
        if (!this.explorerViewCenterPanel.showIfOpen(widgetID)) {
            AssetItemGrid g = new AssetItemGrid(this.createEditEvent(), widgetID, (AssetItemGridDataLoader)new /* Unavailable Anonymous Inner Class!! */);
            this.explorerViewCenterPanel.addTab(title, (Widget)g, widgetID);
        }
    }

    public void openState(String title, String widgetID) {
        if (!this.explorerViewCenterPanel.showIfOpen(widgetID)) {
            String stateName = widgetID.substring(widgetID.indexOf("-") + 1);
            AssetItemGrid grid = new AssetItemGrid(this.createEditEvent(), "rulelist", (AssetItemGridDataLoader)new /* Unavailable Anonymous Inner Class!! */, null);
            10 push = new /* Unavailable Anonymous Inner Class!! */;
            PushClient.instance().subscribe((ServerPushNotification)push);
            grid.addUnloadListener((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.explorerViewCenterPanel.addTab(this.constants.Status() + title, (Widget)grid, widgetID);
        }
    }

    public void openCategory(String title, String widgetID) {
        if (!this.explorerViewCenterPanel.showIfOpen(widgetID)) {
            String categoryName = widgetID.substring(widgetID.indexOf("-") + 1);
            AssetItemGrid grid = new AssetItemGrid(this.createEditEvent(), "rulelist", (AssetItemGridDataLoader)new /* Unavailable Anonymous Inner Class!! */, GWT.getModuleBaseURL() + "feed/category?name=" + categoryName + "&viewUrl=" + Util.getSelfURL());
            13 push = new /* Unavailable Anonymous Inner Class!! */;
            PushClient.instance().subscribe((ServerPushNotification)push);
            grid.addUnloadListener((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.explorerViewCenterPanel.addTab(this.constants.CategoryColon() + title, (Widget)grid, widgetID);
        }
    }

    private OpenItemCommand createEditEvent() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void openPackageViewAssets(String packageUuid, String packageName, String key, List<String> formatInList, Boolean formatIsRegistered, String itemName) {
        if (!this.explorerViewCenterPanel.showIfOpen(key)) {
            String feedUrl = GWT.getModuleBaseURL() + "feed/package?name=" + packageName + "&viewUrl=" + Util.getSelfURL() + "&status=*";
            AssetTable table = new AssetTable(packageUuid, formatInList, formatIsRegistered, (OpenItemCommand)new /* Unavailable Anonymous Inner Class!! */, feedUrl);
            this.explorerViewCenterPanel.addTab(itemName + " [" + packageName + "]", (Widget)table, key);
            17 sub = new /* Unavailable Anonymous Inner Class!! */;
            PushClient.instance().subscribe((ServerPushNotification)sub);
            table.addUnloadListener((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openTestScenario(String packageUuid, String packageName) {
        if (!this.explorerViewCenterPanel.showIfOpen("scenarios" + packageUuid)) {
            19 edit = new /* Unavailable Anonymous Inner Class!! */;
            String m = Format.format((String)this.constants.ScenariosForPackage(), (String[])new String[]{packageName});
            this.explorerViewCenterPanel.addTab(m, (Widget)new ScenarioPackageView(packageUuid, packageName, (OpenItemCommand)edit, this.explorerViewCenterPanel), "scenarios" + packageUuid);
        }
    }

    public void openVerifierView(String packageUuid, String packageName) {
        if (!this.explorerViewCenterPanel.showIfOpen("analysis" + packageUuid)) {
            20 edit = new /* Unavailable Anonymous Inner Class!! */;
            String m = Format.format((String)this.constants.AnalysisForPackage(), (String[])new String[]{packageName});
            this.explorerViewCenterPanel.addTab(m, (Widget)new AnalysisView(packageUuid, packageName, (OpenItemCommand)edit), "analysis" + packageUuid);
        }
    }

    public void openSnapshotAssetList(String name, String uuid, String[] assetTypes, String key) {
        if (!this.explorerViewCenterPanel.showIfOpen(key)) {
            AssetItemGrid grid = new AssetItemGrid((OpenItemCommand)new /* Unavailable Anonymous Inner Class!! */, "rulelist", (AssetItemGridDataLoader)new /* Unavailable Anonymous Inner Class!! */);
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new HTML("<i><small>" + this.constants.SnapshotListingFor() + name + "</small></i>"));
            vp.add((Widget)grid);
            this.explorerViewCenterPanel.addTab(this.constants.SnapshotItems(), (Widget)vp, key);
        }
    }

    static /* synthetic */ Constants access$000(TabOpener x0) {
        return x0.constants;
    }

    static /* synthetic */ ExplorerViewCenterPanel access$100(TabOpener x0) {
        return x0.explorerViewCenterPanel;
    }
}

