/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Event;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueAdaptor;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalMergableGridWidget<T>
extends MergableGridWidget<T> {
    protected DecoratedGridWidget<T> grid;

    public VerticalMergableGridWidget(DecoratedGridWidget<T> grid, DynamicData data, List<DynamicColumn<T>> columns) {
        super(data, columns);
        this.grid = grid;
    }

    public void deleteRow(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be less than zero.");
        }
        if (index > this.grid.getData().size()) {
            throw new IllegalArgumentException("Index cannot be greater than the number of rows.");
        }
        this.grid.getSidebarWidget().deleteSelector(index);
        this.tbody.deleteRow(index);
        this.fixRowStyles(index);
    }

    public void deselectCell(CellValue<? extends Comparable<?>> cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        Coordinate hc = cell.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        String cellSelectedStyle = style.cellTableCellSelected();
        tce.removeClassName(cellSelectedStyle);
    }

    public void hideColumn(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be less than zero");
        }
        if (index > this.columns.size()) {
            throw new IllegalArgumentException("index cannot be greater than the number of rows");
        }
        for (int iRow = 0; iRow < this.grid.getData().size(); ++iRow) {
            DynamicDataRow rowData = (DynamicDataRow)this.grid.getData().get(iRow);
            CellValue cell = (CellValue)rowData.get(index);
            if (cell.getRowSpan() <= 0) continue;
            Coordinate hc = cell.getHtmlCoordinate();
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(hc.getRow());
            TableCellElement tce = (TableCellElement)tre.getCells().getItem(hc.getCol());
            tre.removeChild((Node)tce);
        }
    }

    public void insertRowBefore(int index, DynamicDataRow rowData) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be less than zero.");
        }
        if (index > this.grid.getData().size()) {
            throw new IllegalArgumentException("Index cannot be greater than the number of rows.");
        }
        if (rowData == null) {
            throw new IllegalArgumentException("Row data cannot be null");
        }
        if (rowData.size() != this.columns.size()) {
            throw new IllegalArgumentException("rowData contains a different number of columns to the grid");
        }
        this.grid.getSidebarWidget().insertSelectorBefore(rowData, index);
        TableRowElement newRow = this.tbody.insertRow(index);
        this.populateTableRowElement(newRow, rowData);
        this.fixRowStyles(index);
    }

    public void onBrowserEvent(Event event) {
        DecisionTableCellValueAdaptor cellWidget;
        Set consumedEvents;
        String eventType = event.getType();
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is((JavaScriptObject)eventTarget)) {
            return;
        }
        Element target = (Element)event.getEventTarget().cast();
        TableCellElement tableCell = this.findNearestParentCell(target);
        if (tableCell == null) {
            return;
        }
        int htmlCol = tableCell.getCellIndex();
        Element trElem = tableCell.getParentElement();
        if (trElem == null) {
            return;
        }
        TableRowElement tr = TableRowElement.as((Element)trElem);
        int htmlRow = tr.getSectionRowIndex();
        DynamicDataRow htmlRowData = (DynamicDataRow)this.data.get(htmlRow);
        CellValue htmlCell = (CellValue)htmlRowData.get(htmlCol);
        Coordinate c = htmlCell.getPhysicalCoordinate();
        CellValue physicalCell = (CellValue)((DynamicDataRow)this.data.get(c.getRow())).get(c.getCol());
        if (eventType.equals("click")) {
            this.grid.startSelecting(c);
        }
        if (eventType.equals("keypress")) {
            if (event.getKeyCode() == 46) {
                this.grid.update(null);
            } else if (event.getKeyCode() == 39 || event.getKeyCode() == 9 && !event.getShiftKey()) {
                this.grid.moveSelection(DecoratedGridWidget.MOVE_DIRECTION.RIGHT);
                event.preventDefault();
            } else if (event.getKeyCode() == 37 || event.getKeyCode() == 9 && event.getShiftKey()) {
                this.grid.moveSelection(DecoratedGridWidget.MOVE_DIRECTION.LEFT);
                event.preventDefault();
            } else if (event.getKeyCode() == 38) {
                this.grid.moveSelection(DecoratedGridWidget.MOVE_DIRECTION.UP);
                event.preventDefault();
            } else if (event.getKeyCode() == 40) {
                this.grid.moveSelection(DecoratedGridWidget.MOVE_DIRECTION.DOWN);
                event.preventDefault();
            }
        }
        if (eventType.equals("keydown") && event.getKeyCode() == 13) {
            physicalCell = (CellValue)this.grid.getSelections().first();
            c = physicalCell.getCoordinate();
            tableCell = (TableCellElement)((TableRowElement)this.tbody.getRows().getItem(physicalCell.getHtmlCoordinate().getRow())).getCells().getItem(physicalCell.getHtmlCoordinate().getCol());
        }
        if ((consumedEvents = (cellWidget = ((DynamicColumn)this.grid.getColumns().get(c.getCol())).getCell()).getConsumedEvents()) != null && consumedEvents.contains(eventType)) {
            Cell.Context context = new Cell.Context(c.getRow(), c.getCol(), (Object)c);
            cellWidget.onBrowserEvent(context, tableCell.getFirstChildElement(), (Object)physicalCell, (NativeEvent)event, null);
        }
    }

    public void redraw() {
        this.grid.getSidebarWidget().initialise();
        TableSectionElement nbody = Document.get().createTBodyElement();
        for (int iRow = 0; iRow < this.grid.getData().size(); ++iRow) {
            DynamicDataRow rowData = (DynamicDataRow)this.grid.getData().get(iRow);
            this.grid.getSidebarWidget().appendSelector(rowData);
            TableRowElement tre = Document.get().createTRElement();
            tre.setClassName(this.getRowStyle(iRow));
            this.populateTableRowElement(tre, rowData);
            nbody.appendChild((Node)tre);
        }
        this.table.replaceChild((Node)nbody, (Node)this.tbody);
        this.tbody = nbody;
    }

    public void redrawColumn(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be less than zero.");
        }
        if (index > this.grid.getColumns().size()) {
            throw new IllegalArgumentException("index cannot be greater than the number of defined columns.");
        }
        for (int iRow = 0; iRow < this.grid.getData().size(); ++iRow) {
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(iRow);
            DynamicDataRow rowData = (DynamicDataRow)this.grid.getData().get(iRow);
            this.redrawTableRowElement(rowData, tre, index, index);
        }
    }

    public void redrawColumns(int startRedrawIndex, int endRedrawIndex) {
        if (startRedrawIndex < 0) {
            throw new IllegalArgumentException("startRedrawIndex cannot be less than zero.");
        }
        if (startRedrawIndex > this.grid.getColumns().size()) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than the number of defined columns.");
        }
        if (endRedrawIndex < 0) {
            throw new IllegalArgumentException("endRedrawIndex cannot be less than zero.");
        }
        if (endRedrawIndex > this.grid.getColumns().size()) {
            throw new IllegalArgumentException("endRedrawIndex cannot be greater than the number of defined columns.");
        }
        if (startRedrawIndex > endRedrawIndex) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than endRedrawIndex.");
        }
        for (int iRow = 0; iRow < this.grid.getData().size(); ++iRow) {
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(iRow);
            DynamicDataRow rowData = (DynamicDataRow)this.grid.getData().get(iRow);
            this.redrawTableRowElement(rowData, tre, startRedrawIndex, endRedrawIndex);
        }
    }

    public void redrawRows(int startRedrawIndex, int endRedrawIndex) {
        if (startRedrawIndex < 0) {
            throw new IllegalArgumentException("startRedrawIndex cannot be less than zero.");
        }
        if (startRedrawIndex > this.grid.getData().size()) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than the number of rows in the table.");
        }
        if (endRedrawIndex < 0) {
            throw new IllegalArgumentException("endRedrawIndex cannot be less than zero.");
        }
        if (endRedrawIndex > this.grid.getData().size()) {
            throw new IllegalArgumentException("endRedrawIndex cannot be greater than the number of rows in the table.");
        }
        if (startRedrawIndex > endRedrawIndex) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than endRedrawIndex.");
        }
        for (int iRow = startRedrawIndex; iRow <= endRedrawIndex; ++iRow) {
            TableRowElement newRow = Document.get().createTRElement();
            DynamicDataRow rowData = (DynamicDataRow)this.grid.getData().get(iRow);
            this.populateTableRowElement(newRow, rowData);
            this.tbody.replaceChild((Node)newRow, this.tbody.getChild(iRow));
        }
        this.fixRowStyles(startRedrawIndex);
    }

    public void resizeColumn(DynamicColumn<?> col, int width) {
        if (col == null) {
            throw new IllegalArgumentException("col cannot be null");
        }
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        col.setWidth(width);
        int iCol = col.getColumnIndex();
        for (DynamicDataRow row : this.grid.getData()) {
            CellValue cell = (CellValue)row.get(iCol);
            Coordinate c = cell.getHtmlCoordinate();
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(c.getRow());
            TableCellElement tce = (TableCellElement)tre.getCells().getItem(c.getCol());
            ((DivElement)tce.getFirstChild().cast()).getStyle().setWidth((double)width, Style.Unit.PX);
        }
        this.grid.assertDimensions();
    }

    public void selectCell(CellValue<? extends Comparable<?>> cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        Coordinate hc = cell.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        String cellSelectedStyle = style.cellTableCellSelected();
        tce.addClassName(cellSelectedStyle);
        tce.focus();
    }

    public void showColumn(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be less than zero");
        }
        if (index > this.columns.size()) {
            throw new IllegalArgumentException("index cannot be greater than the number of rows");
        }
        for (int iRow = 0; iRow < this.grid.getData().size(); ++iRow) {
            DynamicDataRow rowData = (DynamicDataRow)this.grid.getData().get(iRow);
            TableCellElement tce = this.makeTableCellElement(index, rowData);
            if (tce == null) continue;
            CellValue cell = (CellValue)rowData.get(index);
            Coordinate hc = cell.getHtmlCoordinate();
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(hc.getRow());
            TableCellElement ntce = tre.insertCell(hc.getCol());
            tre.replaceChild((Node)tce, (Node)ntce);
        }
    }

    private TableCellElement findNearestParentCell(Element elem) {
        while (elem != null && elem != this.table) {
            String tagName = elem.getTagName();
            if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) {
                return (TableCellElement)elem.cast();
            }
            elem = elem.getParentElement();
        }
        return null;
    }

    private void fixRowStyles(int iRow) {
        while (iRow < this.tbody.getChildCount()) {
            Element e = Element.as((Node)this.tbody.getChild(iRow));
            TableRowElement tre = TableRowElement.as((Element)e);
            tre.setClassName(this.getRowStyle(iRow));
            ++iRow;
        }
    }

    private String getRowStyle(int iRow) {
        String evenRowStyle = style.cellTableEvenRow();
        String oddRowStyle = style.cellTableOddRow();
        boolean isEven = iRow % 2 == 0;
        String trClasses = isEven ? evenRowStyle : oddRowStyle;
        return trClasses;
    }

    private TableCellElement makeTableCellElement(int iCol, DynamicDataRow rowData) {
        String cellStyle = style.cellTableCell();
        String divStyle = style.cellTableCellDiv();
        String cellSelectedStyle = style.cellTableCellSelected();
        TableCellElement tce = null;
        DynamicColumn column = (DynamicColumn)this.grid.getColumns().get(iCol);
        CellValue cellData = (CellValue)rowData.get(iCol);
        int rowSpan = cellData.getRowSpan();
        if (rowSpan > 0) {
            tce = Document.get().createTDElement();
            DivElement div = Document.get().createDivElement();
            if (cellData.isSelected()) {
                tce.addClassName(cellSelectedStyle);
            }
            tce.addClassName(cellStyle);
            div.setClassName(divStyle);
            div.getStyle().setWidth((double)column.getWidth(), Style.Unit.PX);
            div.getStyle().setHeight(Math.floor((double)style.rowHeight() * 0.95), Style.Unit.PX);
            tce.getStyle().setHeight((double)(style.rowHeight() * rowSpan), Style.Unit.PX);
            tce.setRowSpan(rowSpan);
            Coordinate c = cellData.getCoordinate();
            Cell.Context context = new Cell.Context(c.getRow(), c.getCol(), (Object)c);
            SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
            column.render(context, rowData, cellBuilder);
            div.setInnerHTML(cellBuilder.toSafeHtml().asString());
            tce.appendChild((Node)div);
            tce.setTabIndex(0);
        }
        return tce;
    }

    private TableRowElement populateTableRowElement(TableRowElement tre, DynamicDataRow rowData) {
        for (int iCol = 0; iCol < this.grid.getColumns().size(); ++iCol) {
            TableCellElement tce;
            if (!((DynamicColumn)this.grid.getColumns().get(iCol)).isVisible() || (tce = this.makeTableCellElement(iCol, rowData)) == null) continue;
            tre.appendChild((Node)tce);
        }
        return tre;
    }

    private void redrawTableRowElement(DynamicDataRow rowData, TableRowElement tre, int startColIndex, int endColIndex) {
        for (int iCol = startColIndex; iCol <= endColIndex; ++iCol) {
            TableCellElement newCell;
            DynamicColumn column = (DynamicColumn)this.grid.getColumns().get(iCol);
            if (!column.isVisible()) continue;
            int maxColumnIndex = tre.getCells().getLength() - 1;
            int requiredColumnIndex = ((CellValue)rowData.get(iCol)).getHtmlCoordinate().getCol();
            if (requiredColumnIndex > maxColumnIndex) {
                newCell = this.makeTableCellElement(iCol, rowData);
                if (newCell == null) continue;
                tre.appendChild((Node)newCell);
                continue;
            }
            newCell = this.makeTableCellElement(iCol, rowData);
            if (newCell == null) continue;
            TableCellElement oldCell = (TableCellElement)tre.getCells().getItem(requiredColumnIndex);
            tre.replaceChild((Node)newCell, (Node)oldCell);
        }
    }
}

