/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageResponse;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.repository.RepositoryStartupService;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.TestEnvironmentSessionHelper;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.AuthorizationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RepositoryServiceServlet
extends RemoteServiceServlet
implements RepositoryService {
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryServiceServlet.class);
    private static boolean testListenerInit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceImplementation getService() {
        if (Contexts.isApplicationContextActive()) {
            return (ServiceImplementation)Component.getInstance((String)"org.drools.guvnor.client.rpc.RepositoryService");
        }
        Class<RepositoryServiceServlet> clazz = RepositoryServiceServlet.class;
        synchronized (RepositoryServiceServlet.class) {
            ServiceImplementation serviceImplementation = new ServiceImplementation();
            serviceImplementation.repository = new RulesRepository(TestEnvironmentSessionHelper.getSession((boolean)false));
            if (!testListenerInit) {
                MailboxService.getInstance().init(new RulesRepository(TestEnvironmentSessionHelper.getSession((boolean)false)));
                RepositoryStartupService.registerCheckinListener();
                testListenerInit = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serviceImplementation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnexpectedFailure(Throwable e) {
        if (e.getCause() instanceof AuthorizationException) {
            HttpServletResponse response = this.getThreadLocalResponse();
            PrintWriter writer = null;
            try {
                writer = response.getWriter();
                log.error(e.getMessage(), e.getCause());
                e.printStackTrace();
                response.setContentType("text/plain");
                response.setStatus(401);
                writer.write("Sorry, insufficient permissions to perform this action.");
            }
            catch (IOException ex) {
                this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
            finally {
                this.close(writer);
            }
        } else if (e.getCause() instanceof RulesRepositoryException) {
            log.error(e.getMessage(), e.getCause());
            this.sendErrorMessage(e.getCause().getMessage());
        } else {
            if (e.getCause() != null) {
                log.error(e.getMessage(), e.getCause());
            } else {
                log.error(e.getMessage(), e);
            }
            this.sendErrorMessage("Sorry, a technical error occurred. Please contact a system administrator.");
        }
    }

    private void close(PrintWriter writer) {
        if (writer != null) {
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendErrorMessage(String msg) {
        HttpServletResponse response = this.getThreadLocalResponse();
        response.setContentType("text/plain");
        response.setStatus(400);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.write(msg);
        }
        catch (IOException ex) {
            this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
        }
        finally {
            this.close(writer);
        }
    }

    public String[] loadChildCategories(String p0) {
        return RepositoryServiceServlet.getService().loadChildCategories(p0);
    }

    public TableDataResult loadRuleListForCategories(String p0, int p1, int p2, String p3) throws SerializationException {
        return RepositoryServiceServlet.getService().loadRuleListForCategories(p0, p1, p2, p3);
    }

    public TableDataResult loadRuleListForState(String p0, int p1, int p2, String p3) throws SerializationException {
        return RepositoryServiceServlet.getService().loadRuleListForState(p0, p1, p2, p3);
    }

    public TableConfig loadTableConfig(String p0) {
        return RepositoryServiceServlet.getService().loadTableConfig(p0);
    }

    public Boolean createCategory(String p0, String p1, String p2) {
        return RepositoryServiceServlet.getService().createCategory(p0, p1, p2);
    }

    public String createNewRule(String p0, String p1, String p2, String p3, String p4) throws SerializationException {
        return RepositoryServiceServlet.getService().createNewRule(p0, p1, p2, p3, p4);
    }

    public String createNewImportedRule(String p0, String p1) throws SerializationException {
        return RepositoryServiceServlet.getService().createNewImportedRule(p0, p1);
    }

    public void deleteUncheckedRule(String p0, String p1) {
        RepositoryServiceServlet.getService().deleteUncheckedRule(p0, p1);
    }

    public void clearRulesRepository() {
        RepositoryServiceServlet.getService().clearRulesRepository();
    }

    public PackageConfigData[] listPackages() {
        return RepositoryServiceServlet.getService().listPackages();
    }

    public PackageConfigData[] listPackages(String workspace) {
        return RepositoryServiceServlet.getService().listPackages(workspace);
    }

    public String[] listWorkspaces() {
        return RepositoryServiceServlet.getService().listWorkspaces();
    }

    public void createWorkspace(String workspace) {
        RepositoryServiceServlet.getService().createWorkspace(workspace);
    }

    public void removeWorkspace(String workspace) {
        RepositoryServiceServlet.getService().removeWorkspace(workspace);
    }

    public void updateWorkspace(String workspace, String[] selectedModules, String[] unselectedModules) {
        RepositoryServiceServlet.getService().updateWorkspace(workspace, selectedModules, unselectedModules);
    }

    public PackageConfigData loadGlobalPackage() {
        return RepositoryServiceServlet.getService().loadGlobalPackage();
    }

    public PackageConfigData[] listArchivedPackages() {
        return RepositoryServiceServlet.getService().listArchivedPackages();
    }

    public RuleAsset loadRuleAsset(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().loadRuleAsset(p0);
    }

    public RuleAsset[] loadRuleAssets(String[] p0) throws SerializationException {
        return RepositoryServiceServlet.getService().loadRuleAssets(p0);
    }

    public TableDataResult loadAssetHistory(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().loadAssetHistory(p0);
    }

    public TableDataResult loadArchivedAssets(int p0, int p1) throws SerializationException {
        return RepositoryServiceServlet.getService().loadArchivedAssets(p0, p1);
    }

    public String checkinVersion(RuleAsset p0) throws SerializationException {
        return RepositoryServiceServlet.getService().checkinVersion(p0);
    }

    public void restoreVersion(String p0, String p1, String p2) {
        RepositoryServiceServlet.getService().restoreVersion(p0, p1, p2);
    }

    public String createPackage(String p0, String p1) throws SerializationException {
        return RepositoryServiceServlet.getService().createPackage(p0, p1);
    }

    public String createSubPackage(String p0, String p1, String parentPackage) throws SerializationException {
        return RepositoryServiceServlet.getService().createSubPackage(p0, p1, parentPackage);
    }

    public PackageConfigData loadPackageConfig(String p0) {
        return RepositoryServiceServlet.getService().loadPackageConfig(p0);
    }

    public ValidatedResponse savePackage(PackageConfigData p0) throws SerializationException {
        return RepositoryServiceServlet.getService().savePackage(p0);
    }

    public AssetPageResponse findAssetPage(AssetPageRequest request) throws SerializationException {
        return RepositoryServiceServlet.getService().findAssetPage(request);
    }

    public TableDataResult listAssets(String p0, String[] p1, int p2, int p3, String p4) throws SerializationException {
        return RepositoryServiceServlet.getService().listAssets(p0, p1, p2, p3, p4);
    }

    public TableDataResult listAssetsWithPackageName(String p0, String[] p1, int p2, int p3, String p4) throws SerializationException {
        return RepositoryServiceServlet.getService().listAssetsWithPackageName(p0, p1, p2, p3, p4);
    }

    public String[] listStates() throws SerializationException {
        return RepositoryServiceServlet.getService().listStates();
    }

    public String createState(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().createState(p0);
    }

    public void renameState(String p0, String p1) throws SerializationException {
        RepositoryServiceServlet.getService().renameState(p0, p1);
    }

    public void removeState(String p0) throws SerializationException {
        RepositoryServiceServlet.getService().removeState(p0);
    }

    public void changeState(String p0, String p1, boolean p2) {
        RepositoryServiceServlet.getService().changeState(p0, p1, p2);
    }

    public void changeAssetPackage(String p0, String p1, String p2) {
        RepositoryServiceServlet.getService().changeAssetPackage(p0, p1, p2);
    }

    public void promoteAssetToGlobalArea(String p0) {
        RepositoryServiceServlet.getService().promoteAssetToGlobalArea(p0);
    }

    public String copyAsset(String p0, String p1, String p2) {
        return RepositoryServiceServlet.getService().copyAsset(p0, p1, p2);
    }

    public void copyPackage(String p0, String p1) throws SerializationException {
        RepositoryServiceServlet.getService().copyPackage(p0, p1);
    }

    public SnapshotInfo[] listSnapshots(String p0) {
        return RepositoryServiceServlet.getService().listSnapshots(p0);
    }

    public void createPackageSnapshot(String p0, String p1, boolean p2, String p3) {
        RepositoryServiceServlet.getService().createPackageSnapshot(p0, p1, p2, p3);
    }

    public void copyOrRemoveSnapshot(String p0, String p1, boolean p2, String p3) throws SerializationException {
        RepositoryServiceServlet.getService().copyOrRemoveSnapshot(p0, p1, p2, p3);
    }

    public void removeCategory(String p0) throws SerializationException {
        RepositoryServiceServlet.getService().removeCategory(p0);
    }

    public SuggestionCompletionEngine loadSuggestionCompletionEngine(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().loadSuggestionCompletionEngine(p0);
    }

    public BuilderResult buildPackage(String p0, boolean p1, String p2, String p3, String p4, boolean p5, String p6, String p7, boolean p8, String p9) throws SerializationException {
        return RepositoryServiceServlet.getService().buildPackage(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public String[] getCustomSelectors() throws SerializationException {
        return RepositoryServiceServlet.getService().getCustomSelectors();
    }

    public String buildPackageSource(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().buildPackageSource(p0);
    }

    public String buildAssetSource(RuleAsset p0) throws SerializationException {
        return RepositoryServiceServlet.getService().buildAssetSource(p0);
    }

    public BuilderResult buildAsset(RuleAsset p0) throws SerializationException {
        return RepositoryServiceServlet.getService().buildAsset(p0);
    }

    public String renameAsset(String p0, String p1) {
        return RepositoryServiceServlet.getService().renameAsset(p0, p1);
    }

    public void renameCategory(String p0, String p1) {
        RepositoryServiceServlet.getService().renameCategory(p0, p1);
    }

    public void archiveAsset(String p0) {
        RepositoryServiceServlet.getService().archiveAsset(p0);
    }

    public void unArchiveAsset(String p0) {
        RepositoryServiceServlet.getService().unArchiveAsset(p0);
    }

    public void archiveAssets(String[] p0, boolean p1) {
        RepositoryServiceServlet.getService().archiveAssets(p0, p1);
    }

    public void removeAsset(String p0) {
        RepositoryServiceServlet.getService().removeAsset(p0);
    }

    public void removeAssets(String[] p0) {
        RepositoryServiceServlet.getService().removeAssets(p0);
    }

    public void removePackage(String p0) {
        RepositoryServiceServlet.getService().removePackage(p0);
    }

    public String renamePackage(String p0, String p1) {
        return RepositoryServiceServlet.getService().renamePackage(p0, p1);
    }

    public void rebuildSnapshots() throws SerializationException {
        RepositoryServiceServlet.getService().rebuildSnapshots();
    }

    public void rebuildPackages() throws SerializationException {
        RepositoryServiceServlet.getService().rebuildPackages();
    }

    public String[] listRulesInPackage(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().listRulesInPackage(p0);
    }

    public SingleScenarioResult runScenario(String p0, Scenario p1) throws SerializationException {
        return RepositoryServiceServlet.getService().runScenario(p0, p1);
    }

    public BulkTestRunResult runScenariosInPackage(PackageItem item) throws DetailedSerializationException, SerializationException {
        return RepositoryServiceServlet.getService().runScenariosInPackage(item);
    }

    public BulkTestRunResult runScenariosInPackage(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().runScenariosInPackage(p0);
    }

    public String[] listTypesInPackage(String p0) throws SerializationException {
        return RepositoryServiceServlet.getService().listTypesInPackage(p0);
    }

    public LogEntry[] showLog() {
        return RepositoryServiceServlet.getService().showLog();
    }

    public void cleanLog() {
        RepositoryServiceServlet.getService().cleanLog();
    }

    public String[] loadDropDownExpression(String[] p0, String p1) {
        return RepositoryServiceServlet.getService().loadDropDownExpression(p0, p1);
    }

    public TableDataResult quickFindAsset(String p0, boolean p1, int p2, int p3) throws SerializationException {
        return RepositoryServiceServlet.getService().quickFindAsset(p0, p1, p2, p3);
    }

    public TableDataResult queryFullText(String p0, boolean p1, int p2, int p3) throws SerializationException {
        return RepositoryServiceServlet.getService().queryFullText(p0, p1, p2, p3);
    }

    public TableDataResult queryMetaData(MetaDataQuery[] p0, Date p1, Date p2, Date p3, Date p4, boolean p5, int p6, int p7) throws SerializationException {
        return RepositoryServiceServlet.getService().queryMetaData(p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public Map listUserPermissions() throws DetailedSerializationException {
        return RepositoryServiceServlet.getService().listUserPermissions();
    }

    public Map retrieveUserPermissions(String p0) {
        return RepositoryServiceServlet.getService().retrieveUserPermissions(p0);
    }

    public void updateUserPermissions(String p0, Map p1) {
        RepositoryServiceServlet.getService().updateUserPermissions(p0, p1);
    }

    public String[] listAvailablePermissionTypes() {
        return RepositoryServiceServlet.getService().listAvailablePermissionTypes();
    }

    public void deleteUser(String p0) {
        RepositoryServiceServlet.getService().deleteUser(p0);
    }

    public void createUser(String p0) {
        RepositoryServiceServlet.getService().createUser(p0);
    }

    public String getAssetLockerUserName(String p0) {
        return RepositoryServiceServlet.getService().getAssetLockerUserName(p0);
    }

    public void lockAsset(String p0) {
        RepositoryServiceServlet.getService().lockAsset(p0);
    }

    public void unLockAsset(String p0) {
        RepositoryServiceServlet.getService().unLockAsset(p0);
    }

    public void installSampleRepository() throws SerializationException {
        RepositoryServiceServlet.getService().installSampleRepository();
    }

    public List loadDiscussionForAsset(String p0) {
        return RepositoryServiceServlet.getService().loadDiscussionForAsset(p0);
    }

    public List addToDiscussionForAsset(String p0, String p1) {
        return RepositoryServiceServlet.getService().addToDiscussionForAsset(p0, p1);
    }

    public void clearAllDiscussionsForAsset(String p0) {
        RepositoryServiceServlet.getService().clearAllDiscussionsForAsset(p0);
    }

    public List subscribe() {
        return RepositoryServiceServlet.getService().subscribe();
    }

    public TableDataResult loadInbox(String p0) throws DetailedSerializationException {
        return RepositoryServiceServlet.getService().loadInbox(p0);
    }

    public SnapshotDiffs compareSnapshots(String p0, String p1, String p2) {
        return RepositoryServiceServlet.getService().compareSnapshots(p0, p1, p2);
    }

    public String processTemplate(String p0, Map<String, Object> p1) {
        return RepositoryServiceServlet.getService().processTemplate(p0, p1);
    }

    public Boolean isHostedMode() {
        return RepositoryServiceServlet.getService().isHostedMode();
    }
}

