/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.drools.builder.ResourceType;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.server.factory.ConstraintsFactory;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.VerifierRunner;
import org.drools.io.ResourceFactory;
import org.drools.repository.PackageItem;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerificationServiceImplementation
extends RemoteServiceServlet
implements VerificationService {
    private static final long serialVersionUID = 510L;
    private static final LoggingHelper log = LoggingHelper.getLogger(ServiceImplementation.class);
    private Verifier defaultVerifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier();

    private ServiceImplementation getService() {
        return RepositoryServiceServlet.getService();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport analysePackage(String packageUUID) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
        PackageItem packageItem = this.getService().getRulesRepository().loadPackageByUUID(packageUUID);
        VerifierRunner runner = new VerifierRunner(this.defaultVerifier);
        AnalysisReport report = runner.verify(packageItem, new ScopesAgendaFilter(true, "knowledge-package"));
        this.defaultVerifier.flushKnowledgeSession();
        return report;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport verifyAsset(RuleAsset asset, Set<String> activeWorkingSets) throws SerializationException {
        return this.performAssetVerification(asset, true, activeWorkingSets);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport verifyAssetWithoutVerifiersRules(RuleAsset asset, Set<String> activeWorkingSets) throws SerializationException {
        return this.performAssetVerification(asset, false, activeWorkingSets);
    }

    private AnalysisReport performAssetVerification(RuleAsset asset, boolean useVerifierDefaultConfig, Set<String> activeWorkingSets) throws SerializationException {
        long startTime = System.currentTimeMillis();
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
        }
        PackageItem packageItem = this.getService().getRulesRepository().loadPackage(asset.metaData.packageName);
        List constraintRules = this.applyWorkingSets(activeWorkingSets);
        Verifier verifierToBeUsed = null;
        verifierToBeUsed = useVerifierDefaultConfig ? this.defaultVerifier : this.getWorkingSetVerifier((Collection)constraintRules);
        log.debug("constraints rules: " + constraintRules);
        try {
            VerifierRunner runner = new VerifierRunner(verifierToBeUsed);
            AnalysisReport report = runner.verify(packageItem, this.chooseScopesAgendaFilterFor(asset));
            verifierToBeUsed.flushKnowledgeSession();
            log.debug("Asset verification took: " + (System.currentTimeMillis() - startTime));
            return report;
        }
        catch (Throwable t) {
            throw new SerializationException(t.getMessage());
        }
    }

    private ScopesAgendaFilter chooseScopesAgendaFilterFor(RuleAsset asset) {
        if (this.isAssetDecisionTable(asset)) {
            return new ScopesAgendaFilter(true, "decision-table");
        }
        return new ScopesAgendaFilter(true, "single-rule");
    }

    private boolean isAssetDecisionTable(RuleAsset asset) {
        return "gdst".equals(asset.metaData.format) || "xls".equals(asset.metaData.format);
    }

    private List<String> applyWorkingSets(Set<String> activeWorkingSets) throws SerializationException {
        if (activeWorkingSets == null) {
            return new LinkedList<String>();
        }
        RuleAsset[] workingSets = this.getService().loadRuleAssets(activeWorkingSets.toArray(new String[activeWorkingSets.size()]));
        LinkedList<String> constraintRules = new LinkedList<String>();
        if (workingSets != null) {
            for (RuleAsset workingSet : workingSets) {
                WorkingSetConfigData wsConfig = (WorkingSetConfigData)workingSet.content;
                if (wsConfig.constraints == null) continue;
                for (ConstraintConfiguration config : wsConfig.constraints) {
                    constraintRules.add(ConstraintsFactory.getInstance().getVerifierRule(config));
                }
            }
        }
        return constraintRules;
    }

    private Verifier getWorkingSetVerifier(Collection<String> additionalVerifierRules) {
        DefaultVerifierConfiguration configuration = new DefaultVerifierConfiguration();
        configuration = new VerifierConfigurationImpl();
        if (additionalVerifierRules != null) {
            for (String rule : additionalVerifierRules) {
                configuration.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            }
        }
        return VerifierBuilderFactory.newVerifierBuilder().newVerifier((VerifierConfiguration)configuration);
    }
}

