/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.contenthandler.IValidating;
import org.drools.guvnor.server.contenthandler.PlainTextContentHandler;
import org.drools.ide.common.server.util.DataEnumLoader;
import org.drools.repository.AssetItem;

public class EnumerationContentHandler
extends PlainTextContentHandler
implements IValidating {
    public BuilderResult validateAsset(AssetItem asset) {
        String content = asset.getContent();
        DataEnumLoader loader = new DataEnumLoader(content);
        if (!loader.hasErrors()) {
            return new BuilderResult();
        }
        ArrayList<BuilderResultLine> errors = new ArrayList<BuilderResultLine>();
        List errs = loader.getErrors();
        for (String message : errs) {
            BuilderResultLine result = new BuilderResultLine();
            result.assetName = asset.getName();
            result.assetFormat = asset.getFormat();
            result.uuid = asset.getUUID();
            result.message = message;
            errors.add(result);
        }
        BuilderResult result = new BuilderResult();
        result.setLines(errors.toArray(new BuilderResultLine[errors.size()]));
        return result;
    }

    public BuilderResult validateAsset(RuleAsset asset) {
        String content = ((RuleContentText)asset.content).content;
        DataEnumLoader loader = new DataEnumLoader(content);
        if (!loader.hasErrors()) {
            return new BuilderResult();
        }
        ArrayList<BuilderResultLine> errors = new ArrayList<BuilderResultLine>();
        List errs = loader.getErrors();
        for (String message : errs) {
            BuilderResultLine result = new BuilderResultLine();
            result.assetName = asset.metaData.name;
            result.assetFormat = asset.metaData.format;
            result.uuid = asset.uuid;
            result.message = message;
            errors.add(result);
        }
        BuilderResult result = new BuilderResult();
        result.setLines(errors.toArray(new BuilderResultLine[errors.size()]));
        return result;
    }
}

