/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.server.files.RestAPIServlet;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.WebDavPackageNameType;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.VersionableItem;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDAVImpl
implements IWebdavStore {
    private static final String SNAPSHOTS = "snapshots";
    private static final String PACKAGES = "packages";
    static Map<String, byte[]> osxDoubleData = Collections.synchronizedMap(new WeakHashMap());
    final ThreadLocal<RulesRepository> tlRepo = new ThreadLocal();

    public WebDAVImpl(File f) {
    }

    public WebDAVImpl() {
    }

    public WebDAVImpl(RulesRepository testRepo) {
        this.tlRepo.set(testRepo);
    }

    RulesRepository getRepo() {
        return (RulesRepository)this.tlRepo.get();
    }

    public ITransaction begin(Principal principal) {
        this.tlRepo.set(RestAPIServlet.getRepository());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void checkAuthentication(ITransaction arg0) {
    }

    public void commit(ITransaction iTransaction) {
        this.getRepo().save();
        this.tlRepo.set(null);
    }

    public void createFolder(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.isAdmin()) {
            if (path.length > 2) {
                throw new UnsupportedOperationException("Can't nest packages.");
            }
            RulesRepository repository = this.getRepo();
            if (repository.containsPackage(path[1])) {
                PackageItem pkg = this.loadPackageFromRepository(repository, path[1]);
                pkg.archiveItem(false);
                pkg.checkin("<restored by webdav>");
            } else {
                repository.createPackage(path[1], "<from webdav>");
            }
        } else {
            throw new UnsupportedOperationException("Not able to create folders here...");
        }
    }

    public void createResource(ITransaction iTransaction, String uri) {
        if (uri.endsWith(".DS_Store")) {
            return;
        }
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.checkPackagePermission(path[1], "package.admin")) {
            if (path.length > 3) {
                throw new UnsupportedOperationException("Can't do nested packages.");
            }
            String[] resource = AssetItem.getAssetNameFromFileName((String)path[2]);
            PackageItem packageItem = this.loadPackageFromRepository(this.getRepo(), path[1]);
            if (path[2].startsWith("._")) {
                osxDoubleData.put(uri, null);
                return;
            }
            if (packageItem.containsAsset(resource[0])) {
                AssetItem lazarus = packageItem.loadAsset(resource[0]);
                lazarus.archiveItem(false);
            } else {
                AssetItem asset = packageItem.addAsset(resource[0], "");
                asset.updateFormat(resource[1]);
            }
        } else {
            throw new UnsupportedOperationException("Can't add assets here.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getChildrenNames(ITransaction iTransaction, String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        ArrayList result = new ArrayList();
        if (path.length == 0) {
            return new String[]{PACKAGES, SNAPSHOTS};
        }
        if (this.isPackages(path)) {
            if (path.length > 2) {
                return null;
            }
            if (path.length == 1) {
                this.listPackages(repository, result);
                return result.toArray(new String[result.size()]);
            } else {
                if (!this.checkPackagePermissionIfReadOnly(path)) return result.toArray(new String[result.size()]);
                this.handleReadOnlyPackages(repository, path, result);
            }
            return result.toArray(new String[result.size()]);
        } else {
            if (!this.isSnaphosts(path)) throw new UnsupportedOperationException("Not a valid path : " + path[0]);
            if (path.length > 3) {
                return null;
            }
            if (path.length == 1) {
                this.listPackages(repository, result);
                return result.toArray(new String[result.size()]);
            } else {
                if (this.isPermission(path, 2)) {
                    return repository.listPackageSnapshots(path[1]);
                }
                if (!this.isPermission(path, 3)) throw new IllegalArgumentException();
                this.handleReadOnlySnapshotPackages(repository, path, result);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private void handleReadOnlySnapshotPackages(RulesRepository repository, String[] path, List<String> result) {
        Iterator it = this.loadPackageSnapshotFromRepository(repository, path).getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.isArchived()) continue;
            this.addNameAndFormat(result, asset);
        }
    }

    private void handleReadOnlyPackages(RulesRepository repository, String[] path, List<String> result) {
        PackageItem pkg = this.loadPackageFromRepository(repository, path[1]);
        Iterator it = pkg.getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.isArchived()) continue;
            this.addNameAndFormat(result, asset);
        }
    }

    private boolean addNameAndFormat(List<String> result, AssetItem asset) {
        return result.add(asset.getName() + "." + asset.getFormat());
    }

    private void listPackages(RulesRepository repository, List<String> result) {
        PackageIterator it = repository.listPackages();
        while (it.hasNext()) {
            PackageItem pkg = (PackageItem)it.next();
            String packageName = pkg.getName();
            if (pkg.isArchived() || !this.checkPackagePermission(packageName, "package.readonly")) continue;
            result.add(packageName);
        }
    }

    public Date getCreationDate(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return new Date();
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getCreationDateForPackage(repository, path);
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getCreationTimeForSnapshotPackage(repository, path);
        }
        throw new UnsupportedOperationException();
    }

    private Date getCreationTimeForSnapshotPackage(RulesRepository repository, String[] path) {
        if (path.length == 2) {
            return new Date();
        }
        if (path.length == 3) {
            return this.loadPackageSnapshotFromRepository(repository, path).getCreatedDate().getTime();
        }
        if (path.length == 4) {
            return this.loadAssetItemFromPackageItem(this.loadPackageSnapshotFromRepository(repository, path), path[3]).getCreatedDate().getTime();
        }
        throw new UnsupportedOperationException();
    }

    private Date getCreationDateForPackage(RulesRepository repository, String[] path) {
        PackageItem packageItem = this.loadPackageFromRepository(repository, path[1]);
        if (path.length == 2) {
            return packageItem.getCreatedDate().getTime();
        }
        return this.loadAssetItemFromPackageItem(packageItem, path[2]).getCreatedDate().getTime();
    }

    public Date getLastModified(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return new Date();
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getLastModifiedForPackage(repository, path);
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getLastModifiedForSnaphotPackage(repository, path);
        }
        throw new UnsupportedOperationException();
    }

    private Date getLastModifiedForSnaphotPackage(RulesRepository repository, String[] path) {
        if (path.length == 2) {
            return new Date();
        }
        if (path.length == 3) {
            return this.loadPackageSnapshotFromRepository(repository, path).getLastModified().getTime();
        }
        if (path.length == 4) {
            PackageItem pkg = this.loadPackageSnapshotFromRepository(repository, path);
            return this.getLastModifiedFromPackageAssetItem(pkg, path[3]);
        }
        throw new UnsupportedOperationException();
    }

    private Date getLastModifiedForPackage(RulesRepository repository, String[] path) {
        PackageItem pkg = this.loadPackageFromRepository(repository, path[1]);
        if (path.length == 2) {
            return pkg.getLastModified().getTime();
        }
        return this.getLastModifiedFromPackageAssetItem(pkg, path[2]);
    }

    private Date getLastModifiedFromPackageAssetItem(PackageItem packageItem, String path) {
        return this.loadAssetItemFromPackageItem(packageItem, path).getLastModified().getTime();
    }

    public InputStream getResourceContent(ITransaction iTransaction, String uri) {
        return this.getContent(uri);
    }

    public StoredObject getStoredObject(ITransaction iTransaction, String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return this.createStoredObject(uri);
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getStoredObjectForReadOnlyPackages(uri, repository, path);
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getStoredObjectForReadOnlySnapshots(uri, repository, path);
        }
        throw new UnsupportedOperationException();
    }

    private StoredObject createStoredObject(String uri) {
        StoredObject so = new StoredObject();
        so.setCreationDate(new Date());
        so.setFolder(this.isFolder(uri));
        so.setLastModified(new Date());
        so.setResourceLength(0L);
        return so;
    }

    private StoredObject getStoredObjectForReadOnlySnapshots(String uri, RulesRepository repository, String[] path) {
        if (path.length == 2) {
            StoredObject so = this.createStoredObject(uri, (VersionableItem)this.loadPackageFromRepository(repository, path[1]), 0L);
            so.setFolder(this.isFolder(uri));
            return so;
        }
        if (path.length == 3) {
            return this.createStoredObject(uri, (VersionableItem)this.loadPackageSnapshotFromRepository(repository, path), 0L);
        }
        if (path.length == 4) {
            AssetItem asset;
            PackageItem pkg = this.loadPackageSnapshotFromRepository(repository, path);
            try {
                asset = this.loadAssetItemFromPackageItem(pkg, path[3]);
            }
            catch (Exception e) {
                return null;
            }
            return this.createStoredObject(uri, (VersionableItem)asset, asset.getContentLength());
        }
        throw new UnsupportedOperationException();
    }

    private StoredObject getStoredObjectForReadOnlyPackages(String uri, RulesRepository repository, String[] path) {
        AssetItem asset;
        PackageItem packageItem = this.loadPackageFromRepository(repository, path[1]);
        if (path.length == 2) {
            return this.createStoredObject(uri, (VersionableItem)packageItem, 0L);
        }
        try {
            asset = this.loadAssetItemFromPackageItem(packageItem, path[2]);
        }
        catch (Exception e) {
            return null;
        }
        return this.createStoredObject(uri, (VersionableItem)asset, asset.getContentLength());
    }

    private StoredObject createStoredObject(String uri, VersionableItem versionableItem, long resourceLength) {
        StoredObject so = new StoredObject();
        so.setCreationDate(versionableItem.getCreatedDate().getTime());
        so.setFolder(this.isFolder(uri));
        so.setLastModified(versionableItem.getLastModified().getTime());
        so.setResourceLength(resourceLength);
        return so;
    }

    private InputStream getContent(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getAssetData(this.loadAssetItemFromPackage(repository, path));
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getAssetData(this.loadAssetItemFromPackageSnaphot(repository, path));
        }
        throw new UnsupportedOperationException();
    }

    private InputStream getAssetData(AssetItem assetItem) {
        if (assetItem.isBinary()) {
            return assetItem.getBinaryContentAttachment();
        }
        return new ByteArrayInputStream(assetItem.getContent().getBytes());
    }

    public long getResourceLength(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        try {
            RulesRepository repository = this.getRepo();
            if (path.length == 3 && this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
                return this.loadAssetItemFromPackage(repository, path).getContentLength();
            }
            if (path.length == 4 && this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
                return this.loadAssetItemFromPackageSnaphot(repository, path).getContentLength();
            }
            return 0L;
        }
        catch (Exception e) {
            System.err.println("Not able to get content length");
            return 0L;
        }
    }

    boolean isFolder(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length == 0) {
            return true;
        }
        if (path.length == 1 && (this.isPackages(path) || this.isSnaphosts(path))) {
            return true;
        }
        if (path.length == 2) {
            return repository.containsPackage(path[1]);
        }
        if (path.length == 3 && this.isSnaphosts(path)) {
            return repository.containsPackage(path[1]);
        }
        return false;
    }

    boolean isResource(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 3) {
            return false;
        }
        if (!this.isPackages(path) && !this.isSnaphosts(path)) {
            return false;
        }
        if (repository.containsPackage(path[1])) {
            if (this.isPackages(path)) {
                PackageItem pkg = this.loadPackageFromRepository(repository, path[1]);
                if (path[2].startsWith("._")) {
                    return osxDoubleData.containsKey(uri);
                }
                return pkg.containsAsset(AssetItem.getAssetNameFromFileName((String)path[2])[0]);
            }
            if (path.length == 4) {
                return this.isAssetItemInPackage(repository, path);
            }
            return false;
        }
        return false;
    }

    boolean objectExists(String uri) {
        if (uri.indexOf(" copy ") > 0) {
            throw new IllegalArgumentException("OSX is not capable of copy and pasting without breaking the file extension.");
        }
        return this.internalObjectExists(uri);
    }

    private boolean internalObjectExists(String uri) {
        RulesRepository repository = this.getRepo();
        if (uri.endsWith(".DS_Store")) {
            return false;
        }
        String[] path = this.getPath(uri);
        if (path.length == 0 || path.length == 1 && (this.isPackages(path) || this.isSnaphosts(path))) {
            return true;
        }
        if (path.length == 1 || !repository.containsPackage(path[1])) {
            return false;
        }
        if (this.isPackages(path)) {
            return this.handlePackagesInternalObjectExists(uri, repository, path);
        }
        if (this.isSnaphosts(path)) {
            return this.handleSnapshotsInternalObjectExists(repository, path);
        }
        throw new IllegalStateException();
    }

    private boolean handleSnapshotsInternalObjectExists(RulesRepository repository, String[] path) {
        if (path.length == 2) {
            return repository.containsPackage(path[1]);
        }
        if (path.length == 3) {
            return repository.containsSnapshot(path[1], path[2]);
        }
        if (path.length == 4) {
            return this.isAssetItemInPackage(repository, path);
        }
        return false;
    }

    private boolean handlePackagesInternalObjectExists(String uri, RulesRepository repository, String[] path) {
        if (path.length == 2) {
            PackageItem pkg = this.loadPackageFromRepository(repository, path[1]);
            return !pkg.isArchived();
        }
        PackageItem pkg = this.loadPackageFromRepository(repository, path[1]);
        if (path[2].startsWith("._")) {
            return osxDoubleData.containsKey(uri);
        }
        String assetName = AssetItem.getAssetNameFromFileName((String)path[2])[0];
        return pkg.containsAsset(assetName) && !pkg.loadAsset(assetName).isArchived();
    }

    public void removeObject(ITransaction iTransaction, String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length == 0 || path.length == 1) {
            throw new IllegalArgumentException();
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfDeveloper(path)) {
            PackageItem packageItem = this.loadPackageFromRepository(repository, path[1]);
            if (path.length == 3) {
                if (path[2].startsWith("._")) {
                    osxDoubleData.remove(uri);
                    return;
                }
                AssetItem item = this.loadAssetItemFromPackageItem(packageItem, path[2]);
                item.archiveItem(true);
                item.checkin("");
            } else {
                packageItem.archiveItem(true);
                packageItem.checkin("");
            }
        } else {
            throw new IllegalArgumentException("Not allowed to remove this file.");
        }
    }

    public void rollback(ITransaction iTransaction) {
        RulesRepository repository = this.getRepo();
        repository.getSession().logout();
    }

    public long setResourceContent(ITransaction iTransaction, String uri, InputStream content, String contentType, String characterEncoding) {
        RulesRepository repository = this.getRepo();
        if (uri.endsWith(".DS_Store")) {
            return 0L;
        }
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.checkPackagePermissionIfDeveloper(path)) {
            if (path.length != 3) {
                throw new IllegalArgumentException("Not a valid resource path " + uri);
            }
            if (path[2].startsWith("._")) {
                try {
                    osxDoubleData.put(uri, IOUtils.toByteArray((InputStream)content));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return 0L;
            }
        } else {
            throw new UnsupportedOperationException("Unable to save content to this location.");
        }
        AssetItem asset = this.loadAssetItemFromPackage(repository, path);
        asset.updateBinaryContentAttachment(content);
        asset.checkin("<content from webdav>");
        return 0L;
    }

    String[] getPath(String uri) {
        return this.getPath(uri, false);
    }

    String[] getPath(String uri, boolean usingWebdavAsRegex) {
        if (uri.equals("/")) {
            return new String[0];
        }
        if (usingWebdavAsRegex) {
            if (uri.endsWith("webdav") || uri.endsWith("webdav/")) {
                return new String[0];
            }
            if (uri.indexOf("webdav/") > -1) {
                return uri.split("webdav/", 2)[1].split("/");
            }
        }
        return uri.substring(1).split("/");
    }

    private boolean isAdmin() {
        if (Contexts.isSessionContextActive()) {
            try {
                Identity.instance().checkPermission((Object)new AdminType(), "admin");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPackagePermission(String packageName, String type) {
        if (Contexts.isSessionContextActive()) {
            try {
                Identity.instance().checkPermission((Object)new WebDavPackageNameType(packageName), type);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private AssetItem loadAssetItemFromPackage(RulesRepository repository, String[] path) {
        return this.loadAssetItemFromPackageItem(this.loadPackageFromRepository(repository, path[1]), path[2]);
    }

    private AssetItem loadAssetItemFromPackageSnaphot(RulesRepository repository, String[] path) {
        return this.loadAssetItemFromPackageItem(this.loadPackageSnapshotFromRepository(repository, path), path[3]);
    }

    private AssetItem loadAssetItemFromPackageItem(PackageItem pkg, String path) {
        return pkg.loadAsset(AssetItem.getAssetNameFromFileName((String)path)[0]);
    }

    private boolean isAssetItemInPackage(RulesRepository repository, String[] path) {
        return this.loadPackageSnapshotFromRepository(repository, path).containsAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
    }

    private PackageItem loadPackageFromRepository(RulesRepository repository, String path) {
        return repository.loadPackage(path);
    }

    private PackageItem loadPackageSnapshotFromRepository(RulesRepository repository, String[] path) {
        return repository.loadPackageSnapshot(path[1], path[2]);
    }

    private boolean isPermission(String[] path, int pathIndex) {
        return path.length == pathIndex && this.checkPackagePermissionIfReadOnly(path);
    }

    private boolean checkPackagePermissionIfReadOnly(String[] path) {
        return this.checkPackagePermission(path[1], "package.readonly");
    }

    private boolean checkPackagePermissionIfDeveloper(String[] path) {
        return this.checkPackagePermission(path[1], "package.developer");
    }

    private boolean isPackages(String[] path) {
        return path[0].equals(PACKAGES);
    }

    private boolean isSnaphosts(String[] path) {
        return path[0].equals(SNAPSHOTS);
    }
}

