/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;

public class BuiltInSelector
implements AssetSelector {
    private String status;
    private String statusOperator;
    private String category;
    private String categoryOperator;
    private boolean enableStatusSelector;
    private boolean enableCategorySelector;

    public boolean isEnableStatusSelector() {
        return this.enableStatusSelector;
    }

    public void setEnableStatusSelector(boolean enableStatusSelector) {
        this.enableStatusSelector = enableStatusSelector;
    }

    public boolean isEnableCategorySelector() {
        return this.enableCategorySelector;
    }

    public void setEnableCategorySelector(boolean enableCategorySelector) {
        this.enableCategorySelector = enableCategorySelector;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryOperator() {
        return this.categoryOperator;
    }

    public void setCategoryOperator(String categoryOperator) {
        this.categoryOperator = categoryOperator;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusOperator() {
        return this.statusOperator;
    }

    public void setStatusOperator(String statusOperator) {
        this.statusOperator = statusOperator;
    }

    public boolean isAssetAllowed(AssetItem item) {
        if (this.enableStatusSelector && this.enableCategorySelector) {
            return this.isStatusAllowed(item) && this.isCategoryAllowed(item);
        }
        if (this.enableStatusSelector) {
            return this.isStatusAllowed(item);
        }
        if (this.enableCategorySelector) {
            return this.isCategoryAllowed(item);
        }
        return true;
    }

    private boolean isStatusAllowed(AssetItem item) {
        return "=".equals(this.statusOperator) ? item.getStateDescription().equals(this.status) : "!=".equals(this.statusOperator) && !item.getStateDescription().equals(this.status);
    }

    private boolean isCategoryAllowed(AssetItem item) {
        block3: {
            block2: {
                if (!"=".equals(this.categoryOperator)) break block2;
                for (CategoryItem cat : item.getCategories()) {
                    if (!cat.getName().equals(this.category)) continue;
                    return true;
                }
                break block3;
            }
            if (!"!=".equals(this.categoryOperator)) break block3;
            for (CategoryItem cat : item.getCategories()) {
                if (cat.getName().equals(this.category)) continue;
                return true;
            }
        }
        return false;
    }
}

