/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.standalonededitor;

import java.util.ArrayList;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.standalonededitor.RuleAssetProvider;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRXMLPersistence;

public class BRLRuleAssetProvider
implements RuleAssetProvider {
    private String packageName;
    private String[] initialBRLs;

    public BRLRuleAssetProvider(String packageName, String[] initialBRLs) {
        this.packageName = packageName;
        this.initialBRLs = initialBRLs;
    }

    public RuleAsset[] getRuleAssets() throws DetailedSerializationException {
        ArrayList<RuleModel> models = new ArrayList<RuleModel>(this.initialBRLs.length);
        ArrayList<RuleAsset> assets = new ArrayList<RuleAsset>(this.initialBRLs.length);
        for (String brl : this.initialBRLs) {
            models.add(BRXMLPersistence.getInstance().unmarshal(brl));
        }
        try {
            for (RuleModel ruleModel : models) {
                assets.add(this.createAsset(ruleModel));
            }
        }
        catch (Exception e) {
            for (RuleAsset ruleAsset : assets) {
                this.getService().removeAsset(ruleAsset.uuid);
            }
            if (e instanceof DetailedSerializationException) {
                throw (DetailedSerializationException)((Object)e);
            }
            throw new DetailedSerializationException("Error creating assets", e.getMessage());
        }
        return assets.toArray(new RuleAsset[assets.size()]);
    }

    private RuleAsset createAsset(RuleModel ruleModel) {
        RuleAsset asset = new RuleAsset();
        asset.uuid = "mock";
        asset.content = ruleModel;
        asset.metaData = this.createMetaData(ruleModel);
        return asset;
    }

    private MetaData createMetaData(RuleModel ruleModel) {
        MetaData metaData = new MetaData();
        metaData.name = ruleModel.name;
        metaData.packageName = this.packageName;
        metaData.format = "brl";
        metaData.packageUUID = "mock";
        return metaData;
    }

    private ServiceImplementation getService() {
        return RepositoryServiceServlet.getService();
    }
}

