/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.server.util.AssetLockManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;

@Scope(value=ScopeType.APPLICATION)
@Startup
@Name(value="assetLockManager")
public class AssetLockManager {
    private static final long LOCK_EXPIRATION_TIME = 1200000L;
    private Map<String, Lock> map = new HashMap();

    public static AssetLockManager instance() {
        return (AssetLockManager)Component.getInstance((String)"assetLockManager");
    }

    public boolean isAssetLocked(String uuid) {
        if (this.map.keySet().contains(uuid)) {
            long timeStamp = ((Lock)this.map.get((Object)uuid)).timeStamp;
            long currentTime = System.currentTimeMillis();
            if (currentTime - timeStamp > 1200000L) {
                this.map.remove(uuid);
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAssetLockerUserName(String uuid) {
        if (this.isAssetLocked(uuid)) {
            return ((Lock)this.map.get((Object)uuid)).userName;
        }
        return null;
    }

    public void lockAsset(String uuid, String userName) {
        this.map.put(uuid, new Lock(this, userName));
    }

    public void unLockAsset(String uuid) {
        this.map.remove(uuid);
    }
}

