/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integration.console.forms;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormDispatcher
implements FormDispatcherPlugin {
    public URL getDispatchUrl(FormAuthorityRef ref) {
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        sb.append("localhost");
        sb.append(":").append(8080);
        sb.append("/gwt-console-server/rs/form/" + this.getType(ref) + "/");
        sb.append(ref.getReferenceId());
        sb.append("/render");
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve form dispatch url", e);
        }
    }

    protected String getType(FormAuthorityRef ref) {
        FormAuthorityRef.Type type = ref.getType();
        if (type.equals((Object)FormAuthorityRef.Type.TASK)) {
            return "task";
        }
        if (type.equals((Object)FormAuthorityRef.Type.PROCESS)) {
            return "process";
        }
        throw new IllegalArgumentException("Unknown form authority type: " + ref.getType());
    }

    public InputStream getTemplate(String name) {
        return AbstractFormDispatcher.class.getResourceAsStream("/" + name + ".ftl");
    }

    protected DataHandler processTemplate(final String name, InputStream src, Map<String, Object> renderContext) {
        DataHandler merged = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            final ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            temp.process(renderContext, (Writer)out);
            ((Writer)out).flush();
            merged = new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(bout.toByteArray());
                }

                public OutputStream getOutputStream() throws IOException {
                    return bout;
                }

                public String getContentType() {
                    return "*/*";
                }

                public String getName() {
                    return name + "_DataSource";
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process form template", e);
        }
        return merged;
    }
}

