/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import org.drools.impact.analysis.graph.ReactivityType;

public enum LinkFilter {
    POSITIVE(true, false, false),
    POSITIVE_NEGATIVE(true, true, false),
    POSITIVE_UNKNOWN(true, false, true),
    NEGATIVE(false, true, false),
    NEGATIVE_UNKNOWN(false, true, true),
    UNKNOWN(false, false, true),
    ALL(true, true, true);

    private final boolean viewPositive;
    private final boolean viewNegative;
    private final boolean viewUnknown;

    private LinkFilter(boolean viewPositive, boolean viewNegative, boolean viewUnknown) {
        this.viewPositive = viewPositive;
        this.viewNegative = viewNegative;
        this.viewUnknown = viewUnknown;
    }

    public boolean isViewPositive() {
        return this.viewPositive;
    }

    public boolean isViewNegative() {
        return this.viewNegative;
    }

    public boolean isViewUnknown() {
        return this.viewUnknown;
    }

    boolean accept(ReactivityType type) {
        return this.viewPositive && type == ReactivityType.POSITIVE || this.viewNegative && type == ReactivityType.NEGATIVE || this.viewUnknown && type == ReactivityType.UNKNOWN;
    }
}

