/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph.graphviz;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizCmdLineEngine;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Link;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.util.PortablePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphImageGenerator {
    private static final Logger logger = LoggerFactory.getLogger(GraphImageGenerator.class);
    private static final PortablePath DEFAULT_OUTPUT_DIR = PortablePath.of((String)"target/graph-output");
    private static final String RENDER_FAILURE_WARN = "graphviz-java failed to render an image. Solutions would be:\n1. Install graphviz tools in your local machine. graphviz-java will use graphviz command line binary (e.g. /usr/bin/dot) if available.\n2. Consider generating a graph in DOT format and then visualize it with an external tool.";
    private boolean renderEngineFailed = false;
    private String graphName;
    private int width = 0;
    private int height = 0;
    private int totalMemory = 1000000000;
    private int cmdLineEngineTimeout = 600;
    private PortablePath outputDir = DEFAULT_OUTPUT_DIR;
    private Rank.RankDir rankDir = Rank.RankDir.LEFT_TO_RIGHT;
    private double sep = 1.0;

    public GraphImageGenerator(String graphName) {
        this.graphName = graphName;
        this.initEngines();
    }

    public static GraphImageGenerator getGraphImageGeneratorWithErrorGraphvizEngine(String graphName) {
        GraphImageGenerator generator = new GraphImageGenerator();
        generator.graphName = graphName;
        Graphviz.useEngine((GraphvizEngine)new GraphvizEngine(){

            public void close() throws Exception {
            }

            public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
                onError.accept(this);
            }

            public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
                return null;
            }
        }, (GraphvizEngine[])new GraphvizEngine[0]);
        return generator;
    }

    private GraphImageGenerator() {
    }

    public GraphImageGenerator(String graphName, int width, int height, int cmdLineEngineTimeout) {
        this.graphName = graphName;
        this.width = width;
        this.height = height;
        this.cmdLineEngineTimeout = cmdLineEngineTimeout;
        this.initEngines();
    }

    protected void initEngines() {
        GraphvizCmdLineEngine cmdLineEngine = new GraphvizCmdLineEngine();
        cmdLineEngine.timeout(this.cmdLineEngineTimeout, TimeUnit.SECONDS);
        Graphviz.useEngine((GraphvizEngine)cmdLineEngine, (GraphvizEngine[])new GraphvizEngine[]{new GraphvizV8Engine(), new GraphvizJdkEngine()});
    }

    public String getOutputDir() {
        return this.outputDir.asString();
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = PortablePath.of((String)outputDir);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Rank.RankDir getRankDir() {
        return this.rankDir;
    }

    public void setRankDir(Rank.RankDir rankDir) {
        this.rankDir = rankDir;
    }

    public double getSep() {
        return this.sep;
    }

    public void setSep(double sep) {
        this.sep = sep;
    }

    public int getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(int totalMemory) {
        this.totalMemory = totalMemory;
    }

    private guru.nidi.graphviz.model.Graph convertGraph(Graph g) {
        guru.nidi.graphviz.model.Graph graph = (guru.nidi.graphviz.model.Graph)Factory.graph((String)this.graphName).directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)this.rankDir).sep(this.sep));
        List nodeList = g.getNodeMap().values().stream().collect(Collectors.toList());
        for (Node n : nodeList) {
            guru.nidi.graphviz.model.Node node = Factory.node((String)n.getRuleName());
            if (n.getStatus() == Node.Status.CHANGED) {
                node = (guru.nidi.graphviz.model.Node)node.with((Attributes)Color.RED, (Attributes)Style.FILLED);
            } else if (n.getStatus() == Node.Status.IMPACTED) {
                node = (guru.nidi.graphviz.model.Node)node.with((Attributes)Color.YELLOW, (Attributes)Style.FILLED);
            } else if (n.getStatus() == Node.Status.TARGET) {
                node = (guru.nidi.graphviz.model.Node)node.with((Attributes)Color.ORANGE, (Attributes)Style.FILLED);
            } else if (n.getStatus() == Node.Status.IMPACTING) {
                node = (guru.nidi.graphviz.model.Node)node.with((Attributes)Color.LIGHTBLUE, (Attributes)Style.FILLED);
            }
            for (Link l : n.getOutgoingLinks()) {
                if (!nodeList.contains(l.getTarget())) continue;
                Style style = l.getReactivityType() == ReactivityType.POSITIVE ? Style.SOLID : (l.getReactivityType() == ReactivityType.NEGATIVE ? Style.DASHED : Style.DOTTED);
                node = node.link(new LinkTarget[]{Factory.to((guru.nidi.graphviz.model.Node)Factory.node((String)l.getTarget().getRuleName())).with((Attributes)style)});
            }
            graph = graph.with(new LinkSource[]{node});
        }
        return graph;
    }

    public String generateDot(Graph g) {
        guru.nidi.graphviz.model.Graph graph = this.convertGraph(g);
        try {
            String filePath = this.outputDir.asString() + File.separator + this.graphName + ".dot";
            Graphviz.fromGraph((guru.nidi.graphviz.model.Graph)graph).totalMemory(Integer.valueOf(this.totalMemory)).width(this.width).height(this.height).render(Format.DOT).toFile(new File(filePath));
            logger.info("--- Graph dot format is generated to {}", (Object)filePath);
            return filePath;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String generatePng(Graph g) {
        return this.generateImage(g, Format.PNG);
    }

    public String generateSvg(Graph g) {
        return this.generateImage(g, Format.SVG);
    }

    private String generateImage(Graph g, Format format) {
        if (this.renderEngineFailed) {
            logger.warn(RENDER_FAILURE_WARN);
            return null;
        }
        guru.nidi.graphviz.model.Graph graph = this.convertGraph(g);
        try {
            String filePath = this.outputDir.asString() + File.separator + this.graphName + "." + format.fileExtension;
            Graphviz.fromGraph((guru.nidi.graphviz.model.Graph)graph).totalMemory(Integer.valueOf(this.totalMemory)).width(this.width).height(this.height).render(format).toFile(new File(filePath));
            logger.info("--- Graph {} image is generated to {}", (Object)format.fileExtension, (Object)filePath);
            return filePath;
        }
        catch (GraphvizException e) {
            logger.warn(RENDER_FAILURE_WARN, (Throwable)e);
            this.renderEngineFailed = true;
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

