/*
 * Copyright (c) 2020. Red Hat, Inc. and/or its affiliates.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.impact.analysis.model.right;

public class ConsequenceAction {

    public enum Type {
        INSERT,
        DELETE,
        MODIFY;
    }

    private final Type type;
    private final Class<?> actionClass;

    public ConsequenceAction( Type type, Class<?> actionClass ) {
        this.type = type;
        this.actionClass = actionClass;
    }

    public Type getType() {
        return type;
    }

    public Class<?> getActionClass() {
        return actionClass;
    }

    @Override
    public String toString() {
        return "ConsequenceAction{" +
                "type=" + type +
                ", actionClass=" + actionClass.getCanonicalName() +
                '}';
    }
}
