/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.parser.impl;

import java.util.ArrayList;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.impact.analysis.model.Package;
import org.drools.impact.analysis.model.Rule;
import org.drools.impact.analysis.parser.impl.ImpactAnalysisRuleContext;
import org.drools.impact.analysis.parser.impl.LhsParser;
import org.drools.impact.analysis.parser.impl.RhsParser;
import org.drools.impact.analysis.parser.internal.ImpactModelBuilderImpl;
import org.drools.modelcompiler.builder.PackageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageParser {
    Logger logger = LoggerFactory.getLogger(PackageParser.class);
    private final ImpactModelBuilderImpl kbuilder;
    private final PackageModel packageModel;
    private final CompositePackageDescr packageDescr;
    private final PackageRegistry pkgRegistry;

    public PackageParser(ImpactModelBuilderImpl kbuilder, PackageModel packageModel, CompositePackageDescr packageDescr, PackageRegistry pkgRegistry) {
        this.kbuilder = kbuilder;
        this.packageModel = packageModel;
        this.packageDescr = packageDescr;
        this.pkgRegistry = pkgRegistry;
    }

    public Package parse() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
            rules.add(this.parseRule(ruleDescr));
        }
        return new Package(this.packageDescr.getName(), rules);
    }

    private Rule parseRule(RuleDescr ruleDescr) {
        ImpactAnalysisRuleContext context = new ImpactAnalysisRuleContext(this.kbuilder, this.packageModel, this.pkgRegistry.getTypeResolver(), ruleDescr);
        context.addGlobalDeclarations();
        context.setDialectFromAttributes(this.packageDescr.getAttributes());
        Rule rule = new Rule(this.packageDescr.getName(), ruleDescr.getName(), ruleDescr.getResource().getSourcePath());
        this.logger.debug("Parsing : " + rule.getName());
        new LhsParser(this.packageModel, this.pkgRegistry).parse(ruleDescr, context, rule);
        new RhsParser(this.pkgRegistry).parse(ruleDescr, context, rule);
        return rule;
    }
}

