/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.parser.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.builder.impl.ClassDefinitionFactory;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationFactory;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.Drools;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.impl.PackageParser;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;

public class ImpactModelBuilderImpl
extends KnowledgeBuilderImpl {
    private final ReleaseId releaseId;
    private final DRLIdGenerator exprIdGenerator = new DRLIdGenerator();
    private final Map<String, PackageModel> packageModels = new HashMap<String, PackageModel>();
    private Collection<CompositePackageDescr> compositePackages;
    private Map<String, CompositePackageDescr> compositePackagesMap;
    private final AnalysisModel analysisModel = new AnalysisModel();

    public ImpactModelBuilderImpl(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId) {
        super(configuration);
        this.releaseId = releaseId;
    }

    protected void doFirstBuildStep(Collection<CompositePackageDescr> packages) {
        this.compositePackages = packages;
    }

    public void addPackage(PackageDescr packageDescr) {
        CompositePackageDescr pkgDescr;
        if (this.compositePackagesMap == null) {
            this.compositePackagesMap = new HashMap<String, CompositePackageDescr>();
            if (this.compositePackages != null) {
                for (CompositePackageDescr pkg : this.compositePackages) {
                    this.compositePackagesMap.put(pkg.getNamespace(), pkg);
                }
            } else {
                this.compositePackagesMap.put(packageDescr.getNamespace(), new CompositePackageDescr(packageDescr.getResource(), packageDescr));
            }
            this.compositePackages = null;
        }
        if ((pkgDescr = this.compositePackagesMap.get(packageDescr.getNamespace())) == null) {
            this.compositePackagesMap.put(packageDescr.getNamespace(), new CompositePackageDescr(packageDescr.getResource(), packageDescr));
        } else {
            pkgDescr.addPackageDescr(packageDescr.getResource(), packageDescr);
        }
        PackageRegistry pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        for (ImportDescr importDescr : packageDescr.getImports()) {
            pkgRegistry.addImport(importDescr);
        }
        for (GlobalDescr globalDescr : packageDescr.getGlobals()) {
            try {
                Class globalType = pkg.getTypeResolver().resolveType(globalDescr.getType());
                this.addGlobal(globalDescr.getIdentifier(), globalType);
                pkg.addGlobal(globalDescr.getIdentifier(), globalType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void doSecondBuildStep(Collection<CompositePackageDescr> compositePackages) {
        Collection<CompositePackageDescr> packages = this.findPackages(compositePackages);
        this.initPackageRegistries(packages);
        this.registerTypeDeclarations(packages);
        this.buildOtherDeclarations(packages);
        this.buildRules(packages);
    }

    private Collection<CompositePackageDescr> findPackages(Collection<CompositePackageDescr> compositePackages) {
        Collection<Object> packages = compositePackages != null && !compositePackages.isEmpty() ? compositePackages : (this.compositePackagesMap != null ? this.compositePackagesMap.values() : Collections.emptyList());
        return packages;
    }

    protected void initPackageRegistries(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            PackageRegistry pkgRegistry;
            if (StringUtils.isEmpty((CharSequence)packageDescr.getName())) {
                packageDescr.setName(this.getBuilderConfiguration().getDefaultPackageName());
            }
            if ((pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace())) == null) {
                this.getOrCreatePackageRegistry((PackageDescr)packageDescr);
                continue;
            }
            for (ImportDescr importDescr : packageDescr.getImports()) {
                pkgRegistry.registerImport(importDescr.getTarget());
            }
        }
    }

    private void registerTypeDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            InternalKnowledgePackage pkg = this.getOrCreatePackageRegistry((PackageDescr)packageDescr).getPackage();
            for (TypeDeclarationDescr typeDescr : packageDescr.getTypeDeclarations()) {
                this.processTypeDeclarationDescr(pkg, (AbstractClassTypeDeclarationDescr)typeDescr);
            }
            for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
                this.processTypeDeclarationDescr(pkg, (AbstractClassTypeDeclarationDescr)enumDeclarationDescr);
            }
        }
    }

    private void processTypeDeclarationDescr(InternalKnowledgePackage pkg, AbstractClassTypeDeclarationDescr typeDescr) {
        this.normalizeAnnotations((AnnotatedBaseDescr)typeDescr, pkg.getTypeResolver(), false);
        try {
            Class typeClass = pkg.getTypeResolver().resolveType(typeDescr.getTypeName());
            String typePkg = typeClass.getPackage().getName();
            String typeName = typeClass.getName().substring(typePkg.length() + 1);
            TypeDeclaration type = new TypeDeclaration(typeName);
            type.setTypeClass(typeClass);
            type.setResource(typeDescr.getResource());
            if (Drools.hasMvel()) {
                type.setTypeClassDef(ClassDefinitionFactory.createClassDefinition((Class)typeClass, (Resource)typeDescr.getResource()));
            }
            TypeDeclarationFactory.processAnnotations((AbstractClassTypeDeclarationDescr)typeDescr, (TypeDeclaration)type);
            this.getOrCreatePackageRegistry(new PackageDescr(typePkg)).getPackage().addTypeDeclaration(type);
        }
        catch (ClassNotFoundException e) {
            TypeDeclaration type = new TypeDeclaration(typeDescr.getTypeName());
            type.setResource(typeDescr.getResource());
            TypeDeclarationFactory.processAnnotations((AbstractClassTypeDeclarationDescr)typeDescr, (TypeDeclaration)type);
            pkg.addTypeDeclaration(type);
        }
    }

    protected void buildRules(Collection<CompositePackageDescr> packages) {
        if (this.hasErrors()) {
            return;
        }
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter((KnowledgeBuilderImpl.AssetFilter)packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            PackageModel packageModel = this.getPackageModel((PackageDescr)packageDescr, pkgRegistry, packageDescr.getName());
            PackageModel.initPackageModel((KnowledgeBuilderImpl)this, (InternalKnowledgePackage)pkgRegistry.getPackage(), (TypeResolver)pkgRegistry.getTypeResolver(), (PackageDescr)packageDescr, (PackageModel)packageModel);
            this.analysisModel.addPackage(new PackageParser(this, packageModel, packageDescr, pkgRegistry).parse());
        }
    }

    private PackageModel getPackageModel(PackageDescr packageDescr, PackageRegistry pkgRegistry, String pkgName) {
        return this.packageModels.computeIfAbsent(pkgName, s -> PackageModel.createPackageModel((KnowledgeBuilderConfigurationImpl)this.getBuilderConfiguration(), (PackageDescr)packageDescr, (PackageRegistry)pkgRegistry, (String)pkgName, (ReleaseId)this.releaseId, (DRLIdGenerator)this.exprIdGenerator));
    }

    public AnalysisModel getAnalysisModel() {
        return this.analysisModel;
    }
}

