/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.jpdl.core.JpdlProcess;
import org.drools.jpdl.core.node.Decision;
import org.drools.jpdl.core.node.EndState;
import org.drools.jpdl.core.node.Fork;
import org.drools.jpdl.core.node.Join;
import org.drools.jpdl.core.node.JpdlNode;
import org.drools.jpdl.core.node.StartState;
import org.drools.jpdl.core.node.State;
import org.drools.jpdl.core.node.SuperState;
import org.jbpm.graph.def.Action;
import org.jbpm.instantiation.Delegation;

public class EpdlWriter {
    private static int suggestedNodeId = 99;

    public static void write(JpdlProcess process) {
        Node[] nodes = process.getNodes();
        boolean id = false;
        System.out.println("<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" type=\"RuleFlow\" name=\"flow\" id=\"" + process.getName() + "\" package-name=\"org.drools.examples\" >");
        System.out.println("<header>");
        System.out.println("</header>");
        EpdlWriter.printNodesAndConnections(nodes);
        System.out.println("</process>");
    }

    private static void printNodesAndConnections(Node[] nodes) {
        Map outConnections;
        Set keys;
        Node node2;
        String generatedConnections = "";
        System.out.println("<nodes>");
        for (Node node2 : nodes) {
            Delegation delegation;
            Set keys2;
            if (node2 instanceof StartState) {
                System.out.println("<start id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\" />");
                continue;
            }
            if (node2 instanceof Fork) {
                System.out.println("<split id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\" type=\"1\" />");
                continue;
            }
            if (node2 instanceof Join) {
                System.out.println("<join id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\" type=\"1\" />");
                continue;
            }
            if (node2 instanceof SuperState) {
                generatedConnections = generatedConnections + EpdlWriter.suggestSplitNode(node2);
                generatedConnections = generatedConnections + EpdlWriter.suggestJoinNode(node2);
                System.out.println("<composite id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\">");
                List<JpdlNode> nodesList = ((SuperState)node2).getNodes();
                EpdlWriter.printNodesAndConnections(nodesList.toArray(new Node[nodesList.size()]));
                EpdlWriter.printInPortsAndOutPorts(nodesList.toArray(new Node[nodesList.size()]));
                System.out.println("</composite>");
                continue;
            }
            if (node2 instanceof State) {
                generatedConnections = generatedConnections + EpdlWriter.suggestJoinNode(node2);
                System.out.println("<state id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\" >");
                System.out.println("    <constraints>");
                keys2 = node2.getOutgoingConnections().keySet();
                for (String key : keys2) {
                    for (Connection connection : node2.getOutgoingConnections(key)) {
                        System.out.println("        <constraint toNodeId=\"" + connection.getTo().getId() + "\" name=\"signalTo" + connection.getTo().getName() + "\" />");
                    }
                }
                System.out.println("    </constraints>");
                System.out.println("</state>");
                continue;
            }
            if (node2 instanceof Decision) {
                System.out.println("<split id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\" type=\"2\" >");
                System.out.println("    <constraints>");
                keys2 = node2.getOutgoingConnections().keySet();
                for (String key : keys2) {
                    for (Connection connection : node2.getOutgoingConnections(key)) {
                        System.out.println("        <constraint toNodeId=\"" + connection.getTo().getId() + "\" name=\"signalTo" + connection.getTo().getName() + "\" toType=\"DROOLS_DEFAULT\" type=\"rule\" dialect=\"java\" >");
                        System.out.println("        </constraint>");
                    }
                }
                System.out.println("    </constraints>");
                System.out.println("</split>");
                continue;
            }
            if (node2 instanceof EndState) {
                generatedConnections = generatedConnections + EpdlWriter.suggestJoinNode(node2);
                System.out.println("<end id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\" />");
                continue;
            }
            if (!(node2 instanceof JpdlNode)) continue;
            generatedConnections = generatedConnections + EpdlWriter.suggestSplitNode(node2);
            generatedConnections = generatedConnections + EpdlWriter.suggestJoinNode(node2);
            System.out.println("<actionNode id=\"" + node2.getId() + "\" name=\"" + node2.getName() + "\">");
            System.out.println("    <action type=\"expression\" dialect=\"java\" >");
            Action action = ((JpdlNode)node2).getAction();
            if (action == null || (delegation = action.getActionDelegation()) != null) {
                // empty if block
            }
            System.out.println("    </action>");
            System.out.println("</actionNode>");
        }
        System.out.println("</nodes>");
        System.out.println("<connections>");
        Node[] arr$ = nodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (keys = (outConnections = (node2 = arr$[i$]).getOutgoingConnections()).keySet()).size() != 0; ++i$) {
            for (String key : keys) {
                List connections = (List)outConnections.get(key);
                for (Connection connection : connections) {
                    System.out.println("    <connection from=\"" + node2.getId() + "\" to=\"" + connection.getTo().getId() + "\" />");
                }
            }
        }
        if (!generatedConnections.equals("")) {
            System.out.println("<!-- Generated Connection for suggested nodes -->");
            System.out.println(generatedConnections);
            System.out.println("<!-- END - Generated Connection for suggested nodes -->");
        }
        System.out.println("</connections>");
    }

    private static String suggestJoinNode(Node node) {
        String resultGeneratedConnection = "";
        Set incomingConnectionsTypes = node.getIncomingConnections().keySet();
        if (incomingConnectionsTypes.size() == 0) {
            return "";
        }
        String firstKey = (String)incomingConnectionsTypes.iterator().next();
        boolean suggestJoinNode = false;
        if (incomingConnectionsTypes.size() > 1) {
            suggestJoinNode = true;
        } else if (incomingConnectionsTypes.size() == 1 && ((List)node.getIncomingConnections().get(firstKey)).size() > 1) {
            suggestJoinNode = true;
        }
        if (suggestJoinNode) {
            System.out.println("<!-- This is a suggested Join Node -->");
            System.out.println("<join id=\"" + suggestedNodeId + "\" name=\"Join XOR - " + suggestedNodeId + "\" type=\"2\" />");
            for (String key : incomingConnectionsTypes) {
                Iterator itConnections = node.getIncomingConnections(key).iterator();
                long fromNodeId = 0L;
                while (itConnections.hasNext()) {
                    Connection connection = (Connection)itConnections.next();
                    Node fromNode = connection.getFrom();
                    fromNodeId = connection.getTo().getId();
                    if (fromNode instanceof State) {
                        System.out.println("<!-- Take a look at the State Node that is pointing here, you will need to change the constraint for signal it to the new JoinNode id -->");
                        System.out.println("<!-- in node id: " + fromNode.getId() + " / name: " + fromNode.getName() + " -->");
                        System.out.println("<!-- you should change the fromId (" + fromNodeId + ") attribute to: " + suggestedNodeId + "-->");
                        System.out.println("<!-- you can also change the name for something that reference the JoinNode -->");
                    }
                    fromNode.getOutgoingConnections(key).remove(connection);
                    resultGeneratedConnection = resultGeneratedConnection + "  <connection from=\"" + fromNode.getId() + "\" to=\"" + suggestedNodeId + "\" />\n";
                }
                resultGeneratedConnection = resultGeneratedConnection + "  <connection from=\"" + suggestedNodeId + "\" to=\"" + fromNodeId + "\" />\n";
            }
            System.out.println("<!-- END - This is a suggested Join Node -->");
            ++suggestedNodeId;
        }
        return resultGeneratedConnection;
    }

    private static String suggestSplitNode(Node node) {
        String resultGeneratedConnection = "";
        Set outgoingConnectionsTypes = node.getOutgoingConnections().keySet();
        if (outgoingConnectionsTypes.size() == 0) {
            return "";
        }
        String firstKey = (String)outgoingConnectionsTypes.iterator().next();
        boolean suggestSplitNode = false;
        if (outgoingConnectionsTypes.size() > 1) {
            suggestSplitNode = true;
        } else if (outgoingConnectionsTypes.size() == 1 && ((List)node.getOutgoingConnections().get(firstKey)).size() > 1) {
            suggestSplitNode = true;
        }
        if (suggestSplitNode) {
            System.out.println("<!-- This is a suggested Split Node -->");
            System.out.println("<split id=\"" + suggestedNodeId + "\" name=\"Split XOR - " + suggestedNodeId + "\" type=\"2\" >");
            System.out.println("    <constraints>");
            Set keys = node.getOutgoingConnections().keySet();
            for (String key : keys) {
                for (Connection connection : node.getOutgoingConnections(key)) {
                    System.out.println("        <constraint toNodeId=\"" + connection.getTo().getId() + "\" name=\"signalTo" + connection.getTo().getName() + "\" toType=\"DROOLS_DEFAULT\" type=\"rule\" dialect=\"java\" >");
                    System.out.println("        </constraint>");
                }
            }
            System.out.println("    </constraints>");
            System.out.println("</split>");
            System.out.println("<!-- END - This is a suggested Split Node -->");
            ArrayList<Connection> removeConnections = new ArrayList<Connection>();
            for (String key : outgoingConnectionsTypes) {
                for (Connection connection : node.getOutgoingConnections(key)) {
                    Node toNode = connection.getTo();
                    removeConnections.add(connection);
                    resultGeneratedConnection = resultGeneratedConnection + "  <connection from=\"" + suggestedNodeId + "\" to=\"" + toNode.getId() + "\" />\n";
                }
            }
            resultGeneratedConnection = resultGeneratedConnection + "  <connection from=\"" + node.getId() + "\" to=\"" + suggestedNodeId + "\" />\n";
            ++suggestedNodeId;
            for (Connection conn : removeConnections) {
                node.getOutgoingConnections(conn.getFromType()).remove(conn);
            }
        }
        return resultGeneratedConnection;
    }

    private static void printInPortsAndOutPorts(Node[] toArray) {
        int lastNode = 0;
        if (toArray.length > 1) {
            lastNode = toArray.length - 1;
        }
        System.out.println("<in-ports>");
        System.out.println("    <in-port type=\"DROOLS_DEFAULT\" nodeId=\"" + toArray[0].getId() + "\" nodeInType=\"DROOLS_DEFAULT\" />");
        System.out.println("</in-ports>");
        System.out.println("<out-ports>");
        System.out.println("    <out-port type=\"DROOLS_DEFAULT\" nodeId=\"" + toArray[lastNode].getId() + "\" nodeOutType=\"DROOLS_DEFAULT\" />");
        System.out.println("</out-ports>");
    }
}

