/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.jpdl.core.JpdlProcess;
import org.drools.jpdl.core.node.EndState;
import org.drools.jpdl.core.node.StartState;
import org.drools.process.core.Work;
import org.drools.process.core.context.variable.Variable;
import org.drools.process.core.validation.ProcessValidationError;
import org.drools.process.core.validation.ProcessValidator;
import org.drools.process.core.validation.impl.ProcessValidationErrorImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.Join;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.core.node.RuleSetNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.WorkItemNode;
import org.mvel2.ErrorDetail;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlProcessValidator
implements ProcessValidator {
    private static JpdlProcessValidator instance;

    private JpdlProcessValidator() {
    }

    public static JpdlProcessValidator getInstance() {
        if (instance == null) {
            instance = new JpdlProcessValidator();
        }
        return instance;
    }

    public ProcessValidationError[] validateProcess(JpdlProcess process) {
        ArrayList<ProcessValidationError> errors = new ArrayList<ProcessValidationError>();
        if (process.getName() == null) {
            errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Process has no id."));
        }
        if (process.getPackageName() == null || "".equals(process.getPackageName())) {
            errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Process has no package name."));
        }
        Node[] nodes = process.getNodes();
        this.validateNodes(nodes, errors, process);
        Node startNode = process.getStart();
        if (startNode == null) {
            errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Process has no start node."));
        }
        for (Variable variable : process.getVariableScope().getVariables()) {
            if (variable.getType() != null) continue;
            errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Variable '" + variable.getName() + "' has no type."));
        }
        this.checkAllNodesConnectedToStart(process, errors);
        return errors.toArray(new ProcessValidationError[errors.size()]);
    }

    private void validateNodes(Node[] nodes, List<ProcessValidationError> errors, JpdlProcess process) {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof StartState) {
                StartState startState = (StartState)node;
                if (startState.getOutgoingConnections().size() == 0) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Start state '" + node.getName() + "' [" + node.getId() + "] has no outgoing connections."));
                }
                boolean outgoingConnection = false;
                for (List connections : startState.getOutgoingConnections().values()) {
                    if (connections.size() <= 0) continue;
                    outgoingConnection = true;
                    break;
                }
                if (outgoingConnection) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Start state '" + node.getName() + "' [" + node.getId() + "] has no outgoing connections."));
                continue;
            }
            if (node instanceof EndState) {
                List connections;
                EndState endState = (EndState)node;
                if (endState.getIncomingConnections().size() != 1) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "End state '" + node.getName() + "' [" + node.getId() + "] has more than one type of incoming connections."));
                }
                if ((connections = endState.getIncomingConnections("DROOLS_DEFAULT")) != null && connections.size() != 0) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "End state '" + node.getName() + "' [" + node.getId() + "] has no default incoming connections."));
                continue;
            }
            if (node instanceof RuleSetNode) {
                String ruleFlowGroup;
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (ruleSetNode.getFrom() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (ruleSetNode.getTo() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if ((ruleFlowGroup = ruleSetNode.getRuleFlowGroup()) != null && !"".equals(ruleFlowGroup)) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no ruleflow-group."));
                continue;
            }
            if (node instanceof Split) {
                Split split = (Split)node;
                if (split.getType() == 0) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (split.getFrom() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (split.getDefaultOutgoingConnections().size() < 2) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have more than one outgoing connection: " + split.getOutgoingConnections().size() + "."));
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    if (split.getConstraint(connection) != null) continue;
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have a constraint for " + connection.toString() + "."));
                }
                continue;
            }
            if (node instanceof Join) {
                Join join = (Join)node;
                if (join.getType() == 0) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (join.getDefaultIncomingConnections().size() < 2) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Join node '" + node.getName() + "' [" + node.getId() + "] does not have more than one incoming connection: " + join.getIncomingConnections().size() + "."));
                }
                if (join.getTo() != null) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                continue;
            }
            if (node instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)node;
                if (milestone.getFrom() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (milestone.getTo() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (milestone.getConstraint() != null) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no constraint."));
                continue;
            }
            if (node instanceof SubProcessNode) {
                SubProcessNode subProcess = (SubProcessNode)node;
                if (subProcess.getFrom() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (subProcess.getTo() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (subProcess.getProcessId() != null) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no process id."));
                continue;
            }
            if (node instanceof ActionNode) {
                ActionNode actionNode = (ActionNode)node;
                if (actionNode.getFrom() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (actionNode.getTo() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (actionNode.getAction() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no action."));
                    continue;
                }
                if (!(actionNode.getAction() instanceof DroolsConsequenceAction)) continue;
                DroolsConsequenceAction droolsAction = (DroolsConsequenceAction)actionNode.getAction();
                String actionString = droolsAction.getConsequence();
                if (actionString == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Action node '" + node.getName() + "' [" + node.getId() + "] has empty action."));
                    continue;
                }
                try {
                    ExpressionCompiler compiler = new ExpressionCompiler(actionString);
                    compiler.setVerifying(true);
                    ParserContext parserContext = new ParserContext();
                    compiler.compile(parserContext);
                    List mvelErrors = parserContext.getErrorList();
                    if (mvelErrors == null) continue;
                    for (ErrorDetail error : mvelErrors) {
                        errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + error.getMessage() + "."));
                    }
                    continue;
                }
                catch (Throwable t) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + t.getMessage() + "."));
                    continue;
                }
            }
            if (node instanceof WorkItemNode) {
                WorkItemNode workItemNode = (WorkItemNode)node;
                if (workItemNode.getFrom() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (workItemNode.getTo() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (workItemNode.getWork() == null) {
                    errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no work specified."));
                    continue;
                }
                Work work = workItemNode.getWork();
                if (work.getName() != null) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no work name."));
                continue;
            }
            if (!(node instanceof CompositeNode)) continue;
            CompositeNode compositeNode = (CompositeNode)node;
            for (String inType : compositeNode.getLinkedIncomingNodes().keySet()) {
                if (compositeNode.getIncomingConnections(inType).size() != 0) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection for type " + inType));
            }
            for (String outType : compositeNode.getLinkedOutgoingNodes().keySet()) {
                if (compositeNode.getOutgoingConnections(outType).size() != 0) continue;
                errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection for type " + outType));
            }
            this.validateNodes(compositeNode.getNodes(), errors, process);
        }
    }

    private void checkAllNodesConnectedToStart(JpdlProcess process, List<ProcessValidationError> errors) {
        HashMap<Node, Boolean> processNodes = new HashMap<Node, Boolean>();
        Node[] nodes = process.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
        }
        Node startNode = process.getStart();
        if (startNode != null) {
            this.processNode(startNode, processNodes);
        }
        for (Node node : processNodes.keySet()) {
            if (!Boolean.FALSE.equals(processNodes.get(node))) continue;
            errors.add((ProcessValidationError)new ProcessValidationErrorImpl((Process)process, "Node '" + node.getName() + "' [" + node.getId() + "] has no connection to the start node."));
        }
    }

    private void processNode(Node node, Map<Node, Boolean> nodes) {
        if (!nodes.containsKey(node)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process.");
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE) {
            for (List list : node.getOutgoingConnections().values()) {
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    this.processNode(((Connection)it2.next()).getTo(), nodes);
                }
            }
        }
    }

    public ProcessValidationError[] validateProcess(Process process) {
        if (!(process instanceof JpdlProcess)) {
            throw new IllegalArgumentException("This validator can only validate ruleflow processes!");
        }
        return this.validateProcess((JpdlProcess)process);
    }
}

