/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.core.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.process.core.Context;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.workflow.core.impl.NodeImpl;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlNode
extends NodeImpl {
    private static final long serialVersionUID = 1L;
    private Map<String, Event> events;
    private Action action;

    public JpdlNode() {
        this.setContext("ExceptionScope", (Context)new ExceptionScope());
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Connection getOutgoingConnection(String type) {
        List connections = this.getOutgoingConnections(type);
        if (connections == null || connections.size() == 0) {
            return null;
        }
        return (Connection)connections.get(0);
    }

    public Map<String, Event> getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return this.events != null && this.events.size() > 0;
    }

    public Event getEvent(String eventType) {
        Event event = null;
        if (this.events != null) {
            event = this.events.get(eventType);
        }
        return event;
    }

    public boolean hasEvent(String eventType) {
        boolean hasEvent = false;
        if (this.events != null) {
            hasEvent = this.events.containsKey(eventType);
        }
        return hasEvent;
    }

    public Event addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("can't add a null event to a graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't add an event without an eventType to a graph element");
        }
        if (this.events == null) {
            this.events = new HashMap<String, Event>();
        }
        this.events.put(event.getEventType(), event);
        return event;
    }

    public Event removeEvent(Event event) {
        Event removedEvent = null;
        if (event == null) {
            throw new IllegalArgumentException("can't remove a null event from a graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't remove an event without an eventType from a graph element");
        }
        if (this.events != null) {
            removedEvent = this.events.remove(event.getEventType());
        }
        return removedEvent;
    }

    public ExceptionScope getExceptionScope() {
        return (ExceptionScope)this.getContext("ExceptionScope");
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't add a null exceptionHandler to a graph element");
        }
        this.getExceptionScope().setExceptionHandler(exceptionHandler.getExceptionClassName(), (org.drools.process.core.context.exception.ExceptionHandler)new JpdlExceptionHandler(exceptionHandler));
        return exceptionHandler;
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't remove a null exceptionHandler from an graph element");
        }
        this.getExceptionScope().removeExceptionHandler(exceptionHandler.getExceptionClassName());
    }

    private class JpdlExceptionHandler
    implements org.drools.process.core.context.exception.ExceptionHandler {
        private ExceptionHandler exceptionHandler;
        private String faultVariable;

        private JpdlExceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        public ExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public String getFaultVariable() {
            return this.faultVariable;
        }

        public void setFaultVariable(String faultVariable) {
            this.faultVariable = faultVariable;
        }
    }
}

