/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.jpdl.core.node.Join;
import org.drools.jpdl.instance.node.JpdlNodeInstance;
import org.drools.workflow.instance.NodeInstance;
import org.jbpm.graph.exe.Token;

public class JoinInstance
extends JpdlNodeInstance {
    private static final long serialVersionUID = 1L;
    private Map<Long, Integer> triggers = new HashMap<Long, Integer>();

    public Join getJoin() {
        return (Join)this.getNode();
    }

    public void execute(NodeInstance from, String type) {
        if (this.getJoin().isDiscriminator()) {
            this.leave();
        } else {
            Integer count = this.triggers.get(type);
            if (count == null) {
                this.triggers.put(from.getNodeId(), 1);
            } else {
                this.triggers.put(from.getNodeId(), count + 1);
            }
            if (this.getJoin().getTokenNames() != null) {
                Collection<String> tokenNames = this.getJoin().getTokenNames();
            } else if (this.getJoin().getScript() != null) {
                Map result = null;
                try {
                    result = this.getJoin().getScript().eval((Token)null);
                }
                catch (Exception e) {
                    this.raiseException(e);
                }
                if (!(result instanceof Collection) && result instanceof Boolean && ((Boolean)((Object)result)).booleanValue()) {
                    this.leave();
                }
            } else if (this.getJoin().getNOutOfM() != -1) {
                if (this.triggers.size() >= this.getJoin().getNOutOfM()) {
                    this.resetAllTriggers();
                    this.leave();
                }
            } else if (this.checkAllTriggers()) {
                this.decreaseAllTriggers();
                this.leave();
            }
        }
    }

    private boolean checkAllTriggers() {
        for (Connection connection : this.getJoin().getIncomingConnections("DROOLS_DEFAULT")) {
            if (this.triggers.get(connection.getFrom().getId()) != null) continue;
            return false;
        }
        return true;
    }

    private void decreaseAllTriggers() {
        for (Connection connection : this.getJoin().getIncomingConnections("DROOLS_DEFAULT")) {
            Integer count = this.triggers.get(connection.getFrom().getId());
            if (count == 1) {
                this.triggers.remove(connection.getFrom().getId());
                continue;
            }
            this.triggers.put(connection.getFrom().getId(), count - 1);
        }
    }

    private void resetAllTriggers() {
        this.triggers.clear();
    }
}

