/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.audit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.audit.event.ActivationLogEvent;
import org.drools.core.audit.event.ILogEventFilter;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.ObjectLogEvent;
import org.drools.core.audit.event.RuleBaseLogEvent;
import org.drools.core.audit.event.RuleFlowGroupLogEvent;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.drools.core.audit.event.RuleFlowVariableLogEvent;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.spi.Activation;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.spi.Tuple;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.kiesession.session.StatelessKnowledgeSessionImpl;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.AfterFunctionRemovedEvent;
import org.kie.api.event.kiebase.AfterKieBaseLockedEvent;
import org.kie.api.event.kiebase.AfterKieBaseUnlockedEvent;
import org.kie.api.event.kiebase.AfterKiePackageAddedEvent;
import org.kie.api.event.kiebase.AfterKiePackageRemovedEvent;
import org.kie.api.event.kiebase.AfterProcessAddedEvent;
import org.kie.api.event.kiebase.AfterProcessRemovedEvent;
import org.kie.api.event.kiebase.AfterRuleAddedEvent;
import org.kie.api.event.kiebase.AfterRuleRemovedEvent;
import org.kie.api.event.kiebase.BeforeFunctionRemovedEvent;
import org.kie.api.event.kiebase.BeforeKieBaseLockedEvent;
import org.kie.api.event.kiebase.BeforeKieBaseUnlockedEvent;
import org.kie.api.event.kiebase.BeforeKiePackageAddedEvent;
import org.kie.api.event.kiebase.BeforeKiePackageRemovedEvent;
import org.kie.api.event.kiebase.BeforeProcessAddedEvent;
import org.kie.api.event.kiebase.BeforeProcessRemovedEvent;
import org.kie.api.event.kiebase.BeforeRuleAddedEvent;
import org.kie.api.event.kiebase.BeforeRuleRemovedEvent;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.command.RegistryContext;

public abstract class WorkingMemoryLogger
implements RuleRuntimeEventListener,
AgendaEventListener,
ProcessEventListener,
KieBaseEventListener {
    private List<ILogEventFilter> filters = new ArrayList<ILogEventFilter>();

    public WorkingMemoryLogger() {
    }

    public WorkingMemoryLogger(WorkingMemory workingMemory) {
        workingMemory.addEventListener((RuleRuntimeEventListener)this);
        workingMemory.addEventListener((AgendaEventListener)this);
        this.setProcessRuntimeEventListener((InternalWorkingMemory)workingMemory);
        workingMemory.addEventListener((KieBaseEventListener)this);
    }

    private void setProcessRuntimeEventListener(InternalWorkingMemory workingMemory) {
        try {
            InternalProcessRuntime processRuntime = workingMemory.getProcessRuntime();
            if (processRuntime != null) {
                processRuntime.addEventListener((ProcessEventListener)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WorkingMemoryLogger(KieRuntimeEventManager session) {
        if (session instanceof StatefulKnowledgeSessionImpl) {
            StatefulKnowledgeSessionImpl statefulSession;
            StatefulKnowledgeSessionImpl eventManager = statefulSession = (StatefulKnowledgeSessionImpl)session;
            eventManager.addEventListener(this);
            eventManager.addEventListener(this);
            eventManager.addEventListener(this);
            this.setProcessRuntimeEventListener((InternalWorkingMemory)session);
        } else if (session instanceof StatelessKnowledgeSessionImpl) {
            StatelessKnowledgeSessionImpl statelessSession = (StatelessKnowledgeSessionImpl)session;
            statelessSession.addEventListener(this);
            statelessSession.addEventListener(this);
            statelessSession.getKnowledgeBase().addEventListener(this);
        } else if (session instanceof CommandBasedStatefulKnowledgeSession) {
            StatefulKnowledgeSessionImpl statefulSession;
            StatefulKnowledgeSessionImpl eventManager = statefulSession = (StatefulKnowledgeSessionImpl)((RegistryContext)((CommandBasedStatefulKnowledgeSession)session).getRunner().createContext()).lookup(KieSession.class);
            eventManager.addEventListener(this);
            eventManager.addEventListener(this);
            InternalProcessRuntime processRuntime = eventManager.getProcessRuntime();
            eventManager.addEventListener(this);
            if (processRuntime != null) {
                processRuntime.addEventListener((ProcessEventListener)this);
            }
        } else {
            throw new IllegalArgumentException("Not supported session in logger: " + session.getClass());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.filters = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.filters);
    }

    public abstract void logEventCreated(LogEvent var1);

    private void filterLogEvent(LogEvent logEvent) {
        for (ILogEventFilter filter : this.filters) {
            if (filter.acceptEvent(logEvent)) continue;
            return;
        }
        this.logEventCreated(logEvent);
    }

    public void addFilter(ILogEventFilter filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filters.add(filter);
    }

    public void removeFilter(ILogEventFilter filter) {
        this.filters.remove(filter);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void objectInserted(ObjectInsertedEvent event) {
        this.filterLogEvent((LogEvent)new ObjectLogEvent(1, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    public void objectUpdated(ObjectUpdatedEvent event) {
        this.filterLogEvent((LogEvent)new ObjectLogEvent(2, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    public void objectDeleted(ObjectDeletedEvent event) {
        this.filterLogEvent((LogEvent)new ObjectLogEvent(3, ((InternalFactHandle)event.getFactHandle()).getId(), event.getOldObject().toString()));
    }

    public void matchCreated(MatchCreatedEvent event) {
        this.filterLogEvent((LogEvent)new ActivationLogEvent(4, WorkingMemoryLogger.getActivationId(event.getMatch()), event.getMatch().getRule().getName(), this.extractDeclarations(event.getMatch()), ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup(), this.extractFactHandleIds((Activation)event.getMatch())));
    }

    public void matchCancelled(MatchCancelledEvent event) {
        this.filterLogEvent((LogEvent)new ActivationLogEvent(5, WorkingMemoryLogger.getActivationId(event.getMatch()), event.getMatch().getRule().getName(), this.extractDeclarations(event.getMatch()), ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup(), this.extractFactHandleIds((Activation)event.getMatch())));
    }

    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        this.filterLogEvent((LogEvent)new ActivationLogEvent(6, WorkingMemoryLogger.getActivationId(event.getMatch()), event.getMatch().getRule().getName(), this.extractDeclarations(event.getMatch()), ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup(), this.extractFactHandleIds((Activation)event.getMatch())));
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        this.filterLogEvent((LogEvent)new ActivationLogEvent(7, WorkingMemoryLogger.getActivationId(event.getMatch()), event.getMatch().getRule().getName(), this.extractDeclarations(event.getMatch()), ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup(), this.extractFactHandleIds((Activation)event.getMatch())));
    }

    private String extractDeclarations(Match match) {
        StringBuilder result = new StringBuilder();
        List declarations = match.getDeclarationIds();
        Map declsMap = ((AgendaItem)match).getTerminalNode().getSubRule().getOuterDeclarations();
        for (int i = 0; i < declarations.size(); ++i) {
            String declaration = (String)declarations.get(i);
            Declaration decl = (Declaration)declsMap.get(declaration);
            InternalFactHandle handle = ((Tuple)match).get(decl);
            if (!handle.isValid()) continue;
            Object value = decl.getValue(null, handle.getObject());
            result.append(declaration);
            result.append("=");
            if (value == null) {
                result.append("null");
            } else {
                result.append(value);
            }
            if (i >= declarations.size() - 1) continue;
            result.append("; ");
        }
        return result.toString();
    }

    private String extractFactHandleIds(Activation activation) {
        InternalFactHandle activatingFact = activation.getPropagationContext().getFactHandle();
        StringBuilder sb = new StringBuilder();
        if (activatingFact != null) {
            sb.append(activatingFact.getId());
        }
        InternalFactHandle[] factHandles = activation.getTuple().toFactHandles();
        for (int i = 0; i < factHandles.length; ++i) {
            if (activatingFact != null) {
                if (activatingFact.getId() == factHandles[i].getId()) continue;
                sb.append(",");
            } else if (i > 0) {
                sb.append(",");
            }
            sb.append(factHandles[i].getId());
        }
        return sb.toString();
    }

    private static String getActivationId(Match match) {
        StringBuilder result = new StringBuilder(match.getRule().getName());
        result.append(" [");
        List factHandles = match.getFactHandles();
        for (int i = 0; i < factHandles.size(); ++i) {
            result.append(((InternalFactHandle)factHandles.get(i)).getId());
            if (i >= factHandles.size() - 1) continue;
            result.append(", ");
        }
        return result.append("]").toString();
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowGroupLogEvent(12, event.getRuleFlowGroup().getName(), ((RuleFlowGroup)event.getRuleFlowGroup()).size()));
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowGroupLogEvent(13, event.getRuleFlowGroup().getName(), ((RuleFlowGroup)event.getRuleFlowGroup()).size()));
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowGroupLogEvent(14, event.getRuleFlowGroup().getName(), ((RuleFlowGroup)event.getRuleFlowGroup()).size()));
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowGroupLogEvent(15, event.getRuleFlowGroup().getName(), ((RuleFlowGroup)event.getRuleFlowGroup()).size()));
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowLogEvent(8, event.getProcessInstance()));
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowLogEvent(9, event.getProcessInstance()));
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowLogEvent(10, event.getProcessInstance()));
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowLogEvent(11, event.getProcessInstance()));
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowNodeLogEvent(24, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance()));
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowNodeLogEvent(25, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance()));
    }

    private String createNodeId(NodeInstance nodeInstance) {
        Node node = nodeInstance.getNode();
        if (node == null) {
            return "";
        }
        Object uniqueIdObj = node.getMetaData().get("UniqueId");
        String nodeId = uniqueIdObj == null ? "" + node.getId() : (String)uniqueIdObj;
        NodeContainer nodeContainer = node.getNodeContainer();
        while (nodeContainer != null && nodeContainer instanceof Node) {
            node = (Node)nodeContainer;
            if ((nodeContainer = node.getNodeContainer()).getClass().getName().endsWith("ForEachNode")) continue;
            nodeId = node.getId() + ":" + nodeId;
        }
        return nodeId;
    }

    private String createNodeInstanceId(NodeInstance nodeInstance) {
        String nodeInstanceId = "" + nodeInstance.getId();
        NodeInstanceContainer nodeContainer = nodeInstance.getNodeInstanceContainer();
        while (nodeContainer != null && nodeContainer instanceof NodeInstance) {
            nodeInstance = (NodeInstance)nodeContainer;
            nodeInstanceId = nodeInstance.getId() + ":" + nodeInstanceId;
            nodeContainer = nodeInstance.getNodeInstanceContainer();
        }
        return nodeInstanceId;
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowNodeLogEvent(26, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance()));
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowNodeLogEvent(27, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance()));
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowVariableLogEvent(32, event.getVariableId(), event.getVariableInstanceId(), event.getProcessInstance(), event.getNewValue() == null ? "null" : event.getNewValue().toString()));
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        this.filterLogEvent((LogEvent)new RuleFlowVariableLogEvent(33, event.getVariableId(), event.getVariableInstanceId(), event.getProcessInstance(), event.getNewValue() == null ? "null" : event.getNewValue().toString()));
    }

    public void afterKiePackageAdded(AfterKiePackageAddedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(17, event.getKiePackage().getName(), null));
    }

    public void afterKiePackageRemoved(AfterKiePackageRemovedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(19, event.getKiePackage().getName(), null));
    }

    public void beforeKieBaseLocked(BeforeKieBaseLockedEvent event) {
    }

    public void afterKieBaseLocked(AfterKieBaseLockedEvent event) {
    }

    public void beforeKieBaseUnlocked(BeforeKieBaseUnlockedEvent event) {
    }

    public void afterKieBaseUnlocked(AfterKieBaseUnlockedEvent event) {
    }

    public void afterRuleAdded(AfterRuleAddedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(21, event.getRule().getPackageName(), event.getRule().getName()));
    }

    public void afterRuleRemoved(AfterRuleRemovedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(23, event.getRule().getPackageName(), event.getRule().getName()));
    }

    public void beforeFunctionRemoved(BeforeFunctionRemovedEvent event) {
    }

    public void beforeKiePackageAdded(BeforeKiePackageAddedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(16, event.getKiePackage().getName(), null));
    }

    public void beforeKiePackageRemoved(BeforeKiePackageRemovedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(18, event.getKiePackage().getName(), null));
    }

    public void beforeRuleAdded(BeforeRuleAddedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(20, event.getRule().getPackageName(), event.getRule().getName()));
    }

    public void beforeRuleRemoved(BeforeRuleRemovedEvent event) {
        this.filterLogEvent((LogEvent)new RuleBaseLogEvent(22, event.getRule().getPackageName(), event.getRule().getName()));
    }

    public void afterFunctionRemoved(AfterFunctionRemovedEvent event) {
    }

    public void beforeProcessAdded(BeforeProcessAddedEvent event) {
    }

    public void afterProcessAdded(AfterProcessAddedEvent event) {
    }

    public void beforeProcessRemoved(BeforeProcessRemovedEvent event) {
    }

    public void afterProcessRemoved(AfterProcessRemovedEvent event) {
    }
}

