/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.agenda;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.common.ActivationGroupImpl;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.AgendaGroupsManager;
import org.drools.core.common.InternalActivationGroup;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleFlowGroup;
import org.drools.core.concurrent.GroupEvaluator;
import org.drools.core.concurrent.ParallelGroupEvaluator;
import org.drools.core.concurrent.SequentialGroupEvaluator;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SynchronizedBypassPropagationList;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.drools.core.phreak.ThreadUnsafePropagationList;
import org.drools.core.reteoo.AgendaComponentFactory;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.consequence.ConsequenceExceptionHandler;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.index.TupleList;
import org.drools.util.StringUtils;
import org.drools.wiring.api.ComponentsFactory;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.AgendaGroup;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgenda
implements InternalAgenda {
    protected static final Logger log = LoggerFactory.getLogger(DefaultAgenda.class);
    private static final long serialVersionUID = 510L;
    protected final InternalWorkingMemory workingMemory;
    private final Map<String, InternalActivationGroup> activationGroups;
    private final LinkedList<RuleAgendaItem> eager = new LinkedList();
    private final Map<QueryImpl, RuleAgendaItem> queries = new ConcurrentHashMap<QueryImpl, RuleAgendaItem>();
    private ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private org.kie.api.runtime.rule.ConsequenceExceptionHandler consequenceExceptionHandler;
    protected int activationCounter;
    private final boolean declarativeAgenda;
    private final boolean sequential;
    private ActivationsFilter activationsFilter;
    private final List<PropagationContext> expirationContexts;
    private final GroupEvaluator groupEvaluator;
    private final PropagationList propagationList;
    private final ExecutionStateMachine executionStateMachine;
    private final AgendaGroupsManager agendaGroupsManager;

    public DefaultAgenda(InternalWorkingMemory workingMemory) {
        this(workingMemory, null);
    }

    DefaultAgenda(InternalWorkingMemory workingMemory, ExecutionStateMachine executionStateMachine) {
        this.workingMemory = workingMemory;
        this.agendaGroupsManager = AgendaGroupsManager.create((InternalWorkingMemory)workingMemory);
        this.activationGroups = new HashMap<String, InternalActivationGroup>();
        this.executionStateMachine = executionStateMachine != null ? executionStateMachine : (workingMemory.getRuleSessionConfiguration().isThreadSafe() ? new ConcurrentExecutionStateMachine() : new UnsafeExecutionStateMachine());
        InternalRuleBase kBase = workingMemory.getKnowledgeBase();
        RuleBaseConfiguration ruleBaseConf = kBase.getRuleBaseConfiguration();
        Object object = ComponentsFactory.createConsequenceExceptionHandler((String)ruleBaseConf.getConsequenceExceptionHandler(), (ClassLoader)ruleBaseConf.getClassLoader());
        if (object instanceof ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (org.kie.api.runtime.rule.ConsequenceExceptionHandler)object;
        }
        this.declarativeAgenda = ruleBaseConf.isDeclarativeAgenda();
        this.sequential = ruleBaseConf.isSequential();
        this.expirationContexts = ruleBaseConf.getEventProcessingMode() == EventProcessingOption.STREAM ? new ArrayList() : null;
        this.groupEvaluator = ruleBaseConf.isParallelEvaluation() && !ruleBaseConf.isParallelExecution() ? new ParallelGroupEvaluator((ActivationsManager)this) : new SequentialGroupEvaluator((ActivationsManager)this);
        this.propagationList = this.createPropagationList();
    }

    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory rs, TerminalNode rtn) {
        String ruleFlowGroupName = rtn.getRule().getRuleFlowGroup();
        return AgendaComponentFactory.get().createAgendaItem(salience, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)this.getAgendaGroup(!StringUtils.isEmpty((CharSequence)ruleFlowGroupName) ? ruleFlowGroupName : rtn.getRule().getAgendaGroup()));
    }

    public InternalMatch createAgendaItem(RuleTerminalNodeLeftTuple rtnLeftTuple, int salience, PropagationContext context, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        rtnLeftTuple.init((long)this.activationCounter++, salience, context, ruleAgendaItem, agendaGroup);
        return rtnLeftTuple;
    }

    protected PropagationList createPropagationList() {
        if (!this.workingMemory.getRuleSessionConfiguration().isThreadSafe()) {
            return new ThreadUnsafePropagationList((ReteEvaluator)this.workingMemory);
        }
        return this.workingMemory.getRuleSessionConfiguration().hasForceEagerActivationFilter() ? new SynchronizedBypassPropagationList((ReteEvaluator)this.workingMemory) : new SynchronizedPropagationList((ReteEvaluator)this.workingMemory);
    }

    public PropagationList getPropagationList() {
        return this.propagationList;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        if (this.sequential) {
            return;
        }
        if (item.isInList(this.eager)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Added {} to eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.add((LinkedListNode)item);
    }

    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        if (!item.isInList(this.eager)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.remove((LinkedListNode)item);
    }

    public void addQueryAgendaItem(RuleAgendaItem item) {
        this.queries.put((QueryImpl)item.getRule(), item);
        if (log.isTraceEnabled()) {
            log.trace("Added {} to query evaluation list.", (Object)item.getRule().getName());
        }
    }

    public void removeQueryAgendaItem(RuleAgendaItem item) {
        this.queries.remove((QueryImpl)item.getRule());
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from query evaluation list.", (Object)item.getRule().getName());
        }
    }

    public void addItemToActivationGroup(InternalMatch internalMatch) {
        String group = internalMatch.getRule().getActivationGroup();
        if (!StringUtils.isEmpty((CharSequence)group)) {
            InternalActivationGroup actgroup = this.getActivationGroup(group);
            if (actgroup.getTriggeredForRecency() != 0L && actgroup.getTriggeredForRecency() >= internalMatch.getPropagationContext().getFactHandle().getRecency()) {
                return;
            }
            actgroup.addActivation(internalMatch);
        }
    }

    public RuleAgendaItem peekNextRule() {
        return this.getAgendaGroupsManager().peekNextRule();
    }

    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, String processInstanceId) {
        this.propagationList.flush();
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        for (RuleAgendaItem item : ((InternalAgendaGroup)systemRuleFlowGroup).getActivations()) {
            RuleExecutor ruleExecutor = item.getRuleExecutor();
            ruleExecutor.evaluateNetwork((ActivationsManager)this);
            TupleList list = ruleExecutor.getLeftTupleList();
            for (RuleTerminalNodeLeftTuple lt = (RuleTerminalNodeLeftTuple)list.getFirst(); lt != null; lt = (RuleTerminalNodeLeftTuple)lt.getNext()) {
                if (!ruleName.equals(lt.getRule().getName()) || !lt.checkProcessInstance((ReteEvaluator)this.workingMemory, processInstanceId)) continue;
                return true;
            }
        }
        return false;
    }

    public void cancelActivation(InternalMatch internalMatch) {
        InternalMatch item = internalMatch;
        this.workingMemory.cancelActivation(internalMatch, this.isDeclarativeAgenda());
        if (this.isDeclarativeAgenda()) {
            if (internalMatch.getActivationFactHandle() == null) {
                return;
            }
            if (internalMatch.getActivationGroupNode() != null) {
                internalMatch.getActivationGroupNode().getActivationGroup().removeActivation(internalMatch);
            }
        }
        if (internalMatch.isQueued()) {
            if (internalMatch.getActivationGroupNode() != null) {
                internalMatch.getActivationGroupNode().getActivationGroup().removeActivation(internalMatch);
            }
            this.workingMemory.getAgendaEventSupport().fireActivationCancelled(internalMatch, (ReteEvaluator)this.workingMemory, MatchCancelledCause.WME_MODIFY);
        }
        if (item.getRuleAgendaItem() != null) {
            item.getRuleAgendaItem().getRuleExecutor().fireConsequenceEvent((ReteEvaluator)this.workingMemory, (ActivationsManager)this, item, "$onDeleteMatch$");
        }
        this.workingMemory.getRuleEventSupport().onDeleteMatch((Match)item);
    }

    public boolean setFocus(String name) {
        return this.setFocus(null, name);
    }

    public boolean setFocus(PropagationContext ctx, String name) {
        InternalAgendaGroup agendaGroup = this.getAgendaGroupsManager().getAgendaGroup(name);
        agendaGroup.setAutoFocusActivator(ctx);
        return this.getAgendaGroupsManager().setFocus(agendaGroup);
    }

    public ReteEvaluator getReteEvaluator() {
        return this.workingMemory;
    }

    public AgendaGroupsManager getAgendaGroupsManager() {
        return this.agendaGroupsManager;
    }

    public AgendaEventSupport getAgendaEventSupport() {
        return this.workingMemory.getAgendaEventSupport();
    }

    public Map<String, InternalActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    public InternalActivationGroup getActivationGroup(String name) {
        return this.activationGroups.computeIfAbsent(name, k -> new ActivationGroupImpl((ActivationsManager)this, k));
    }

    public RuleFlowGroup getRuleFlowGroup(String name) {
        return (RuleFlowGroup)this.getAgendaGroup(name);
    }

    public void activateRuleFlowGroup(String name) {
        InternalRuleFlowGroup group = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(group, -1, null);
    }

    public void activateRuleFlowGroup(String name, String processInstanceId, String nodeInstanceId) {
        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(ruleFlowGroup, (Object)processInstanceId, nodeInstanceId);
    }

    public void activateRuleFlowGroup(InternalRuleFlowGroup group, Object processInstanceId, String nodeInstanceId) {
        this.workingMemory.getAgendaEventSupport().fireBeforeRuleFlowGroupActivated((RuleFlowGroup)group, (ReteEvaluator)this.workingMemory);
        group.setActive(true);
        group.hasRuleFlowListener(true);
        if (!StringUtils.isEmpty((CharSequence)nodeInstanceId)) {
            group.addNodeInstance(processInstanceId, nodeInstanceId);
            group.setActive(true);
        }
        group.setFocus();
        this.workingMemory.getAgendaEventSupport().fireAfterRuleFlowGroupActivated((RuleFlowGroup)group, (ReteEvaluator)this.workingMemory);
        this.propagationList.notifyWaitOnRest();
    }

    public void clear() {
        this.agendaGroupsManager.reset(true);
        for (InternalActivationGroup group : this.activationGroups.values()) {
            group.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            group.reset();
        }
        this.propagationList.reset();
    }

    public AgendaGroup getAgendaGroup(String name) {
        return this.getAgendaGroupsManager().getAgendaGroup(name);
    }

    public void reset() {
        this.agendaGroupsManager.reset(false);
        for (InternalActivationGroup group : this.activationGroups.values()) {
            group.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            group.reset();
        }
        this.eager.clear();
        this.activationCounter = 0;
        this.executionStateMachine.reset();
        this.propagationList.reset();
    }

    public void clearAndCancel() {
        this.agendaGroupsManager.clearAndCancel((InternalAgenda)this);
        for (InternalActivationGroup group : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(group);
        }
    }

    public void clearAndCancelAgendaGroup(String name) {
        this.agendaGroupsManager.clearAndCancelAgendaGroup(name, (InternalAgenda)this);
    }

    public void clearAndCancelActivationGroup(String name) {
        InternalActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    public void clearAndCancelActivationGroup(InternalActivationGroup activationGroup) {
        InternalWorkingMemory eventsupport = this.workingMemory;
        activationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        for (ActivationGroupNode node : activationGroup) {
            InternalMatch internalMatch = node.getActivation();
            internalMatch.setActivationGroupNode(null);
            if (!internalMatch.isQueued()) continue;
            internalMatch.remove();
            eventsupport.getAgendaEventSupport().fireActivationCancelled(internalMatch, (ReteEvaluator)this.workingMemory, MatchCancelledCause.CLEAR);
        }
        activationGroup.reset();
    }

    public void clearAndCancelRuleFlowGroup(String name) {
        this.agendaGroupsManager.clearAndCancelAgendaGroup(name, (InternalAgenda)this);
    }

    public void evaluateEagerList() {
        while (!this.eager.isEmpty()) {
            RuleAgendaItem item = (RuleAgendaItem)this.eager.removeFirst();
            if (!item.isRuleInUse()) continue;
            this.evaluateQueriesForRule(item);
            item.getRuleExecutor().evaluateNetwork((ActivationsManager)this);
        }
    }

    public void evaluateQueriesForRule(RuleAgendaItem item) {
        RuleImpl rule = item.getRule();
        if (!rule.isQuery()) {
            for (QueryImpl query : rule.getDependingQueries()) {
                RuleAgendaItem queryAgendaItem = this.queries.remove(query);
                if (queryAgendaItem == null) continue;
                queryAgendaItem.getRuleExecutor().evaluateNetwork((ActivationsManager)this);
            }
        }
    }

    public int sizeOfRuleFlowGroup(String name) {
        return this.agendaGroupsManager.sizeOfRuleFlowGroup(name);
    }

    public String getFocusName() {
        return this.agendaGroupsManager.getFocusName();
    }

    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire Until Halt");
        }
        if (this.executionStateMachine.toFireUntilHalt()) {
            this.internalFireUntilHalt(agendaFilter, true);
        }
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire Until Halt");
        }
    }

    void internalFireUntilHalt(AgendaFilter agendaFilter, boolean isInternalFire) {
        this.propagationList.setFiringUntilHalt(true);
        try {
            this.fireLoop(agendaFilter, -1, RestHandler.FIRE_UNTIL_HALT, isInternalFire);
        }
        finally {
            this.propagationList.setFiringUntilHalt(false);
        }
    }

    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        if (!this.executionStateMachine.toFireAllRules()) {
            return 0;
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire All Rules");
        }
        int fireCount = this.internalFireAllRules(agendaFilter, fireLimit, true);
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire All Rules");
        }
        return fireCount;
    }

    int internalFireAllRules(AgendaFilter agendaFilter, int fireLimit, boolean isInternalFire) {
        return this.fireLoop(agendaFilter, fireLimit, RestHandler.FIRE_ALL_RULES, isInternalFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fireLoop(AgendaFilter agendaFilter, int fireLimit, RestHandler restHandler, boolean isInternalFire) {
        int fireCount = 0;
        try {
            boolean limitReached;
            PropagationEntry head = this.propagationList.takeAll();
            boolean bl = limitReached = fireLimit == 0;
            while (this.isFiring()) {
                int returnedFireCount;
                if (head != null) {
                    this.propagationList.flush(head);
                    head = null;
                }
                if (!this.isFiring()) break;
                this.evaluateEagerList();
                InternalAgendaGroup group = this.getAgendaGroupsManager().getNextFocus();
                if (group != null && !limitReached) {
                    returnedFireCount = this.groupEvaluator.evaluateAndFire(group, agendaFilter, fireCount, fireLimit);
                    limitReached = fireLimit > 0 && (fireCount += returnedFireCount) >= fireLimit;
                    head = this.propagationList.takeAll();
                } else {
                    returnedFireCount = 0;
                    group = null;
                }
                if (returnedFireCount != 0 || head != null || group != null && (!group.isEmpty() || group.isAutoDeactivate()) || this.flushExpirations()) continue;
                head = restHandler.handleRest(this, isInternalFire);
                if (isInternalFire || head != null) continue;
                break;
            }
            this.agendaGroupsManager.deactivateMainGroupWhenEmpty();
        }
        finally {
            if (isInternalFire) {
                this.executionStateMachine.immediateHalt(this.propagationList);
            }
        }
        return fireCount;
    }

    public boolean isFiring() {
        return this.executionStateMachine.isFiring();
    }

    public void executeTask(ExecutableEntry executable) {
        if (!this.executionStateMachine.toExecuteTask(executable)) {
            return;
        }
        try {
            executable.execute();
        }
        finally {
            this.executionStateMachine.immediateHalt(this.propagationList);
        }
    }

    public void executeFlush() {
        if (!this.executionStateMachine.toExecuteTaskState()) {
            return;
        }
        try {
            this.flushPropagations();
        }
        finally {
            this.executionStateMachine.immediateHalt(this.propagationList);
        }
    }

    public void activate() {
        this.executionStateMachine.activate(this, this.propagationList);
    }

    public void deactivate() {
        this.executionStateMachine.deactivate();
    }

    public boolean tryDeactivate() {
        return this.executionStateMachine.tryDeactivate();
    }

    public synchronized void halt() {
        if (this.isFiring()) {
            this.propagationList.addEntry((PropagationEntry)new Halt(this.executionStateMachine));
        }
    }

    public boolean dispose(InternalWorkingMemory wm) {
        this.propagationList.dispose();
        return this.executionStateMachine.dispose(wm);
    }

    public boolean isAlive() {
        return this.executionStateMachine.isAlive();
    }

    public void internalHalt() {
        this.executionStateMachine.internalHalt();
    }

    public void setActivationsFilter(ActivationsFilter filter) {
        this.activationsFilter = filter;
    }

    public ActivationsFilter getActivationsFilter() {
        return this.activationsFilter;
    }

    public void handleException(InternalMatch internalMatch, Exception e) {
        if (this.legacyConsequenceExceptionHandler != null) {
            this.legacyConsequenceExceptionHandler.handleException(internalMatch, (WorkingMemory)this.getWorkingMemory(), e);
        } else if (this.consequenceExceptionHandler != null) {
            this.consequenceExceptionHandler.handleException((Match)internalMatch, (RuleRuntime)this.getWorkingMemory().getKnowledgeRuntime(), e);
        } else {
            throw new RuntimeException(e);
        }
    }

    public KnowledgeHelper getKnowledgeHelper() {
        return this.groupEvaluator.getKnowledgeHelper();
    }

    public void resetKnowledgeHelper() {
        this.groupEvaluator.resetKnowledgeHelper();
    }

    public void haltGroupEvaluation() {
        this.groupEvaluator.haltEvaluation();
    }

    public void addPropagation(PropagationEntry propagationEntry) {
        this.propagationList.addEntry(propagationEntry);
    }

    public void flushPropagations() {
        this.propagationList.flush();
    }

    public void notifyWaitOnRest() {
        this.propagationList.notifyWaitOnRest();
    }

    public Iterator<PropagationEntry> getActionsIterator() {
        return this.propagationList.iterator();
    }

    public boolean hasPendingPropagations() {
        return !this.propagationList.isEmpty();
    }

    public void registerExpiration(PropagationContext ectx) {
        this.expirationContexts.add(ectx);
    }

    private boolean flushExpirations() {
        if (this.expirationContexts == null || this.expirationContexts.isEmpty() || this.propagationList.hasEntriesDeferringExpiration()) {
            return false;
        }
        for (PropagationContext ectx : this.expirationContexts) {
            this.doRetract(ectx);
        }
        this.expirationContexts.clear();
        return true;
    }

    protected void doRetract(PropagationContext ectx) {
        InternalFactHandle factHandle = (InternalFactHandle)ectx.getFactHandle();
        this.retractFactHandle(ectx, factHandle);
        if (this.isPendingRemoveFactHandleFromStore(factHandle)) {
            String epId = factHandle.getEntryPointName();
            ((InternalWorkingMemoryEntryPoint)this.workingMemory.getEntryPoint(epId)).removeFromObjectStore(factHandle);
        }
    }

    protected void retractFactHandle(PropagationContext ectx, InternalFactHandle factHandle) {
        ObjectTypeNode.retractLeftTuples((InternalFactHandle)factHandle, (PropagationContext)ectx, (ReteEvaluator)this.workingMemory);
        ObjectTypeNode.retractRightTuples((InternalFactHandle)factHandle, (PropagationContext)ectx, (ReteEvaluator)this.workingMemory);
    }

    protected boolean isPendingRemoveFactHandleFromStore(InternalFactHandle factHandle) {
        return factHandle.isPendingRemoveFromStore();
    }

    public boolean isParallelAgenda() {
        return false;
    }

    static class ConcurrentExecutionStateMachine
    implements ExecutionStateMachine {
        private volatile ExecutionStateMachine.ExecutionState currentState = ExecutionStateMachine.ExecutionState.INACTIVE;
        private volatile boolean wasFiringUntilHalt = false;
        private final Object stateMachineLock = new Object();
        private long fireUntilHaltThreadId = -1L;

        ConcurrentExecutionStateMachine() {
        }

        @Override
        public boolean isFiring() {
            return this.currentState.isFiring();
        }

        @Override
        public void reset() {
            this.currentState = ExecutionStateMachine.ExecutionState.INACTIVE;
            this.wasFiringUntilHalt = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean toFireAllRules() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState.isFiring() || !this.currentState.isAlive()) {
                    return false;
                }
                this.waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState.FIRING_ALL_RULES);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean toFireUntilHalt() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState == ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT || this.currentState == ExecutionStateMachine.ExecutionState.HALTING) {
                    return false;
                }
                this.waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean toExecuteTask(ExecutableEntry executable) {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.isFiring()) {
                    executable.enqueue();
                    return false;
                }
                if (this.currentState != ExecutionStateMachine.ExecutionState.EXECUTING_TASK) {
                    this.waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState.EXECUTING_TASK);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean toExecuteTaskState() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (!this.currentState.isAlive() || this.currentState.isFiring()) {
                    return false;
                }
                this.waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState.EXECUTING_TASK);
                return true;
            }
        }

        private void waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState newState) {
            this.waitInactive();
            this.setCurrentState(newState);
        }

        private void waitInactive() {
            while (this.currentState != ExecutionStateMachine.ExecutionState.INACTIVE && this.currentState != ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT && this.currentState != ExecutionStateMachine.ExecutionState.DISPOSED) {
                try {
                    this.stateMachineLock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void setCurrentState(ExecutionStateMachine.ExecutionState state) {
            if (log.isDebugEnabled()) {
                log.debug("State was {} is now {}", (Object)this.currentState, (Object)state);
            }
            if (this.currentState != ExecutionStateMachine.ExecutionState.DISPOSED) {
                this.currentState = state;
            }
        }

        @Override
        public void activate(DefaultAgenda agenda, PropagationList propagationList) {
            if (this.currentState.isAlive()) {
                boolean restoreFireUntilHalt = this.wasFiringUntilHalt;
                this.wasFiringUntilHalt = false;
                boolean restoreFiringOnSameThread = restoreFireUntilHalt && this.fireUntilHaltThreadId == Thread.currentThread().getId();
                this.fireUntilHaltThreadId = -1L;
                this.immediateHalt(propagationList);
                if (restoreFireUntilHalt) {
                    if (restoreFiringOnSameThread) {
                        agenda.fireUntilHalt();
                    } else {
                        new Thread(agenda::fireUntilHalt).start();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deactivate() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                this.pauseFiringUntilHalt();
                if (this.currentState != ExecutionStateMachine.ExecutionState.DEACTIVATED && this.currentState.isAlive()) {
                    this.waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState.DEACTIVATED);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryDeactivate() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (!this.currentState.isAlive()) {
                    return true;
                }
                this.pauseFiringUntilHalt();
                if (this.currentState == ExecutionStateMachine.ExecutionState.INACTIVE || this.currentState == ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT) {
                    this.setCurrentState(ExecutionStateMachine.ExecutionState.DEACTIVATED);
                    return true;
                }
            }
            return false;
        }

        private void pauseFiringUntilHalt() {
            if (this.currentState == ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT) {
                this.wasFiringUntilHalt = true;
                this.setCurrentState(ExecutionStateMachine.ExecutionState.HALTING);
                this.waitInactive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void immediateHalt(PropagationList propagationList) {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState != ExecutionStateMachine.ExecutionState.INACTIVE) {
                    this.setCurrentState(ExecutionStateMachine.ExecutionState.INACTIVE);
                    this.stateMachineLock.notifyAll();
                    propagationList.onEngineInactive();
                    if (this.wasFiringUntilHalt) {
                        this.fireUntilHaltThreadId = Thread.currentThread().getId();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inactiveOnFireUntilHalt() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState != ExecutionStateMachine.ExecutionState.INACTIVE && this.currentState != ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT) {
                    this.setCurrentState(ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT);
                    this.stateMachineLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void internalHalt() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.isFiring()) {
                    this.setCurrentState(ExecutionStateMachine.ExecutionState.HALTING);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispose(InternalWorkingMemory workingMemory) {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (!this.currentState.isAlive()) {
                    return false;
                }
                if (this.currentState.isFiring() && this.currentState != ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT) {
                    this.setCurrentState(ExecutionStateMachine.ExecutionState.DISPOSING);
                    workingMemory.notifyWaitOnRest();
                }
                this.waitAndEnterExecutionState(ExecutionStateMachine.ExecutionState.DISPOSED);
                this.stateMachineLock.notifyAll();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAlive() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                return this.currentState.isAlive();
            }
        }

        @Override
        public ExecutionStateMachine.ExecutionState getCurrentState() {
            return this.currentState;
        }

        @Override
        public Object getStateMachineLock() {
            return this.stateMachineLock;
        }
    }

    static class UnsafeExecutionStateMachine
    implements ExecutionStateMachine {
        private final Object stateMachineLock = new Object();
        private ExecutionStateMachine.ExecutionState currentState = ExecutionStateMachine.ExecutionState.INACTIVE;

        UnsafeExecutionStateMachine() {
        }

        @Override
        public boolean isFiring() {
            return this.currentState.isFiring();
        }

        @Override
        public void reset() {
            this.currentState = ExecutionStateMachine.ExecutionState.INACTIVE;
        }

        @Override
        public boolean toFireAllRules() {
            this.currentState = ExecutionStateMachine.ExecutionState.FIRING_ALL_RULES;
            return true;
        }

        @Override
        public boolean toFireUntilHalt() {
            throw new UnsupportedOperationException("Not permitted in non-thread-safe mode");
        }

        @Override
        public boolean toExecuteTask(ExecutableEntry executable) {
            throw new UnsupportedOperationException("Not permitted in non-thread-safe mode");
        }

        @Override
        public boolean toExecuteTaskState() {
            this.currentState = ExecutionStateMachine.ExecutionState.EXECUTING_TASK;
            return true;
        }

        @Override
        public void activate(DefaultAgenda agenda, PropagationList propagationList) {
        }

        @Override
        public void deactivate() {
            this.currentState = ExecutionStateMachine.ExecutionState.DEACTIVATED;
        }

        @Override
        public boolean tryDeactivate() {
            this.currentState = ExecutionStateMachine.ExecutionState.DEACTIVATED;
            return true;
        }

        @Override
        public void immediateHalt(PropagationList propagationList) {
            this.currentState = ExecutionStateMachine.ExecutionState.INACTIVE;
        }

        @Override
        public void inactiveOnFireUntilHalt() {
            throw new UnsupportedOperationException("Not permitted in non-thread-safe mode");
        }

        @Override
        public void internalHalt() {
            if (this.isFiring()) {
                this.currentState = ExecutionStateMachine.ExecutionState.HALTING;
            }
        }

        @Override
        public boolean dispose(InternalWorkingMemory workingMemory) {
            this.currentState = ExecutionStateMachine.ExecutionState.DISPOSED;
            return true;
        }

        @Override
        public boolean isAlive() {
            return this.currentState.isAlive();
        }

        @Override
        public ExecutionStateMachine.ExecutionState getCurrentState() {
            return this.currentState;
        }

        @Override
        public Object getStateMachineLock() {
            return this.stateMachineLock;
        }
    }

    static interface ExecutionStateMachine {
        public boolean isFiring();

        public void reset();

        public boolean toFireAllRules();

        public boolean toFireUntilHalt();

        public boolean toExecuteTask(ExecutableEntry var1);

        public boolean toExecuteTaskState();

        public void activate(DefaultAgenda var1, PropagationList var2);

        public void deactivate();

        public boolean tryDeactivate();

        public void immediateHalt(PropagationList var1);

        public void inactiveOnFireUntilHalt();

        public void internalHalt();

        public boolean dispose(InternalWorkingMemory var1);

        public boolean isAlive();

        public ExecutionState getCurrentState();

        public Object getStateMachineLock();

        public static enum ExecutionState {
            INACTIVE(false, true),
            FIRING_ALL_RULES(true, true),
            FIRING_UNTIL_HALT(true, true),
            INACTIVE_ON_FIRING_UNTIL_HALT(true, true),
            HALTING(false, true),
            EXECUTING_TASK(false, true),
            DEACTIVATED(false, true),
            DISPOSING(false, false),
            DISPOSED(false, false);

            private final boolean firing;
            private final boolean alive;

            private ExecutionState(boolean firing, boolean alive) {
                this.firing = firing;
                this.alive = alive;
            }

            public boolean isFiring() {
                return this.firing;
            }

            public boolean isAlive() {
                return this.alive;
            }
        }
    }

    static class Halt
    extends PropagationEntry.AbstractPropagationEntry {
        private final ExecutionStateMachine executionStateMachine;

        protected Halt(ExecutionStateMachine executionStateMachine) {
            this.executionStateMachine = executionStateMachine;
        }

        public void internalExecute(ReteEvaluator reteEvaluator) {
            this.executionStateMachine.internalHalt();
            reteEvaluator.getActivationsManager().haltGroupEvaluation();
        }

        public String toString() {
            return "Halt";
        }
    }

    static interface RestHandler {
        public static final RestHandler FIRE_ALL_RULES = new FireAllRulesRestHandler();
        public static final RestHandler FIRE_UNTIL_HALT = new FireUntilHaltRestHandler();

        public PropagationEntry handleRest(DefaultAgenda var1, boolean var2);

        public static class FireUntilHaltRestHandler
        implements RestHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropagationEntry handleRest(DefaultAgenda agenda, boolean isInternalFire) {
                PropagationEntry head;
                boolean deactivated = false;
                if (isInternalFire && agenda.executionStateMachine.getCurrentState() == ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT) {
                    agenda.executionStateMachine.inactiveOnFireUntilHalt();
                    deactivated = true;
                }
                PropagationList propagationList = agenda.propagationList;
                synchronized (propagationList) {
                    head = agenda.propagationList.takeAll();
                    if (head == null && (agenda.executionStateMachine.getCurrentState() == ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT || agenda.executionStateMachine.getCurrentState() == ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT)) {
                        agenda.propagationList.waitOnRest();
                        head = agenda.propagationList.takeAll();
                    }
                }
                if (deactivated) {
                    agenda.executionStateMachine.toFireUntilHalt();
                }
                return head;
            }
        }

        public static class FireAllRulesRestHandler
        implements RestHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropagationEntry handleRest(DefaultAgenda agenda, boolean isInternalFire) {
                Object object = agenda.executionStateMachine.getStateMachineLock();
                synchronized (object) {
                    PropagationEntry head = agenda.propagationList.takeAll();
                    if (isInternalFire && head == null) {
                        agenda.internalHalt();
                    }
                    return head;
                }
            }
        }
    }
}

