/*
 * Decompiled with CFR 0.152.
 */
package org.drools.metric.util;

import org.drools.core.common.BaseNode;
import org.drools.metric.util.MicrometerUtils;
import org.drools.metric.util.NodeStats;
import org.drools.util.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricLogUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetricLogUtils.class);
    public static final String METRIC_LOGGER_ENABLED = "drools.metric.logger.enabled";
    private boolean enabled = Boolean.parseBoolean(Config.getConfig((String)"drools.metric.logger.enabled", (String)"false"));
    private boolean micrometerAvailable = MetricLogUtils.isMicrometerAvailable();
    public static final String METRIC_LOGGER_THRESHOLD = "drools.metric.logger.threshold";
    private int threshold = Integer.parseInt(Config.getConfig((String)"drools.metric.logger.threshold", (String)"500"));
    private final ThreadLocal<NodeStats> nodeStats = new ThreadLocal();
    private static final MetricLogUtils INSTANCE = new MetricLogUtils();

    private static boolean isMicrometerAvailable() {
        try {
            Class.forName("io.micrometer.core.instrument.Tag");
            return true;
        }
        catch (Exception e) {
            logger.trace("Micrometer not found on the classpath.");
            return false;
        }
    }

    public static MetricLogUtils getInstance() {
        return INSTANCE;
    }

    private MetricLogUtils() {
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void startMetrics(BaseNode baseNode) {
        if (this.enabled) {
            this.nodeStats.set(new NodeStats(baseNode));
        } else {
            logger.warn("Metrics must not be started when disabled");
        }
    }

    public void incrementEvalCount() {
        if (this.enabled) {
            NodeStats stats = this.nodeStats.get();
            if (stats != null && stats.isStarted()) {
                stats.incrementEvalCount();
            }
        } else {
            logger.warn("Metrics must not be executed when disabled");
        }
    }

    public void logAndEndMetrics() {
        if (this.enabled) {
            NodeStats stats = this.nodeStats.get();
            if (stats != null && stats.isStarted()) {
                long evalCount = stats.getEvalCount();
                long elapsedTimeInNanos = System.nanoTime() - stats.getStartTime();
                long elapsedTimeInMicro = elapsedTimeInNanos / 1000L;
                if (evalCount > 0L && elapsedTimeInMicro > (long)this.threshold) {
                    if (this.micrometerAvailable) {
                        MicrometerUtils.INSTANCE.triggerMicrometer(stats.getNode(), evalCount, elapsedTimeInNanos);
                    } else {
                        logger.trace("{}, evalCount:{}, elapsedMicro:{}", new Object[]{stats.getNode(), evalCount, elapsedTimeInMicro});
                    }
                }
            } else {
                logger.warn("nodeStats has to be initialized. Call startMetrics() beforehand : stats = {}", (Object)stats);
            }
            this.nodeStats.remove();
        }
    }
}

