/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.util.DateUtils;
import org.drools.core.util.StringUtils;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.drlx.expr.DrlxExpression;
import org.drools.javaparser.ast.drlx.expr.HalfBinaryExpr;
import org.drools.javaparser.ast.drlx.expr.HalfPointFreeExpr;
import org.drools.javaparser.ast.drlx.expr.PointFreeExpr;
import org.drools.javaparser.ast.expr.BigDecimalLiteralExpr;
import org.drools.javaparser.ast.expr.BigIntegerLiteralExpr;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.CastExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NullLiteralExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.ThisExpr;
import org.drools.javaparser.ast.expr.UnaryExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithArguments;
import org.drools.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.errors.ParseExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.CoercedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.MultipleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.SingleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyperContext;
import org.drools.modelcompiler.builder.generator.expressiontyper.TypedExpressionResult;

public class ConstraintParser {
    public static final boolean GENERATE_EXPR_ID = true;
    private RuleContext context;
    private PackageModel packageModel;

    public ConstraintParser(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public DrlxParseResult drlxParse(Class<?> patternType, String bindingId, String expression) {
        return this.drlxParse(patternType, bindingId, expression, false);
    }

    public DrlxParseResult drlxParse(Class<?> patternType, String bindingId, String expression, boolean isPositional) {
        return this.drlxParse(patternType, bindingId, new ConstraintExpression(expression), isPositional);
    }

    public DrlxParseResult drlxParse(Class<?> patternType, String bindingId, ConstraintExpression expression, boolean isPositional) {
        DrlxExpression drlx = DrlxParseUtil.parseExpression(expression.getExpression());
        DrlxParseResult drlxParseResult = this.getDrlxParseResult(patternType, bindingId, expression, drlx.getExpr(), drlx.getBind() != null, isPositional);
        drlxParseResult.accept(result -> {
            if (drlx.getBind() != null) {
                SingleDrlxParseSuccess singleResult = (SingleDrlxParseSuccess)result;
                String bindId = drlx.getBind().asString();
                this.context.addDeclaration(bindId, singleResult.getExprRawClass());
                singleResult.setExprBinding(bindId);
            }
        });
        return drlxParseResult;
    }

    private DrlxParseResult getDrlxParseResult(Class<?> patternType, String bindingId, ConstraintExpression constraint, Expression drlxExpr, boolean hasBind, boolean isPositional) {
        ExpressionTyper expressionTyper;
        ExpressionTyperContext expressionTyperContext;
        boolean isEnclosed = false;
        while (drlxExpr instanceof EnclosedExpr) {
            drlxExpr = ((EnclosedExpr)drlxExpr).getInner();
            isEnclosed = true;
        }
        if (drlxExpr instanceof MethodCallExpr && !((MethodCallExpr)drlxExpr).getScope().isPresent() && ((MethodCallExpr)drlxExpr).getNameAsString().equals("eval")) {
            drlxExpr = ((MethodCallExpr)drlxExpr).getArgument(0);
        }
        String expression = constraint.getExpression();
        String exprId = this.context.getExprId(patternType, hasBind ? expression.substring(expression.indexOf(58) + 1).trim() : expression);
        if (drlxExpr instanceof BinaryExpr) {
            return this.parseBinaryExpr((BinaryExpr)drlxExpr, patternType, bindingId, constraint, drlxExpr, hasBind, isPositional, isEnclosed, expression, exprId);
        }
        if (drlxExpr instanceof UnaryExpr) {
            return this.parseUnaryExpr((UnaryExpr)drlxExpr, patternType, bindingId, isPositional, exprId);
        }
        if (drlxExpr instanceof PointFreeExpr) {
            return this.parsePointFreeExpr((PointFreeExpr)drlxExpr, patternType, bindingId, constraint, hasBind, isPositional, exprId);
        }
        if (patternType == null && drlxExpr instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)drlxExpr;
            Optional<MethodDeclaration> functionCall = this.packageModel.getFunctions().stream().filter(m -> m.getName().equals((Object)methodCallExpr.getName())).findFirst();
            if (functionCall.isPresent()) {
                return this.parseFunctionInEval(methodCallExpr, patternType, bindingId, exprId, isPositional, functionCall);
            }
        }
        if (drlxExpr instanceof FieldAccessExpr) {
            return this.parseFieldAccessExpr((FieldAccessExpr)drlxExpr, patternType, bindingId, exprId);
        }
        if (drlxExpr instanceof NameExpr) {
            return this.parseNameExpr((NameExpr)drlxExpr, patternType, bindingId, drlxExpr, hasBind, expression, exprId);
        }
        if (drlxExpr instanceof OOPathExpr) {
            return new SingleDrlxParseSuccess(patternType, exprId, bindingId, drlxExpr, null);
        }
        if (drlxExpr instanceof LiteralExpr) {
            return new SingleDrlxParseSuccess(patternType, exprId, bindingId, drlxExpr, DrlxParseUtil.getLiteralExpressionType((LiteralExpr)drlxExpr));
        }
        if (patternType != null) {
            expressionTyperContext = new ExpressionTyperContext();
            expressionTyper = new ExpressionTyper(this.context, patternType, bindingId, isPositional, expressionTyperContext);
            TypedExpressionResult leftTypedExpressionResult = expressionTyper.toTypedExpression(drlxExpr);
            Optional<TypedExpression> optLeft = leftTypedExpressionResult.getTypedExpression();
            if (!optLeft.isPresent()) {
                return new DrlxParseFail(new InvalidExpressionErrorResult("Unable to parse left part of expression: " + expression));
            }
            TypedExpression left = optLeft.get();
            Expression combo = left.getExpression();
            for (Expression e : leftTypedExpressionResult.getPrefixExpressions()) {
                combo = new BinaryExpr(e, combo, BinaryExpr.Operator.AND);
            }
            return new SingleDrlxParseSuccess(patternType, exprId, bindingId, combo, left.getType()).setUsedDeclarations(expressionTyperContext.getUsedDeclarations());
        }
        expressionTyperContext = new ExpressionTyperContext();
        expressionTyper = new ExpressionTyper(this.context, null, bindingId, isPositional, expressionTyperContext);
        TypedExpressionResult leftTypedExpressionResult = expressionTyper.toTypedExpression(drlxExpr);
        Optional<TypedExpression> optLeft = leftTypedExpressionResult.getTypedExpression();
        if (!optLeft.isPresent()) {
            return new DrlxParseFail(new InvalidExpressionErrorResult("Unable to parse left part of expression: " + expression));
        }
        TypedExpression left = optLeft.get();
        return new SingleDrlxParseSuccess(null, exprId, bindingId, drlxExpr, left.getType()).setUsedDeclarations(expressionTyperContext.getUsedDeclarations());
    }

    private DrlxParseResult parseFunctionInEval(MethodCallExpr methodCallExpr, Class<?> patternType, String bindingId, String exprId, boolean isPositional, Optional<MethodDeclaration> functionCall) {
        List rewriteThisExprs = ConstraintParser.recurseCollectArguments(methodCallExpr).stream().filter(ThisExpr.class::isInstance).map(ThisExpr.class::cast).collect(Collectors.toList());
        for (ThisExpr t : rewriteThisExprs) {
            methodCallExpr.replace((Node)t, (Node)new NameExpr("_this"));
        }
        Class<?> returnType = DrlxParseUtil.getClassFromContext(this.context.getTypeResolver(), functionCall.get().getType().asString());
        NodeList arguments = methodCallExpr.getArguments();
        ArrayList<String> usedDeclarations = new ArrayList<String>();
        for (Expression arg : arguments) {
            if (arg instanceof NameExpr && !arg.toString().equals("_this")) {
                usedDeclarations.add(arg.toString());
                continue;
            }
            if (arg instanceof CastExpr) {
                usedDeclarations.add(((CastExpr)arg).getExpression().toString());
                continue;
            }
            if (!(arg instanceof MethodCallExpr)) continue;
            TypedExpressionResult typedExpressionResult = new ExpressionTyper(this.context, null, bindingId, isPositional).toTypedExpression(arg);
            usedDeclarations.addAll(typedExpressionResult.getUsedDeclarations());
        }
        return new SingleDrlxParseSuccess(patternType, exprId, bindingId, (Expression)methodCallExpr, returnType).setUsedDeclarations(usedDeclarations);
    }

    private DrlxParseResult parseNameExpr(NameExpr nameExpr, Class<?> patternType, String bindingId, Expression drlxExpr, boolean hasBind, String expression, String exprId) {
        TypedExpression converted = DrlxParseUtil.toMethodCallWithClassCheck(this.context, (Expression)nameExpr, bindingId, patternType, this.context.getTypeResolver());
        if (converted == null) {
            return new DrlxParseFail();
        }
        Expression withThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), converted.getExpression());
        if (hasBind) {
            return new SingleDrlxParseSuccess(patternType, exprId, bindingId, null, converted.getType()).setLeft(new TypedExpression(withThis, converted.getType())).addReactOnProperty(StringUtils.lcFirst((String)nameExpr.getNameAsString()));
        }
        if (this.context.hasDeclaration(expression)) {
            return new SingleDrlxParseSuccess(patternType, exprId, bindingId, this.context.getVarExpr(drlxExpr.toString()), this.context.getDeclarationById(expression).get().getDeclarationClass());
        }
        return new SingleDrlxParseSuccess(patternType, exprId, bindingId, withThis, converted.getType()).addReactOnProperty(nameExpr.getNameAsString());
    }

    private DrlxParseResult parseFieldAccessExpr(FieldAccessExpr fieldCallExpr, Class<?> patternType, String bindingId, String exprId) {
        TypedExpression converted = DrlxParseUtil.toMethodCallWithClassCheck(this.context, (Expression)fieldCallExpr, bindingId, patternType, this.context.getTypeResolver());
        Expression withThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), converted.getExpression());
        return new SingleDrlxParseSuccess(patternType, exprId, bindingId, withThis, converted.getType()).setLeft(converted);
    }

    private DrlxParseResult parsePointFreeExpr(PointFreeExpr pointFreeExpr, Class<?> patternType, String bindingId, ConstraintExpression constraint, boolean hasBind, boolean isPositional, String exprId) {
        TypedExpressionResult typedExpressionResult = new ExpressionTyper(this.context, patternType, bindingId, isPositional).toTypedExpression((Expression)pointFreeExpr);
        return typedExpressionResult.getTypedExpression().map(typedExpression -> {
            Expression rightExpr;
            boolean isTemporal = ModelGenerator.temporalOperators.contains(pointFreeExpr.getOperator().asString());
            String rightLiteral = null;
            if (isTemporal && pointFreeExpr.getRight().size() == 1 && (rightExpr = (Expression)pointFreeExpr.getRight().get(0)) instanceof StringLiteralExpr) {
                String value = ((StringLiteralExpr)rightExpr).getValue();
                rightLiteral = DateUtils.parseDate((String)value).getTime() + "L";
            }
            return new SingleDrlxParseSuccess(patternType, exprId, bindingId, typedExpression.getExpression(), typedExpression.getType()).setUsedDeclarations(typedExpressionResult.getUsedDeclarations()).setUsedDeclarationsOnLeft(Collections.emptyList()).setReactOnProperties(typedExpressionResult.getReactOnProperties()).setLeft(typedExpression.getLeft()).setRight(typedExpression.getRight()).setRightLiteral(rightLiteral).setStatic(typedExpression.isStatic()).setTemporal(isTemporal).setValidExpression(true);
        }).orElseGet(() -> new DrlxParseFail(new ParseExpressionErrorResult((Expression)pointFreeExpr)));
    }

    private DrlxParseResult parseUnaryExpr(UnaryExpr unaryExpr, Class<?> patternType, String bindingId, boolean isPositional, String exprId) {
        TypedExpressionResult typedExpressionResult = new ExpressionTyper(this.context, patternType, bindingId, isPositional).toTypedExpression((Expression)unaryExpr);
        return typedExpressionResult.getTypedExpression().map(left -> new SingleDrlxParseSuccess(patternType, exprId, bindingId, left.getExpression(), left.getType()).setUsedDeclarations(typedExpressionResult.getUsedDeclarations()).setReactOnProperties(typedExpressionResult.getReactOnProperties()).setLeft((TypedExpression)left)).orElseGet(() -> new DrlxParseFail(new ParseExpressionErrorResult((Expression)unaryExpr)));
    }

    private DrlxParseResult parseBinaryExpr(BinaryExpr binaryExpr, Class<?> patternType, String bindingId, ConstraintExpression constraint, Expression drlxExpr, boolean hasBind, boolean isPositional, boolean isEnclosed, String expression, String exprId) {
        boolean isBetaNode;
        BinaryExpr combo;
        CoercedExpression.CoercedExpressionResult coerced;
        TypedExpression right;
        ArrayList<String> usedDeclarationsOnLeft;
        BinaryExpr.Operator operator = binaryExpr.getOperator();
        if (ConstraintParser.isLogicalOperator(operator) && this.isCombinable(binaryExpr)) {
            DrlxParseResult leftResult = this.getDrlxParseResult(patternType, bindingId, constraint, binaryExpr.getLeft(), hasBind, isPositional);
            Expression rightExpr = binaryExpr.getRight() instanceof HalfPointFreeExpr ? ConstraintParser.completeHalfExpr(((PointFreeExpr)binaryExpr.getLeft()).getLeft(), (HalfPointFreeExpr)binaryExpr.getRight()) : binaryExpr.getRight();
            DrlxParseResult rightResult = this.getDrlxParseResult(patternType, bindingId, constraint, rightExpr, hasBind, isPositional);
            if (leftResult.isSuccess() && rightResult.isSuccess() && (((DrlxParseSuccess)leftResult).isTemporal() || ((DrlxParseSuccess)rightResult).isTemporal())) {
                return new MultipleDrlxParseSuccess(operator, (DrlxParseSuccess)leftResult, (DrlxParseSuccess)rightResult);
            }
            return leftResult.combineWith(rightResult, operator);
        }
        ExpressionTyperContext expressionTyperContext = new ExpressionTyperContext();
        ExpressionTyper expressionTyper = new ExpressionTyper(this.context, patternType, bindingId, isPositional, expressionTyperContext);
        TypedExpressionResult leftTypedExpressionResult = expressionTyper.toTypedExpression(binaryExpr.getLeft());
        Optional<TypedExpression> optLeft = leftTypedExpressionResult.getTypedExpression();
        if (!optLeft.isPresent()) {
            return new DrlxParseFail(new InvalidExpressionErrorResult("Unable to parse left part of expression: " + expression));
        }
        TypedExpression left = optLeft.get();
        ArrayList<String> arrayList = usedDeclarationsOnLeft = hasBind ? new ArrayList<String>(expressionTyperContext.getUsedDeclarations()) : null;
        if (constraint.isNameClashingUnification()) {
            String name = constraint.getUnificationField();
            right = new TypedExpression((Expression)new NameExpr(name), left.getType());
            expressionTyperContext.addUsedDeclarations(name);
        } else {
            TypedExpressionResult rightExpressionResult = expressionTyper.toTypedExpression(binaryExpr.getRight());
            Optional<TypedExpression> optRight = rightExpressionResult.getTypedExpression();
            if (!optRight.isPresent()) {
                return new DrlxParseFail(new ParseExpressionErrorResult(drlxExpr));
            }
            right = optRight.get();
        }
        try {
            coerced = new CoercedExpression(left, right).coerce();
        }
        catch (CoercedExpression.CoercedExpressionException e) {
            return new DrlxParseFail(e.getInvalidExpressionErrorResult());
        }
        left = coerced.getCoercedLeft();
        right = coerced.getCoercedRight();
        if (left.isPrimitive()) {
            combo = new BinaryExpr(left.getExpression(), right.getExpression(), operator);
        } else {
            switch (operator) {
                case EQUALS: 
                case NOT_EQUALS: {
                    combo = ConstraintParser.getEqualityExpression(left, right, operator);
                    break;
                }
                default: {
                    if (left.getExpression() == null || right.getExpression() == null) {
                        return new DrlxParseFail(new ParseExpressionErrorResult(drlxExpr));
                    }
                    combo = ConstraintParser.handleSpecialComparisonCases(operator, left, right);
                }
            }
        }
        for (Expression e : leftTypedExpressionResult.getPrefixExpressions()) {
            combo = new BinaryExpr(e, (Expression)combo, BinaryExpr.Operator.AND);
        }
        boolean bl = isBetaNode = right.getExpression() != null && this.context.getDeclarationById(ConstraintParser.getExpressionSymbol(right.getExpression())).isPresent();
        if (isEnclosed) {
            combo = new EnclosedExpr((Expression)combo);
        }
        boolean requiresSplit = operator == BinaryExpr.Operator.AND && binaryExpr.getRight() instanceof HalfBinaryExpr && !isBetaNode;
        return new SingleDrlxParseSuccess(patternType, exprId, bindingId, (Expression)combo, left.getType()).setDecodeConstraintType(DrlxParseUtil.toConstraintType(operator)).setUsedDeclarations(expressionTyperContext.getUsedDeclarations()).setUsedDeclarationsOnLeft(usedDeclarationsOnLeft).setUnification(constraint.isUnification()).setReactOnProperties(expressionTyperContext.getReactOnProperties()).setLeft(left).setRight(right).setBetaNode(isBetaNode).setRequiresSplit(requiresSplit);
    }

    private boolean isCombinable(BinaryExpr binaryExpr) {
        return !(binaryExpr.getRight() instanceof HalfBinaryExpr) && (!(binaryExpr.getRight() instanceof HalfPointFreeExpr) || binaryExpr.getLeft() instanceof PointFreeExpr);
    }

    private static boolean isLogicalOperator(BinaryExpr.Operator operator) {
        return operator == BinaryExpr.Operator.AND || operator == BinaryExpr.Operator.OR;
    }

    private static PointFreeExpr completeHalfExpr(Expression left, HalfPointFreeExpr halfRight) {
        return new PointFreeExpr((TokenRange)halfRight.getTokenRange().orElse(null), left, halfRight.getRight(), halfRight.getOperator(), Boolean.valueOf(halfRight.isNegated()), halfRight.getArg1(), halfRight.getArg2(), halfRight.getArg3(), halfRight.getArg4());
    }

    private static String getExpressionSymbol(Expression expr) {
        if (expr instanceof MethodCallExpr && ((MethodCallExpr)expr).getScope().isPresent()) {
            return ConstraintParser.getExpressionSymbol((Expression)((MethodCallExpr)expr).getScope().get());
        }
        if (expr instanceof FieldAccessExpr) {
            return ConstraintParser.getExpressionSymbol(((FieldAccessExpr)expr).getScope());
        }
        return expr.toString();
    }

    private static Expression getEqualityExpression(TypedExpression left, TypedExpression right, BinaryExpr.Operator operator) {
        if ((ConstraintParser.isAnyOperandBigDecimal(left, right) || ConstraintParser.isAnyOperandBigInteger(left, right)) && !ConstraintParser.isAnyOperandNullLiteral(left, right)) {
            return ConstraintParser.compareBigDecimal(operator, left, right);
        }
        Expression rightExpression = right.getExpression();
        Expression leftExpression = left.getExpression();
        if (DrlxParseUtil.isPrimitiveExpression(rightExpression) && DrlxParseUtil.isPrimitiveExpression(leftExpression) && left.getType() != String.class) {
            return new BinaryExpr(leftExpression, rightExpression, operator == BinaryExpr.Operator.EQUALS ? BinaryExpr.Operator.EQUALS : BinaryExpr.Operator.NOT_EQUALS);
        }
        String equalsMethod = !left.getType().equals(right.getType()) && Number.class.isAssignableFrom(left.getRawClass()) ? "org.drools.modelcompiler.util.EvaluationUtil.areNumbersNullSafeEquals" : "org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals";
        MethodCallExpr methodCallExpr = new MethodCallExpr(null, equalsMethod);
        methodCallExpr.addArgument(left.getExpression());
        methodCallExpr.addArgument(right.getExpression());
        return operator == BinaryExpr.Operator.EQUALS ? methodCallExpr : new UnaryExpr((Expression)methodCallExpr, UnaryExpr.Operator.LOGICAL_COMPLEMENT);
    }

    private static Expression handleSpecialComparisonCases(BinaryExpr.Operator operator, TypedExpression left, TypedExpression right) {
        String methodName;
        if ((ConstraintParser.isAnyOperandBigDecimal(left, right) || ConstraintParser.isAnyOperandBigInteger(left, right)) && ConstraintParser.isComparisonOperator(operator)) {
            return ConstraintParser.compareBigDecimal(operator, left, right);
        }
        if (ConstraintParser.isComparisonOperator(operator) && (methodName = ConstraintParser.getComparisonMethodName(operator, left, right)) != null) {
            MethodCallExpr compareMethod = new MethodCallExpr(null, methodName);
            compareMethod.addArgument(left.getExpression());
            compareMethod.addArgument(right.getExpression());
            return compareMethod;
        }
        return new BinaryExpr(left.getExpression(), right.getExpression(), operator);
    }

    private static String getComparisonMethodName(BinaryExpr.Operator operator, TypedExpression left, TypedExpression right) {
        String methodName = "org.drools.modelcompiler.util.EvaluationUtil." + ConstraintParser.operatorToName(operator);
        if (left.getType() == String.class && right.getType() == String.class) {
            return methodName + "StringsAsNumbers";
        }
        if (ConstraintParser.isNumericType(left.getRawClass()) || ConstraintParser.isNumericType(right.getRawClass())) {
            return methodName + "Numbers";
        }
        if (Comparable.class.isAssignableFrom(left.getRawClass()) && Comparable.class.isAssignableFrom(right.getRawClass())) {
            return methodName;
        }
        return null;
    }

    private static String operatorToName(BinaryExpr.Operator operator) {
        switch (operator.asString()) {
            case "==": {
                return "equals";
            }
            case "!=": {
                return "notEquals";
            }
            case "<": {
                return "lessThan";
            }
            case "<=": {
                return "lessOrEqual";
            }
            case ">": {
                return "greaterThan";
            }
            case ">=": {
                return "greaterOrEqual";
            }
        }
        throw new RuntimeException("unknown operator: " + operator);
    }

    private static boolean isNumericType(Class<?> type) {
        return Number.class.isAssignableFrom(type) && type != BigInteger.class && type != BigDecimal.class;
    }

    private static boolean isAnyOperandBigDecimal(TypedExpression left, TypedExpression right) {
        return left.getType() == BigDecimal.class || right.getType() == BigDecimal.class;
    }

    private static boolean isAnyOperandBigInteger(TypedExpression left, TypedExpression right) {
        return left.getType() == BigInteger.class || right.getType() == BigInteger.class;
    }

    private static boolean isAnyOperandNullLiteral(TypedExpression left, TypedExpression right) {
        return left.getExpression() instanceof NullLiteralExpr || right.getExpression() instanceof NullLiteralExpr;
    }

    private static Expression compareBigDecimal(BinaryExpr.Operator operator, TypedExpression left, TypedExpression right) {
        String methodName = "org.drools.modelcompiler.util.EvaluationUtil." + ConstraintParser.operatorToName(operator);
        MethodCallExpr compareMethod = new MethodCallExpr(null, methodName);
        compareMethod.addArgument(ConstraintParser.toBigDecimalExpression(left));
        compareMethod.addArgument(ConstraintParser.toBigDecimalExpression(right));
        return compareMethod;
    }

    private static Expression toBigDecimalExpression(TypedExpression typedExpression) {
        MethodCallExpr toBigDecimalMethod = new MethodCallExpr(null, "org.drools.modelcompiler.util.EvaluationUtil.toBigDecimal");
        Expression arg = typedExpression.getExpression();
        if (arg instanceof BigIntegerLiteralExpr) {
            arg = new ObjectCreationExpr(null, DrlxParseUtil.toClassOrInterfaceType(BigInteger.class), NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(((BigIntegerLiteralExpr)arg).asBigInteger().toString())}));
        } else if (arg instanceof BigDecimalLiteralExpr) {
            arg = new ObjectCreationExpr(null, DrlxParseUtil.toClassOrInterfaceType(BigDecimal.class), NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(((BigDecimalLiteralExpr)arg).asBigDecimal().toString())}));
        }
        toBigDecimalMethod.addArgument(arg);
        return toBigDecimalMethod;
    }

    private static boolean isComparisonOperator(BinaryExpr.Operator op) {
        return op == BinaryExpr.Operator.LESS || op == BinaryExpr.Operator.GREATER || op == BinaryExpr.Operator.LESS_EQUALS || op == BinaryExpr.Operator.GREATER_EQUALS;
    }

    private static List<Expression> recurseCollectArguments(NodeWithArguments<?> methodCallExpr) {
        Object scope;
        NodeWithOptionalScope nodeWithOptionalScope;
        ArrayList<Expression> res = new ArrayList<Expression>((Collection<Expression>)methodCallExpr.getArguments());
        if (methodCallExpr instanceof NodeWithOptionalScope && (nodeWithOptionalScope = (NodeWithOptionalScope)methodCallExpr).getScope().isPresent() && (scope = nodeWithOptionalScope.getScope().get()) instanceof NodeWithArguments) {
            res.addAll(ConstraintParser.recurseCollectArguments((NodeWithArguments)scope));
        }
        return res;
    }
}

