/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.ReturnStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.model.Query;
import org.drools.model.QueryDef;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.util.StringUtil;

public class QueryGenerator {
    public static void processQueryDef(PackageModel packageModel, QueryDescr queryDescr, RuleContext context) {
        context.setDescr((RuleDescr)queryDescr);
        String queryName = queryDescr.getName();
        String queryDefVariableName = QueryGenerator.toQueryDef(queryName);
        context.setQueryName(Optional.of(queryDefVariableName));
        QueryGenerator.parseQueryParameters(context, packageModel, queryDescr);
        ClassOrInterfaceType queryDefType = QueryGenerator.getQueryType(context.getQueryParameters());
        MethodCallExpr queryCall = new MethodCallExpr(null, "D.query");
        if (!queryDescr.getNamespace().isEmpty()) {
            queryCall.addArgument((Expression)new StringLiteralExpr(queryDescr.getNamespace()));
        }
        queryCall.addArgument((Expression)new StringLiteralExpr(queryName));
        for (QueryParameter qp : context.getQueryParameters()) {
            queryCall.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)qp.type.getCanonicalName())));
            queryCall.addArgument((Expression)new StringLiteralExpr(qp.name));
        }
        packageModel.getQueryDefWithType().put(queryDefVariableName, new QueryDefWithType(queryDefType, queryCall, context));
    }

    public static void processQuery(KnowledgeBuilderImpl kbuilder, PackageModel packageModel, QueryDescr queryDescr) {
        String queryDefVariableName = QueryGenerator.toQueryDef(queryDescr.getName());
        RuleContext context = packageModel.getQueryDefWithType().get(queryDefVariableName).getContext();
        context.addGlobalDeclarations(packageModel.getGlobals());
        context.setDialectFromAttributes(queryDescr.getAttributes().values());
        new ModelGeneratorVisitor(context, packageModel).visit(queryDescr.getLhs());
        Type queryType = JavaParser.parseType((String)Query.class.getCanonicalName());
        MethodDeclaration queryMethod = new MethodDeclaration(EnumSet.of(Modifier.PRIVATE), queryType, "query_" + StringUtil.toId(queryDescr.getName()));
        BlockStmt queryBody = new BlockStmt();
        ModelGenerator.createVariables(kbuilder, queryBody, packageModel, context);
        queryMethod.setBody(queryBody);
        String queryBuildVarName = StringUtil.toId(queryDescr.getName()) + "_build";
        VariableDeclarationExpr queryBuildVar = new VariableDeclarationExpr(queryType, queryBuildVarName);
        MethodCallExpr buildCall = new MethodCallExpr((Expression)new NameExpr(queryDefVariableName), "build");
        context.getExpressions().forEach(arg_0 -> ((MethodCallExpr)buildCall).addArgument(arg_0));
        AssignExpr queryBuildAssign = new AssignExpr((Expression)queryBuildVar, (Expression)buildCall, AssignExpr.Operator.ASSIGN);
        queryBody.addStatement((Expression)queryBuildAssign);
        queryBody.addStatement((Statement)new ReturnStmt(queryBuildVarName));
        packageModel.putQueryMethod(queryMethod);
    }

    private static void parseQueryParameters(RuleContext context, PackageModel packageModel, QueryDescr descr) {
        for (int i = 0; i < descr.getParameters().length; ++i) {
            String argument = descr.getParameters()[i];
            String type = descr.getParameterTypes()[i];
            context.addDeclaration(argument, DrlxParseUtil.getClassFromContext(context.getTypeResolver(), type));
            QueryParameter queryParameter = new QueryParameter(argument, DrlxParseUtil.getClassFromContext(context.getTypeResolver(), type));
            context.getQueryParameters().add(queryParameter);
            packageModel.putQueryVariable("query_" + StringUtil.toId(descr.getName()), queryParameter);
        }
    }

    private static ClassOrInterfaceType getQueryType(List<QueryParameter> queryParameters) {
        ClassOrInterfaceType queryType = DrlxParseUtil.toClassOrInterfaceType(QueryDef.getQueryClassByArity((int)queryParameters.size()));
        Type[] genericType = (Type[])queryParameters.stream().map(e -> e.type).map(DrlxParseUtil::classToReferenceType).toArray(Type[]::new);
        if (genericType.length > 0) {
            queryType.setTypeArguments(genericType);
        }
        return queryType;
    }

    public static boolean isLiteral(String value) {
        return value != null && value.length() > 0 && (Character.isDigit(value.charAt(0)) || value.charAt(0) == '\"' || "true".equals(value) || "false".equals(value) || "null".equals(value) || value.endsWith(".class"));
    }

    public static String toQueryDef(String queryName) {
        return "queryDef_" + StringUtil.toId(queryName);
    }

    public static String toQueryArg(int queryParameterIndex) {
        return "getArg" + queryParameterIndex;
    }

    public static class QueryDefWithType {
        private ClassOrInterfaceType queryType;
        private MethodCallExpr methodCallExpr;
        private RuleContext context;

        public QueryDefWithType(ClassOrInterfaceType queryType, MethodCallExpr methodCallExpr, RuleContext contex) {
            this.queryType = queryType;
            this.methodCallExpr = methodCallExpr;
            this.context = contex;
        }

        public ClassOrInterfaceType getQueryType() {
            return this.queryType;
        }

        public MethodCallExpr getMethodCallExpr() {
            return this.methodCallExpr;
        }

        public RuleContext getContext() {
            return this.context;
        }
    }
}

