/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import java.lang.reflect.Field;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.kie.api.definition.type.Position;

public class ConstraintExpression {
    private final String expression;
    private String unificationField;
    private boolean nameClashingUnification;

    public ConstraintExpression(String expression) {
        this.expression = expression;
    }

    public static ConstraintExpression createConstraintExpression(Class<?> patternType, BaseDescr constraint, boolean isPositional) {
        String expression = ConstraintExpression.parseConstraintExpression(patternType, constraint, isPositional);
        int unifPos = expression.indexOf(":=");
        if (unifPos > 0) {
            String unificationField = expression.substring(0, unifPos).trim();
            String unifiedProp = expression.substring(unifPos + 2).trim();
            expression = unifiedProp + " == " + unificationField;
            ConstraintExpression constraintExpression = new ConstraintExpression(expression);
            constraintExpression.unificationField = unificationField;
            constraintExpression.nameClashingUnification = unificationField.equals(unifiedProp);
            return constraintExpression;
        }
        return new ConstraintExpression(expression);
    }

    public static String parseConstraintExpression(Class<?> patternType, BaseDescr constraint, boolean isPositional) {
        if (isPositional) {
            int position = ((ExprConstraintDescr)constraint).getPosition();
            return ConstraintExpression.getFieldAtPosition(patternType, position) + " == " + constraint.toString();
        }
        return constraint.toString();
    }

    private static String getFieldAtPosition(Class<?> patternType, int position) {
        for (Field field : patternType.getDeclaredFields()) {
            Position p = field.getAnnotation(Position.class);
            if (p == null || p.value() != position) continue;
            return field.getName();
        }
        if (patternType.getSuperclass() != null && patternType.getSuperclass() != Object.class) {
            return ConstraintExpression.getFieldAtPosition(patternType.getSuperclass(), position);
        }
        throw new RuntimeException("Cannot find field in position " + position + " for " + patternType);
    }

    public String getExpression() {
        return this.expression;
    }

    public String getUnificationField() {
        return this.unificationField;
    }

    public boolean isUnification() {
        return this.unificationField != null;
    }

    public boolean isNameClashingUnification() {
        return this.nameClashingUnification;
    }
}

