/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.printer.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.Drools;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.PackageModel;
import org.kie.api.builder.ReleaseId;

public class ModelWriter {
    public Result writeModel(MemoryFileSystem srcMfs, Collection<PackageModel> packageModels) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        ArrayList<String> modelFiles = new ArrayList<String>();
        PrettyPrinter prettyPrinter = JavaParserCompiler.getPrettyPrinter();
        for (PackageModel pkgModel : packageModels) {
            String pojoSourceName;
            String source;
            String pkgName = pkgModel.getName();
            String folderName = pkgName.replace('.', '/');
            for (ClassOrInterfaceDeclaration classOrInterfaceDeclaration : pkgModel.getGeneratedPOJOsSource()) {
                source = JavaParserCompiler.toPojoSource(pkgModel.getName(), pkgModel.getImports(), pkgModel.getStaticImports(), classOrInterfaceDeclaration);
                pkgModel.logRule(source);
                pojoSourceName = "src/main/java/" + folderName + "/" + classOrInterfaceDeclaration.getName() + ".java";
                srcMfs.write(pojoSourceName, source.getBytes());
                sourceFiles.add(pojoSourceName);
            }
            for (GeneratedClassWithPackage generatedClassWithPackage : pkgModel.getGeneratedAccumulateClasses()) {
                source = JavaParserCompiler.toPojoSource(pkgModel.getName(), generatedClassWithPackage.getImports(), pkgModel.getStaticImports(), generatedClassWithPackage.getGeneratedClass());
                pkgModel.logRule(source);
                pojoSourceName = "src/main/java/" + folderName + "/" + generatedClassWithPackage.getGeneratedClass().getName() + ".java";
                srcMfs.write(pojoSourceName, source.getBytes());
                sourceFiles.add(pojoSourceName);
            }
            PackageModel.RuleSourceResult rulesSourceResult = pkgModel.getRulesSource();
            String string = pkgModel.getRulesFileName();
            String rulesSourceName = "src/main/java/" + folderName + "/" + string + ".java";
            String rulesSource = prettyPrinter.print((Node)rulesSourceResult.getMainRuleClass());
            pkgModel.logRule(rulesSource);
            byte[] rulesBytes = rulesSource.getBytes();
            srcMfs.write(rulesSourceName, rulesBytes);
            modelFiles.add(pkgName + "." + string);
            sourceFiles.add(rulesSourceName);
            for (CompilationUnit cu : rulesSourceResult.getSplitted()) {
                String addFileName = ((ClassOrInterfaceDeclaration)cu.findFirst(ClassOrInterfaceDeclaration.class).get()).getNameAsString();
                String addSourceName = "src/main/java/" + folderName + "/" + addFileName + ".java";
                String addSource = prettyPrinter.print((Node)cu);
                pkgModel.logRule(addSource);
                byte[] addBytes = addSource.getBytes();
                srcMfs.write(addSourceName, addBytes);
                sourceFiles.add(addSourceName);
            }
        }
        return new Result(sourceFiles, modelFiles);
    }

    public void writeModelFile(Collection<String> modelSources, MemoryFileSystem trgMfs, ReleaseId releaseId) {
        String pkgNames = "Drools-Model-Version:" + Drools.getFullVersion() + "\n";
        if (!modelSources.isEmpty()) {
            pkgNames = pkgNames + modelSources.stream().collect(Collectors.joining("\n"));
        }
        trgMfs.write(CanonicalKieModule.getModelFileWithGAV(releaseId), pkgNames.getBytes());
    }

    public static class Result {
        private final List<String> sourceFiles;
        private final List<String> modelFiles;

        public Result(List<String> sourceFiles, List<String> modelFiles) {
            this.sourceFiles = sourceFiles;
            this.modelFiles = modelFiles;
        }

        public String[] getSources() {
            return this.sourceFiles.toArray(new String[this.sourceFiles.size()]);
        }

        public List<String> getSourceFiles() {
            return this.sourceFiles;
        }

        public List<String> getModelFiles() {
            return this.modelFiles;
        }
    }
}

