/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;

public class FunctionGenerator {
    public static MethodDeclaration toFunction(FunctionDescr desc) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        List parameterTypes = desc.getParameterTypes();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String type = (String)parameterTypes.get(i);
            String name = (String)desc.getParameterNames().get(i);
            parameters.add(new Parameter(StaticJavaParser.parseType((String)type), name));
        }
        NodeList modifiers = NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier()});
        MethodDeclaration methodDeclaration = new MethodDeclaration(modifiers, desc.getName(), StaticJavaParser.parseType((String)desc.getReturnType()), NodeList.nodeList(parameters));
        BlockStmt block = DrlxParseUtil.parseBlock("try {} catch (Exception e) { throw new RuntimeException(e); }");
        TryStmt tryStmt = (TryStmt)block.getStatement(0);
        tryStmt.setTryBlock(DrlxParseUtil.parseBlock(desc.getBody()));
        methodDeclaration.setBody(block);
        return methodDeclaration;
    }
}

