/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.kie.builder.impl.KieBaseUpdateContext;
import org.drools.compiler.kie.builder.impl.KieBaseUpdater;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CanonicalKieBaseUpdater
extends KieBaseUpdater {
    public CanonicalKieBaseUpdater(KieBaseUpdateContext ctx) {
        super(ctx);
    }

    public void run() {
        List<Object> rulesToBeAdded;
        List<RuleImpl> rulesToBeRemoved;
        CanonicalKieModule oldKM = (CanonicalKieModule)this.ctx.currentKM;
        CanonicalKieModule newKM = (CanonicalKieModule)this.ctx.newKM;
        if (this.ctx.modifyingUsedClass) {
            for (Class cls : this.ctx.modifiedClasses) {
                this.clearInstancesOfModifiedClass(cls);
            }
            rulesToBeRemoved = this.getAllRulesInKieBase(oldKM, this.ctx.currentKieBaseModel);
            rulesToBeAdded = this.getAllRulesInKieBase(newKM, this.ctx.newKieBaseModel);
        } else {
            newKM.setModuleClassLoader(((CanonicalKieModule)this.ctx.currentKM).getModuleClassLoader());
            CanonicalKiePackages newPkgs = newKM.getKiePackages(this.ctx.newKieBaseModel);
            rulesToBeRemoved = new ArrayList<RuleImpl>();
            rulesToBeAdded = new ArrayList();
            for (ResourceChangeSet changeSet : this.ctx.cs.getChanges().values()) {
                if (!CanonicalKieBaseUpdater.isPackageInKieBase((KieBaseModel)this.ctx.newKieBaseModel, changeSet.getResourceName())) continue;
                InternalKnowledgePackage oldKpkg = this.ctx.kBase.getPackage(changeSet.getResourceName());
                InternalKnowledgePackage kpkg = (InternalKnowledgePackage)newPkgs.getKiePackage(changeSet.getResourceName());
                for (ResourceChange change : changeSet.getChanges()) {
                    String changedItemName = change.getName();
                    if (change.getChangeType() == ChangeType.UPDATED || change.getChangeType() == ChangeType.REMOVED) {
                        if (change.getType() == ResourceChange.Type.GLOBAL) {
                            this.ctx.kBase.removeGlobal(changedItemName);
                        } else {
                            rulesToBeRemoved.add(oldKpkg.getRule(changedItemName));
                        }
                    }
                    if (change.getChangeType() != ChangeType.UPDATED && change.getChangeType() != ChangeType.ADDED) continue;
                    if (change.getType() == ResourceChange.Type.GLOBAL) {
                        try {
                            this.ctx.kBase.addGlobal(changedItemName, kpkg.getTypeResolver().resolveType((String)kpkg.getGlobals().get(changedItemName)));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    rulesToBeAdded.add(kpkg.getRule(changedItemName));
                }
            }
        }
        this.ctx.kBase.removeRules(rulesToBeRemoved);
        this.ctx.kBase.addRules(rulesToBeAdded);
    }

    private List<RuleImpl> getAllRulesInKieBase(CanonicalKieModule kieModule, KieBaseModelImpl model) {
        ArrayList<RuleImpl> rules = new ArrayList<RuleImpl>();
        for (KiePackage oldPkg : kieModule.getKiePackages(model).getKiePackages()) {
            if (!CanonicalKieBaseUpdater.isPackageInKieBase((KieBaseModel)this.ctx.currentKieBaseModel, oldPkg.getName())) continue;
            for (Rule oldRule : oldPkg.getRules()) {
                rules.add((RuleImpl)oldRule);
            }
        }
        return rules;
    }

    private static boolean isPackageInKieBase(KieBaseModel kieBaseModel, String pkgName) {
        return kieBaseModel.getPackages().isEmpty() || KieBuilderImpl.isPackageInKieBase((KieBaseModel)kieBaseModel, (String)pkgName);
    }
}

