/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelWriter;
import org.kie.internal.builder.KnowledgeBuilder;

public class CanonicalModelKieProject
extends KieModuleKieProject {
    protected List<ModelBuilderImpl> modelBuilders = new ArrayList<ModelBuilderImpl>();

    public CanonicalModelKieProject(InternalKieModule kieModule, ClassLoader classLoader) {
        super(kieModule, classLoader);
    }

    protected KnowledgeBuilder createKnowledgeBuilder(KieBaseModelImpl kBaseModel, AbstractKieModule kModule) {
        ModelBuilderImpl modelBuilder = new ModelBuilderImpl();
        this.modelBuilders.add(modelBuilder);
        return modelBuilder;
    }

    public void writeProjectOutput(MemoryFileSystem trgMfs, ResultsImpl messages) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        ModelWriter modelWriter = new ModelWriter();
        ArrayList<String> modelFiles = new ArrayList<String>();
        for (ModelBuilderImpl modelBuilder : this.modelBuilders) {
            ModelWriter.Result result = modelWriter.writeModel(srcMfs, modelBuilder.getPackageModels());
            modelFiles.addAll(result.modelFiles);
            String[] sources = result.getSources();
            if (sources.length == 0) continue;
            CompilationResult res = JavaParserCompiler.getCompiler().compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClassLoader());
            for (CompilationProblem problem : res.getErrors()) {
                messages.addMessage(problem);
            }
            for (CompilationProblem problem : res.getWarnings()) {
                messages.addMessage(problem);
            }
        }
        modelWriter.writeModelFile(modelFiles, trgMfs);
    }
}

