/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.POJOGenerator;

public class ModelBuilderImpl
extends KnowledgeBuilderImpl {
    private final Map<String, PackageModel> packageModels = new HashMap<String, PackageModel>();

    public ModelBuilderImpl() {
    }

    public ModelBuilderImpl(KnowledgeBuilderConfigurationImpl configuration) {
        super(configuration);
    }

    public ModelBuilderImpl(InternalKnowledgeBase kBase) {
        super(kBase);
    }

    public ModelBuilderImpl(InternalKnowledgeBase kBase, KnowledgeBuilderConfigurationImpl configuration) {
        super(kBase, configuration);
    }

    public void buildPackages(Collection<CompositePackageDescr> packages) {
        this.initPackageRegistries(packages);
        this.buildOtherDeclarations(packages);
        this.buildRules(packages);
    }

    protected void buildRules(Collection<CompositePackageDescr> packages) {
        InternalKnowledgePackage pkg;
        for (CompositePackageDescr packageDescr : packages) {
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.generatePOJOs((PackageDescr)packageDescr, pkgRegistry);
        }
        List<GeneratedClassWithPackage> allGeneratedPojos = this.packageModels.values().stream().flatMap(p -> p.getGeneratedPOJOsSource().stream().map(c -> new GeneratedClassWithPackage((ClassOrInterfaceDeclaration)c, p.getName(), p.getImports()))).collect(Collectors.toList());
        HashMap allCompiledClasses = new HashMap();
        for (CompositePackageDescr packageDescr : packages) {
            pkg = this.getPackageRegistry(packageDescr.getNamespace()).getPackage();
            allCompiledClasses.putAll(POJOGenerator.compileType(this, pkg.getPackageClassLoader(), allGeneratedPojos));
        }
        for (CompositePackageDescr packageDescr : packages) {
            pkg = this.getPackageRegistry(packageDescr.getNamespace()).getPackage();
            allGeneratedPojos.forEach(c -> POJOGenerator.registerType(pkg.getTypeResolver(), allCompiledClasses));
        }
        if (this.hasErrors()) {
            return;
        }
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter((KnowledgeBuilderImpl.AssetFilter)packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileKnowledgePackages((PackageDescr)packageDescr, pkgRegistry);
            this.setAssetFilter(null);
        }
    }

    protected void generatePOJOs(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        String pkgName = pkg.getName();
        PackageModel model = this.packageModels.computeIfAbsent(pkgName, s -> new PackageModel(pkgName, this.getBuilderConfiguration()));
        model.addImports(pkg.getTypeResolver().getImports());
        POJOGenerator.generatePOJO(pkg, packageDescr, model);
    }

    protected void compileKnowledgePackages(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        this.validateUniqueRuleNames(packageDescr);
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        String pkgName = pkg.getName();
        PackageModel model = this.packageModels.computeIfAbsent(pkgName, s -> new PackageModel(pkgName, this.getBuilderConfiguration()));
        ModelGenerator.generateModel(this, pkg, packageDescr, model);
    }

    public List<PackageModel> getPackageModels() {
        return new ArrayList<PackageModel>(this.packageModels.values());
    }
}

