/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.drools.core.util.index.IndexUtil;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.modelcompiler.builder.generator.TypedExpression;

public class DrlxParseResult {
    private final Class<?> patternType;
    private Expression expr;
    private final Class<?> exprType;
    private String exprId;
    private String patternBinding;
    private boolean isPatternBindingUnification = false;
    private String exprBinding;
    private IndexUtil.ConstraintType decodeConstraintType;
    private Collection<String> usedDeclarations = new LinkedHashSet<String>();
    private Set<String> reactOnProperties = Collections.emptySet();
    private String[] watchedProperties;
    private TypedExpression left;
    private TypedExpression right;
    private boolean isStatic;
    private boolean isValidExpression;

    public DrlxParseResult(Class<?> patternType, String exprId, String patternBinding, Expression expr, Class<?> exprType) {
        this.patternType = patternType;
        this.exprId = exprId;
        this.patternBinding = patternBinding;
        this.expr = expr;
        this.exprType = exprType;
    }

    public DrlxParseResult setDecodeConstraintType(IndexUtil.ConstraintType decodeConstraintType) {
        this.decodeConstraintType = decodeConstraintType;
        return this;
    }

    public DrlxParseResult setUsedDeclarations(List<String> usedDeclarations) {
        this.usedDeclarations = new LinkedHashSet<String>(usedDeclarations);
        return this;
    }

    public DrlxParseResult setReactOnProperties(Set<String> reactOnProperties) {
        this.reactOnProperties = reactOnProperties;
        return this;
    }

    public DrlxParseResult setPatternBindingUnification(Boolean unification) {
        this.isPatternBindingUnification = unification;
        return this;
    }

    public DrlxParseResult addReactOnProperty(String reactOnProperty) {
        if (this.reactOnProperties.isEmpty()) {
            this.reactOnProperties = new HashSet<String>();
        }
        this.reactOnProperties.add(reactOnProperty);
        return this;
    }

    public DrlxParseResult setLeft(TypedExpression left) {
        this.left = left;
        return this;
    }

    public DrlxParseResult setRight(TypedExpression right) {
        this.right = right;
        return this;
    }

    public DrlxParseResult setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public String getExprId() {
        return this.exprId;
    }

    public String getPatternBinding() {
        return this.patternBinding;
    }

    public void setExprId(String exprId) {
        this.exprId = exprId;
    }

    public void setExpr(Expression expr) {
        this.expr = expr;
    }

    public void setPatternBinding(String patternBinding) {
        this.patternBinding = patternBinding;
    }

    public DrlxParseResult setExprBinding(String exprBinding) {
        this.exprBinding = exprBinding;
        return this;
    }

    public boolean hasUnificationVariable() {
        return Optional.ofNullable(this.left).flatMap(TypedExpression::getUnificationVariable).isPresent() || Optional.ofNullable(this.right).flatMap(TypedExpression::getUnificationVariable).isPresent();
    }

    public String getUnificationVariable() {
        return this.left.getUnificationVariable().isPresent() ? this.left.getUnificationVariable().get() : this.right.getUnificationVariable().get();
    }

    public String getUnificationName() {
        return this.left.getUnificationName().isPresent() ? this.left.getUnificationName().get() : this.right.getUnificationName().get();
    }

    public Class<?> getUnificationVariableType() {
        return this.left.getUnificationVariable().isPresent() ? this.right.getType() : this.left.getType();
    }

    public Expression getExpr() {
        return this.expr;
    }

    public String getExprBinding() {
        return this.exprBinding;
    }

    public Class<?> getExprType() {
        return this.exprType;
    }

    public Class<?> getPatternType() {
        return this.patternType;
    }

    public boolean isPatternBindingUnification() {
        return this.isPatternBindingUnification;
    }

    public IndexUtil.ConstraintType getDecodeConstraintType() {
        return this.decodeConstraintType;
    }

    public Collection<String> getUsedDeclarations() {
        return this.usedDeclarations;
    }

    public Set<String> getReactOnProperties() {
        return this.reactOnProperties;
    }

    public String[] getWatchedProperties() {
        return this.watchedProperties;
    }

    public void setWatchedProperties(String[] watchedProperties) {
        this.watchedProperties = watchedProperties;
    }

    public TypedExpression getLeft() {
        return this.left;
    }

    public TypedExpression getRight() {
        return this.right;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isValidExpression() {
        return this.isValidExpression || this.expr != null && (this.right != null || this.getExprType() == Boolean.class || this.getExprType() == Boolean.TYPE);
    }

    public DrlxParseResult setValidExpression(boolean validExpression) {
        this.isValidExpression = validExpression;
        return this;
    }
}

