/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.util.ClassUtils;
import org.drools.javaparser.ast.drlx.OOPathChunk;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.expr.BooleanLiteralExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;

public class OOPathExprGenerator {
    private final RuleContext context;
    private final PackageModel packageModel;

    public OOPathExprGenerator(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public void visit(Class<?> originalClass, String originalBind, OOPathExpr ooPathExpr) {
        Class<Object> previousClass = originalClass;
        String previousBind = originalBind;
        LinkedHashMap<String, List<DrlxParseResult>> ooPathConditionExpressions = new LinkedHashMap<String, List<DrlxParseResult>>();
        for (OOPathChunk chunk : ooPathExpr.getChunks()) {
            Class<Object> fieldType;
            String fieldName = chunk.getField().toString();
            TypedExpression callExpr = DrlxParseUtil.nameExprToMethodCallExpr(fieldName, previousClass, null);
            Class<Object> clazz = fieldType = chunk.getInlineCast() != null ? DrlxParseUtil.getClassFromContext(this.context.getPkg().getTypeResolver(), chunk.getInlineCast().toString()) : callExpr.getType();
            if (Iterable.class.isAssignableFrom(fieldType)) {
                fieldType = ClassUtils.extractGenericType(previousClass, (String)((MethodCallExpr)callExpr.getExpression()).getName().toString());
            }
            String chunkKey = originalBind + fieldName;
            String bindingId = this.context.getOOPathId(fieldType, chunkKey);
            Expression accessorLambda = DrlxParseUtil.generateLambdaWithoutParameters(Collections.emptySortedSet(), DrlxParseUtil.prepend((Expression)new NameExpr("_this"), callExpr.getExpression()));
            MethodCallExpr reactiveFrom = new MethodCallExpr(null, "reactiveFrom");
            reactiveFrom.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(previousBind)));
            reactiveFrom.addArgument(accessorLambda);
            DeclarationSpec newDeclaration = new DeclarationSpec(bindingId, fieldType, (Expression)reactiveFrom);
            this.context.addDeclaration(newDeclaration);
            this.context.addOOPathDeclaration(newDeclaration);
            List conditions = chunk.getConditions();
            if (!conditions.isEmpty()) {
                Class<Object> finalFieldType = fieldType;
                List conditionParseResult = conditions.stream().map(c -> ModelGenerator.drlxParse(this.context, this.packageModel, finalFieldType, bindingId, c.toString())).collect(Collectors.toList());
                ooPathConditionExpressions.put(chunkKey, conditionParseResult);
            } else {
                DrlxParseResult drlxParseResult = new DrlxParseResult(fieldType, "", bindingId, (Expression)new BooleanLiteralExpr(true), fieldType);
                ooPathConditionExpressions.put(chunkKey, Collections.singletonList(drlxParseResult));
            }
            previousBind = bindingId;
            previousClass = fieldType;
        }
        this.inferTypeForInnerBinding(ooPathConditionExpressions);
        List<Expression> collect = this.buildExpressions(ooPathConditionExpressions);
        collect.forEach(this.context::addExpression);
    }

    private List<Expression> buildExpressions(Map<String, List<DrlxParseResult>> ooPathConditionExpressions) {
        return ooPathConditionExpressions.entrySet().stream().map(kv -> {
            List value = (List)kv.getValue();
            if (value.size() == 1) {
                return ModelGenerator.buildExpressionWithIndexing(this.context, (DrlxParseResult)value.get(0));
            }
            MethodCallExpr andDSL = new MethodCallExpr(null, "and");
            value.forEach(e -> {
                Expression expression = ModelGenerator.buildExpressionWithIndexing(this.context, e);
                andDSL.addArgument(expression);
            });
            return andDSL;
        }).collect(Collectors.toList());
    }

    private void inferTypeForInnerBinding(Map<String, List<DrlxParseResult>> ooPathConditionExpressions) {
        List<DeclarationSpec> declarations = this.context.getDeclarations();
        Optional<DeclarationSpec> missingClassDeclarationFound = declarations.stream().filter(d -> d.getDeclarationClass() == null).findFirst();
        missingClassDeclarationFound.ifPresent(missingClassDeclaration -> {
            DrlxParseResult[] flattenedCollection;
            declarations.remove(declarations.indexOf(missingClassDeclaration));
            String innerBindingId = missingClassDeclaration.getBindingId();
            int lastIndex = declarations.size() - 1;
            DeclarationSpec last = (DeclarationSpec)declarations.get(lastIndex);
            declarations.add(new DeclarationSpec(innerBindingId, last.getDeclarationClass(), last.getOptPattern(), last.getDeclarationSource()));
            for (DrlxParseResult r : flattenedCollection = (DrlxParseResult[])ooPathConditionExpressions.values().stream().flatMap(Collection::stream).toArray(DrlxParseResult[]::new)) {
                if (r.getExprId().equals(last.getBindingId())) {
                    r.setExprId(innerBindingId);
                    continue;
                }
                if (!r.getPatternBinding().equals(last.getBindingId())) continue;
                r.setPatternBinding(innerBindingId);
            }
        });
    }
}

