/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Interval;
import org.drools.model.SingleConstraint;
import org.drools.model.constraints.TemporalConstraint;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;

public class TemporalConstraintEvaluator
extends ConstraintEvaluator {
    private final Interval interval;

    public TemporalConstraintEvaluator(Declaration[] declarations, Pattern pattern, SingleConstraint constraint) {
        super(declarations, pattern, constraint);
        TemporalPredicate temporalPredicate = this.getTemporalPredicate();
        this.interval = new Interval(temporalPredicate.getInterval().getLowerBound(), temporalPredicate.getInterval().getUpperBound());
    }

    public TemporalPredicate getTemporalPredicate() {
        return ((TemporalConstraint)this.constraint).getTemporalPredicate();
    }

    @Override
    public boolean evaluate(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        InternalFactHandle[] fhs = this.getBetaInvocationFactHandles(handle, tuple);
        long start1 = ((EventFactHandle)fhs[0]).getStartTimestamp();
        long duration1 = ((EventFactHandle)fhs[0]).getDuration();
        long end1 = start1 + duration1;
        long start2 = ((EventFactHandle)fhs[1]).getStartTimestamp();
        long duration2 = ((EventFactHandle)fhs[1]).getDuration();
        long end2 = start2 + duration2;
        return this.getTemporalPredicate().evaluate(start1, duration1, end1, start2, duration2, end2);
    }

    @Override
    public boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }
}

