/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.mvelcompiler.ast.TypedExpression;

public class ObjectCreationExpressionT
implements TypedExpression {
    private final Class<?> type;
    private List<TypedExpression> constructorArguments;

    public ObjectCreationExpressionT(List<TypedExpression> constructorArguments, Class<?> type) {
        this.constructorArguments = constructorArguments;
        this.type = type;
    }

    @Override
    public Optional<Type> getType() {
        return Optional.of(this.type);
    }

    @Override
    public Node toJavaExpression() {
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(this.type);
        List arguments = this.constructorArguments.stream().map(typedExpression -> (Expression)typedExpression.toJavaExpression()).collect(Collectors.toList());
        objectCreationExpr.setArguments(NodeList.nodeList(arguments));
        return objectCreationExpr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectCreationExpressionT{");
        sb.append("arguments=").append(this.constructorArguments);
        sb.append("type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

