/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.util.BigDecimalArgumentCoercion;
import org.drools.mvelcompiler.util.CoercionUtils;

public class MethodCallExprT
implements TypedExpression {
    private final String name;
    private final Optional<TypedExpression> scope;
    private final List<TypedExpression> arguments;
    private List<Class<?>> actualMethodArgumentType;
    private final Optional<Type> type;

    public MethodCallExprT(String name, Optional<TypedExpression> scope, List<TypedExpression> arguments, List<Class<?>> actualMethodArgumentType, Optional<Type> type) {
        this.name = name;
        this.scope = scope;
        this.arguments = arguments;
        this.actualMethodArgumentType = actualMethodArgumentType;
        this.type = type;
    }

    @Override
    public Optional<Type> getType() {
        return this.type;
    }

    @Override
    public Node toJavaExpression() {
        Node scopeE = this.scope.map(TypedExpression::toJavaExpression).orElse(null);
        List<Expression> methodArguments = "put".equals(this.name) && this.arguments.size() == 2 ? this.coercedMapArguments() : this.toJavaExpressionArgument();
        return new MethodCallExpr((Expression)scopeE, this.name, NodeList.nodeList(methodArguments));
    }

    private List<Expression> toJavaExpressionArgument() {
        ArrayList<Expression> list = new ArrayList<Expression>();
        List<TypedExpression> typedArguments = this.arguments;
        for (int i = 0; i < typedArguments.size(); ++i) {
            Expression expression = this.toJavaArgument(typedArguments, i);
            list.add(expression);
        }
        return list;
    }

    private Expression toJavaArgument(List<TypedExpression> typedExpressions, int i) {
        Class actualType;
        Class argumentType;
        Type argumentTypeOrig;
        TypedExpression a = typedExpressions.get(i);
        Optional<Object> optionalActualType = Optional.empty();
        if (this.actualMethodArgumentType.size() == typedExpressions.size()) {
            optionalActualType = Optional.ofNullable(this.actualMethodArgumentType.get(i));
        }
        if (optionalActualType.isPresent() && a.getType().isPresent() && (argumentTypeOrig = a.getType().get()) instanceof Class && (argumentType = (Class)argumentTypeOrig) != (actualType = (Class)optionalActualType.get())) {
            return new BigDecimalArgumentCoercion().coercedArgument(argumentType, actualType, (Expression)a.toJavaExpression());
        }
        return (Expression)a.toJavaExpression();
    }

    private List<Expression> coercedMapArguments() {
        Expression key = (Expression)this.arguments.get(0).toJavaExpression();
        Expression originalValue = (Expression)this.arguments.get(1).toJavaExpression();
        Optional<Type> scopeType = this.scope.flatMap(TypedExpression::getType);
        Expression coercedValue = CoercionUtils.coerceMapValueToString(scopeType, originalValue);
        return Arrays.asList(key, coercedValue);
    }

    public String toString() {
        return "MethodCallExprT{name='" + this.name + '\'' + ", scope=" + this.scope + ", arguments=" + this.arguments + ", type=" + this.type + '}';
    }
}

