/* Generated by: ParserGeneratorCC: Do not edit this line. SimpleCharStream.java Version 1.1 */
/* ParserGeneratorCCOptions:SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
/*
 * Copyright (C) 2007-2010 Júlio Vilmar Gesser.
 * Copyright (C) 2011, 2013-2016 The JavaParser Team.
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * This file is part of JavaParser.
 *
 * JavaParser can be used either under the terms of
 * a) the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * b) the terms of the Apache License
 *
 * You should have received a copy of both licenses in LICENCE.LGPL and
 * LICENCE.APACHE. Please refer to those files for details.
 *
 * JavaParser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * Modified by Red Hat, Inc.
 */
package org.drools.mvel.parser;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (without unicode processing).
 */
public
class SimpleCharStream extends AbstractCharStream
{
  protected Provider inputStream;

  @Override
  protected int streamRead(final char[] buffer, final int offset, final int len) throws java.io.IOException {
    return inputStream.read (buffer, offset, len); 
  }
  
  @Override
  protected void streamClose() throws java.io.IOException {
    inputStream.close (); 
  }

  protected void fillBuff() throws java.io.IOException
  {
    if (maxNextCharInd == available)
    {
      if (available == bufsize)
      {
        if (tokenBegin > 2048)
        {
          maxNextCharInd = 0;
          bufpos = 0;
          available = tokenBegin;
        }
        else
        if (tokenBegin < 0) {
          maxNextCharInd = 0;
          bufpos = 0;
        }
        else
          expandBuff(false);
      }
      else
      if (available > tokenBegin)
        available = bufsize;
      else
      if ((tokenBegin - available) < 2048)
        expandBuff(true);
      else
        available = tokenBegin;
    }

    try {
      int i = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd);
      if (i == -1)
      {
        inputStream.close();
        throw new java.io.IOException();
      }
      maxNextCharInd += i;
      return;
    }
    catch(final java.io.IOException e) {
      --bufpos;
      backup(0);
      if (tokenBegin == -1)
        tokenBegin = bufpos;
      throw e;
    }
  }

  /** Read a character. */
  public char readChar() throws java.io.IOException
  {
    if (inBuf > 0)
    {
      --inBuf;

      if (++bufpos == bufsize)
        bufpos = 0;

      return buffer[bufpos];
    }

    ++bufpos;
    if (bufpos >= maxNextCharInd)
      fillBuff();

    char c = buffer[bufpos];

    if (isTrackLineColumn())
      updateLineColumn(c);
    return c;
  }

  /** Constructor. */
  public SimpleCharStream(final Provider dstream,
                          final int startline,
                          final int startcolumn,
                          final int buffersize)
  {
    super (startline, startcolumn, buffersize);
    inputStream = dstream;
  }

  /** Constructor. */
  public SimpleCharStream(final Provider dstream,
                          final int startline,
                          final int startcolumn)
  {
    this(dstream, startline, startcolumn, 4096);
  }

  /** Constructor. */
  public SimpleCharStream(final Provider dstream)
  {
    this(dstream, 1, 1, 4096);
  }

  /** Reinitialise. */
  public void reInit(final Provider dstream,
                     final int startline,
                     final int startcolumn,
                     final int buffersize)
  {
    inputStream = dstream;
    super.reInit (startline, startcolumn, buffersize);
  }

  /** Reinitialise. */
  public void reInit(final Provider dstream,
                     final int startline,
                     final int startcolumn)
  {
    reInit(dstream, startline, startcolumn, 4096);
  }

  /** Reinitialise. */
  public void reInit(final Provider dstream)
  {
    reInit(dstream, 1, 1, 4096);
  }
}
/* ParserGeneratorCC - OriginalChecksum=16f4775d9273da1121f89e718229b869 (do not edit this line) */
