/* GeneratedMvelParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. GeneratedMvelParser.java */
/*
 * Copyright (C) 2007-2010 Júlio Vilmar Gesser.
 * Copyright (C) 2011, 2013-2016 The JavaParser Team.
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * This file is part of JavaParser.
 *
 * JavaParser can be used either under the terms of
 * a) the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * b) the terms of the Apache License
 *
 * You should have received a copy of both licenses in LICENCE.LGPL and
 * LICENCE.APACHE. Please refer to those files for details.
 *
 * JavaParser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * Modified by Red Hat, Inc.
 */
package org.drools.mvel.parser;
import java.io.*;
import java.util.*;
import java.util.concurrent.TimeUnit;
import com.github.javaparser.ast.*;
import com.github.javaparser.ast.body.*;
import com.github.javaparser.ast.comments.*;
import com.github.javaparser.ast.modules.*;
import com.github.javaparser.ast.expr.*;
import org.drools.mvel.parser.ast.expr.*;
import com.github.javaparser.ast.stmt.*;
import com.github.javaparser.ast.type.*;
import com.github.javaparser.utils.*;

import com.github.javaparser.Problem;
import com.github.javaparser.TokenRange;
import com.github.javaparser.TokenRange;
import org.drools.mvel.parser.Token;
import com.github.javaparser.JavaToken;
import static com.github.javaparser.ast.stmt.SwitchEntry.Type.*;

import static com.github.javaparser.JavaToken.INVALID;
import static com.github.javaparser.ast.Node.Parsedness.UNPARSABLE;
import static com.github.javaparser.utils.Utils.*;
import static com.github.javaparser.ast.NodeList.*;
import static org.drools.mvel.parser.GeneratedMvelParser.*;
import static com.github.javaparser.Range.*;
import static com.github.javaparser.Position.*;
import static com.github.javaparser.ast.type.ArrayType.*;
import static org.drools.mvel.parser.GeneratedMvelParserTokenManagerBase.*;
import static org.drools.mvel.parser.utils.AstUtils.*;

import com.github.javaparser.JavaToken;

@Generated("JavaCC")
public final class GeneratedMvelParser extends GeneratedMvelParserBase implements GeneratedMvelParserConstants {
    private boolean optionalSemicolon = true;
    private int nestedBlocks = 0;
    private boolean isWithOrModify = false;

    public void setOptionalSemicolon(boolean optionalSemicolon) {
        this.optionalSemicolon = optionalSemicolon;
    }

    public boolean shouldTerminateStatement() {
        Token token = getToken(1);
        return (this.optionalSemicolon && (
                    ( token.kind == RBRACE ) ||
                    ( token.kind == IDENTIFIER ) ||
                    ( this.isWithOrModify && token.kind == COMMA ) ||
                    ( token.specialToken != null &&
                        ( token.specialToken.kind == UNIX_EOL ||
                          token.specialToken.kind == WINDOWS_EOL ||
                          token.specialToken.kind == SINGLE_LINE_COMMENT ) ) ) );

    }

    public boolean inBlock() {
        return nestedBlocks > 0;
    }

    public void enterBlock() {
        this.nestedBlocks++;
    }

    public void leaveBlock() {
        this.nestedBlocks--;
    }

    /* Returns the JavaParser specific token type of the last matched token */
    JavaToken token() {
        if(token.toString() == null) {
            return null;
        }
        return new org.drools.mvel.parser.JavaToken(token.javaToken.getKind(), token.javaToken.getText());
    }

    /* Changes the amount by which the horizontal position is increased when a tab character is encountered.
        One by default.*/
    void setTabSize(int size) {
        jj_input_stream.setTabSize(size);
    }

    @Override
    GeneratedMvelParserTokenManager getTokenSource() {
        return token_source;
    }

    private Collection<String> pointFreeOperators = new ArrayList<String>();
    public void setPointFreeOperators(Collection<String> pointFreeOperators) {
        this.pointFreeOperators = pointFreeOperators;
    }

    public boolean isPointFreeOperator(String operator) {
        return this.pointFreeOperators.contains(operator);
    }

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/

/*
 * Program structuring syntax follows.
 */
  final public 
CompilationUnit CompilationUnit() throws ParseException {PackageDeclaration pakage = null;
 NodeList<ImportDeclaration> imports = emptyList();
 ImportDeclaration in = null;
 NodeList<TypeDeclaration<?>> types = emptyList();
    ModifierHolder modifier;
 TypeDeclaration<?> tn = null;
 ModuleDeclaration module = null;
    try {
      label_1:
      while (true) {
        if (jj_2_1(2)) {
        } else {
          break label_1;
        }
        jj_consume_token(SEMICOLON);
      }
      if (jj_2_2(2147483647)) {
        pakage = PackageDeclaration();
      } else {
        ;
      }
      label_2:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ABSTRACT:
        case CLASS:
        case _DEFAULT:
        case ENUM:
        case FINAL:
        case IMPORT:
        case INTERFACE:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case OPEN:
        case MODULE:
        case TRANSITIVE:
        case RULE:
        case SEMICOLON:
        case AT:{
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_2;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IMPORT:{
          in = ImportDeclaration();
imports = add(imports, in);
          break;
          }
        case ABSTRACT:
        case CLASS:
        case _DEFAULT:
        case ENUM:
        case FINAL:
        case INTERFACE:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case OPEN:
        case MODULE:
        case TRANSITIVE:
        case RULE:
        case SEMICOLON:
        case AT:{
          modifier = Modifiers();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case CLASS:
          case INTERFACE:{
            tn = ClassOrInterfaceDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case RULE:{
            tn = RuleDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case ENUM:{
            tn = EnumDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case OPEN:
          case MODULE:{
            module = ModuleDeclaration(modifier);
            break;
            }
          case SEMICOLON:{
            jj_consume_token(SEMICOLON);
            break;
            }
          default:
            jj_la1[1] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 0:{
        jj_consume_token(0);
        break;
        }
      case CTRL_Z:{
        jj_consume_token(CTRL_Z);
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return new CompilationUnit(range(token_source.getHomeToken(), token()), pakage, imports, types, module);}
    } catch (ParseException e) {
recover(EOF, e);
        final CompilationUnit compilationUnit = new CompilationUnit(range(token_source.getHomeToken(), token()), null, new NodeList<ImportDeclaration>(), new NodeList<TypeDeclaration<?>>(), null);
        compilationUnit.setParsed(UNPARSABLE);
        {if ("" != null) return compilationUnit;}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PackageDeclaration PackageDeclaration() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
 Name name;
 JavaToken begin;
    annotations = Annotations();
    jj_consume_token(PACKAGE);
begin = token();
    name = Name();
    jj_consume_token(SEMICOLON);
{if ("" != null) return new PackageDeclaration(range(begin, token()), annotations, name);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ImportDeclaration ImportDeclaration() throws ParseException {Name name;
    boolean isStatic = false;
    boolean isAsterisk = false;
    JavaToken begin;
    jj_consume_token(IMPORT);
begin = token();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STATIC:{
      jj_consume_token(STATIC);
isStatic = true;
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    name = Name();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      jj_consume_token(STAR);
isAsterisk = true;
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
{if ("" != null) return new ImportDeclaration(range(begin, token()), name, isStatic, isAsterisk);}
    throw new IllegalStateException ("Missing return statement in function");
}

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public 
ModifierHolder Modifiers() throws ParseException {JavaToken begin = INVALID;
    NodeList<Modifier> modifiers = new NodeList<Modifier>();
 NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    AnnotationExpr ann;
    label_3:
    while (true) {
      if (jj_2_3(2)) {
      } else {
        break label_3;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PUBLIC:{
        jj_consume_token(PUBLIC);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.PUBLIC)); begin = orIfInvalid(begin, token());
        break;
        }
      case STATIC:{
        jj_consume_token(STATIC);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.STATIC)); begin = orIfInvalid(begin, token());
        break;
        }
      case PROTECTED:{
        jj_consume_token(PROTECTED);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.PROTECTED)); begin = orIfInvalid(begin, token());
        break;
        }
      case PRIVATE:{
        jj_consume_token(PRIVATE);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.PRIVATE)); begin = orIfInvalid(begin, token());
        break;
        }
      case FINAL:{
        jj_consume_token(FINAL);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.FINAL)); begin = orIfInvalid(begin, token());
        break;
        }
      case ABSTRACT:{
        jj_consume_token(ABSTRACT);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.ABSTRACT)); begin = orIfInvalid(begin, token());
        break;
        }
      case SYNCHRONIZED:{
        jj_consume_token(SYNCHRONIZED);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.SYNCHRONIZED)); begin = orIfInvalid(begin, token());
        break;
        }
      case NATIVE:{
        jj_consume_token(NATIVE);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.NATIVE)); begin = orIfInvalid(begin, token());
        break;
        }
      case TRANSIENT:{
        jj_consume_token(TRANSIENT);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.TRANSIENT)); begin = orIfInvalid(begin, token());
        break;
        }
      case VOLATILE:{
        jj_consume_token(VOLATILE);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.VOLATILE)); begin = orIfInvalid(begin, token());
        break;
        }
      case STRICTFP:{
        jj_consume_token(STRICTFP);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.STRICTFP));  begin = orIfInvalid(begin, token());
        break;
        }
      case TRANSITIVE:{
        jj_consume_token(TRANSITIVE);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.TRANSITIVE));  begin = orIfInvalid(begin, token());
        break;
        }
      case _DEFAULT:{
        jj_consume_token(_DEFAULT);
add(modifiers, new Modifier(tokenRange(), Modifier.Keyword.DEFAULT));  begin = orIfInvalid(begin, token());
        break;
        }
      case AT:{
        ann = Annotation();
annotations = add(annotations, ann); begin = orIfInvalid(begin, ann);
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return new ModifierHolder(begin, modifiers, annotations);}
    throw new IllegalStateException ("Missing return statement in function");
}

/*
 * Declaration syntax follows.
 */
  final public 
ClassOrInterfaceDeclaration ClassOrInterfaceDeclaration(ModifierHolder modifier) throws ParseException {boolean isInterface = false;
    SimpleName name;
    RangedList<TypeParameter> typePar = new RangedList<TypeParameter>(emptyList());
    NodeList<ClassOrInterfaceType> extList = emptyList();
    NodeList<ClassOrInterfaceType> impList = emptyList();
    NodeList<BodyDeclaration<?>> members = emptyList();
    JavaToken begin = modifier.begin;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CLASS:{
      jj_consume_token(CLASS);
      break;
      }
    case INTERFACE:{
      jj_consume_token(INTERFACE);
isInterface = true;
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
begin = orIfInvalid(begin, token());
    name = SimpleName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:{
      typePar = TypeParameters();
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXTENDS:{
      extList = ExtendsList();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IMPLEMENTS:{
      impList = ImplementsList();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    members = ClassOrInterfaceBody();
{if ("" != null) return new ClassOrInterfaceDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, isInterface, name, typePar.list, extList, impList, members);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<ClassOrInterfaceType> ExtendsList() throws ParseException {boolean extendsMoreThanOne = false;
   NodeList<ClassOrInterfaceType> ret = new NodeList<ClassOrInterfaceType>();
   ClassOrInterfaceType cit;
    jj_consume_token(EXTENDS);
    cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    label_4:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      cit = AnnotatedClassOrInterfaceType();
ret.add(cit); extendsMoreThanOne = true;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<ClassOrInterfaceType> ImplementsList() throws ParseException {NodeList<ClassOrInterfaceType> ret = new NodeList<ClassOrInterfaceType>();
   ClassOrInterfaceType cit;
    jj_consume_token(IMPLEMENTS);
    cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EnumDeclaration EnumDeclaration(ModifierHolder modifier) throws ParseException {SimpleName name;
    NodeList<ClassOrInterfaceType> impList = emptyList();
 EnumConstantDeclaration entry;
 NodeList<EnumConstantDeclaration> entries = emptyList();
 BodyDeclaration<?> member;
    NodeList<BodyDeclaration<?>> members = emptyList();
 JavaToken begin = modifier.begin;
    jj_consume_token(ENUM);
begin = orIfInvalid(begin, token());
    name = SimpleName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IMPLEMENTS:{
      impList = ImplementsList();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:{
      entry = EnumConstantDeclaration();
entries.add(entry);
      label_6:
      while (true) {
        if (jj_2_4(2)) {
        } else {
          break label_6;
        }
        jj_consume_token(COMMA);
        entry = EnumConstantDeclaration();
entries.add(entry);
      }
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      label_7:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case CLASS:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case LBRACE:
        case SEMICOLON:
        case AT:{
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_7;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case CLASS:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case LBRACE:
        case AT:{
          member = ClassOrInterfaceBodyDeclaration();
members = add(members, member);
          break;
          }
        case SEMICOLON:{
          jj_consume_token(SEMICOLON);
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new EnumDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, name, impList, entries, members);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EnumConstantDeclaration EnumConstantDeclaration() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
 AnnotationExpr ann;
 SimpleName name;
 NodeList<Expression> args = emptyList();
 NodeList<BodyDeclaration<?>> classBody = emptyList();
 JavaToken begin = INVALID;

    label_8:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AT:{
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_8;
      }
      ann = Annotation();
annotations = add(annotations, ann); begin = orIfInvalid(begin, ann);
    }
    name = SimpleName();
begin = orIfInvalid(begin, token());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      args = Arguments();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACE:{
      classBody = ClassOrInterfaceBody();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
{if ("" != null) return new EnumConstantDeclaration(range(begin, token()), annotations, name, args, classBody);}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * If the list inside the returned RangedList is null, there are no brackets.
 * If it is empty, there are brackets, but nothing is in them <>.
 * The normal case is that it contains TypeParameters, like <A, B, C>.
 */
  final public RangedList<TypeParameter> TypeParameters() throws ParseException {RangedList<TypeParameter> ret = new RangedList<TypeParameter>(new NodeList<TypeParameter>());
 TypeParameter tp;
 NodeList<AnnotationExpr> annotations;
    jj_consume_token(LT);
ret.beginAt(token());
    annotations = Annotations();
    tp = TypeParameter(annotations);
ret.add(tp); annotations = null;
    label_9:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      annotations = Annotations();
      tp = TypeParameter(annotations);
ret.add(tp); annotations = null;
    }
    jj_consume_token(GT);
ret.endAt(token());
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TypeParameter TypeParameter(NodeList<AnnotationExpr> annotations) throws ParseException {SimpleName name;
 NodeList<ClassOrInterfaceType> typeBound  = emptyList();
 JavaToken begin;
    name = SimpleName();
begin=token();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXTENDS:{
      typeBound = TypeBound();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
{if ("" != null) return new TypeParameter(range(begin, token()), name, typeBound, annotations);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<ClassOrInterfaceType> TypeBound() throws ParseException {NodeList<ClassOrInterfaceType> ret = emptyList();
 ClassOrInterfaceType cit;
    jj_consume_token(EXTENDS);
    cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    label_10:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BIT_AND:{
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_10;
      }
      jj_consume_token(BIT_AND);
      cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<BodyDeclaration<?>> ClassOrInterfaceBody() throws ParseException {NodeList<BodyDeclaration<?>> ret = emptyList();
 BodyDeclaration member;
    jj_consume_token(LBRACE);
    label_11:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case LBRACE:
      case SEMICOLON:
      case AT:{
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_11;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case LBRACE:
      case AT:{
        member = ClassOrInterfaceBodyDeclaration();
ret.add(member);
        break;
        }
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public BodyDeclaration<?> ClassOrInterfaceBodyDeclaration() throws ParseException {ModifierHolder modifier;
   BodyDeclaration<?> ret;
    if (jj_2_7(2)) {
      ret = InitializerDeclaration();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case AT:{
        // Just get all the modifiers out of the way. If you want to do
              // more checks, pass the modifiers down to the member
           modifier = Modifiers();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CLASS:
        case INTERFACE:{
          ret = ClassOrInterfaceDeclaration(modifier);
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          if (jj_2_5(2147483647)) {
            ret = EnumDeclaration(modifier);
          } else if (jj_2_6(2147483647)) {
            ret = FieldDeclaration(modifier);
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RULE:{
              ret = RuleDeclaration(modifier);
              break;
              }
            default:
              jj_la1[28] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FieldDeclaration FieldDeclaration(ModifierHolder modifier) throws ParseException {Type partialType;
 NodeList<VariableDeclarator> variables = new NodeList<VariableDeclarator>();
 VariableDeclarator val;
    // Modifiers are already matched in the caller
        partialType = Type(emptyList());
    val = VariableDeclarator(partialType);
variables.add(val);
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      val = VariableDeclarator(partialType);
variables.add(val);
    }
    jj_consume_token(SEMICOLON);
JavaToken begin = orIfInvalid(modifier.begin, partialType);
        {if ("" != null) return new FieldDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, variables);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public VariableDeclarator VariableDeclarator(Type partialType) throws ParseException {Pair<SimpleName, List<ArrayBracketPair>> id;
 Expression init = null;
    id = VariableDeclaratorId();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      init = VariableInitializer();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
{if ("" != null) return new VariableDeclarator(range(id.a, token()), juggleArrayType(partialType, id.b), id.a, init);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Pair<SimpleName, List<ArrayBracketPair>> VariableDeclaratorId() throws ParseException {SimpleName name;
 JavaToken begin;
 ArrayBracketPair arrayBracketPair;
 List<ArrayBracketPair> arrayBracketPairs = new ArrayList(0);
    name = SimpleName();
begin=token();
    label_13:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACKET:
      case AT:{
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_13;
      }
      arrayBracketPair = ArrayBracketPair(Origin.NAME);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
    }
if(storeTokens) {
            name.setTokenRange(name.getTokenRange().get().withEnd(token()));
        }
        {if ("" != null) return new Pair(name, arrayBracketPairs);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression VariableInitializer() throws ParseException {Expression ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACE:{
      ret = ArrayInitializer();
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      if (jj_2_8(1)) {
        ret = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ArrayInitializerExpr ArrayInitializer() throws ParseException {NodeList<Expression> values = emptyList();
 Expression val;
 JavaToken begin;
    jj_consume_token(LBRACE);
begin=token();
    if (jj_2_10(1)) {
      val = VariableInitializer();
values = add(values, val);
      label_14:
      while (true) {
        if (jj_2_9(2)) {
        } else {
          break label_14;
        }
        jj_consume_token(COMMA);
        val = VariableInitializer();
values = add(values, val);
      }
    } else {
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new ArrayInitializerExpr(range(begin, token()), values);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReferenceType AnnotatedReferenceType() throws ParseException {NodeList<AnnotationExpr> annotations;
 ReferenceType type;
    annotations = Annotations();
    type = ReferenceType(annotations);
{if ("" != null) return type;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Type AnnotatedType() throws ParseException {NodeList<AnnotationExpr> annotations;
 Type type;
    annotations = Annotations();
    type = Type(annotations);
{if ("" != null) return type;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Pair<NodeList<Parameter>, ReceiverParameter> Parameters() throws ParseException {NodeList<Parameter> ret = emptyList();
 Parameter par;
 ReceiverParameter rp = null;
    jj_consume_token(LPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case _DEFAULT:
    case DOUBLE:
    case ENUM:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case STRICTFP:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:{
      if (jj_2_11(2147483647)) {
        rp = ReceiverParameter();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case AT:{
          par = Parameter();
ret = add(ret, par);
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_15:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[36] = jj_gen;
          break label_15;
        }
        jj_consume_token(COMMA);
        par = Parameter();
ret = add(ret, par);
      }
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return new Pair(ret, rp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Parameter> LambdaParameters() throws ParseException {NodeList<Parameter> ret = null;
  Parameter par;
    par = Parameter();
ret = add(ret, par);
    label_16:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        break label_16;
      }
      jj_consume_token(COMMA);
      par = Parameter();
ret = add(ret, par);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Parameter> InferredLambdaParameters() throws ParseException {NodeList<Parameter> ret = null;
    Pair<SimpleName, List<ArrayBracketPair>> id;
    id = VariableDeclaratorId();
ret = add(ret, new Parameter(range(id.a, id.a), new NodeList<Modifier>(), emptyList(), new UnknownType(), false, emptyList(), id.a));
    label_17:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      id = VariableDeclaratorId();
ret = add(ret, new Parameter(range(id.a, id.a), new NodeList<Modifier>(), emptyList(), new UnknownType(), false, emptyList(), id.a));
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Parameter Parameter() throws ParseException {ModifierHolder modifier;
 Type partialType;
 boolean isVarArg = false;
 Pair<SimpleName, List<ArrayBracketPair>> id;
 NodeList<AnnotationExpr> varArgAnnotations = emptyList();
    modifier = Modifiers();
    partialType = Type(emptyList());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AT:
    case ELLIPSIS:{
      varArgAnnotations = Annotations();
      jj_consume_token(ELLIPSIS);
isVarArg = true;
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
    id = VariableDeclaratorId();
JavaToken begin = orIfInvalid(modifier.begin, partialType);
        {if ("" != null) return new Parameter(range(begin, token()), modifier.modifiers, modifier.annotations, juggleArrayType(partialType, id.b), isVarArg, varArgAnnotations, id.a);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReceiverParameter ReceiverParameter() throws ParseException {Type partialType;
 Name id;
 NodeList<AnnotationExpr> annotations = emptyList();
    annotations = Annotations();
    partialType = Type(emptyList());
    id = ReceiverParameterId();
{if ("" != null) return new ReceiverParameter(range(partialType, token()), annotations, partialType, id);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Name ReceiverParameterId() throws ParseException {Name ret = null;
    if (jj_2_12(2147483647)) {
      ret = Name();
      jj_consume_token(DOT);
    } else {
      ;
    }
    jj_consume_token(THIS);
{if ("" != null) return new Name(tokenRange(), ret, token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExplicitConstructorInvocationStmt ExplicitConstructorInvocation() throws ParseException {boolean isThis = false;
 NodeList<Expression> args;
 Expression expr = null;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
 JavaToken begin = INVALID;
    if (jj_2_14(2147483647)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:{
        typeArgs = TypeArguments();
begin=typeArgs.range.getBegin();
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      jj_consume_token(THIS);
begin = orIfInvalid(begin, token()); isThis = true;
      args = Arguments();
      jj_consume_token(SEMICOLON);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case LT:{
        if (jj_2_13(2147483647)) {
          expr = PrimaryExpressionWithoutSuperSuffix();
          jj_consume_token(DOT);
begin = orIfInvalid(begin, expr);
        } else {
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
begin = orIfInvalid(begin, typeArgs.range.getBegin());
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          ;
        }
        jj_consume_token(SUPER);
begin = orIfInvalid(begin, token());
        args = Arguments();
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return new ExplicitConstructorInvocationStmt(range(begin, token()),typeArgs.list, isThis, expr, args);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Statement> Statements() throws ParseException {NodeList<Statement> ret = emptyList();
 Statement stmt;
    label_18:
    while (true) {
      if (jj_2_15(2)) {
      } else {
        break label_18;
      }
      stmt = BlockStatement();
ret = add(ret, stmt);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public InitializerDeclaration InitializerDeclaration() throws ParseException {BlockStmt body;
 JavaToken begin = INVALID;
 boolean isStatic = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STATIC:{
      jj_consume_token(STATIC);
isStatic = true; begin=token();
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    body = Block();
begin = orIfInvalid(begin, body);
{if ("" != null) return new InitializerDeclaration(range(begin, token()), isStatic, body);}
    throw new IllegalStateException ("Missing return statement in function");
}

/*
 * Type, name and expression syntax follows.
 */
  final public 
Type Type(NodeList<AnnotationExpr> annotations) throws ParseException {Type ret;
    if (jj_2_16(2)) {
      ret = ReferenceType(annotations);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:{
        ret = PrimitiveType(annotations);
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReferenceType ReferenceType(NodeList<AnnotationExpr> annotations) throws ParseException {Type type;
 ArrayBracketPair arrayBracketPair;
 List<ArrayBracketPair> arrayBracketPairs = new ArrayList(0);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:{
      type = PrimitiveType(annotations);
      label_19:
      while (true) {
        arrayBracketPair = ArrayBracketPair(Origin.TYPE);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
        if (jj_2_17(2147483647)) {
        } else {
          break label_19;
        }
      }
      break;
      }
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      type = ClassOrInterfaceType(annotations);
      label_20:
      while (true) {
        if (jj_2_18(2147483647)) {
        } else {
          break label_20;
        }
        arrayBracketPair = ArrayBracketPair(Origin.TYPE);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
      }
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return (ReferenceType)wrapInArrayTypes(type, arrayBracketPairs);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ArrayBracketPair ArrayBracketPair(Origin origin) throws ParseException {NodeList<AnnotationExpr> annotations;
    JavaToken begin = INVALID;
    annotations = Annotations();
    jj_consume_token(LBRACKET);
begin = orIfInvalid(begin, token());
    jj_consume_token(RBRACKET);
{if ("" != null) return new ArrayBracketPair(range(begin, token()), origin, annotations);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public IntersectionType IntersectionType(NodeList<AnnotationExpr> annotations) throws ParseException {JavaToken begin = INVALID;
 ReferenceType elementType;
 NodeList<ReferenceType> elements = emptyList();
    elementType = ReferenceType(annotations);
begin = orIfInvalid(begin, elementType); elements = add(elements, elementType);
    jj_consume_token(BIT_AND);
    label_21:
    while (true) {
      elementType = AnnotatedReferenceType();
elements = add(elements, elementType);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case AT:{
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        break label_21;
      }
    }
{if ("" != null) return new IntersectionType(range(begin, token()), elements);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ClassOrInterfaceType AnnotatedClassOrInterfaceType() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
 ClassOrInterfaceType cit;
    annotations = Annotations();
    cit = ClassOrInterfaceType(annotations);
{if ("" != null) return cit;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ClassOrInterfaceType ClassOrInterfaceType(NodeList<AnnotationExpr> firstAnnotations) throws ParseException {ClassOrInterfaceType ret;
 SimpleName name;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
 JavaToken begin;
 NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    name = SimpleName();
begin=token();
    if (jj_2_19(2)) {
      typeArgs = TypeArguments();
    } else {
      ;
    }
ret = new ClassOrInterfaceType(range(begin, token()), null, name, typeArgs.list, firstAnnotations);
      typeArgs = new RangedList<Type>(null);
    label_22:
    while (true) {
      if (jj_2_20(2)) {
      } else {
        break label_22;
      }
      jj_consume_token(DOT);
      annotations = Annotations();
      name = SimpleName();
      if (jj_2_21(2)) {
        typeArgs = TypeArguments();
      } else {
        ;
      }
ret = new ClassOrInterfaceType(range(begin, token()), ret, name, typeArgs.list, annotations);
        typeArgs = new RangedList<Type>(null);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RangedList<Type> TypeArguments() throws ParseException {RangedList<Type> ret = new RangedList<Type>(new NodeList<Type>());
 Type type;
    jj_consume_token(LT);
ret.beginAt(token());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:
    case HOOK:{
      type = TypeArgument();
ret.add(type);
      label_23:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          break label_23;
        }
        jj_consume_token(COMMA);
        type = TypeArgument();
ret.add(type);
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    jj_consume_token(GT);
ret.endAt(token());
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Type TypeArgument() throws ParseException {Type ret;
 NodeList<AnnotationExpr> annotations;
    annotations = Annotations();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      ret = Type(annotations);
      break;
      }
    case HOOK:{
      ret = Wildcard(annotations);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public WildcardType Wildcard(NodeList<AnnotationExpr> firstAnnotations) throws ParseException {ReferenceType ext = null;
 ReferenceType sup = null;
 JavaToken begin;
 NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    jj_consume_token(HOOK);
begin=token();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXTENDS:
    case SUPER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EXTENDS:{
        jj_consume_token(EXTENDS);
        annotations = Annotations();
        ext = ReferenceType(annotations);
        break;
        }
      case SUPER:{
        jj_consume_token(SUPER);
        annotations = Annotations();
        sup = ReferenceType(annotations);
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
{if ("" != null) return new WildcardType(range(begin, token()), ext, sup, firstAnnotations);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PrimitiveType PrimitiveType(NodeList<AnnotationExpr> annotations) throws ParseException {PrimitiveType ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.BOOLEAN, annotations);
      break;
      }
    case CHAR:{
      jj_consume_token(CHAR);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.CHAR, annotations);
      break;
      }
    case BYTE:{
      jj_consume_token(BYTE);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.BYTE, annotations);
      break;
      }
    case SHORT:{
      jj_consume_token(SHORT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.SHORT, annotations);
      break;
      }
    case INT:{
      jj_consume_token(INT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.INT, annotations);
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.LONG, annotations);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.FLOAT, annotations);
      break;
      }
    case DOUBLE:{
      jj_consume_token(DOUBLE);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.DOUBLE, annotations);
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Type ResultType(NodeList<AnnotationExpr> annotations) throws ParseException {Type ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case VOID:{
      jj_consume_token(VOID);
ret = new VoidType(tokenRange());
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      ret = Type(annotations);
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Name Name() throws ParseException {Name ret;
    Identifier();
ret = new Name(tokenRange(), null, token.image);
    label_24:
    while (true) {
      if (jj_2_22(2)) {
      } else {
        break label_24;
      }
      jj_consume_token(DOT);
      Identifier();
ret = new Name(range(ret, token()), ret, token.image);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleName SimpleName() throws ParseException {SimpleName ret;
    Identifier();
ret = new SimpleName(tokenRange(), token.image);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String Identifier() throws ParseException {String ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case RULE:{
      jj_consume_token(RULE);
      break;
      }
    case MODULE:{
      jj_consume_token(MODULE);
      break;
      }
    case REQUIRES:{
      jj_consume_token(REQUIRES);
      break;
      }
    case TO:{
      jj_consume_token(TO);
      break;
      }
    case OPEN:{
      jj_consume_token(OPEN);
      break;
      }
    case OPENS:{
      jj_consume_token(OPENS);
      break;
      }
    case USES:{
      jj_consume_token(USES);
      break;
      }
    case EXPORTS:{
      jj_consume_token(EXPORTS);
      break;
      }
    case PROVIDES:{
      jj_consume_token(PROVIDES);
      break;
      }
    case TRANSITIVE:{
      jj_consume_token(TRANSITIVE);
      break;
      }
    case ENUM:{
      jj_consume_token(ENUM);
      break;
      }
    case STRICTFP:{
      jj_consume_token(STRICTFP);
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret = token.image; setTokenKind(IDENTIFIER);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

/*
 * Expression syntax follows.
 */
  final public 
Expression Expression() throws ParseException {Expression ret;
 AssignExpr.Operator op;
 Expression value;
 Statement lambdaBody = null;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
    ret = ConditionalExpression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASSIGN:
    case PLUSASSIGN:
    case MINUSASSIGN:
    case STARASSIGN:
    case SLASHASSIGN:
    case ANDASSIGN:
    case ORASSIGN:
    case XORASSIGN:
    case REMASSIGN:
    case LSHIFTASSIGN:
    case RSIGNEDSHIFTASSIGN:
    case RUNSIGNEDSHIFTASSIGN:
    case ARROW:
    case DOUBLECOLON:{
      if (jj_2_23(2)) {
        op = AssignmentOperator();
        value = Expression();
ret = new AssignExpr(range(ret, token()), ret, value, op);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ARROW:{
          jj_consume_token(ARROW);
          lambdaBody = LambdaBody();
if (ret instanceof CastExpr) {
                    ret = generateLambda(ret, lambdaBody);
                } else if (ret instanceof ConditionalExpr) {
                    ConditionalExpr ce = (ConditionalExpr) ret;
                    if(ce.getElseExpr() != null) {
                        ce.setElseExpr(generateLambda(ce.getElseExpr(), lambdaBody));
                    }
                } else {
                    ret = generateLambda(ret, lambdaBody);
                }
          break;
          }
        case DOUBLECOLON:{
          jj_consume_token(DOUBLECOLON);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[56] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ENUM:
          case STRICTFP:
          case REQUIRES:
          case TO:
          case OPEN:
          case OPENS:
          case USES:
          case MODULE:
          case EXPORTS:
          case PROVIDES:
          case TRANSITIVE:
          case RULE:
          case IDENTIFIER:{
            Identifier();
            break;
            }
          case NEW:{
            jj_consume_token(NEW);
            break;
            }
          default:
            jj_la1[57] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ret = new MethodReferenceExpr(range(ret, token()), ret, typeArgs.list, token.image);
          break;
          }
        default:
          jj_la1[58] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AssignExpr.Operator AssignmentOperator() throws ParseException {AssignExpr.Operator ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
ret = AssignExpr.Operator.ASSIGN;
      break;
      }
    case STARASSIGN:{
      jj_consume_token(STARASSIGN);
ret = AssignExpr.Operator.MULTIPLY;
      break;
      }
    case SLASHASSIGN:{
      jj_consume_token(SLASHASSIGN);
ret = AssignExpr.Operator.DIVIDE;
      break;
      }
    case REMASSIGN:{
      jj_consume_token(REMASSIGN);
ret = AssignExpr.Operator.REMAINDER;
      break;
      }
    case PLUSASSIGN:{
      jj_consume_token(PLUSASSIGN);
ret = AssignExpr.Operator.PLUS;
      break;
      }
    case MINUSASSIGN:{
      jj_consume_token(MINUSASSIGN);
ret = AssignExpr.Operator.MINUS;
      break;
      }
    case LSHIFTASSIGN:{
      jj_consume_token(LSHIFTASSIGN);
ret = AssignExpr.Operator.LEFT_SHIFT;
      break;
      }
    case RSIGNEDSHIFTASSIGN:{
      jj_consume_token(RSIGNEDSHIFTASSIGN);
ret = AssignExpr.Operator.SIGNED_RIGHT_SHIFT;
      break;
      }
    case RUNSIGNEDSHIFTASSIGN:{
      jj_consume_token(RUNSIGNEDSHIFTASSIGN);
ret = AssignExpr.Operator.UNSIGNED_RIGHT_SHIFT;
      break;
      }
    case ANDASSIGN:{
      jj_consume_token(ANDASSIGN);
ret = AssignExpr.Operator.BINARY_AND;
      break;
      }
    case XORASSIGN:{
      jj_consume_token(XORASSIGN);
ret = AssignExpr.Operator.XOR;
      break;
      }
    case ORASSIGN:{
      jj_consume_token(ORASSIGN);
ret = AssignExpr.Operator.BINARY_OR;
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ConditionalExpression() throws ParseException {Expression ret;
 Expression left;
 Expression right;
    ret = ConditionalOrExpression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case HOOK:{
      jj_consume_token(HOOK);
      left = Expression();
      jj_consume_token(COLON);
      right = ConditionalExpression();
ret = new ConditionalExpr(range(ret, token()), ret, left, right);
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ConditionalOrExpression() throws ParseException {Expression ret;
 Expression right;
    ret = ConditionalAndExpression();
    label_25:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SC_OR:{
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_25;
      }
      jj_consume_token(SC_OR);
      right = ConditionalAndExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.OR);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ConditionalAndExpression() throws ParseException {Expression ret;
 Expression right;
    ret = InclusiveOrExpression();
    label_26:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SC_AND:{
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        break label_26;
      }
      jj_consume_token(SC_AND);
      right = InclusiveOrExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.AND);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression InclusiveOrExpression() throws ParseException {Expression ret;
 Expression right;
    ret = ExclusiveOrExpression();
    label_27:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BIT_OR:{
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        break label_27;
      }
      jj_consume_token(BIT_OR);
      right = ExclusiveOrExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.BINARY_OR);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ExclusiveOrExpression() throws ParseException {Expression ret;
 Expression right;
    ret = AndExpression();
    label_28:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case XOR:{
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        break label_28;
      }
      jj_consume_token(XOR);
      right = AndExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.XOR);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression AndExpression() throws ParseException {Expression ret;
 Expression right;
    ret = EqualityExpression();
    label_29:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BIT_AND:{
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        break label_29;
      }
      jj_consume_token(BIT_AND);
      right = EqualityExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.BINARY_AND);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression EqualityExpression() throws ParseException {Expression ret;
 Expression right;
 BinaryExpr.Operator op;
    ret = InstanceOfExpression();
    label_30:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:
      case NE:{
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        break label_30;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
op = BinaryExpr.Operator.EQUALS;
        break;
        }
      case NE:{
        jj_consume_token(NE);
op = BinaryExpr.Operator.NOT_EQUALS;
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = InstanceOfExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression InstanceOfExpression() throws ParseException {Expression ret;
 ReferenceType type;
 NodeList<AnnotationExpr> annotations;
    ret = RelationalExpression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INSTANCEOF:{
      jj_consume_token(INSTANCEOF);
      type = AnnotatedReferenceType();
ret = new InstanceOfExpr(range(ret, token()), ret, type);
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression RelationalExpression() throws ParseException {Expression ret;
 Expression right;
 BinaryExpr.Operator op;
    ret = ShiftExpression();
    label_31:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case LE:
      case GE:
      case GT:{
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        break label_31;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:{
        jj_consume_token(LT);
op = BinaryExpr.Operator.LESS;
        break;
        }
      case GT:{
        jj_consume_token(GT);
op = BinaryExpr.Operator.GREATER;
        break;
        }
      case LE:{
        jj_consume_token(LE);
op = BinaryExpr.Operator.LESS_EQUALS;
        break;
        }
      case GE:{
        jj_consume_token(GE);
op = BinaryExpr.Operator.GREATER_EQUALS;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = ShiftExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ShiftExpression() throws ParseException {Expression ret;
 Expression right;
 BinaryExpr.Operator op;
    ret = AdditiveExpression();
    label_32:
    while (true) {
      if (jj_2_24(1)) {
      } else {
        break label_32;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LSHIFT:{
        jj_consume_token(LSHIFT);
op = BinaryExpr.Operator.LEFT_SHIFT;
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        if (jj_2_25(1)) {
          RSIGNEDSHIFT();
op = BinaryExpr.Operator.SIGNED_RIGHT_SHIFT;
        } else if (jj_2_26(1)) {
          RUNSIGNEDSHIFT();
op = BinaryExpr.Operator.UNSIGNED_RIGHT_SHIFT;
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      right = AdditiveExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression AdditiveExpression() throws ParseException {Expression ret;
 Expression right;
 BinaryExpr.Operator op;
    ret = MultiplicativeExpression();
    label_33:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:
      case MINUS:{
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        break label_33;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = BinaryExpr.Operator.PLUS;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = BinaryExpr.Operator.MINUS;
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression ret;
 Expression right;
 BinaryExpr.Operator op;
    ret = UnaryExpression();
    label_34:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STAR:
      case SLASH:
      case REM:{
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        break label_34;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
op = BinaryExpr.Operator.MULTIPLY;
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
op = BinaryExpr.Operator.DIVIDE;
        break;
        }
      case REM:{
        jj_consume_token(REM);
op = BinaryExpr.Operator.REMAINDER;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression UnaryExpression() throws ParseException {Expression ret;
 UnaryExpr.Operator op;
 JavaToken begin = INVALID;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INCR:{
      ret = PreIncrementExpression();
      break;
      }
    case DECR:{
      ret = PreDecrementExpression();
      break;
      }
    case PLUS:
    case MINUS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = UnaryExpr.Operator.PLUS; begin=token();
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = UnaryExpr.Operator.MINUS; begin=token();
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, op);
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      if (jj_2_27(1)) {
        ret = HalfBinaryExpression();
      } else if (jj_2_28(2147483647)) {
        ret = MapCreationLiteralExpression();
      } else if (jj_2_29(2147483647)) {
        ret = ListCreationLiteralExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PreIncrementExpression() throws ParseException {Expression ret;
 JavaToken begin = INVALID;
    jj_consume_token(INCR);
begin=token();
    ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, UnaryExpr.Operator.PREFIX_INCREMENT);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PreDecrementExpression() throws ParseException {Expression ret;
 JavaToken begin;
    jj_consume_token(DECR);
begin=token();
    ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, UnaryExpr.Operator.PREFIX_DECREMENT);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

// mvel start
  final public Expression HalfBinaryExpression() throws ParseException {Expression ret;
 HalfBinaryExpr.Operator op;
 JavaToken begin = INVALID;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case GT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
op = HalfBinaryExpr.Operator.EQUALS; begin=token();
        break;
        }
      case NE:{
        jj_consume_token(NE);
op = HalfBinaryExpr.Operator.NOT_EQUALS; begin=token();
        break;
        }
      case LT:{
        jj_consume_token(LT);
op = HalfBinaryExpr.Operator.LESS; begin=token();
        break;
        }
      case GT:{
        jj_consume_token(GT);
op = HalfBinaryExpr.Operator.GREATER; begin=token();
        break;
        }
      case LE:{
        jj_consume_token(LE);
op = HalfBinaryExpr.Operator.LESS_EQUALS; begin=token();
        break;
        }
      case GE:{
        jj_consume_token(GE);
op = HalfBinaryExpr.Operator.GREATER_EQUALS; begin=token();
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_30(2147483647)) {
        ret = HalfBinaryExpression();
      } else if (jj_2_31(1)) {
        ret = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
ret = new HalfBinaryExpr(range(begin, token()), ret, op);
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      if (jj_2_32(1)) {
        ret = DrlxExpressionSwitch();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression DrlxExpressionSwitch() throws ParseException {Expression ret;
    if (jj_2_33(2147483647)) {
      ret = PointFreeExprMvel();
    } else if (jj_2_34(2147483647)) {
      ret = HalfPointFreeExprMvel();
    } else if (jj_2_35(2147483647)) {
      ret = PointFreeExpr();
    } else if (jj_2_36(2147483647) && ((isPointFreeOperator(getToken(1).image) || isPointFreeOperator(getToken(2).image) ))) {
      ret = HalfPointFreeExpr();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case SWITCH:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case BANG:
      case TILDE:{
        ret = UnaryExpressionNotPlusMinus();
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

// drlcontraintparser end
  final public 
Expression UnaryExpressionNotPlusMinus() throws ParseException {Expression ret;
 UnaryExpr.Operator op;
 JavaToken begin = INVALID;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BANG:
    case TILDE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TILDE:{
        jj_consume_token(TILDE);
op = UnaryExpr.Operator.BITWISE_COMPLEMENT; begin=token();
        break;
        }
      case BANG:{
        jj_consume_token(BANG);
op = UnaryExpr.Operator.LOGICAL_COMPLEMENT;     begin=token();
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, op);
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      if (jj_2_37(2147483647)) {
        ret = CastExpression();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case STRICTFP:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case DOT_DOT_SLASH:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case BIG_INTEGER_LITERAL:
        case BIG_DECIMAL_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case AT:{
          ret = PostfixExpression();
          break;
          }
        case SWITCH:{
          ret = SwitchExpression();
          break;
          }
        default:
          jj_la1[84] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PostfixExpression() throws ParseException {Expression ret;
 UnaryExpr.Operator op;
    ret = PrimaryExpression();
    if (jj_2_38(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INCR:{
        jj_consume_token(INCR);
op = UnaryExpr.Operator.POSTFIX_INCREMENT;
        break;
        }
      case DECR:{
        jj_consume_token(DECR);
op = UnaryExpr.Operator.POSTFIX_DECREMENT;
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
ret = new UnaryExpr(range(ret, token()), ret, op);
    } else {
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression CastExpression() throws ParseException {Expression ret;
 ReferenceType referenceType;
 PrimitiveType primitiveType;
 JavaToken begin = INVALID;
 NodeList<AnnotationExpr> annotations;
 NodeList<ReferenceType> typesOfMultiCast = emptyList();
    jj_consume_token(LPAREN);
begin=token();
    annotations = Annotations();
    if (jj_2_39(2)) {
      primitiveType = PrimitiveType(annotations);
      jj_consume_token(RPAREN);
      ret = UnaryExpression();
ret = new CastExpr(range(begin, token()), primitiveType, ret);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        referenceType = ReferenceType(annotations);
typesOfMultiCast = add(typesOfMultiCast, referenceType);
        label_35:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case BIT_AND:{
            break;
            }
          default:
            jj_la1[86] = jj_gen;
            break label_35;
          }
          jj_consume_token(BIT_AND);
          referenceType = AnnotatedReferenceType();
typesOfMultiCast = add(typesOfMultiCast, referenceType);
        }
        jj_consume_token(RPAREN);
        ret = UnaryExpressionNotPlusMinus();
if (typesOfMultiCast.size() > 1) {
           ret = new CastExpr(range(begin, token()), new IntersectionType(range(typesOfMultiCast.get(0), typesOfMultiCast.get(typesOfMultiCast.size() -1)), typesOfMultiCast), ret);
       } else {
           ret = new CastExpr(range(begin, token()), referenceType, ret);
       }
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PrimaryExpression() throws ParseException {Expression ret;
    ret = PrimaryPrefix();
    label_36:
    while (true) {
      if (jj_2_40(2)) {
      } else {
        break label_36;
      }
      ret = PrimarySuffix(ret);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PrimaryExpressionWithoutSuperSuffix() throws ParseException {Expression ret;
    ret = PrimaryPrefix();
    label_37:
    while (true) {
      if (jj_2_41(2147483647)) {
      } else {
        break label_37;
      }
      ret = PrimarySuffixWithoutSuper(ret);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PrimaryPrefix() throws ParseException {Expression ret = null;
 SimpleName name = null;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
 NodeList<Expression> args = emptyList();
 NodeList<Parameter> params = emptyList();
 boolean hasArgs = false;
 boolean isLambda = false;
 Type type;
 JavaToken begin;
 Parameter p = null;
 SimpleName id = null;
 int numberOfBackReferences = 0;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:{
      ret = Literal();
      break;
      }
    case THIS:{
      jj_consume_token(THIS);
ret = new ThisExpr(tokenRange(), null);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        args = Arguments();
hasArgs=true;
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        ;
      }
if (hasArgs) {
      ret = parseThisExprOrHalfBinary(range(ret, token()), (ThisExpr) ret, args);
   }
      break;
      }
    case SUPER:{
      jj_consume_token(SUPER);
ret = new SuperExpr(tokenRange(), null);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[89] = jj_gen;
          ;
        }
        name = SimpleName();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          args = Arguments();
hasArgs=true;
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          ;
        }
if (hasArgs) {
      ret = new MethodCallExpr(range(ret, token()), ret, typeArgs.list, name, args);
   } else {
      ret = new FieldAccessExpr(range(ret, token()), ret, emptyList(), name);
   }
        break;
        }
      case DOUBLECOLON:{
        jj_consume_token(DOUBLECOLON);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ENUM:
        case STRICTFP:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:{
          Identifier();
          break;
          }
        case NEW:{
          jj_consume_token(NEW);
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret = new MethodReferenceExpr(range(ret, token()), ret, typeArgs.list, token.image);
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
begin=token();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RPAREN:{
        jj_consume_token(RPAREN);
ret = new LambdaExpr(range(begin, token()), params, new BlockStmt(), true);
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        if (jj_2_42(2147483647)) {
          ret = Expression();
          jj_consume_token(RPAREN);
ret = new EnclosedExpr(range(begin, token()), ret);
        } else if (jj_2_43(2147483647)) {
          params = LambdaParameters();
          jj_consume_token(RPAREN);
ret = new LambdaExpr(range(begin, token()), params, new BlockStmt(), true);
        } else if (jj_2_44(2147483647)) {
          params = InferredLambdaParameters();
          jj_consume_token(RPAREN);
ret = new LambdaExpr(range(begin, token()), params, new BlockStmt(), true);
        } else if (jj_2_45(2147483647)) {
          name = SimpleName();
          jj_consume_token(COLON);
          ret = Expression();
          jj_consume_token(RPAREN);
ret = new DrlxExpression(name, ret); ret = new EnclosedExpr(range(begin, token()), ret);
        } else if (jj_2_46(1)) {
          // This could still be a lambda expression, but this is handled after matching -> elsewhere
                      ret = Expression();
          jj_consume_token(RPAREN);
ret = new EnclosedExpr(range(begin, token()), ret);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case NEW:{
      ret = AllocationExpression(null);
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      if (jj_2_47(2147483647)) {
        type = ResultType(emptyList());
        jj_consume_token(DOT);
        jj_consume_token(CLASS);
ret = new ClassExpr(range(type, token()), type);
      } else if (jj_2_48(2147483647)) {
        type = AnnotatedType();
        jj_consume_token(DOUBLECOLON);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ENUM:
        case STRICTFP:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:{
          Identifier();
          break;
          }
        case NEW:{
          jj_consume_token(NEW);
          break;
          }
        default:
          jj_la1[96] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret = new TypeExpr(range(type, type), type);
    ret = new MethodReferenceExpr(range(ret, token()), ret, typeArgs.list, token.image);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ENUM:
        case STRICTFP:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case DOT_DOT_SLASH:
        case IDENTIFIER:{
          label_38:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DOT_DOT_SLASH:{
              break;
              }
            default:
              jj_la1[97] = jj_gen;
              break label_38;
            }
            jj_consume_token(DOT_DOT_SLASH);
numberOfBackReferences++;
          }
          name = SimpleName();
begin=token();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[98] = jj_gen;
            ;
          }
if (hasArgs) {
      ret = parseMethodExprOrHalfBinary(range(begin, token()), name, args);
   } else {
      ret = new DrlNameExpr(name, numberOfBackReferences );
   }
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PrimarySuffix(Expression scope) throws ParseException {Expression ret;
    if (jj_2_49(2)) {
      ret = PrimarySuffixWithoutSuper(scope);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        jj_consume_token(SUPER);
ret = new SuperExpr(range(scope, token()), scope);
        break;
        }
      default:
        jj_la1[101] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PrimarySuffixWithoutSuper(Expression scope) throws ParseException {Expression ret;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
 NodeList<Expression> args = emptyList();
 boolean hasArgs = false;
 SimpleName name;
 Name fqname;
 Type type;
 NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case THIS:{
        jj_consume_token(THIS);
ret = new ThisExpr(range(scope, token()), scope);
        break;
        }
      case NEW:{
        ret = AllocationExpression(scope);
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        if (jj_2_50(2147483647)) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[102] = jj_gen;
            ;
          }
          name = SimpleName();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[103] = jj_gen;
            ;
          }
if (hasArgs) {
      ret = parseMethodExprOrHalfBinary(range(scope, token()), scope, typeArgs.list, name, args, false);
   } else {
      ret = new FieldAccessExpr(range(scope, token()), scope, typeArgs.list, name);
   }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      ret = Expression();
      jj_consume_token(RBRACKET);
ret = new ArrayAccessExpr(range(scope, token()), scope, ret);
      break;
      }
    case HASHMARK:{
      jj_consume_token(HASHMARK);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        fqname = Name();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          args = Arguments();
hasArgs=true;
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          ;
        }
if (hasArgs) {
      ret = new FullyQualifiedInlineCastExpr(range(scope, token()), scope, fqname, args);
   } else {
      ret = new FullyQualifiedInlineCastExpr(range(scope, token()), scope, fqname);
   }
        break;
        }
      case LPAREN:{
        jj_consume_token(LPAREN);
        type = Type(emptyList());
        jj_consume_token(RPAREN);
ret = new InlineCastExpr(range(scope, token()), type, scope);
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case EXCL_DOT:{
      jj_consume_token(EXCL_DOT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case THIS:{
        jj_consume_token(THIS);
ret = new ThisExpr(range(scope.getTokenRange().get().getBegin(), token()), scope);
        break;
        }
      case NEW:{
        ret = AllocationExpression(scope);
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        if (jj_2_51(2147483647)) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[107] = jj_gen;
            ;
          }
          name = SimpleName();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[108] = jj_gen;
            ;
          }
if (hasArgs) {
                ret = parseMethodExprOrHalfBinary(range(scope.getTokenRange().get().getBegin(), token()), scope, typeArgs.list, name, args, true);
            } else {
                ret = new NullSafeFieldAccessExpr(range(scope.getTokenRange().get().getBegin(), token()), scope, typeArgs.list, name);
            }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression Literal() throws ParseException {Expression ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INTEGER_LITERAL:{
      jj_consume_token(INTEGER_LITERAL);
ret = new IntegerLiteralExpr(tokenRange(), token.image);
      break;
      }
    case LONG_LITERAL:{
      jj_consume_token(LONG_LITERAL);
ret = new LongLiteralExpr(tokenRange(), token.image);
      break;
      }
    case BIG_DECIMAL_LITERAL:{
      jj_consume_token(BIG_DECIMAL_LITERAL);
ret = new BigDecimalLiteralExpr(tokenRange(), token.image);
      break;
      }
    case BIG_INTEGER_LITERAL:{
      jj_consume_token(BIG_INTEGER_LITERAL);
ret = new BigIntegerLiteralExpr(tokenRange(), token.image);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      jj_consume_token(FLOATING_POINT_LITERAL);
ret = new DoubleLiteralExpr(tokenRange(), token.image);
      break;
      }
    case CHARACTER_LITERAL:{
      jj_consume_token(CHARACTER_LITERAL);
ret = new CharLiteralExpr(tokenRange(), token.image.substring(1, token.image.length()-1));
      break;
      }
    case STRING_LITERAL:{
      jj_consume_token(STRING_LITERAL);
ret = new StringLiteralExpr(tokenRange(), token.image.substring(1, token.image.length()-1));
      break;
      }
    case FALSE:
    case TRUE:{
      ret = BooleanLiteral();
      break;
      }
    case NULL:{
      ret = NullLiteral();
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression BooleanLiteral() throws ParseException {Expression ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
ret = new BooleanLiteralExpr(tokenRange(), true);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
ret = new BooleanLiteralExpr(tokenRange(), false);
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression NullLiteral() throws ParseException {
    jj_consume_token(NULL);
{if ("" != null) return new NullLiteralExpr(tokenRange());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> Arguments() throws ParseException {NodeList<Expression> ret = emptyList();
    jj_consume_token(LPAREN);
    if (jj_2_52(1)) {
      ret = ArgumentList();
    } else {
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> ArgumentList() throws ParseException {NodeList<Expression> ret = emptyList();
 Expression expr;
    expr = Expression();
ret.add(expr);
    label_39:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        break label_39;
      }
      jj_consume_token(COMMA);
      expr = Expression();
ret.add(expr);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression AllocationExpression(Expression scope) throws ParseException {Expression ret;
 Type type;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
 NodeList<BodyDeclaration<?>> anonymousBody = null;
 NodeList<Expression> args;
 JavaToken begin = INVALID;
 NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    jj_consume_token(NEW);
if(scope==null) {begin=token();} else {begin = orIfInvalid(begin, scope);}
    annotations = Annotations();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:{
      type = PrimitiveType(annotations);
      ret = ArrayCreation(begin, type);
      break;
      }
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:
    case LT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:{
        typeArgs = TypeArguments();
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        ;
      }
      type = AnnotatedClassOrInterfaceType();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACKET:
      case AT:{
        ret = ArrayCreation(begin, type);
        break;
        }
      case LPAREN:{
        args = Arguments();
        if (jj_2_53(2)) {
          anonymousBody = ClassOrInterfaceBody();
        } else {
          ;
        }
ret = new ObjectCreationExpr(range(begin, token()), scope, (ClassOrInterfaceType) type, typeArgs.list, args, anonymousBody);
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ArrayCreationExpr ArrayCreation(JavaToken begin, Type type) throws ParseException {Expression expr = null;
 ArrayInitializerExpr arrayInitializerExpr = null;
 NodeList<Expression> inits = emptyList();
 List<NodeList<AnnotationExpr>> accum = new ArrayList<NodeList<AnnotationExpr>>();
 NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
 JavaToken arrayCreationLevelStart = INVALID;
 List<TokenRange> levelRanges = new ArrayList<TokenRange>();
    label_40:
    while (true) {
      annotations = Annotations();
      jj_consume_token(LBRACKET);
arrayCreationLevelStart = annotations.isEmpty() ? token() : orIfInvalid(arrayCreationLevelStart, annotations.get(0));
      if (jj_2_54(1)) {
        expr = Expression();
      } else {
        ;
      }
accum = add(accum, annotations); inits = add(inits, expr); annotations=null; expr=null;
      jj_consume_token(RBRACKET);
levelRanges.add(range(arrayCreationLevelStart, token()));
      if (jj_2_55(2)) {
      } else {
        break label_40;
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACE:{
      arrayInitializerExpr = ArrayInitializer();
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      ;
    }
{if ("" != null) return juggleArrayCreation(range(begin, token()), levelRanges, type, inits, accum, arrayInitializerExpr);}
    throw new IllegalStateException ("Missing return statement in function");
}

/*
 * Statement syntax follows.
 */
  final public 
Statement Statement() throws ParseException {Statement ret;
    try {
      if (jj_2_56(2)) {
        ret = LabeledStatement();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ASSERT:{
          ret = AssertStatement();
          break;
          }
        case LBRACE:{
          ret = Block();
          break;
          }
        case SEMICOLON:{
          ret = EmptyStatement();
          break;
          }
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case STRICTFP:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case REQUIRES:
        case TO:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case DOT_DOT_SLASH:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case BIG_INTEGER_LITERAL:
        case BIG_DECIMAL_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case AT:
        case INCR:
        case DECR:{
          ret = StatementExpression();
          break;
          }
        case SWITCH:{
          ret = SwitchStatement();
          break;
          }
        case IF:{
          ret = IfStatement();
          break;
          }
        case WHILE:{
          ret = WhileStatement();
          break;
          }
        case DO:{
          ret = DoStatement();
          break;
          }
        case FOR:{
          ret = ForStatement();
          break;
          }
        case BREAK:{
          ret = BreakStatement();
          break;
          }
        case CONTINUE:{
          ret = ContinueStatement();
          break;
          }
        case RETURN:{
          ret = ReturnStatement();
          break;
          }
        case THROW:{
          ret = ThrowStatement();
          break;
          }
        case SYNCHRONIZED:{
          ret = SynchronizedStatement();
          break;
          }
        case TRY:{
          ret = TryStatement();
          break;
          }
        case MODIFY:{
          ret = ModifyStatement();
          break;
          }
        case WITH:{
          ret = WithStatement();
          break;
          }
        default:
          jj_la1[118] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return ret;}
    } catch (ParseException e) {
TokenRange errorRange = recover(SEMICOLON, e);
        {if ("" != null) return new UnparsableStmt(errorRange);}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AssertStmt AssertStatement() throws ParseException {Expression check;
 Expression msg = null;
 JavaToken begin;
    jj_consume_token(ASSERT);
begin=token();
    check = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      msg = Expression();
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
{if ("" != null) return new AssertStmt(range(begin, token()), check, msg);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LabeledStmt LabeledStatement() throws ParseException {SimpleName label;
 Statement stmt;
 JavaToken begin;
    label = SimpleName();
begin=token();
    jj_consume_token(COLON);
    stmt = Statement();
{if ("" != null) return new LabeledStmt(range(begin, token()), label, stmt);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public BlockStmt Block() throws ParseException {NodeList<Statement> stmts = emptyList();
 JavaToken begin;
 this.enterBlock();
    jj_consume_token(LBRACE);
begin=token();
    try {
      stmts = Statements();
      jj_consume_token(RBRACE);
{if ("" != null) return new BlockStmt(range(begin, token()), stmts);}
    } catch (ParseException e) {
recover(RBRACE, e);
        BlockStmt block = new BlockStmt(range(begin, token()), new NodeList<Statement>());
        block.setParsed(UNPARSABLE);
        {if ("" != null) return block;}
    } finally {
this.leaveBlock();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

/*
 * Classes inside body statements can only be abstract or final. The semantic must check it.
 */
  final public Statement BlockStatement() throws ParseException {Statement ret;
 Expression expr;
 ClassOrInterfaceDeclaration typeDecl;
 ModifierHolder modifier;
    try {
      if (jj_2_57(2147483647)) {
        modifier = Modifiers();
        typeDecl = ClassOrInterfaceDeclaration(modifier);
ret = new LocalClassDeclarationStmt(range(typeDecl, token()), typeDecl);
      } else if (jj_2_58(2147483647)) {
        expr = VariableDeclarationExpression();
        EOS();
ret = new ExpressionStmt(range(expr, token()), expr);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ASSERT:
        case BOOLEAN:
        case BREAK:
        case BYTE:
        case CHAR:
        case CONTINUE:
        case DO:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case FOR:
        case IF:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case RETURN:
        case SHORT:
        case STRICTFP:
        case SUPER:
        case SWITCH:
        case SYNCHRONIZED:
        case THIS:
        case THROW:
        case TRUE:
        case TRY:
        case VOID:
        case WHILE:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case MODIFY:
        case DOT_DOT_SLASH:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case BIG_INTEGER_LITERAL:
        case BIG_DECIMAL_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case LBRACE:
        case SEMICOLON:
        case AT:
        case INCR:
        case DECR:{
          ret = Statement();
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return ret;}
    } catch (ParseException e) {
TokenRange errorRange = recover(SEMICOLON, e);
        {if ("" != null) return new UnparsableStmt(errorRange);}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public VariableDeclarationExpr VariableDeclarationExpression() throws ParseException {ModifierHolder modifier;
 Type partialType;
 NodeList<VariableDeclarator> variables = new NodeList<VariableDeclarator>();
 VariableDeclarator var;
    modifier = Modifiers();
    partialType = Type(emptyList());
    var = VariableDeclarator(partialType);
variables.add(var);
    label_41:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      var = VariableDeclarator(partialType);
variables.add(var);
    }
JavaToken begin=orIfInvalid(modifier.begin, partialType);
        {if ("" != null) return new VariableDeclarationExpr(range(begin, token()), modifier.modifiers, modifier.annotations, variables);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EmptyStmt EmptyStatement() throws ParseException {
    jj_consume_token(SEMICOLON);
{if ("" != null) return new EmptyStmt(tokenRange());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Statement LambdaBody() throws ParseException {Expression expr;
    Statement n = null;
    if (jj_2_59(1)) {
      expr = Expression();
n = new ExpressionStmt(range(expr, token()), expr);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACE:{
        n = Block();
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return n;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionStmt StatementExpression() throws ParseException {Expression expr;
 AssignExpr.Operator op;
 Expression value;
 RangedList<Type> typeArgs = new RangedList<Type>(null);
 Statement lambdaBody;
    if (jj_2_60(2)) {
      expr = PreIncrementExpression();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECR:{
        expr = PreDecrementExpression();
        break;
        }
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:{
        expr = PrimaryExpression();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ASSIGN:
        case INCR:
        case DECR:
        case PLUSASSIGN:
        case MINUSASSIGN:
        case STARASSIGN:
        case SLASHASSIGN:
        case ANDASSIGN:
        case ORASSIGN:
        case XORASSIGN:
        case REMASSIGN:
        case LSHIFTASSIGN:
        case RSIGNEDSHIFTASSIGN:
        case RUNSIGNEDSHIFTASSIGN:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case INCR:{
            jj_consume_token(INCR);
expr = new UnaryExpr(range(expr, token()), expr, UnaryExpr.Operator.POSTFIX_INCREMENT);
            break;
            }
          case DECR:{
            jj_consume_token(DECR);
expr = new UnaryExpr(range(expr, token()), expr, UnaryExpr.Operator.POSTFIX_DECREMENT);
            break;
            }
          case ASSIGN:
          case PLUSASSIGN:
          case MINUSASSIGN:
          case STARASSIGN:
          case SLASHASSIGN:
          case ANDASSIGN:
          case ORASSIGN:
          case XORASSIGN:
          case REMASSIGN:
          case LSHIFTASSIGN:
          case RSIGNEDSHIFTASSIGN:
          case RUNSIGNEDSHIFTASSIGN:{
            op = AssignmentOperator();
            value = Expression();
expr = new AssignExpr(range(expr, token()), expr, value, op);
            break;
            }
          default:
            jj_la1[123] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    EOS();
{if ("" != null) return new ExpressionStmt(range(expr, token()), expr);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SwitchStmt SwitchStatement() throws ParseException {Expression selector;
 SwitchEntry entry;
 NodeList<SwitchEntry> entries = emptyList();
 JavaToken begin;
    jj_consume_token(SWITCH);
begin=token();
    jj_consume_token(LPAREN);
    selector = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_42:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASE:
      case _DEFAULT:{
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        break label_42;
      }
      entry = SwitchEntry();
entries = add(entries, entry);
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new SwitchStmt(range(begin, token()), selector, entries);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SwitchExpr SwitchExpression() throws ParseException {Expression selector;
 SwitchEntry entry;
 NodeList<SwitchEntry> entries = emptyList();
 JavaToken begin;
    jj_consume_token(SWITCH);
begin=token();
    jj_consume_token(LPAREN);
    selector = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_43:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASE:
      case _DEFAULT:{
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_43;
      }
      entry = SwitchEntry();
entries = add(entries, entry);
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new SwitchExpr(range(begin, token()), selector, entries);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SwitchEntry SwitchEntry() throws ParseException {Expression label = null;
 NodeList<Expression> labels = emptyList();
 NodeList<Statement> stmts = emptyList();
 JavaToken begin;
 SwitchEntry ret;
 Expression expression = null;
 Statement stmt = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CASE:{
      jj_consume_token(CASE);
begin=token();
      label = ConditionalExpression();
labels = add(labels, label);
      label_44:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          break label_44;
        }
        jj_consume_token(COMMA);
        label = ConditionalExpression();
labels = add(labels, label);
      }
      break;
      }
    case _DEFAULT:{
      jj_consume_token(_DEFAULT);
begin=token();
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      stmts = Statements();
ret = new SwitchEntry(range(begin, token()), labels, STATEMENT_GROUP, stmts);
      break;
      }
    case ARROW:{
      jj_consume_token(ARROW);
      if (jj_2_61(1)) {
        expression = Expression();
        jj_consume_token(SEMICOLON);
TokenRange r=range(begin, token());
    stmts.add(new ExpressionStmt(r, expression));
    ret = new SwitchEntry(r, labels, EXPRESSION, stmts);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACE:{
          stmt = Block();
TokenRange r=range(begin, token());
    stmts.add(stmt);
    ret = new SwitchEntry(r, labels, BLOCK, stmts);
          break;
          }
        case THROW:{
          stmt = ThrowStatement();
TokenRange r=range(begin, token());
    stmts.add(stmt);
    ret = new SwitchEntry(r, labels, THROWS_STATEMENT, stmts);
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[131] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public IfStmt IfStatement() throws ParseException {Expression condition;
 Statement thenStmt;
 Statement elseStmt = null;
 JavaToken begin;
    jj_consume_token(IF);
begin=token();
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);

    thenStmt = Statement();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);

      elseStmt = Statement();
      break;
      }
    default:
      jj_la1[132] = jj_gen;
      ;
    }
{if ("" != null) return new IfStmt(range(begin, token()), condition, thenStmt, elseStmt);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public WhileStmt WhileStatement() throws ParseException {Expression condition;
 Statement body;
 JavaToken begin;
    jj_consume_token(WHILE);
begin=token();
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    body = Statement();
{if ("" != null) return new WhileStmt(range(begin, token()),condition, body);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DoStmt DoStatement() throws ParseException {Expression condition;
 Statement body;
 JavaToken begin;
    jj_consume_token(DO);
begin=token();
    body = Statement();
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
{if ("" != null) return new DoStmt(range(begin, token()),body, condition);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Statement ForStatement() throws ParseException {VariableDeclarationExpr varExpr = null;
 Expression expr = null;
 NodeList<Expression> init = emptyList();
 NodeList<Expression> update = emptyList();
 Statement body;
 JavaToken begin;
    jj_consume_token(FOR);
begin=token();
    jj_consume_token(LPAREN);
    if (jj_2_65(2147483647)) {
      varExpr = VariableDeclarationExpression();
      jj_consume_token(COLON);
      expr = Expression();
    } else if (jj_2_66(1)) {
      if (jj_2_62(1)) {
        init = ForInit();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      if (jj_2_63(1)) {
        expr = Expression();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      if (jj_2_64(1)) {
        update = ForUpdate();
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
    body = Statement();
if (varExpr != null) {
    {if ("" != null) return new ForEachStmt(range(begin, token()),varExpr, expr, body);}
   }
 {if ("" != null) return new ForStmt(range(begin, token()),init, expr, update, body);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> ForInit() throws ParseException {NodeList<Expression> ret;
 Expression expr;
    if (jj_2_67(2147483647)) {
      expr = VariableDeclarationExpression();
ret = new NodeList<Expression>(); ret.add(expr);
    } else if (jj_2_68(1)) {
      ret = ExpressionList();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> ExpressionList() throws ParseException {NodeList<Expression> ret = new NodeList<Expression>();
 Expression expr;
    expr = Expression();
ret.add(expr);
    label_45:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        break label_45;
      }
      jj_consume_token(COMMA);
      expr = Expression();
ret.add(expr);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> ForUpdate() throws ParseException {NodeList<Expression> ret;
    ret = ExpressionList();
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public BreakStmt BreakStatement() throws ParseException {Expression value = null;
 JavaToken begin;
    jj_consume_token(BREAK);
begin=token();
    if (jj_2_69(1)) {
      value = Expression();
    } else {
      ;
    }
    jj_consume_token(SEMICOLON);
{if ("" != null) return new BreakStmt(range(begin, token()), value);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ContinueStmt ContinueStatement() throws ParseException {SimpleName label = null;
 JavaToken begin;
    jj_consume_token(CONTINUE);
begin=token();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      label = SimpleName();
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
{if ("" != null) return new ContinueStmt(range(begin, token()), label);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReturnStmt ReturnStatement() throws ParseException {Expression expr = null;
 JavaToken begin;
    jj_consume_token(RETURN);
begin=token();
    if (jj_2_70(1)) {
      expr = Expression();
    } else {
      ;
    }
    jj_consume_token(SEMICOLON);
{if ("" != null) return new ReturnStmt(range(begin, token()),expr);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ThrowStmt ThrowStatement() throws ParseException {Expression expr;
 JavaToken begin;
    jj_consume_token(THROW);
begin=token();
    expr = Expression();
    jj_consume_token(SEMICOLON);
{if ("" != null) return new ThrowStmt(range(begin, token()),expr);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SynchronizedStmt SynchronizedStatement() throws ParseException {Expression expr;
 BlockStmt body;
 JavaToken begin;
    jj_consume_token(SYNCHRONIZED);
begin=token();
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(RPAREN);
    body = Block();
{if ("" != null) return new SynchronizedStmt(range(begin, token()),expr, body);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TryStmt TryStatement() throws ParseException {NodeList<Expression> resources = emptyList();
 BlockStmt tryBlock;
 BlockStmt finallyBlock = null;
 NodeList<CatchClause> catchs = emptyList();
 BlockStmt catchBlock;
 ModifierHolder exceptModifier;
 ReferenceType exceptionType;
 NodeList<ReferenceType> exceptionTypes = emptyList();
 Pair<SimpleName, List<ArrayBracketPair>> exceptId;
 JavaToken begin;
 JavaToken catchBegin;
 JavaToken typesBegin;
 JavaToken paramEnd;
 Type type;
    jj_consume_token(TRY);
begin=token();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      resources = ResourceSpecification();
      break;
      }
    default:
      jj_la1[135] = jj_gen;
      ;
    }
    tryBlock = Block();
    label_46:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CATCH:{
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        break label_46;
      }
      jj_consume_token(CATCH);
catchBegin=token();
      jj_consume_token(LPAREN);
typesBegin=token();
      exceptModifier = Modifiers();
      exceptionType = ReferenceType(emptyList());
exceptionTypes.add(exceptionType);
      label_47:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BIT_OR:{
          break;
          }
        default:
          jj_la1[137] = jj_gen;
          break label_47;
        }
        jj_consume_token(BIT_OR);
        exceptionType = AnnotatedReferenceType();
exceptionTypes.add(exceptionType);
      }
      exceptId = VariableDeclaratorId();
paramEnd = token();
      jj_consume_token(RPAREN);
      catchBlock = Block();
if (exceptionTypes.size() > 1) {
             type = new UnionType(range(exceptionTypes.get(0), exceptionTypes.get(exceptionTypes.size() - 1)), exceptionTypes);
         } else {
             type = (Type)exceptionTypes.get(0);
         }
    Parameter catchType = new Parameter(range(type, paramEnd), exceptModifier.modifiers, exceptModifier.annotations, type, false, emptyList(), exceptId.a);
         catchs = add(catchs, new CatchClause(range(catchBegin, token()), catchType, catchBlock));
         exceptionTypes = emptyList();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FINALLY:{
      jj_consume_token(FINALLY);
      finallyBlock = Block();
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      ;
    }
{if ("" != null) return new TryStmt(range(begin, token()), resources, tryBlock, catchs, finallyBlock);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ModifyStatement ModifyStatement() throws ParseException {JavaToken begin;
    Statement first = null;
    Statement other = null;
    NodeList<Statement> all = emptyList();
    Expression modifyObject = null;
this.isWithOrModify = true;
    jj_consume_token(MODIFY);
    jj_consume_token(LPAREN);
    modifyObject = UnaryExpressionNotPlusMinus();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASSERT:
    case BOOLEAN:
    case BREAK:
    case BYTE:
    case CHAR:
    case CONTINUE:
    case DO:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case FOR:
    case IF:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case RETURN:
    case SHORT:
    case STRICTFP:
    case SUPER:
    case SWITCH:
    case SYNCHRONIZED:
    case THIS:
    case THROW:
    case TRUE:
    case TRY:
    case VOID:
    case WHILE:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case MODIFY:
    case DOT_DOT_SLASH:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case LBRACE:
    case SEMICOLON:
    case AT:
    case INCR:
    case DECR:{
      first = Statement();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[140] = jj_gen;
      ;
    }
begin=token(); all.add(first);
    label_48:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        break label_48;
      }
      label_49:
      while (true) {
        jj_consume_token(COMMA);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[142] = jj_gen;
          break label_49;
        }
      }
      other = Statement();
all.add(other);
    }
    jj_consume_token(RBRACE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[143] = jj_gen;
      ;
    }
this.isWithOrModify = false;
                {if ("" != null) return new ModifyStatement(range(begin, token()), modifyObject, all);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public WithStatement WithStatement() throws ParseException {JavaToken begin;
    Statement first = null;
    Statement other = null;
    NodeList<Statement> all = emptyList();
    Expression withObject = null;
this.isWithOrModify = true;
    jj_consume_token(WITH);
    jj_consume_token(LPAREN);
    withObject = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_50:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASSERT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case RETURN:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case SWITCH:
      case SYNCHRONIZED:
      case THIS:
      case THROW:
      case TRUE:
      case TRY:
      case VOID:
      case WHILE:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case MODIFY:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case INCR:
      case DECR:{
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_50;
      }
      first = Statement();
      label_51:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SEMICOLON:{
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          break label_51;
        }
        jj_consume_token(SEMICOLON);
      }
    }
begin=token(); all.add(first);
    label_52:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        break label_52;
      }
      jj_consume_token(COMMA);
      other = Statement();
all.add(other);
    }
    jj_consume_token(RBRACE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      ;
    }
this.isWithOrModify = false;
                {if ("" != null) return new WithStatement(range(begin, token()), withObject, all);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> ResourceSpecification() throws ParseException {NodeList<Expression> variables;
    jj_consume_token(LPAREN);
    variables = Resources();
    if (jj_2_71(2)) {
      jj_consume_token(SEMICOLON);
    } else {
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return variables;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> Resources() throws ParseException {NodeList<Expression> expressions = new NodeList<Expression>();
 Expression expr;
    expr = Resource();
expressions.add(expr);
    label_53:
    while (true) {
      if (jj_2_72(2)) {
      } else {
        break label_53;
      }
      jj_consume_token(SEMICOLON);
      expr = Resource();
expressions.add(expr);
    }
{if ("" != null) return expressions;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression Resource() throws ParseException {Expression expr;
    if (jj_2_73(2147483647)) {
      /*this is a bit more lenient than we need to be, eg allowing access modifiers like private*/
              expr = VariableDeclarationExpression();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:{
        expr = PrimaryExpression();
        break;
        }
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return expr;}
    throw new IllegalStateException ("Missing return statement in function");
}

/* We use productions to match >>>, >> and > so that we can keep the
 * type declaration syntax with generics clean
 */
  final public 
void RUNSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    getToken(1).realKind == RUNSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
    jj_consume_token(GT);
}

  final public void RSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    getToken(1).realKind == RSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
}

/* Annotation syntax follows. */
  final public 
NodeList<AnnotationExpr> Annotations() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
 AnnotationExpr annotation;
    label_54:
    while (true) {
      if (jj_2_74(2147483647)) {
      } else {
        break label_54;
      }
      annotation = Annotation();
annotations = add(annotations, annotation);
    }
{if ("" != null) return annotations;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AnnotationExpr Annotation() throws ParseException {AnnotationExpr ret;
 Name name;
 NodeList<MemberValuePair> pairs = emptyList();
 JavaToken begin;
 Expression memberVal;
    jj_consume_token(AT);
begin=token();
    name = Name();
    if (jj_2_75(2147483647)) {
      jj_consume_token(LPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        pairs = MemberValuePairs();
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
ret = new NormalAnnotationExpr(range(begin, token()), name, pairs);
    } else if (jj_2_76(2147483647)) {
      jj_consume_token(LPAREN);
      memberVal = MemberValue();
      jj_consume_token(RPAREN);
ret = new SingleMemberAnnotationExpr(range(begin, token()), name, memberVal);
    } else {
ret = new MarkerAnnotationExpr(range(begin, token()), name);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<MemberValuePair> MemberValuePairs() throws ParseException {NodeList<MemberValuePair> ret = new NodeList<MemberValuePair>();
 MemberValuePair pair;
    pair = MemberValuePair();
ret.add(pair);
    label_55:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        break label_55;
      }
      jj_consume_token(COMMA);
      pair = MemberValuePair();
ret.add(pair);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public MemberValuePair MemberValuePair() throws ParseException {SimpleName name;
 Expression value;
 JavaToken begin;
    name = SimpleName();
begin=token();
    jj_consume_token(ASSIGN);
    value = MemberValue();
{if ("" != null) return new MemberValuePair(range(begin, token()),name, value);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression MemberValue() throws ParseException {Expression ret;
    if (jj_2_77(2147483647)) {
      ret = Annotation();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACE:{
        ret = MemberValueArrayInitializer();
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        if (jj_2_78(1)) {
          ret = ConditionalExpression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression MemberValueArrayInitializer() throws ParseException {NodeList<Expression> ret = emptyList();
 Expression member;
 JavaToken begin;
    jj_consume_token(LBRACE);
begin=token();
    if (jj_2_80(1)) {
      member = MemberValue();
ret.add(member);
      label_56:
      while (true) {
        if (jj_2_79(2)) {
        } else {
          break label_56;
        }
        jj_consume_token(COMMA);
        member = MemberValue();
ret.add(member);
      }
    } else {
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new ArrayInitializerExpr(range(begin, token()),ret);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression DefaultValue() throws ParseException {Expression ret;
    jj_consume_token(_DEFAULT);
    ret = MemberValue();
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

/* Module syntax follows */
  final public 

ModuleDirective ModuleDirective() throws ParseException {ModifierHolder modifiers;
    Name name;
    Name tmpName;
    NodeList<Name> names=emptyList();
    JavaToken begin;
    ModuleDirective directive;
    JavaToken transitiveExceptionalToken;
    if (jj_2_81(2147483647)) {
      jj_consume_token(REQUIRES);
begin=token();
      jj_consume_token(TRANSITIVE);
transitiveExceptionalToken=token(); setTokenKind(IDENTIFIER);
      jj_consume_token(SEMICOLON);
directive=new ModuleRequiresDirective(range(begin, token()), new NodeList<Modifier>(), new Name(range(transitiveExceptionalToken, transitiveExceptionalToken), null, transitiveExceptionalToken.getText()));
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case REQUIRES:{
        jj_consume_token(REQUIRES);
begin=token();
        modifiers = Modifiers();
        name = Name();
        jj_consume_token(SEMICOLON);
directive=new ModuleRequiresDirective(range(begin, token()), modifiers.modifiers, name);
        break;
        }
      case EXPORTS:{
        jj_consume_token(EXPORTS);
begin=token();
        name = Name();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TO:{
          jj_consume_token(TO);
          tmpName = Name();
names.add(tmpName);
          label_57:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case COMMA:{
              break;
              }
            default:
              jj_la1[153] = jj_gen;
              break label_57;
            }
            jj_consume_token(COMMA);
            tmpName = Name();
names.add(tmpName);
          }
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
directive=new ModuleExportsDirective(range(begin, token()), name, names);
        break;
        }
      case OPENS:{
        jj_consume_token(OPENS);
begin=token();
        name = Name();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TO:{
          jj_consume_token(TO);
          tmpName = Name();
names.add(tmpName);
          label_58:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case COMMA:{
              break;
              }
            default:
              jj_la1[155] = jj_gen;
              break label_58;
            }
            jj_consume_token(COMMA);
            tmpName = Name();
names.add(tmpName);
          }
          break;
          }
        default:
          jj_la1[156] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
directive=new ModuleOpensDirective(range(begin, token()), name, names);
        break;
        }
      case USES:{
        jj_consume_token(USES);
begin=token();
        name = Name();
        jj_consume_token(SEMICOLON);
directive=new ModuleUsesDirective(range(begin, token()), name);
        break;
        }
      case PROVIDES:{
        jj_consume_token(PROVIDES);
begin=token();
        name = Name();
        jj_consume_token(WITH);
        tmpName = Name();
names.add(tmpName);
        label_59:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            break;
            }
          default:
            jj_la1[157] = jj_gen;
            break label_59;
          }
          jj_consume_token(COMMA);
          tmpName = Name();
names.add(tmpName);
        }
        jj_consume_token(SEMICOLON);
directive=new ModuleProvidesDirective(range(begin, token()), name, names);
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return directive;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ModuleDeclaration ModuleDeclaration(ModifierHolder modifier) throws ParseException {NodeList<ModuleDirective> directives = new NodeList<ModuleDirective>();
    boolean open=false;
    ModuleDirective directive;
    Name name;
    JavaToken begin = modifier.begin;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPEN:{
      jj_consume_token(OPEN);
open=true; begin = orIfInvalid(begin, token());
      break;
      }
    default:
      jj_la1[159] = jj_gen;
      ;
    }
    jj_consume_token(MODULE);
begin = orIfInvalid(begin, token());
    name = Name();
    jj_consume_token(LBRACE);
    label_60:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case REQUIRES:
      case OPENS:
      case USES:
      case EXPORTS:
      case PROVIDES:{
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        break label_60;
      }
      directive = ModuleDirective();
directives = add(directives, directive);
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new ModuleDeclaration(range(begin, token()), modifier.annotations, name, open, directives);}
    throw new IllegalStateException ("Missing return statement in function");
}

/* Rules for matching partial inputs.
These rules are needed to properly terminate them -
if we simply use the usual rules, they will ignore everything in the provider
after they matched their desired input, which will lead to unexpected behaviour
*/
  final public 

BlockStmt BlockParseStart() throws ParseException {BlockStmt ret;
    ret = Block();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Statement BlockStatementParseStart() throws ParseException {Statement ret;
    if (jj_2_82(3)) {
      ret = BlockStatement();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case LT:{
        ret = ExplicitConstructorInvocation();
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ImportDeclaration ImportDeclarationParseStart() throws ParseException {ImportDeclaration ret;
    ret = ImportDeclaration();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ExpressionParseStart() throws ParseException {Expression ret;
    ret = Expression();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AnnotationExpr AnnotationParseStart() throws ParseException {AnnotationExpr ret;
    ret = Annotation();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public BodyDeclaration<?> ClassOrInterfaceBodyDeclarationParseStart() throws ParseException {BodyDeclaration<?> ret;
    ret = ClassOrInterfaceBodyDeclaration();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ClassOrInterfaceType ClassOrInterfaceTypeParseStart() throws ParseException {ClassOrInterfaceType ret;
    ret = AnnotatedClassOrInterfaceType();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Type ResultTypeParseStart() throws ParseException {NodeList<AnnotationExpr> annotations; Type ret;
    annotations = Annotations();
    ret = ResultType(annotations);
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public VariableDeclarationExpr VariableDeclarationExpressionParseStart() throws ParseException {VariableDeclarationExpr ret;
    ret = VariableDeclarationExpression();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExplicitConstructorInvocationStmt ExplicitConstructorInvocationParseStart() throws ParseException {ExplicitConstructorInvocationStmt ret;
    ret = ExplicitConstructorInvocation();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Name NameParseStart() throws ParseException {Name ret;
    ret = Name();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleName SimpleNameParseStart() throws ParseException {SimpleName ret;
    ret = SimpleName();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Parameter ParameterParseStart() throws ParseException {Parameter ret;
    ret = Parameter();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PackageDeclaration PackageDeclarationParseStart() throws ParseException {PackageDeclaration ret;
    ret = PackageDeclaration();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TypeDeclaration<?> TypeDeclarationParseStart() throws ParseException {TypeDeclaration<?> ret;
 ModifierHolder modifier;
    modifier = Modifiers();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CLASS:
    case INTERFACE:{
      ret = ClassOrInterfaceDeclaration(modifier);
      break;
      }
    case ENUM:{
      ret = EnumDeclaration(modifier);
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ModuleDeclaration ModuleDeclarationParseStart() throws ParseException {ModuleDeclaration ret;
  ModifierHolder modifiers;
    modifiers = Modifiers();
    ret = ModuleDeclaration(modifiers);
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ModuleDirective ModuleDirectiveParseStart() throws ParseException {ModuleDirective ret;
    ret = ModuleDirective();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TypeParameter TypeParameterParseStart() throws ParseException {TypeParameter ret;
 NodeList<AnnotationExpr> annotations;
    annotations = Annotations();
    ret = TypeParameter(annotations);
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<Expression> Expressions() throws ParseException {NodeList<Expression> ret = emptyList();
 Expression expr;
    jj_consume_token(LPAREN);
    if (jj_2_83(1)) {
      expr = Expression();
ret = add(ret, expr);
      label_61:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[163] = jj_gen;
          break label_61;
        }
        jj_consume_token(COMMA);
        expr = Expression();
ret = add(ret, expr);
      }
    } else {
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CompilationUnit DrlxCompilationUnit() throws ParseException {PackageDeclaration pakage = null;
 NodeList<ImportDeclaration> imports = emptyList();
 ImportDeclaration in = null;
 NodeList<TypeDeclaration<?>> types = emptyList();
    ModifierHolder modifier;
 TypeDeclaration<?> tn = null;
 ModuleDeclaration module = null;
 SimpleName unit = null;
    try {
      label_62:
      while (true) {
        if (jj_2_84(2)) {
        } else {
          break label_62;
        }
        jj_consume_token(SEMICOLON);
      }
      if (jj_2_85(2147483647)) {
        pakage = PackageDeclaration();
      } else {
        ;
      }
      label_63:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IMPORT:
        case UNIT:{
          break;
          }
        default:
          jj_la1[164] = jj_gen;
          break label_63;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IMPORT:{
          in = ImportDeclaration();
imports = add(imports, in);
          break;
          }
        case UNIT:{
          unit = UnitDeclaration();
          // FIXME keep name around
                      modifier = Modifiers();
          label_64:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RULE:{
              break;
              }
            default:
              jj_la1[165] = jj_gen;
              break label_64;
            }
            tn = RuleDeclaration(modifier);
types = add(types, tn);
          }
          break;
          }
        default:
          jj_la1[166] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 0:{
        jj_consume_token(0);
        break;
        }
      case CTRL_Z:{
        jj_consume_token(CTRL_Z);
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return new CompilationUnit(range(token_source.getHomeToken(), token()), pakage, imports, types, new ModuleDeclaration().setName(unit.getIdentifier()));}
    } catch (ParseException e) {
recover(EOF, e);
        final CompilationUnit compilationUnit = new CompilationUnit(range(token_source.getHomeToken(), token()), null, new NodeList<ImportDeclaration>(), new NodeList<TypeDeclaration<?>>(), null);
        compilationUnit.setParsed(UNPARSABLE);
        {if ("" != null) return compilationUnit;}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleName UnitDeclaration() throws ParseException {SimpleName name;
    jj_consume_token(UNIT);
    name = SimpleName();
    jj_consume_token(SEMICOLON);
{if ("" != null) return name;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RuleDeclaration RuleDeclaration(ModifierHolder modifier) throws ParseException {SimpleName name;
    JavaToken begin = modifier.begin;
    RuleBody body;
    jj_consume_token(RULE);
    name = SimpleName();
    body = RuleBody();
{if ("" != null) return new RuleDeclaration(range(begin, token()), modifier.annotations, name, body);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RuleBody RuleBody() throws ParseException {NodeList<RuleItem> items = emptyList();
    JavaToken begin;
begin=token();
    items = RuleItems();
{if ("" != null) return new RuleBody(range(begin, token()), items);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NodeList<RuleItem> RuleItems() throws ParseException {NodeList<RuleItem> items = emptyList();
    RuleItem item;
    RuleConsequence consequnce;
    jj_consume_token(LBRACE);
    label_65:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DO:
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        break label_65;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        item = RulePattern();
items.add(item);
        break;
        }
      case DO:{
        jj_consume_token(DO);
        item = RuleConsequence();
items.add(item);
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return items;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RulePattern RulePattern() throws ParseException {JavaToken begin;
    SimpleName type;
    SimpleName bind;
    OOPathExpr expr;
    type = SimpleName();
begin=token();
    bind = SimpleName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      break;
      }
    case COLON:{
      jj_consume_token(COLON);
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    // need to differentiate in the Pattern kind
      expr = OOPathExpr();
    jj_consume_token(COMMA);
{if ("" != null) return new RulePattern(range(begin, token()), type, bind, expr);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RuleConsequence RuleConsequence() throws ParseException {JavaToken begin;
    Statement statement;
begin=token();
    statement = Statement();
{if ("" != null) return new RuleConsequence(range(begin, token()), statement);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public OOPathExpr OOPathExpr() throws ParseException {JavaToken begin;
    NodeList<OOPathChunk> chunks = emptyList();
    OOPathChunk chunk;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SLASH:{
      jj_consume_token(SLASH);
begin=token();
      chunk = OOPathChunk();
chunks.add(chunk);
      break;
      }
    case PASSIVE_OOPATH:{
      jj_consume_token(PASSIVE_OOPATH);
begin=token();
      chunk = OOPathChunk();
chunks.add(chunk.passive());
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_66:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PASSIVE_OOPATH:
      case DOT:
      case SLASH:{
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        break label_66;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SLASH:{
        jj_consume_token(SLASH);
        chunk = OOPathChunk();
chunks.add(chunk);
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        chunk = OOPathChunk();
chunks.add(chunk.singleValue());
        break;
        }
      case PASSIVE_OOPATH:{
        jj_consume_token(PASSIVE_OOPATH);
        chunk = OOPathChunk();
chunks.add(chunk.passive());
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return new OOPathExpr(range(begin, token()), chunks);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public OOPathChunk OOPathChunk() throws ParseException {JavaToken begin;
    SimpleName field;
    SimpleName inlineCast = null;
    DrlxExpression tempExpr;
    List<DrlxExpression> conditions = new ArrayList<DrlxExpression>();
    field = SimpleName();
begin=token();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case HASHMARK:{
      jj_consume_token(HASHMARK);
      inlineCast = SimpleName();
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      tempExpr = DrlxExpression();
conditions = add(conditions, tempExpr);
      label_67:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[175] = jj_gen;
          break label_67;
        }
        jj_consume_token(COMMA);
        tempExpr = DrlxExpression();
conditions = add(conditions, tempExpr);
      }
      jj_consume_token(RBRACKET);
      break;
      }
    default:
      jj_la1[176] = jj_gen;
      ;
    }
{if ("" != null) return new OOPathChunk(range(begin, token()), field, inlineCast, conditions);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DrlxExpression DrlxExpression() throws ParseException {DrlxExpression ret = null;
    SimpleName decl = null;
 Expression expr;
 Expression right;
    if (jj_2_86(2)) {
      decl = SimpleName();
      jj_consume_token(COLON);
    } else {
      ;
    }
    if (jj_2_87(2147483647)) {
      expr = OOPathExpr();
ret = new DrlxExpression(decl, expr);
    } else if (jj_2_88(1)) {
      expr = Expression();
ret = new DrlxExpression(decl, expr);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_68:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        break;
        }
      default:
        jj_la1[177] = jj_gen;
        break label_68;
      }
      jj_consume_token(COLON);
      right = Expression();
ret = parseBindingAfterAnd(range(ret, token()), ret, right);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression MapCreationLiteralExpression() throws ParseException {JavaToken begin = null;
    Expression first = null;
    Expression other = null;
    NodeList<Expression> all = emptyList();
    jj_consume_token(LBRACKET);
    label_69:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:{
        break;
        }
      default:
        jj_la1[178] = jj_gen;
        break label_69;
      }
      first = MapCreationLiteralExpressionKeyValuePair();
begin=token(); all.add(first);
    }
    label_70:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        break label_70;
      }
      jj_consume_token(COMMA);
      other = MapCreationLiteralExpressionKeyValuePair();
all.add(other);
    }
    jj_consume_token(RBRACKET);
begin = token();
                {if ("" != null) return new MapCreationLiteralExpression(range(begin, token()), all);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression MapCreationLiteralExpressionKeyValuePair() throws ParseException {JavaToken begin;
        Expression key = null;
        Expression value = null;
    key = PrimaryPrefix();
    jj_consume_token(COLON);
    value = PrimaryPrefix();
begin = token();
            {if ("" != null) return new MapCreationLiteralExpressionKeyValuePair(range(begin, token()), key, value);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ListCreationLiteralExpression() throws ParseException {JavaToken begin = null;
    Expression first = null;
    Expression other = null;
    NodeList<Expression> all = emptyList();
    jj_consume_token(LBRACKET);
    label_71:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case DOT_DOT_SLASH:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:{
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        break label_71;
      }
      first = ListCreationLiteralExpressionElement();
begin=token(); all.add(first);
    }
    label_72:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        break label_72;
      }
      jj_consume_token(COMMA);
      other = ListCreationLiteralExpressionElement();
all.add(other);
    }
    jj_consume_token(RBRACKET);
begin = token();
                {if ("" != null) return new ListCreationLiteralExpression(range(begin, token()), all);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ListCreationLiteralExpressionElement() throws ParseException {JavaToken begin;
        Expression key = null;
        Expression value = null;
    value = PrimaryPrefix();
begin = token();
            {if ("" != null) return new ListCreationLiteralExpressionElement(range(begin, token()), value);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PointFreeExpr() throws ParseException {JavaToken begin;
    Expression left;
    NodeList<Expression> right = emptyList();
    SimpleName operator;
    boolean negated = false;
    TemporalLiteralArguments temporalLiteralArguments;
    Expression tempExpr;
    left = PrimaryExpression();
// if we are in a Block {} we short-circuit;
                // a PointFreeExpr is invalid in that case
                if (this.inBlock()) {
                    {if ("" != null) return left;}
                }
                begin=token();
    label_73:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOT:{
        break;
        }
      default:
        jj_la1[182] = jj_gen;
        break label_73;
      }
      jj_consume_token(NOT);
negated = true;
    }
    operator = SimpleName();
    temporalLiteralArguments = TemporalLiteralArguments();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      right = Expressions();
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case STRICTFP:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case DOT_DOT_SLASH:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case AT:{
      tempExpr = PrimaryExpression();
right = add(right, tempExpr);
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(temporalLiteralArguments != null) {
                        {if ("" != null) return new PointFreeExpr(range(begin, token()), left, right, operator, negated, temporalLiteralArguments.getArg1(), temporalLiteralArguments.getArg2(), temporalLiteralArguments.getArg3(), temporalLiteralArguments.getArg4() );}
                    } else {
                        {if ("" != null) return new PointFreeExpr(range(begin, token()), left, right, operator, negated, null, null, null, null);}
                    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression PointFreeExprMvel() throws ParseException {JavaToken begin;
    Expression left;
    NodeList<Expression> right = emptyList();
    boolean negated = false;
    Expression tempExpr;
    Token mvelOperator = null;
    left = PrimaryExpression();
begin=token();
    label_74:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOT:{
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        break label_74;
      }
      jj_consume_token(NOT);
negated = true;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MVEL_STARTS_WITH:{
      mvelOperator = jj_consume_token(MVEL_STARTS_WITH);
      break;
      }
    case MVEL_ENDS_WITH:{
      mvelOperator = jj_consume_token(MVEL_ENDS_WITH);
      break;
      }
    case MVEL_LENGTH:{
      mvelOperator = jj_consume_token(MVEL_LENGTH);
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tempExpr = PrimaryExpression();
right = add(right, tempExpr);
{if ("" != null) return new PointFreeExpr(range(begin, token()), left, right, new SimpleName(mvelOperator.toString()), negated, null, null, null, null);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression HalfPointFreeExpr() throws ParseException {JavaToken begin = token();
    NodeList<Expression> right = emptyList();
    SimpleName operator;
    boolean negated = false;
    TemporalLiteralArguments temporalLiteralArguments;
    Expression tempExpr;
    label_75:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOT:{
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        break label_75;
      }
      jj_consume_token(NOT);
negated = true;
    }
    operator = SimpleName();
begin = token();
    temporalLiteralArguments = TemporalLiteralArguments();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      right = Expressions();
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case STRICTFP:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case REQUIRES:
    case TO:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case DOT_DOT_SLASH:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case AT:{
      tempExpr = PrimaryPrefix();
right = add(right, tempExpr);
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(temporalLiteralArguments != null) {
                    {if ("" != null) return new HalfPointFreeExpr(range(begin, token()), right, operator, negated, temporalLiteralArguments.getArg1(), temporalLiteralArguments.getArg2(), temporalLiteralArguments.getArg3(), temporalLiteralArguments.getArg4() );}
                } else {
                    {if ("" != null) return new HalfPointFreeExpr(range(begin, token()), right, operator, negated, null, null, null, null);}
                }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression HalfPointFreeExprMvel() throws ParseException {JavaToken begin;
    NodeList<Expression> right = emptyList();
    boolean negated = false;
    Expression tempExpr;
    Token mvelOperator = null;
    label_76:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOT:{
        break;
        }
      default:
        jj_la1[188] = jj_gen;
        break label_76;
      }
      jj_consume_token(NOT);
negated = true;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MVEL_STARTS_WITH:{
      mvelOperator = jj_consume_token(MVEL_STARTS_WITH);
      break;
      }
    case MVEL_ENDS_WITH:{
      mvelOperator = jj_consume_token(MVEL_ENDS_WITH);
      break;
      }
    case MVEL_LENGTH:{
      mvelOperator = jj_consume_token(MVEL_LENGTH);
      break;
      }
    default:
      jj_la1[189] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
begin = token();
    tempExpr = PrimaryExpression();
right = add(right, tempExpr);
{if ("" != null) return new HalfPointFreeExpr(range(begin, token()), right, new SimpleName(mvelOperator.toString()), negated, null, null, null, null);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TemporalLiteralArguments TemporalLiteralArguments() throws ParseException {Expression arg1 = null;
    Expression arg2 = null;
    Expression arg3 = null;
    Expression arg4 = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACKET:{
      if (jj_2_89(2147483647)) {
        jj_consume_token(LBRACKET);
        arg1 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg2 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg3 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg4 = TemporalLiteral();
        jj_consume_token(RBRACKET);
      } else if (jj_2_90(2147483647)) {
        jj_consume_token(LBRACKET);
        arg1 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg2 = TemporalLiteral();
        jj_consume_token(RBRACKET);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACKET:{
          jj_consume_token(LBRACKET);
          arg1 = TemporalLiteral();
          jj_consume_token(RBRACKET);
          break;
          }
        default:
          jj_la1[190] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[191] = jj_gen;
      ;
    }
{if ("" != null) return new TemporalLiteralArguments(arg1, arg2, arg3, arg4);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TemporalLiteralExpr TemporalLiteral() throws ParseException {NodeList<TemporalChunkExpr> chunks = emptyList();
 TemporalLiteralChunkExpr chunk;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INTEGER_LITERAL:{
      jj_consume_token(INTEGER_LITERAL);
chunks.add(new TemporalLiteralChunkExpr(tokenRange(), token.image));
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
chunks.add(new TemporalLiteralInfiniteChunkExpr(tokenRange(), token.image));
      break;
      }
    case FLOATING_POINT_LITERAL:
    case MILLISECOND_LITERAL:
    case SECOND_LITERAL:
    case MINUTE_LITERAL:
    case HOUR_LITERAL:{
      chunk = TemporalLiteralChunk();
chunks.add(chunk);
      label_77:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FLOATING_POINT_LITERAL:
        case MILLISECOND_LITERAL:
        case SECOND_LITERAL:
        case MINUTE_LITERAL:
        case HOUR_LITERAL:{
          break;
          }
        default:
          jj_la1[192] = jj_gen;
          break label_77;
        }
        chunk = TemporalLiteralChunk();
chunks.add(chunk);
      }
      break;
      }
    default:
      jj_la1[193] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new TemporalLiteralExpr(tokenRange(), chunks);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TemporalLiteralChunkExpr TemporalLiteralChunk() throws ParseException {TemporalLiteralChunkExpr ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MILLISECOND_LITERAL:{
      jj_consume_token(MILLISECOND_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.MILLISECONDS);
      break;
      }
    case SECOND_LITERAL:{
      jj_consume_token(SECOND_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.SECONDS);
      break;
      }
    case MINUTE_LITERAL:{
      jj_consume_token(MINUTE_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.MINUTES);
      break;
      }
    case HOUR_LITERAL:{
      jj_consume_token(HOUR_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.HOURS);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      jj_consume_token(FLOATING_POINT_LITERAL);
if (token.image.endsWith("f") || token.image.endsWith("F") || token.image.endsWith("D")) {
             addProblem("unexpected float");
             ret = null;
         } else {
         ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.DAYS);
        }
      break;
      }
    default:
      jj_la1[194] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void EOS() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    case 0:{
      jj_consume_token(0);
      break;
      }
    default:
      jj_la1[195] = jj_gen;
      if (this.shouldTerminateStatement()) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_3R_271()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_337()) jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    xsp = jj_scanpos;
    if (jj_3R_338()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_483()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_3R_128()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_224()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) {
    jj_scanpos = xsp;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_355()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_215()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_356()
 {
    if (jj_scan_token(LONG_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    if (jj_scan_token(BIG_DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_scan_token(BIG_INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3_8()) return true;
    }
    return false;
  }

  private boolean jj_3R_359()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_447()
 {
    if (jj_scan_token(RULE)) return true;
    if (jj_3R_108()) return true;
    if (jj_3R_484()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_3R_406()) return true;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_3R_407()) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_484()
 {
    if (jj_3R_487()) return true;
    return false;
  }

  private boolean jj_3R_406()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) {
    jj_scanpos = xsp;
    if (jj_3R_435()) return true;
    }
    return false;
  }

  private boolean jj_3R_434()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_332()
 {
    if (jj_3R_106()) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_435()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_487()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_506()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_407()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_506()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_513()) {
    jj_scanpos = xsp;
    if (jj_3R_514()) return true;
    }
    return false;
  }

  private boolean jj_3R_513()
 {
    if (jj_3R_517()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_99()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_106()) return true;
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_514()
 {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_518()) return true;
    return false;
  }

  private boolean jj_3R_364()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_517()
 {
    if (jj_3R_108()) return true;
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) return true;
    }
    if (jj_3R_147()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_449()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_449()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_518()
 {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    if (jj_3R_127()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_408()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_106()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_371()) {
    jj_scanpos = xsp;
    if (jj_3R_372()) return true;
    }
    return false;
  }

  private boolean jj_3R_147()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_230()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_3R_128()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_409()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_371()
 {
    if (jj_3R_124()) return true;
    if (jj_3R_410()) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(PASSIVE_OOPATH)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_411()) jj_scanpos = xsp;
    if (jj_3R_412()) return true;
    xsp = jj_scanpos;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) return true;
    }
    return false;
  }

  private boolean jj_3R_411()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_3R_410()) return true;
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_scan_token(PASSIVE_OOPATH)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_414()
 {
    if (jj_3R_364()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_53()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_136()) return true;
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_214()) jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    Token xsp;
    if (jj_3_55()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_55()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_106()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_scan_token(HASHMARK)) return true;
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_404()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_405()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_3R_106()) return true;
    if (jj_3R_94()) return true;
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_404()) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_404()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_432()) {
    jj_scanpos = xsp;
    if (jj_3_88()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_433()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_108()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_432()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_3R_101()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_433()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_3R_373()) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_181()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_182()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_3R_375()) return true;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_3R_376()) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_3R_106()) return true;
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_257()) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_3R_381()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_102()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_3R_382()) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_3R_385()) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_3R_386()) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_3R_387()) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_3R_157()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    if (jj_3R_388()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_257()) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_3R_98()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) return true;
    }
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_3R_108()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_183()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_184()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_234()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_3R_124()) return true;
    Token xsp;
    if (jj_3R_247()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_3R_248()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_249()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_3R_106()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_430()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_190()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_193()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_108()) return true;
    if (jj_3R_194()) return true;
    xsp = jj_scanpos;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) return true;
    }
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_3R_136()) return true;
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_137()) return true;
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_412()
 {
    if (jj_3R_106()) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_3R_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_106()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_3R_136()) return true;
    if (jj_3R_94()) return true;
    if (jj_3R_143()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_219()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_106()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_106()) return true;
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_374()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_422()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) return true;
    }
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(LT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) jj_scanpos = xsp;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_444()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_190()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_191()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    }
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_3R_250()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_301()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_3R_106()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    }
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_375()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) return true;
    }
    }
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_415()
 {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_416()
 {
    if (jj_3R_190()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_438()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_452()) {
    jj_scanpos = xsp;
    if (jj_3R_453()) {
    jj_scanpos = xsp;
    if (jj_3R_454()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_452()
 {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_197()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_108()) return true;
    if (jj_3R_194()) return true;
    xsp = jj_scanpos;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) return true;
    }
    return false;
  }

  private boolean jj_3R_437()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    }
    return false;
  }

  private boolean jj_3R_450()
 {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_106()) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_453()
 {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_451()
 {
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_106()) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_454()
 {
    if (jj_3R_109()) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_376()
 {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_492()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_492()
 {
    if (jj_3R_442()) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(BYTE)) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_scan_token(SHORT)) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_420()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_420()
 {
    if (jj_3R_442()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_192()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    }
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    }
    return false;
  }

  private boolean jj_3R_442()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) {
    jj_scanpos = xsp;
    if (jj_3R_456()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_457()) {
    jj_scanpos = xsp;
    if (jj_3R_458()) return true;
    }
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  private boolean jj_3R_455()
 {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_145()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_462()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_456()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_462()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_457()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_458()
 {
    if (jj_scan_token(ARROW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3R_463()) {
    jj_scanpos = xsp;
    if (jj_3R_464()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_463()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_98()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_261()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_464()
 {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_95()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_377()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_246()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_493()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_3R_285()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_286()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_350()
 {
    if (jj_scan_token(MILLISECOND_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_scan_token(SECOND_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_3R_145()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_335()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_352()
 {
    if (jj_scan_token(MINUTE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_246()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_353()
 {
    if (jj_scan_token(HOUR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_335()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_109()) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_scan_token(ARROW)) return true;
    if (jj_3R_422()) return true;
    return false;
  }

  private boolean jj_3R_380()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_431()) {
    jj_scanpos = xsp;
    if (jj_3_66()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_431()
 {
    if (jj_3R_137()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = this.shouldTerminateStatement();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_347()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_63()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_398()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_424()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_3R_137()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_423()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(STARASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(SLASHASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_scan_token(REMASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(PLUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(MINUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_scan_token(LSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(RSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_scan_token(RUNSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_scan_token(ANDASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_scan_token(XORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(ORASSIGN)) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_347()
 {
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_3R_225()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_396()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_136()) return true;
    if (jj_3R_94()) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_396()
 {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_520()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_493()
 {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_3R_278()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_421()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_424()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_421()
 {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_278()) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_3R_343()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_443()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_69()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_3R_400()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_459()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_417()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_3R_429()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_465()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_383()
 {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_520()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_429()
 {
    if (jj_3R_448()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_467()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_443()
 {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_384()
 {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_448()
 {
    if (jj_3R_460()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_469()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_459()
 {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_417()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_385()
 {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_465()
 {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_469()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) {
    jj_scanpos = xsp;
    if (jj_3R_473()) return true;
    }
    if (jj_3R_460()) return true;
    return false;
  }

  private boolean jj_3R_472()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_473()
 {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_460()
 {
    if (jj_3R_466()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_471()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_467()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_448()) return true;
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_scan_token(TRY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_418()) jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    xsp = jj_scanpos;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_3R_495()) return true;
    }
    return false;
  }

  private boolean jj_3R_418()
 {
    if (jj_3R_439()) return true;
    return false;
  }

  private boolean jj_3R_466()
 {
    if (jj_3R_468()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_475()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_475()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) {
    jj_scanpos = xsp;
    if (jj_3R_477()) {
    jj_scanpos = xsp;
    if (jj_3R_478()) {
    jj_scanpos = xsp;
    if (jj_3R_479()) return true;
    }
    }
    }
    if (jj_3R_468()) return true;
    return false;
  }

  private boolean jj_3R_476()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_508()
 {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_136()) return true;
    if (jj_3R_105()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_516()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_128()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_477()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_494()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_508()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_509()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_478()
 {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_479()
 {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_516()
 {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3R_468()
 {
    if (jj_3R_470()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_24()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_471()
 {
    if (jj_scan_token(INSTANCEOF)) return true;
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    }
    if (jj_3R_470()) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(LSHIFT)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_495()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_509()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_470()
 {
    if (jj_3R_474()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_485()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_387()
 {
    if (jj_scan_token(MODIFY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_260()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_496()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_497()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_485()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_501()) {
    jj_scanpos = xsp;
    if (jj_3R_502()) return true;
    }
    if (jj_3R_474()) return true;
    return false;
  }

  private boolean jj_3R_501()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_502()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_474()
 {
    if (jj_3R_220()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_500()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_496()
 {
    if (jj_3R_246()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_500()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_510()) {
    jj_scanpos = xsp;
    if (jj_3R_511()) {
    jj_scanpos = xsp;
    if (jj_3R_512()) return true;
    }
    }
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_510()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_511()
 {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_512()
 {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_497()
 {
    Token xsp;
    if (jj_scan_token(113)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(113)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_388()
 {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_498()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_499()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    }
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_342()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_498()
 {
    if (jj_3R_246()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(112)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_439()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_461()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_499()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_340()
 {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_461()
 {
    if (jj_3R_142()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_72()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_142()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) return true;
    }
    return false;
  }

  private boolean jj_3R_113()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3_32()) return true;
    }
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3_31()) return true;
    }
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_3R_136()) return true;
    if (jj_3R_94()) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                getToken(1).realKind == RUNSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_179()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                getToken(1).realKind == RSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_178()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    return false;
  }

  private boolean jj_3R_116()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = (isPointFreeOperator(getToken(1).image) || isPointFreeOperator(getToken(2).image) );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_164()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_3R_106()) return true;
    if (jj_scan_token(PACKAGE)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(AT)) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_101()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_260()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_320()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_391()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_146()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_392()
 {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3R_322()
 {
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) return true;
    }
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_419()
 {
    if (jj_3R_440()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_441()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_3R_95()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_393()
 {
    if (jj_3R_190()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_3()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_440()
 {
    if (jj_3R_108()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3_78()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(TRANSIENT)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_106()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    }
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_scan_token(VOLATILE)) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_scan_token(AT)) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(STRICTFP)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_124()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_scan_token(TRANSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_3R_105()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_263()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_3R_146()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_79()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3R_441()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_440()) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_3R_157()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_245()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_3R_302()) return true;
    }
    if (jj_3R_108()) return true;
    xsp = jj_scanpos;
    if (jj_3R_344()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_345()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_344()
 {
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_157()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_158()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_3R_402()) return true;
    return false;
  }

  private boolean jj_3R_346()
 {
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_412()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_490()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_490()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_scan_token(REQUIRES)) return true;
    if (jj_scan_token(TRANSITIVE)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(THIS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_412()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_491()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_491()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_scan_token(SUPER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_365()) jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    xsp = jj_scanpos;
    if (jj_3R_366()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_365()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_366()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_445()
 {
    if (jj_scan_token(ENUM)) return true;
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_480()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_481()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_482()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_480()
 {
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_367()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_481()
 {
    if (jj_3R_93()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_482()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_486()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3_46()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_486()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_505()) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    return false;
  }

  private boolean jj_3R_505()
 {
    if (jj_3R_339()) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    if (jj_3R_369()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_3R_370()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_3R_108()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_150()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_108()) return true;
    xsp = jj_scanpos;
    if (jj_3R_503()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_504()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_3R_129()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_3R_130()) return true;
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_297()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3R_503()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_3R_98()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_3R_128()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_3R_108()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_368()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_3R_129()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_299()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_108()) return true;
    xsp = jj_scanpos;
    if (jj_3R_300()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_3R_130()) return true;
    if (jj_scan_token(DOUBLECOLON)) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_401()
 {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_106()) return true;
    if (jj_3R_488()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_489()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_489()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_106()) return true;
    if (jj_3R_488()) return true;
    return false;
  }

  private boolean jj_3R_504()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_scan_token(DOT_DOT_SLASH)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) return true;
    }
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_488()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_507()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_515()
 {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_412()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_519()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_519()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    return false;
  }

  private boolean jj_3R_266()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_333()) jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    xsp = jj_scanpos;
    if (jj_3R_334()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_3R_339()) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_339()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_399()) return true;
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_131()) jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_98()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_399()
 {
    if (jj_3R_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) {
    jj_scanpos = xsp;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_507()
 {
    if (jj_3R_515()) return true;
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_scan_token(HASHMARK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_3R_101()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_425()
 {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_426()
 {
    if (jj_3R_445()) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_427()
 {
    if (jj_3R_446()) return true;
    return false;
  }

  private boolean jj_3R_428()
 {
    if (jj_3R_447()) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_395()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_94()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(ENUM)) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(EXCL_DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_94()) return true;
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_446()
 {
    if (jj_3R_94()) return true;
    if (jj_3R_143()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_483()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public GeneratedMvelParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[196];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x24480800,0x4080000,0x24480800,0x1,0x0,0x0,0x20400800,0x80000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x4000000,0x0,0xa54ca800,0xa54ca800,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0xa54ca800,0xa54ca800,0x80000,0x0,0xa54ca800,0x0,0x0,0x0,0x0,0x0,0xa544a800,0x0,0xa544a800,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x8104a000,0x8504a000,0x8504a000,0x0,0x8504a000,0x8504a000,0x8000000,0x8000000,0x8104a000,0x8504a000,0x4000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x0,0x9504a000,0x0,0x0,0x8504a000,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x10000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x8504a000,0x0,0x95a4f000,0x0,0x95a4f000,0x0,0x0,0x0,0x0,0x9504a000,0x410000,0x410000,0x0,0x410000,0x0,0x0,0x2000000,0x0,0x4000000,0x0,0x20000,0x0,0x40000000,0x0,0x95a4f000,0x0,0x0,0x0,0x95a4f000,0x0,0x0,0x0,0x9504a000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x4080000,0x0,0x0,0x0,0x0,0x1,0x4800000,0x4800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x9504a000,0x0,0x0,0x9504a000,0x0,0x0,0x0,0x9504a000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x444ce290,0x80,0x444ce290,0x0,0x40000,0x0,0x444ce200,0x80,0x0,0x0,0x8,0x0,0x0,0x8,0x80000,0x0,0x444ee3c0,0x444ee3c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x444ee3c0,0x444ee3c0,0x80,0x0,0x444ee3c0,0x0,0x0,0x0,0x0,0x0,0x444ee340,0x0,0x444ee340,0x0,0x0,0x0,0x0,0x0,0x289a0d40,0x40000,0x20140,0xa0140,0xa0140,0x0,0xa0140,0xa0140,0x100000,0x100000,0x20140,0x200a0140,0x80000,0x0,0x80400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28ba0d40,0x0,0x0,0x28ba0d40,0x0,0x0,0xa0140,0x0,0x0,0x0,0x0,0x80400,0x0,0x0,0x0,0x80400,0x0,0x0,0x8900c00,0x80000,0x0,0x0,0x0,0x800400,0x0,0x80000,0x0,0x0,0x800400,0x0,0x8000800,0x8000000,0x0,0x0,0x0,0xa0140,0x0,0xb9fb0d45,0x0,0xb9fb0d45,0x0,0x0,0x0,0x0,0x289a0d40,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0xb9fb0d45,0x0,0x0,0x0,0xb9fb0d45,0x0,0x0,0x0,0x289a0d40,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x289a0d40,0x80,0x0,0x10,0x0,0x10,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x289a0d40,0x0,0x289a0d40,0x0,0x0,0x289a0d40,0x0,0x0,0x0,0x289a0d40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0xa48,0x848,0xa48,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbfb,0x0,0xbfb,0xbfb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbfb,0xbfb,0x0,0x800,0xbfb,0x0,0x0,0x0,0x0,0x0,0xbfb,0x0,0xbfb,0x0,0x0,0x0,0x0,0x0,0x43c40bfb,0x0,0x0,0xbfb,0xbfb,0x0,0xbfb,0xbfb,0x0,0x0,0x0,0xbfb,0xbfb,0x0,0xbfb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x43c40bfb,0x0,0x0,0x43c40bfb,0x0,0x0,0xbfb,0x0,0x0,0x0,0x0,0xbfb,0x0,0x0,0x0,0xbfb,0x40000,0x0,0x43c00000,0x40bfb,0x0,0x0,0x0,0x0,0x0,0xbfb,0x0,0x0,0x0,0x180000,0x43c00000,0x0,0x0,0x0,0x0,0xbfb,0x0,0x43c44bff,0x0,0x43c44bff,0x0,0x0,0x0,0x0,0x43c40bfb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbfb,0x0,0x0,0x0,0x0,0x0,0x43c44bff,0x0,0x0,0x0,0x43c44bff,0x0,0x0,0x0,0x43c40bfb,0xbfb,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x1b1,0x8,0x1b1,0x43c40bfb,0x0,0x0,0x400,0x800,0x400,0x0,0xbfb,0xbfb,0x0,0x200000,0x200000,0x200000,0x80000,0x0,0x0,0x0,0x43c40bfb,0x0,0x43c40bfb,0x0,0x2000,0x43c40bfb,0x2000,0x38000,0x2000,0x43c40bfb,0x2000,0x38000,0x0,0x0,0x40000000,0x40800000,0x40000000,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x90000,0x10000,0x90000,0x0,0x0,0x40000,0x80000,0x0,0x200000,0x0,0x0,0x20000,0x20000,0x0,0x80080,0x20000,0x91080,0x91080,0x10000,0x80000,0x400,0x1000,0x20000,0x0,0x0,0x91080,0x91080,0x0,0x0,0x80080,0x20000,0x100000,0x84000,0x1000,0x20000,0x80080,0x20000,0x80080,0x20000,0x20000,0x80000,0x200000,0x200000,0x2804e0,0x0,0x0,0x80,0x80080,0x20000,0x1080080,0x1000080,0x0,0x0,0x0,0x80,0x80,0x200000,0x80,0x0,0x100000,0x100000,0x1000000,0x40000000,0x80000000,0x0,0x0,0x0,0x24000000,0x24000000,0x0,0x18200000,0x18200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c200000,0x3c200000,0xc804e0,0xc00000,0xc00000,0x804e0,0x0,0x0,0x80,0x400,0x200000,0x400,0x200000,0x80,0x40000,0x800,0x200000,0x80,0x0,0x400,0x460,0x80,0x40000,0x200000,0x400,0x0,0x400,0x480,0x200000,0x400,0x0,0x44000,0x60,0x0,0x20000,0x200000,0x84400,0x280080,0x1000,0x914e0,0x2000000,0x914e0,0x20000,0x1000,0x100000,0x100000,0x804e0,0x0,0x0,0x20000,0x0,0x1000,0x2000000,0x0,0x20000,0x80,0x400,0x0,0x0,0x0,0x10000,0x914e0,0x20000,0x20000,0x10000,0x914e0,0x10000,0x20000,0x10000,0x804e0,0x80,0x20000,0x1000,0x20000,0x20000,0x0,0x20000,0x0,0x20000,0x0,0x0,0x0,0x2804e0,0x0,0x20000,0x0,0x0,0x0,0x0,0x80,0x80,0x2100000,0x0,0x40000,0x40000,0x0,0x20000,0x4000,0x2000000,0x804e0,0x20000,0x804e0,0x20000,0x0,0x804e0,0x0,0x0,0x0,0x804e0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x10000,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x1bff800,0x3ff800,0x0,0x0,0x0,0x80,0x100,0x40,0x0,0x0,0x0,0x8000000,0x8000000,0x400,0xc,0xc,0x230,0x230,0xc,0xf,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x3,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x0,0x0,0x3ff803,0x3ff803,0x2,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x3,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x20,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xe0000010,0xe0000000,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x0,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[90];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public GeneratedMvelParser(final Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new GeneratedMvelParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 196; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with InputStream.
   * @param sDSL String representation to be parsed
   */
  public GeneratedMvelParser(final String sDSL) {
	   this(new StringProvider(sDSL));
  }

  /**
   * Reinitialise.
   * @param sDSL String representation to be parsed
   */
  public void ReInit(final String sDSL) {
	  ReInit(new StringProvider(sDSL));
  }
  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final Provider stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new GeneratedMvelParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 196; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public GeneratedMvelParser(final GeneratedMvelParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 196; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final GeneratedMvelParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 196; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  private static final class LookaheadSuccess extends IllegalStateException { }
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    jj_nt = token.next;
    if (jj_nt == null) {
      token.next = token_source.getNextToken();
      jj_ntk = token.next.kind;
      return jj_ntk;
    }
    jj_ntk = jj_nt.kind;
    return jj_ntk;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[161];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 196; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 161; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : GeneratedMvelParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 90; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
              case 31: jj_3_32(); break;
              case 32: jj_3_33(); break;
              case 33: jj_3_34(); break;
              case 34: jj_3_35(); break;
              case 35: jj_3_36(); break;
              case 36: jj_3_37(); break;
              case 37: jj_3_38(); break;
              case 38: jj_3_39(); break;
              case 39: jj_3_40(); break;
              case 40: jj_3_41(); break;
              case 41: jj_3_42(); break;
              case 42: jj_3_43(); break;
              case 43: jj_3_44(); break;
              case 44: jj_3_45(); break;
              case 45: jj_3_46(); break;
              case 46: jj_3_47(); break;
              case 47: jj_3_48(); break;
              case 48: jj_3_49(); break;
              case 49: jj_3_50(); break;
              case 50: jj_3_51(); break;
              case 51: jj_3_52(); break;
              case 52: jj_3_53(); break;
              case 53: jj_3_54(); break;
              case 54: jj_3_55(); break;
              case 55: jj_3_56(); break;
              case 56: jj_3_57(); break;
              case 57: jj_3_58(); break;
              case 58: jj_3_59(); break;
              case 59: jj_3_60(); break;
              case 60: jj_3_61(); break;
              case 61: jj_3_62(); break;
              case 62: jj_3_63(); break;
              case 63: jj_3_64(); break;
              case 64: jj_3_65(); break;
              case 65: jj_3_66(); break;
              case 66: jj_3_67(); break;
              case 67: jj_3_68(); break;
              case 68: jj_3_69(); break;
              case 69: jj_3_70(); break;
              case 70: jj_3_71(); break;
              case 71: jj_3_72(); break;
              case 72: jj_3_73(); break;
              case 73: jj_3_74(); break;
              case 74: jj_3_75(); break;
              case 75: jj_3_76(); break;
              case 76: jj_3_77(); break;
              case 77: jj_3_78(); break;
              case 78: jj_3_79(); break;
              case 79: jj_3_80(); break;
              case 80: jj_3_81(); break;
              case 81: jj_3_82(); break;
              case 82: jj_3_83(); break;
              case 83: jj_3_84(); break;
              case 84: jj_3_85(); break;
              case 85: jj_3_86(); break;
              case 86: jj_3_87(); break;
              case 87: jj_3_88(); break;
              case 88: jj_3_89(); break;
              case 89: jj_3_90(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
