/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.IntervalProviderConstraint;
import org.drools.base.rule.MutableTypeConstraint;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.time.Interval;
import org.drools.core.common.InternalFactHandle;
import org.drools.mvel.evaluators.MvelEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public class EvaluatorConstraint
extends MutableTypeConstraint<ContextEntry>
implements IntervalProviderConstraint {
    protected Declaration[] declarations;
    protected Evaluator evaluator;
    protected ReadAccessor rightReadAccessor;
    protected FieldValue field;

    public EvaluatorConstraint() {
    }

    public EvaluatorConstraint(FieldValue field, Evaluator evaluator, ReadAccessor extractor) {
        this.field = field;
        this.declarations = new Declaration[0];
        this.evaluator = evaluator;
        this.rightReadAccessor = extractor;
    }

    public EvaluatorConstraint(Declaration[] declarations, Evaluator evaluator, ReadAccessor extractor) {
        this.declarations = declarations;
        this.evaluator = evaluator;
        this.rightReadAccessor = extractor;
    }

    protected boolean isLiteral() {
        return this.declarations.length == 0;
    }

    public boolean isAllowed(FactHandle handle, ValueResolver valueResolver) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(valueResolver, this.rightReadAccessor, handle, this.field);
        }
        return this.evaluator.evaluate(valueResolver, this.rightReadAccessor, handle, this.declarations[0].getExtractor(), handle);
    }

    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(((LiteralContextEntry)context).valueResolver, ((LiteralContextEntry)context).getFieldExtractor(), handle, this.field);
        }
        return ((MvelEvaluator)this.evaluator).evaluateCachedLeft(((VariableRestriction.VariableContextEntry)context).valueResolver, (VariableRestriction.VariableContextEntry)context, handle);
    }

    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(((LiteralContextEntry)context).valueResolver, ((LiteralContextEntry)context).getFieldExtractor(), ((LiteralContextEntry)context).getFactHandle(), this.field);
        }
        return ((MvelEvaluator)this.evaluator).evaluateCachedRight(((VariableRestriction.VariableContextEntry)context).valueResolver, (VariableRestriction.VariableContextEntry)context, tuple.get(this.declarations[0]));
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.declarations[0].equals((Object)oldDecl)) {
            this.declarations[0] = newDecl;
        }
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public boolean isTemporal() {
        return this.evaluator != null && this.evaluator.isTemporal();
    }

    public boolean isSelf() {
        return this.rightReadAccessor.isSelfReference();
    }

    public Interval getInterval() {
        return this.evaluator == null ? null : this.evaluator.getInterval();
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public FieldValue getField() {
        return this.field;
    }

    protected ReadAccessor getRightReadAccessor() {
        return this.rightReadAccessor;
    }

    public EvaluatorConstraint clone() {
        if (this.isLiteral()) {
            return new EvaluatorConstraint(this.field, this.evaluator, this.rightReadAccessor);
        }
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        System.arraycopy(this.declarations, 0, clonedDeclarations, 0, this.declarations.length);
        return new EvaluatorConstraint(clonedDeclarations, this.evaluator, this.rightReadAccessor);
    }

    public ContextEntry createContext() {
        return this.isLiteral() ? new LiteralContextEntry(this.rightReadAccessor) : VariableRestriction.createContextEntry(this.rightReadAccessor, this.declarations[0], this.evaluator);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.field);
        out.writeObject(this.declarations);
        out.writeObject(this.rightReadAccessor);
        out.writeObject(this.evaluator);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.field = (FieldValue)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.rightReadAccessor = (ReadAccessor)in.readObject();
        this.evaluator = (Evaluator)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvaluatorConstraint)) {
            return false;
        }
        EvaluatorConstraint that = (EvaluatorConstraint)((Object)o);
        if (!Arrays.equals(this.declarations, that.declarations)) {
            return false;
        }
        if (this.evaluator != null ? !this.evaluator.equals(that.evaluator) : that.evaluator != null) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        return !(this.rightReadAccessor != null ? !this.rightReadAccessor.equals(that.rightReadAccessor) : that.rightReadAccessor != null);
    }

    public int hashCode() {
        int result = this.declarations != null ? Arrays.hashCode(this.declarations) : 0;
        result = 31 * result + (this.evaluator != null ? this.evaluator.hashCode() : 0);
        result = 31 * result + (this.rightReadAccessor != null ? this.rightReadAccessor.hashCode() : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    protected static class LiteralContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public ReadAccessor extractor;
        public FactHandle factHandle;
        public ContextEntry next;
        public ValueResolver valueResolver;

        public LiteralContextEntry() {
        }

        public LiteralContextEntry(ReadAccessor extractor) {
            this.extractor = extractor;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (ReadAccessor)in.readObject();
            this.factHandle = (InternalFactHandle)in.readObject();
            this.next = (ContextEntry)in.readObject();
            this.valueResolver = (ValueResolver)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.factHandle);
            out.writeObject(this.next);
            out.writeObject(this.valueResolver);
        }

        public ReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public FactHandle getFactHandle() {
            return this.factHandle;
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromFactHandle(ValueResolver valueResolver, FactHandle handle) {
            this.factHandle = handle;
            this.valueResolver = valueResolver;
        }

        public void updateFromTuple(ValueResolver valueResolver, BaseTuple tuple) {
            this.valueResolver = valueResolver;
        }

        public void resetTuple() {
        }

        public void resetFactHandle() {
            this.factHandle = null;
        }
    }
}

