/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.builder;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.DialectRuntimeData;
import org.drools.base.rule.LineMappings;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.ImportError;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.CollectBuilder;
import org.drools.compiler.rule.builder.ConditionalBranchBuilder;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.EnabledBuilder;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.EntryPointBuilder;
import org.drools.compiler.rule.builder.EvaluatorWrapper;
import org.drools.compiler.rule.builder.ForallBuilder;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.GroupByBuilder;
import org.drools.compiler.rule.builder.GroupElementBuilder;
import org.drools.compiler.rule.builder.NamedConsequenceBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.PatternBuilderForAbductiveQuery;
import org.drools.compiler.rule.builder.PatternBuilderForQuery;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleClassBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.SalienceBuilder;
import org.drools.compiler.rule.builder.WindowReferenceBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.CollectDescr;
import org.drools.drl.ast.descr.ConditionalBranchDescr;
import org.drools.drl.ast.descr.EntryPointDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.GroupByDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.NamedConsequenceDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.ProcessDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.WindowReferenceDescr;
import org.drools.drl.parser.DroolsError;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.builder.MVELAccumulateBuilder;
import org.drools.mvel.builder.MVELAnalysisResult;
import org.drools.mvel.builder.MVELConsequenceBuilder;
import org.drools.mvel.builder.MVELDialectConfiguration;
import org.drools.mvel.builder.MVELEnabledBuilder;
import org.drools.mvel.builder.MVELEvalBuilder;
import org.drools.mvel.builder.MVELExprAnalyzer;
import org.drools.mvel.builder.MVELFromBuilder;
import org.drools.mvel.builder.MVELGroupByBuilder;
import org.drools.mvel.builder.MVELSalienceBuilder;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.java.JavaFunctionBuilder;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.memorycompiler.resources.MemoryResourceReader;
import org.kie.memorycompiler.resources.ResourceReader;
import org.mvel2.MVEL;
import org.mvel2.optimizers.OptimizerFactory;

public class MVELDialect
implements Dialect,
Externalizable {
    private String id = "mvel";
    protected static final PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    protected static final PatternBuilderForQuery QUERY_BUILDER = new PatternBuilderForQuery();
    protected static final PatternBuilderForQuery ABDUCTIVE_QUERY_BUILDER = new PatternBuilderForAbductiveQuery();
    protected static final MVELAccumulateBuilder ACCUMULATE_BUILDER = new MVELAccumulateBuilder();
    protected static final MVELGroupByBuilder GROUP_BY_BUILDER = new MVELGroupByBuilder();
    protected static final SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    protected static final EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    protected static final MVELEvalBuilder EVAL_BUILDER = new MVELEvalBuilder();
    protected static final MVELConsequenceBuilder CONSEQUENCE_BUILDER = new MVELConsequenceBuilder();
    protected static final MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    protected static final JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    protected static final CollectBuilder COLLECT_BUILDER = new CollectBuilder();
    protected static final ForallBuilder FORALL_BUILDER = new ForallBuilder();
    protected static final EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    protected static final WindowReferenceBuilder WINDOW_REFERENCE_BUILDER = new WindowReferenceBuilder();
    protected static final GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    protected static final NamedConsequenceBuilder NAMED_CONSEQUENCE_BUILDER = new NamedConsequenceBuilder();
    protected static final ConditionalBranchBuilder CONDITIONAL_BRANCH_BUILDER = new ConditionalBranchBuilder();
    private static Map<Class<?>, EngineElementBuilder> builders;
    protected List<KnowledgeBuilderResult> results;
    protected MemoryResourceReader src;
    protected InternalKnowledgePackage pkg;
    private MVELDialectConfiguration configuration;
    private PackageRegistry packageRegistry;
    private boolean strictMode;
    private int languageLevel;
    private MVELDialectRuntimeData data;

    public MVELDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        this(rootClassLoader, pkgConf, pkgRegistry, pkg, "mvel");
    }

    public MVELDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg, String id) {
        this.id = id;
        this.pkg = pkg;
        this.packageRegistry = pkgRegistry;
        this.configuration = (MVELDialectConfiguration)pkgConf.getDialectConfiguration("mvel");
        this.setLanguageLevel(this.configuration.getLangLevel());
        this.strictMode = this.configuration.isStrict();
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        this.results = new ArrayList<KnowledgeBuilderResult>();
        if (pkg.getDialectRuntimeRegistry().getDialectData(this.getId()) == null) {
            this.data = new MVELDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(this.getId(), (DialectRuntimeData)this.data);
            this.data.onAdd(this.pkg.getDialectRuntimeRegistry(), rootClassLoader);
        } else {
            this.data = (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
        }
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.src = new MemoryResourceReader();
        if (this.pkg != null) {
            this.addImport(new ImportDescr(this.pkg.getName() + ".*"));
        }
        this.addImport(new ImportDescr("java.lang.*"));
    }

    public MVELDialect() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.results = (List)in.readObject();
        this.src = (MemoryResourceReader)in.readObject();
        this.pkg = (InternalKnowledgePackage)in.readObject();
        this.packageRegistry = (PackageRegistry)in.readObject();
        this.configuration = (MVELDialectConfiguration)in.readObject();
        this.strictMode = in.readBoolean();
        this.data = (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.results);
        out.writeObject(this.src);
        out.writeObject(this.pkg);
        out.writeObject(this.packageRegistry);
        out.writeObject(this.configuration);
        out.writeBoolean(this.strictMode);
        out.writeObject(this.data);
    }

    public void setLanguageLevel(int languageLevel) {
        this.languageLevel = languageLevel;
    }

    public static void initBuilder() {
        if (builders != null) {
            return;
        }
        MVELDialect.reinitBuilder();
    }

    public static void reinitBuilder() {
        builders = new HashMap();
        builders.put(AndDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(OrDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(NotDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(ExistsDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(PatternDescr.class, (EngineElementBuilder)PATTERN_BUILDER);
        builders.put(FromDescr.class, (EngineElementBuilder)FROM_BUILDER);
        builders.put(QueryDescr.class, (EngineElementBuilder)QUERY_BUILDER);
        builders.put(AccumulateDescr.class, (EngineElementBuilder)ACCUMULATE_BUILDER);
        builders.put(GroupByDescr.class, (EngineElementBuilder)GROUP_BY_BUILDER);
        builders.put(EvalDescr.class, (EngineElementBuilder)EVAL_BUILDER);
        builders.put(CollectDescr.class, (EngineElementBuilder)COLLECT_BUILDER);
        builders.put(ForallDescr.class, (EngineElementBuilder)FORALL_BUILDER);
        builders.put(FunctionDescr.class, (EngineElementBuilder)FUNCTION_BUILDER);
        builders.put(EntryPointDescr.class, (EngineElementBuilder)ENTRY_POINT_BUILDER);
        builders.put(WindowReferenceDescr.class, (EngineElementBuilder)WINDOW_REFERENCE_BUILDER);
        builders.put(NamedConsequenceDescr.class, (EngineElementBuilder)NAMED_CONSEQUENCE_BUILDER);
        builders.put(ConditionalBranchDescr.class, (EngineElementBuilder)CONDITIONAL_BRANCH_BUILDER);
    }

    public void init(RuleDescr ruleDescr) {
        String pkgName = this.pkg == null ? "" : this.pkg.getName();
        String ruleClassName = DialectUtil.getUniqueLegalName((String)pkgName, (String)ruleDescr.getName(), (int)ruleDescr.getConsequence().hashCode(), (String)"mvel", (String)"Rule", (ResourceReader)this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
    }

    public void init(ProcessDescr processDescr) {
        String processDescrClassName = DialectUtil.getUniqueLegalName((String)this.pkg.getName(), (String)processDescr.getName(), (int)processDescr.getProcessId().hashCode(), (String)"mvel", (String)"Process", (ResourceReader)this.src);
        processDescr.setClassName(StringUtils.ucFirst((String)processDescrClassName));
    }

    public void addRule(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
    }

    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    public void addImport(ImportDescr importDescr) {
        String importEntry = importDescr.getTarget();
        if (importEntry.endsWith(".*")) {
            importEntry = importEntry.substring(0, importEntry.length() - 2);
            this.data.addPackageImport(importEntry);
        } else {
            try {
                Class cls = this.packageRegistry.getTypeResolver().resolveType(importEntry);
                this.data.addImport(cls.getSimpleName(), cls);
            }
            catch (ClassNotFoundException e) {
                this.results.add((KnowledgeBuilderResult)new ImportError(importDescr, 1));
            }
        }
    }

    public void addStaticImport(ImportDescr importDescr) {
        String staticImportEntry = importDescr.getTarget();
        if (staticImportEntry.endsWith("*")) {
            this.addStaticPackageImport(importDescr);
            return;
        }
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(index + 1);
        Class<?> cls = this.loadImportedClass(className);
        if (cls != null) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                this.data.addImport(methodName, method);
                return;
            }
        }
        this.results.add((KnowledgeBuilderResult)new ImportError(importDescr, -1));
    }

    public void addStaticPackageImport(ImportDescr importDescr) {
        int index;
        String staticImportEntry = importDescr.getTarget();
        String className = staticImportEntry.substring(0, index = staticImportEntry.lastIndexOf(46));
        Class<?> cls = this.loadImportedClass(className);
        if (cls == null) {
            this.results.add((KnowledgeBuilderResult)new ImportError(importDescr, -1));
            return;
        }
        for (Method method : cls.getDeclaredMethods()) {
            if ((method.getModifiers() | 8) <= 0) continue;
            this.data.addImport(method.getName(), method);
        }
    }

    private Class<?> loadImportedClass(String className) {
        try {
            return this.packageRegistry.getPackageClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return this.pkg.getTypeResolver().resolveType(className);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public boolean isJava() {
        return false;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void compileAll() {
    }

    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
        return MVELDialect.analyzeExpression(context, descr, content, availableIdentifiers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes) {
        MVELAnalysisResult result = null;
        BaseDescr temp = context.getParentDescr();
        context.setParentDescr(descr);
        try {
            result = MVELExprAnalyzer.analyzeExpression(context, (String)content, availableIdentifiers, localTypes, "drools", KnowledgeHelper.class);
        }
        catch (Exception e) {
            AsmUtil.copyErrorLocation(e, descr);
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the used declarations.\n" + e.getMessage()));
        }
        finally {
            context.setParentDescr(temp);
        }
        return result;
    }

    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
        return this.analyzeBlock(context, text, availableIdentifiers, null, "drools", KnowledgeHelper.class);
    }

    public AnalysisResult analyzeBlock(PackageBuildContext context, String text, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes, String contextIndeifier, Class kcontextClass) {
        return MVELExprAnalyzer.analyzeExpression(context, text, availableIdentifiers, localTypes, contextIndeifier, kcontextClass);
    }

    public static MVELCompilationUnit getMVELCompilationUnit(String expression, AnalysisResult analysis, Declaration[] previousDeclarations, Declaration[] localDeclarations, Map<String, Class<?>> otherInputVariables, PackageBuildContext context, String contextIndeifier, Class kcontextClass, boolean readLocalsFromTuple, MVELCompilationUnit.Scope scope) {
        LinkedHashMap<Object, Type> resolvedInputs = new LinkedHashMap<Object, Type>();
        ArrayList<Object> ids = new ArrayList<Object>();
        if (analysis.getBoundIdentifiers().getThisClass() != null || localDeclarations != null && localDeclarations.length > 0) {
            Class<Object> cls = analysis.getBoundIdentifiers().getThisClass();
            ids.add("this");
            resolvedInputs.put("this", (Type)((Object)(cls != null ? cls : Object.class)));
        }
        ids.add(contextIndeifier);
        resolvedInputs.put(contextIndeifier, kcontextClass);
        ids.add("kcontext");
        resolvedInputs.put("kcontext", kcontextClass);
        if (scope.hasRule()) {
            ids.add("rule");
            resolvedInputs.put("rule", (Type)((Object)Rule.class));
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (Object identifier : analysis.getIdentifiers()) {
            Object type = ((String)identifier).equals("_workingMemory_") ? InternalWorkingMemory.class : analysis.getBoundIdentifiers().resolveVarType((String)identifier);
            if (type == null) continue;
            strList.add((String)identifier);
            ids.add(identifier);
            resolvedInputs.put(identifier, (Type)type);
        }
        String[] globalIdentifiers = strList.toArray(new String[strList.size()]);
        strList.clear();
        for (String op : analysis.getBoundIdentifiers().getOperators().keySet()) {
            strList.add(op);
            ids.add(op);
            resolvedInputs.put(op, (Type)((Object)EvaluatorWrapper.class));
        }
        EvaluatorWrapper[] operators = new EvaluatorWrapper[strList.size()];
        for (int i = 0; i < operators.length; ++i) {
            operators[i] = (EvaluatorWrapper)analysis.getBoundIdentifiers().getOperators().get(strList.get(i));
        }
        if (previousDeclarations != null) {
            for (Declaration decl : previousDeclarations) {
                if (!analysis.getBoundIdentifiers().getDeclrClasses().containsKey(decl.getIdentifier())) continue;
                ids.add(decl.getIdentifier());
                resolvedInputs.put(decl.getIdentifier(), decl.getDeclarationClass());
            }
        }
        if (localDeclarations != null) {
            for (Declaration decl : localDeclarations) {
                if (!analysis.getBoundIdentifiers().getDeclrClasses().containsKey(decl.getIdentifier())) continue;
                ids.add(decl.getIdentifier());
                resolvedInputs.put(decl.getIdentifier(), decl.getDeclarationClass());
            }
        }
        strList = new ArrayList();
        if (otherInputVariables != null) {
            MVELAnalysisResult mvelAnalysis = (MVELAnalysisResult)analysis;
            for (Map.Entry<String, Class<?>> stringClassEntry : otherInputVariables.entrySet()) {
                if (!analysis.getNotBoundedIdentifiers().contains(stringClassEntry.getKey()) && !mvelAnalysis.getMvelVariables().containsKey(stringClassEntry.getKey()) || "rule".equals(stringClassEntry.getKey())) continue;
                ids.add(stringClassEntry.getKey());
                strList.add(stringClassEntry.getKey());
                resolvedInputs.put(stringClassEntry.getKey(), stringClassEntry.getValue());
            }
        }
        String[] otherIdentifiers = strList.toArray(new String[strList.size()]);
        String[] inputIdentifiers = new String[resolvedInputs.size()];
        String[] inputTypes = new String[resolvedInputs.size()];
        int i = 0;
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id;
            inputIdentifiers[i] = id = (String)iterator.next();
            Type inputType = (Type)resolvedInputs.get(id);
            inputTypes[i++] = inputType instanceof Class ? ((Class)inputType).getName() : inputType.getTypeName();
        }
        Object name = context != null && context.getPkg() != null && context.getPkg().getName() != null ? (context instanceof RuleBuildContext ? context.getPkg().getName() + "." + ((RuleBuildContext)context).getRuleDescr().getClassName() : context.getPkg().getName() + ".Unknown") : "Unknown";
        return new MVELCompilationUnit((String)name, expression, globalIdentifiers, operators, previousDeclarations, localDeclarations, otherIdentifiers, inputIdentifiers, inputTypes, analysis.isTypesafe(), readLocalsFromTuple);
    }

    public EngineElementBuilder getBuilder(Class clazz) {
        return builders.get(clazz);
    }

    public Map<Class<?>, EngineElementBuilder> getBuilders() {
        return builders;
    }

    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    public PatternBuilderForQuery getPatternBuilderForQuery(QueryImpl query) {
        return query.isAbductive() ? ABDUCTIVE_QUERY_BUILDER : QUERY_BUILDER;
    }

    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    public GroupByBuilder getGroupByBuilder() {
        return GROUP_BY_BUILDER;
    }

    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    public List<KnowledgeBuilderResult> getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results.clear();
    }

    public RuleClassBuilder getRuleClassBuilder() {
        throw new UnsupportedOperationException("MVELDialect.getRuleClassBuilder is not supported");
    }

    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    public String getId() {
        return this.id;
    }

    public PackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    static {
        MVELDialect.initBuilder();
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
    }
}

