/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PlainIndexEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.constraint.ConditionEvaluator;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.Drools;
import org.drools.core.util.MemoryUtil;
import org.drools.core.util.StringUtils;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.IndexUtil;
import org.drools.mvel.ASMConditionEvaluatorJitter;
import org.drools.mvel.ConditionAnalyzer;
import org.drools.mvel.MVELConditionEvaluator;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.extractors.MVELObjectClassFieldReader;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.mvel2.ParserConfiguration;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELConstraint
extends MutableTypeConstraint
implements IndexableConstraint,
AcceptsReadAccessor {
    protected static final boolean TEST_JITTING = false;
    private static final Logger logger = LoggerFactory.getLogger(MVELConstraint.class);
    protected final transient AtomicInteger invocationCounter = new AtomicInteger(1);
    protected volatile transient boolean jitted = false;
    private Set<String> packageNames;
    protected String expression;
    private IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.UNKNOWN;
    private Declaration[] declarations;
    private EvaluatorWrapper[] operators;
    private Declaration indexingDeclaration;
    private InternalReadAccessor extractor;
    private boolean isUnification;
    protected boolean isDynamic;
    private FieldValue fieldValue;
    protected MVELCompilationUnit compilationUnit;
    private EvaluationContext evaluationContext = new EvaluationContext();
    protected volatile transient ConditionEvaluator conditionEvaluator;
    private volatile transient ConditionAnalyzer.Condition analyzedCondition;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private static final EvaluatorWrapper[] EMPTY_OPERATORS = new EvaluatorWrapper[0];

    public MVELConstraint() {
    }

    public MVELConstraint(final String packageName, String expression, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, FieldValue fieldValue, InternalReadAccessor extractor, EvaluatorWrapper[] operators) {
        this.packageNames = new HashSet<String>(){
            {
                this.add(packageName);
            }
        };
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = constraintType;
        this.declarations = EMPTY_DECLARATIONS;
        this.operators = operators == null ? EMPTY_OPERATORS : operators;
        this.fieldValue = fieldValue;
        this.extractor = extractor;
    }

    public MVELConstraint(final String packageName, String expression, Declaration[] declarations, EvaluatorWrapper[] operators, MVELCompilationUnit compilationUnit, boolean isDynamic) {
        this.packageNames = new HashSet<String>(){
            {
                this.add(packageName);
            }
        };
        this.expression = expression;
        this.declarations = declarations == null ? EMPTY_DECLARATIONS : declarations;
        this.operators = operators == null ? EMPTY_OPERATORS : operators;
        this.compilationUnit = compilationUnit;
        this.isDynamic = isDynamic;
    }

    public MVELConstraint(Collection<String> packageNames, String expression, Declaration[] declarations, EvaluatorWrapper[] operators, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, Declaration indexingDeclaration, InternalReadAccessor extractor, boolean isUnification) {
        this.packageNames = new HashSet<String>(packageNames);
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = indexingDeclaration != null ? constraintType : IndexUtil.ConstraintType.UNKNOWN;
        this.declarations = declarations == null ? EMPTY_DECLARATIONS : declarations;
        this.operators = operators == null ? EMPTY_OPERATORS : operators;
        this.indexingDeclaration = indexingDeclaration;
        this.extractor = extractor;
        this.isUnification = isUnification;
    }

    protected String getAccessedClass() {
        return this.extractor instanceof ClassFieldReader ? ((ClassFieldReader)this.extractor).getClassName() : (this.extractor instanceof MVELObjectClassFieldReader ? ((MVELObjectClassFieldReader)this.extractor).getClassName() : null);
    }

    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.extractor = readAccessor;
    }

    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    public void addPackageNames(Collection<String> otherPkgs) {
        this.packageNames.addAll(otherPkgs);
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isUnification() {
        return this.isUnification;
    }

    public void unsetUnification() {
        this.isUnification = false;
    }

    public boolean isIndexable(short nodeType) {
        return this.getConstraintType().isIndexableForNode(nodeType);
    }

    public IndexUtil.ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public FieldValue getField() {
        return this.fieldValue;
    }

    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        if (this.isUnification) {
            throw new UnsupportedOperationException("Should not be called");
        }
        return this.evaluate(handle, workingMemory, null);
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isUnification) {
            if (((UnificationContextEntry)context).getVariable() != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(handle, mvelContextEntry.workingMemory, mvelContextEntry.tuple);
    }

    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        if (this.isUnification) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[((UnificationContextEntry)context).getReader().getIndex()];
            if (v != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(mvelContextEntry.rightHandle, mvelContextEntry.workingMemory, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        if (!this.jitted) {
            int jittingThreshold = workingMemory.getKnowledgeBase().getConfiguration().getJittingThreshold();
            if (this.conditionEvaluator == null) {
                if (jittingThreshold == 0 && !this.isDynamic) {
                    MVELConstraint mVELConstraint = this;
                    synchronized (mVELConstraint) {
                        if (this.conditionEvaluator == null) {
                            this.conditionEvaluator = this.forceJitEvaluator(handle, workingMemory, tuple);
                        }
                    }
                } else {
                    this.conditionEvaluator = this.createMvelConditionEvaluator(workingMemory);
                }
            }
            if (jittingThreshold != 0 && !this.isDynamic && this.invocationCounter.getAndIncrement() == jittingThreshold) {
                this.jitEvaluator(handle, workingMemory, tuple);
            }
        }
        try {
            return this.conditionEvaluator.evaluate(handle, workingMemory, tuple);
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating constraint '" + this.expression + "' in " + this.evaluationContext, e);
        }
    }

    protected ConditionEvaluator createMvelConditionEvaluator(InternalWorkingMemory workingMemory) {
        if (this.compilationUnit != null) {
            MVELDialectRuntimeData data = this.getMVELDialectRuntimeData(workingMemory);
            ExecutableStatement statement = (ExecutableStatement)this.compilationUnit.getCompiledExpression(data, (Object)this.evaluationContext);
            ParserConfiguration configuration = statement instanceof CompiledExpression ? ((CompiledExpression)statement).getParserConfiguration() : data.getParserConfiguration();
            return new MVELConditionEvaluator(this.compilationUnit, configuration, statement, this.declarations, this.operators, this.getAccessedClass());
        }
        return new MVELConditionEvaluator(this.getParserConfiguration(workingMemory), this.expression, this.declarations, this.operators, this.getAccessedClass());
    }

    protected ConditionEvaluator forceJitEvaluator(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        ConditionEvaluator mvelEvaluator = this.createMvelConditionEvaluator(workingMemory);
        try {
            mvelEvaluator.evaluate(handle, workingMemory, tuple);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.executeJitting(handle, workingMemory, tuple, mvelEvaluator);
    }

    protected void jitEvaluator(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        this.jitted = true;
        ExecutorHolder.executor.execute(new ConditionJitter(this, handle, workingMemory, tuple));
    }

    private ConditionEvaluator executeJitting(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple, ConditionEvaluator mvelEvaluator) {
        InternalKnowledgeBase kBase = workingMemory.getKnowledgeBase();
        if (!Drools.isJmxAvailable() && MemoryUtil.permGenStats.isUsageThresholdExceeded(kBase.getConfiguration().getPermGenThreshold())) {
            return mvelEvaluator;
        }
        try {
            if (this.analyzedCondition == null) {
                this.analyzedCondition = ((MVELConditionEvaluator)mvelEvaluator).getAnalyzedCondition(handle, workingMemory, tuple);
            }
            ClassLoader jitClassLoader = kBase.getRootClassLoader() instanceof ProjectClassLoader ? ((ProjectClassLoader)kBase.getRootClassLoader()).getTypesClassLoader() : kBase.getRootClassLoader();
            return ASMConditionEvaluatorJitter.jitEvaluator(this.expression, this.analyzedCondition, this.declarations, this.operators, jitClassLoader, tuple);
        }
        catch (Throwable t) {
            logger.warn("Exception jitting: " + this.expression + " This is NOT an error and NOT prevent the correct execution since the constraint will be evaluated in intrepreted mode");
            return mvelEvaluator;
        }
    }

    public ContextEntry createContextEntry() {
        if (this.declarations.length == 0) {
            return null;
        }
        Object contextEntry = new MvelContextEntry(this.declarations);
        if (this.isUnification) {
            contextEntry = new UnificationContextEntry((ContextEntry)contextEntry, this.declarations[0]);
        }
        return contextEntry;
    }

    public AbstractHashTable.FieldIndex getFieldIndex() {
        this.indexingDeclaration.getPattern().setOffset(this.declarations[0].getOffset());
        return new AbstractHashTable.FieldIndex(this.extractor, this.indexingDeclaration, PlainIndexEvaluator.INSTANCE);
    }

    public InternalReadAccessor getFieldExtractor() {
        return this.extractor;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public EvaluatorWrapper[] getOperators() {
        return this.operators;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals((Object)oldDecl)) continue;
            if (this.compilationUnit != null) {
                this.compilationUnit.replaceDeclaration(this.declarations[i], newDecl);
            }
            this.declarations[i] = newDecl;
            break;
        }
        if (this.indexingDeclaration != null && this.indexingDeclaration.equals((Object)oldDecl)) {
            this.indexingDeclaration = newDecl;
        }
    }

    public BitMask getListenedPropertyMask(Class modifiedClass, List<String> settableProperties) {
        return this.analyzedCondition != null ? this.calculateMask(modifiedClass, settableProperties) : this.calculateMaskFromExpression(settableProperties);
    }

    private BitMask calculateMaskFromExpression(List<String> settableProperties) {
        String[] simpleExpressions;
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
        for (String simpleExpression : simpleExpressions = this.expression.split("\\Q&&\\E|\\Q||\\E")) {
            List<String> properties = this.getPropertyNamesFromSimpleExpression(simpleExpression);
            if (properties.isEmpty()) {
                return PropertySpecificUtil.allSetBitMask();
            }
            boolean firstProp = true;
            for (String propertyName : properties) {
                if (propertyName == null || propertyName.equals("this") || propertyName.length() == 0) {
                    return PropertySpecificUtil.allSetButTraitBitMask();
                }
                int pos = settableProperties.indexOf(propertyName);
                if (pos < 0) {
                    if (Character.isUpperCase(propertyName.charAt(0))) {
                        propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                        pos = settableProperties.indexOf(propertyName);
                    } else if ((propertyName = this.findBoundVariable(propertyName)) != null) {
                        pos = settableProperties.indexOf(propertyName);
                    }
                }
                if (pos >= 0) {
                    mask = mask.set(pos + 1);
                } else if (firstProp) {
                    return PropertySpecificUtil.allSetBitMask();
                }
                firstProp = false;
            }
        }
        return mask;
    }

    private String findBoundVariable(String variable) {
        for (Declaration declaration : this.declarations) {
            InternalReadAccessor accessor;
            if (!declaration.getIdentifier().equals(variable) || !((accessor = declaration.getExtractor()) instanceof ClassFieldReader)) continue;
            return ((ClassFieldReader)accessor).getFieldName();
        }
        return null;
    }

    private List<String> getPropertyNamesFromSimpleExpression(String expression) {
        ArrayList<String> names = new ArrayList<String>();
        int cursor = 0;
        while (cursor < expression.length()) {
            cursor = this.nextPropertyName(expression, names, cursor);
        }
        return names;
    }

    private int nextPropertyName(String expression, List<String> names, int cursor) {
        StringBuilder propertyNameBuilder = new StringBuilder();
        cursor = StringUtils.extractFirstIdentifier((String)expression, (StringBuilder)propertyNameBuilder, (int)cursor);
        if (propertyNameBuilder.length() == 0) {
            return cursor;
        }
        boolean isAccessor = false;
        String propertyName = propertyNameBuilder.toString();
        if (propertyName.equals("this")) {
            if ((cursor = StringUtils.skipBlanks((String)expression, (int)cursor)) >= expression.length() || expression.charAt(cursor) != '.') {
                names.add("this");
                return cursor;
            }
            propertyNameBuilder = new StringBuilder();
            StringUtils.extractFirstIdentifier((String)expression, (StringBuilder)propertyNameBuilder, (int)cursor);
            propertyName = propertyNameBuilder.toString();
        } else if (propertyName.equals("null") || propertyName.equals("true") || propertyName.equals("false")) {
            propertyNameBuilder = new StringBuilder();
            StringUtils.extractFirstIdentifier((String)expression, (StringBuilder)propertyNameBuilder, (int)cursor);
            propertyName = propertyNameBuilder.toString();
        }
        if (propertyName.startsWith("is") || propertyName.startsWith("get")) {
            int argsEnd;
            int exprPos = expression.indexOf(propertyName);
            int propNameEnd = exprPos + propertyName.length();
            if (expression.length() > propNameEnd + 1 && expression.charAt(propNameEnd) == '(' && expression.substring(propNameEnd + 1, argsEnd = expression.indexOf(41, propNameEnd)).trim().isEmpty()) {
                propertyName = ClassUtils.getter2property((String)propertyName);
                isAccessor = true;
            }
        }
        if (!isAccessor) {
            boolean isMethodInvocation;
            String lookAhead = this.lookAheadIgnoringSpaces(expression, cursor);
            boolean bl = isMethodInvocation = lookAhead != null && lookAhead.equals("(");
            if (isMethodInvocation) {
                return this.nextPropertyName(expression, names, cursor);
            }
        }
        if (propertyName != null && propertyName.length() > 0) {
            names.add(propertyName);
        }
        return this.skipOperator(expression, cursor);
    }

    private String lookAheadIgnoringSpaces(String expression, int cursor) {
        while (cursor < expression.length()) {
            char c = expression.charAt(cursor);
            if (!Character.isWhitespace(c)) {
                return "" + c;
            }
            ++cursor;
        }
        return null;
    }

    private int skipOperator(String expression, int cursor) {
        int i;
        if (cursor < expression.length() && expression.charAt(cursor) == '.') {
            while (cursor < expression.length() && Character.isWhitespace(expression.charAt(++cursor))) {
            }
        }
        boolean namedOperator = false;
        for (i = cursor; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                namedOperator = true;
                continue;
            }
            if (!(Character.isWhitespace(ch) ? namedOperator : !Character.isJavaIdentifierPart(ch))) continue;
            return i + 1;
        }
        return i;
    }

    private BitMask calculateMask(Class modifiedClass, List<String> settableProperties) {
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
        if (this.analyzedCondition instanceof ConditionAnalyzer.SingleCondition) {
            mask = this.setPropertyOnReactiveMask(modifiedClass, settableProperties, mask, (ConditionAnalyzer.SingleCondition)this.analyzedCondition);
        } else {
            for (ConditionAnalyzer.Condition c : ((ConditionAnalyzer.CombinedCondition)this.analyzedCondition).getConditions()) {
                mask = this.setPropertyOnReactiveMask(modifiedClass, settableProperties, mask, (ConditionAnalyzer.SingleCondition)c);
            }
        }
        return mask;
    }

    private BitMask setPropertyOnReactiveMask(Class modifiedClass, List<String> settableProperties, BitMask mask, ConditionAnalyzer.SingleCondition c) {
        String propertyName = this.getFirstInvokedPropertyName(modifiedClass, c.getLeft());
        return propertyName != null ? PropertySpecificUtil.setPropertyOnMask((Class)modifiedClass, (BitMask)mask, settableProperties, (String)propertyName) : PropertySpecificUtil.allSetBitMask();
    }

    private String getFirstInvokedPropertyName(Class modifiedClass, ConditionAnalyzer.Expression expression) {
        if (!(expression instanceof ConditionAnalyzer.EvaluatedExpression)) {
            return null;
        }
        List<ConditionAnalyzer.Invocation> invocations = ((ConditionAnalyzer.EvaluatedExpression)expression).invocations;
        ConditionAnalyzer.Invocation invocation = invocations.get(0);
        if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
            Method method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
            if (method == null) {
                if (invocations.size() > 1) {
                    invocation = invocations.get(1);
                    if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
                        method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
                    } else if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
                        return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
                    }
                } else {
                    return null;
                }
            }
            return method != null && !Modifier.isStatic(method.getModifiers()) && method.getDeclaringClass().isAssignableFrom(modifiedClass) ? ClassUtils.getter2property((String)method.getName()) : null;
        }
        if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
            return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
        }
        return null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageNames);
        out.writeObject(this.expression);
        if (this.extractor instanceof ClassFieldReader) {
            out.writeObject(((ClassFieldReader)this.extractor).getAccessorKey());
        } else {
            out.writeObject(this.extractor);
        }
        out.writeObject(this.indexingDeclaration);
        out.writeObject(this.declarations);
        out.writeObject(this.constraintType);
        out.writeBoolean(this.isUnification);
        out.writeBoolean(this.isDynamic);
        out.writeObject(this.fieldValue);
        out.writeObject(this.compilationUnit);
        out.writeObject(this.evaluationContext);
        out.writeObject(this.operators);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageNames = (Set)in.readObject();
        this.expression = (String)in.readObject();
        ((DroolsObjectInputStream)in).readExtractor(this::setReadAccessor);
        this.indexingDeclaration = (Declaration)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.constraintType = (IndexUtil.ConstraintType)in.readObject();
        this.isUnification = in.readBoolean();
        this.isDynamic = in.readBoolean();
        this.fieldValue = (FieldValue)in.readObject();
        this.compilationUnit = (MVELCompilationUnit)in.readObject();
        this.evaluationContext = (EvaluationContext)in.readObject();
        this.operators = (EvaluatorWrapper[])in.readObject();
    }

    public boolean isTemporal() {
        return false;
    }

    public MVELConstraint cloneIfInUse() {
        MVELConstraint clone = (MVELConstraint)super.cloneIfInUse();
        if (clone != this) {
            clone.conditionEvaluator = null;
        }
        return clone;
    }

    public MVELConstraint clone() {
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        System.arraycopy(this.declarations, 0, clonedDeclarations, 0, this.declarations.length);
        MVELConstraint clone = new MVELConstraint();
        clone.setType(this.getType());
        clone.packageNames = this.packageNames;
        clone.expression = this.expression;
        clone.fieldValue = this.fieldValue;
        clone.constraintType = this.constraintType;
        clone.declarations = clonedDeclarations;
        clone.operators = this.operators;
        if (this.indexingDeclaration != null) {
            clone.indexingDeclaration = this.indexingDeclaration.cloneWithPattern();
        }
        clone.extractor = this.extractor;
        clone.isUnification = this.isUnification;
        clone.isDynamic = this.isDynamic;
        clone.conditionEvaluator = this.conditionEvaluator;
        clone.compilationUnit = this.compilationUnit != null ? this.compilationUnit.clone() : null;
        return clone;
    }

    public int hashCode() {
        if (this.isAlphaHashable()) {
            return 29 * this.getLeftInExpression(IndexUtil.ConstraintType.EQUAL).hashCode() + 31 * this.fieldValue.hashCode();
        }
        return this.expression.hashCode();
    }

    private String getLeftInExpression(IndexUtil.ConstraintType constraint) {
        return this.expression.substring(0, StringUtils.codeAwareIndexOf((String)this.expression, (String)constraint.getOperator())).trim();
    }

    private boolean isAlphaHashable() {
        return this.fieldValue != null && this.constraintType == IndexUtil.ConstraintType.EQUAL && this.getType() == Constraint.ConstraintType.ALPHA;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != MVELConstraint.class) {
            return false;
        }
        MVELConstraint other = (MVELConstraint)((Object)object);
        if (this.isAlphaHashable() ? !other.isAlphaHashable() || !this.getLeftInExpression(IndexUtil.ConstraintType.EQUAL).equals(other.getLeftInExpression(IndexUtil.ConstraintType.EQUAL)) || !this.fieldValue.equals(other.fieldValue) : !StringUtils.equalsIgnoreSpaces((String)this.expression, (String)other.expression)) {
            return false;
        }
        if (this.declarations.length != other.declarations.length) {
            return false;
        }
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i].getExtractor().equals(other.declarations[i].getExtractor())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object, InternalKnowledgeBase kbase) {
        String otherPkg;
        if (!this.equals(object)) {
            return false;
        }
        String thisPkg = this.packageNames.iterator().next();
        if (thisPkg.equals(otherPkg = ((MVELConstraint)((Object)object)).packageNames.iterator().next())) {
            return true;
        }
        Map<String, Object> thisImports = ((MVELDialectRuntimeData)kbase.getPackage(thisPkg).getDialectRuntimeRegistry().getDialectData("mvel")).getImports();
        Map<String, Object> otherImports = ((MVELDialectRuntimeData)kbase.getPackage(otherPkg).getDialectRuntimeRegistry().getDialectData("mvel")).getImports();
        if (this.fieldValue != null && this.constraintType.getOperator() != null) {
            return this.equalsExpressionTokensInBothImports(this.getLeftInExpression(this.constraintType), thisImports, otherImports);
        }
        return this.equalsExpressionTokensInBothImports(this.expression, thisImports, otherImports);
    }

    private boolean equalsExpressionTokensInBothImports(String expression, Map<String, Object> thisImports, Map<String, Object> otherImports) {
        for (String token : MVELConstraint.splitExpression(expression)) {
            if (ClassUtils.areNullSafeEquals((Object)thisImports.get(token), (Object)otherImports.get(token))) continue;
            return false;
        }
        return true;
    }

    private static List<String> splitExpression(String expression) {
        ArrayList<String> tokens = new ArrayList<String>();
        int lastStart = -1;
        boolean isQuoted = false;
        for (int i = 0; i < expression.length(); ++i) {
            if (lastStart == -1) {
                if (!isQuoted && Character.isJavaIdentifierStart(expression.charAt(i))) {
                    lastStart = i;
                }
            } else if (!Character.isJavaIdentifierPart(expression.charAt(i))) {
                tokens.add(expression.subSequence(lastStart, i).toString());
                lastStart = -1;
            }
            if (expression.charAt(i) != '\"' && expression.charAt(i) != '\'') continue;
            if (i == 0 || expression.charAt(i - 1) != '\\') {
                boolean bl = isQuoted = !isQuoted;
            }
            if (!isQuoted) continue;
            lastStart = -1;
        }
        if (lastStart != -1) {
            tokens.add(expression.subSequence(lastStart, expression.length()).toString());
        }
        return tokens;
    }

    public String toString() {
        return this.expression;
    }

    protected ParserConfiguration getParserConfiguration(InternalWorkingMemory workingMemory) {
        return this.getMVELDialectRuntimeData(workingMemory).getParserConfiguration();
    }

    protected MVELDialectRuntimeData getMVELDialectRuntimeData(InternalWorkingMemory workingMemory) {
        return this.getMVELDialectRuntimeData(workingMemory.getKnowledgeBase());
    }

    protected MVELDialectRuntimeData getMVELDialectRuntimeData(InternalKnowledgeBase kbase) {
        for (String packageName : this.packageNames) {
            InternalKnowledgePackage pkg = kbase.getPackage(packageName);
            if (pkg == null) continue;
            return (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
        }
        return null;
    }

    public void registerEvaluationContext(BuildContext buildContext) {
        this.evaluationContext.addContext(buildContext);
    }

    public static class EvaluationContext
    implements Externalizable {
        private Collection<String> evaluatedRules = new HashSet<String>();

        public void addContext(BuildContext buildContext) {
            this.evaluatedRules.add(buildContext.getRule().toRuleNameAndPathString());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.evaluatedRules);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.evaluatedRules = (Collection)in.readObject();
        }

        public String toString() {
            return this.evaluatedRules.toString();
        }
    }

    public static class UnificationContextEntry
    implements ContextEntry {
        private ContextEntry contextEntry;
        private Declaration declaration;
        private Variable variable;
        private ReadAccessor reader;

        public UnificationContextEntry() {
        }

        public UnificationContextEntry(ContextEntry contextEntry, Declaration declaration) {
            this.contextEntry = contextEntry;
            this.declaration = declaration;
            this.reader = this.declaration.getExtractor();
        }

        public ContextEntry getContextEntry() {
            return this.contextEntry;
        }

        public ReadAccessor getReader() {
            return this.reader;
        }

        public ContextEntry getNext() {
            return this.contextEntry.getNext();
        }

        public void resetFactHandle() {
            this.contextEntry.resetFactHandle();
        }

        public void resetTuple() {
            this.contextEntry.resetTuple();
            this.variable = null;
        }

        public void setNext(ContextEntry entry) {
            this.contextEntry.setNext(entry);
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.contextEntry.updateFromFactHandle(workingMemory, handle);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, Tuple tuple) {
            DroolsQuery query = (DroolsQuery)tuple.getObject(0);
            this.variable = query.getVariables()[this.reader.getIndex()];
            if (this.variable == null) {
                this.contextEntry.updateFromTuple(workingMemory, tuple);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntry = (ContextEntry)in.readObject();
            this.declaration = (Declaration)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntry);
            out.writeObject(this.declaration);
        }

        public Variable getVariable() {
            return this.variable;
        }
    }

    public static class MvelContextEntry
    implements ContextEntry {
        protected ContextEntry next;
        protected Tuple tuple;
        protected InternalFactHandle rightHandle;
        protected Declaration[] declarations;
        protected transient InternalWorkingMemory workingMemory;

        public MvelContextEntry() {
        }

        public MvelContextEntry(Declaration[] declarations) {
            this.declarations = declarations;
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, Tuple tuple) {
            this.tuple = tuple;
            this.workingMemory = workingMemory;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.rightHandle = handle;
        }

        public void resetTuple() {
            this.tuple = null;
        }

        public void resetFactHandle() {
            this.workingMemory = null;
            this.rightHandle = null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tuple);
            out.writeObject(this.rightHandle);
            out.writeObject(this.declarations);
            out.writeObject(this.next);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tuple = (Tuple)in.readObject();
            this.rightHandle = (InternalFactHandle)in.readObject();
            this.declarations = (Declaration[])in.readObject();
            this.next = (ContextEntry)in.readObject();
        }

        public InternalFactHandle getRight() {
            return this.rightHandle;
        }

        public Declaration[] getDeclarations() {
            return this.declarations;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }
    }

    private static class ExecutorHolder {
        private static final Executor executor = ExecutorProviderFactory.getExecutorProvider().getExecutor();

        private ExecutorHolder() {
        }
    }

    private static class ConditionJitter
    implements Runnable {
        private MVELConstraint mvelConstraint;
        private InternalFactHandle rightHandle;
        private InternalWorkingMemory workingMemory;
        private Tuple tuple;

        private ConditionJitter(MVELConstraint mvelConstraint, InternalFactHandle rightHandle, InternalWorkingMemory workingMemory, Tuple tuple) {
            this.mvelConstraint = mvelConstraint;
            this.rightHandle = rightHandle;
            this.workingMemory = workingMemory;
            this.tuple = tuple;
        }

        @Override
        public void run() {
            this.mvelConstraint.conditionEvaluator = this.mvelConstraint.executeJitting(this.rightHandle, this.workingMemory, this.tuple, this.mvelConstraint.conditionEvaluator);
            this.mvelConstraint = null;
            this.rightHandle = null;
            this.workingMemory = null;
            this.tuple = null;
        }
    }
}

