/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaContainerBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaInterfacePointsDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaModifyBlockDescr;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.ConsequenceMetaData;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.mvel.builder.MVELAnalysisResult;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.java.JavaAnalysisResult;
import org.kie.api.definition.type.FactField;
import org.mvel2.CompileException;
import org.mvel2.asm.MethodVisitor;

public final class AsmUtil {
    private static final Pattern LINE_BREAK_FINDER = Pattern.compile("\\r\\n|\\r|\\n");

    public static String fixBlockDescr(RuleBuildContext context, JavaAnalysisResult analysis, Map<String, Declaration> decls) {
        List blocks = DialectUtil.buildBlockDescrs(new ArrayList(), (JavaContainerBlockDescr)analysis.getBlockDescrs());
        return AsmUtil.fixBlockDescr(context, analysis, decls, blocks);
    }

    public static String fixBlockDescr(RuleBuildContext context, JavaAnalysisResult analysis, Map<String, Declaration> decls, List<JavaBlockDescr> blocks) {
        String originalCode = analysis.getAnalyzedExpr();
        blocks.sort(Comparator.comparingInt(JavaBlockDescr::getStart));
        StringBuilder consequence = new StringBuilder();
        int lastAdded = 0;
        block5: for (JavaBlockDescr block : blocks) {
            if (block.getEnd() == 0 || block.getEnd() > originalCode.length()) continue;
            consequence.append(originalCode, lastAdded, block.getStart() - 1);
            lastAdded = block.getEnd();
            switch (block.getType()) {
                case MODIFY: 
                case UPDATE: 
                case DELETE: {
                    AsmUtil.rewriteDescr(context, consequence, block, analysis, decls);
                    continue block5;
                }
                case ENTRY: 
                case EXIT: 
                case CHANNEL: {
                    AsmUtil.rewriteInterfacePoint(context, originalCode, consequence, (JavaInterfacePointsDescr)block);
                    continue block5;
                }
                case INSERT: {
                    AsmUtil.parseInsertDescr(context, block);
                }
            }
            consequence.append(originalCode, block.getStart() - 1, lastAdded);
        }
        consequence.append(originalCode.substring(lastAdded));
        return consequence.toString();
    }

    private static void parseInsertDescr(RuleBuildContext context, JavaBlockDescr block) {
        int argsStart;
        String expr = block.getTargetExpression();
        if (expr.startsWith("new ") && (argsStart = expr.indexOf(40)) > 0) {
            TypeDeclaration typeDeclaration;
            String className = expr.substring(4, argsStart).trim();
            Class typeClass = DialectUtil.findClassByName((RuleBuildContext)context, (String)className);
            TypeDeclaration typeDeclaration2 = typeDeclaration = typeClass == null ? null : context.getKnowledgeBuilder().getTypeDeclaration(typeClass);
            if (typeDeclaration != null) {
                ConsequenceMetaData.Statement statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.INSERT, typeClass);
                context.getRule().getConsequenceMetaData().addStatement(statement);
                String constructorParams = expr.substring(argsStart + 1, expr.indexOf(41)).trim();
                List args = StringUtils.splitArgumentsList((CharSequence)constructorParams);
                ClassDefinition classDefinition = typeDeclaration.getTypeClassDef();
                List fields = classDefinition.getFields();
                if (args.size() == fields.size()) {
                    for (int i = 0; i < args.size(); ++i) {
                        statement.addField(((FactField)fields.get(i)).getName(), (String)args.get(i));
                    }
                }
            }
        }
    }

    private static void rewriteInterfacePoint(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaInterfacePointsDescr ep) {
        consequence.append("drools.get");
        if (ep.getType() == JavaBlockDescr.BlockType.EXIT) {
            consequence.append("ExitPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.ENTRY) {
            consequence.append("EntryPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.CHANNEL) {
            consequence.append("Channel( ");
        } else {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)context.getRuleDescr(), (Object)ep, "Unable to rewrite code block: " + ep + "\n"));
            return;
        }
        consequence.append(ep.getId());
        consequence.append(" )");
        String originalBlock = originalCode.substring(ep.getStart() - 1, ep.getEnd());
        int end = originalBlock.indexOf("]");
        AsmUtil.addLineBreaks(consequence, originalBlock.substring(0, end));
    }

    private static void rewriteDescr(RuleBuildContext context, StringBuilder consequence, JavaBlockDescr d, JavaAnalysisResult analysis, Map<String, Declaration> decls) {
        if (d.getEnd() == 0) {
            return;
        }
        boolean typeSafety = context.isTypesafe();
        context.setTypesafe(false);
        HashMap localTypes = d.getInputs();
        if (d.getInScopeLocalVars() != null && !d.getInScopeLocalVars().isEmpty()) {
            localTypes = new HashMap(d.getInputs() != null ? d.getInputs() : Collections.emptyMap());
            for (JavaLocalDeclarationDescr local : d.getInScopeLocalVars()) {
                try {
                    Class type = context.getDialect("java").getPackageRegistry().getTypeResolver().resolveType(local.getRawType());
                    for (JavaLocalDeclarationDescr.IdentifierDescr id : local.getIdentifiers()) {
                        localTypes.put(id.getIdentifier(), type);
                    }
                }
                catch (ClassNotFoundException e) {
                    context.addError((DroolsError)new DescrBuildError((BaseDescr)context.getRuleDescr(), context.getParentDescr(), null, "Unable to resolve type " + local.getRawType() + ":\n" + e.getMessage()));
                }
            }
        }
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        MVELAnalysisResult mvelAnalysis = (MVELAnalysisResult)mvel.analyzeBlock((PackageBuildContext)context, d.getTargetExpression(), analysis.getBoundIdentifiers(), localTypes, "drools", KnowledgeHelper.class);
        context.setTypesafe(typeSafety);
        if (mvelAnalysis == null) {
            return;
        }
        Class<?> ret = mvelAnalysis.getReturnType();
        if (ret == null) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)context.getRuleDescr(), (Object)analysis.getAnalyzedExpr(), "Unable to determine the resulting type of the expression: " + d.getTargetExpression() + "\n"));
            return;
        }
        String retString = ClassUtils.canonicalName(ret);
        String declrString = d.getTargetExpression().charAt(0) == '(' ? d.getTargetExpression().substring(1, d.getTargetExpression().length() - 1).trim() : d.getTargetExpression();
        String obj = declrString;
        Declaration declr = decls.get(declrString);
        consequence.append("{ ");
        if (declr == null) {
            obj = "__obj__";
            consequence.append(retString);
            consequence.append(" ");
            consequence.append(obj);
            consequence.append(" = ");
            consequence.append(d.getTargetExpression());
            consequence.append("; ");
        }
        if (declr == null || declr.isInternalFact()) {
            consequence.append("org.kie.api.runtime.rule.FactHandle ");
            consequence.append(obj);
            consequence.append("__Handle2__ = drools.getFactHandle(");
            consequence.append(obj);
            consequence.append(");");
        }
        String originalBlock = analysis.getAnalyzedExpr().substring(d.getStart() - 1, d.getEnd());
        switch (d.getType()) {
            case MODIFY: {
                AsmUtil.rewriteModifyDescr(context, d, originalBlock, consequence, declr, obj);
                break;
            }
            case UPDATE: {
                AsmUtil.rewriteUpdateDescr(context, d, analysis, consequence, declr, obj);
                break;
            }
            case DELETE: {
                AsmUtil.rewriteDeleteDescr(context, d, consequence, declr, obj);
            }
        }
    }

    private static void rewriteModifyDescr(RuleBuildContext context, JavaBlockDescr d, String originalBlock, StringBuilder consequence, Declaration declr, String obj) {
        int end;
        BitMask modificationMask;
        boolean isPropertyReactive;
        List settableProperties = null;
        Class<?> typeClass = AsmUtil.findModifiedClass(context, d, declr);
        TypeDeclaration typeDeclaration = typeClass == null ? null : context.getKnowledgeBuilder().getTypeDeclaration(typeClass);
        boolean bl = isPropertyReactive = typeDeclaration != null && typeDeclaration.isPropertyReactive();
        if (isPropertyReactive) {
            settableProperties = typeDeclaration.getAccessibleProperties();
        }
        ConsequenceMetaData.Statement statement = null;
        if (typeDeclaration != null) {
            statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.MODIFY, typeClass);
            context.getRule().getConsequenceMetaData().addStatement(statement);
        }
        BitMask bitMask = modificationMask = isPropertyReactive ? PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size()) : PropertySpecificUtil.allSetButTraitBitMask();
        if (isPropertyReactive) {
            modificationMask = AsmUtil.getModificationMask(consequence, obj, modificationMask, typeDeclaration, settableProperties, statement, false);
        }
        if ((end = originalBlock.indexOf("{")) == -1) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)context.getRuleDescr(), null, "Block missing after modify" + d.getTargetExpression() + " ?\n"));
            return;
        }
        AsmUtil.addLineBreaks(consequence, originalBlock.substring(0, end));
        int start = end + 1;
        for (String exprStr : ((JavaModifyBlockDescr)d).getExpressions()) {
            end = originalBlock.indexOf(exprStr, start);
            AsmUtil.addLineBreaks(consequence, originalBlock.substring(start, end));
            consequence.append(obj).append(".");
            consequence.append(exprStr);
            consequence.append("; ");
            start = end + exprStr.length();
            if (typeDeclaration == null) continue;
            modificationMask = AsmUtil.parseModifiedProperties(statement, settableProperties, typeDeclaration, isPropertyReactive, modificationMask, exprStr);
        }
        AsmUtil.addLineBreaks(consequence, originalBlock.substring(end));
        AsmUtil.appendUpdateStatement(consequence, declr, obj, modificationMask, typeClass);
    }

    private static void rewriteUpdateDescr(RuleBuildContext context, JavaBlockDescr d, JavaAnalysisResult analysis, StringBuilder consequence, Declaration declr, String obj) {
        TypeDeclaration typeDeclaration;
        if (analysis.getAssignedVariables().contains(obj)) {
            consequence.insert(0, "drools.delete(" + obj + ");\n");
            consequence.append("drools.insert(").append(obj).append(");\n}");
            return;
        }
        AllSetBitMask modificationMask = AllSetBitMask.get();
        Class<?> typeClass = AsmUtil.findModifiedClass(context, d, declr);
        TypeDeclaration typeDeclaration2 = typeDeclaration = typeClass == null ? null : context.getKnowledgeBuilder().getTypeDeclaration(typeClass);
        if (typeDeclaration != null) {
            boolean isPropertyReactive = typeDeclaration.isPropertyReactive();
            List settableProperties = null;
            if (isPropertyReactive) {
                settableProperties = typeDeclaration.getAccessibleProperties();
                modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
            }
            ConsequenceMetaData.Statement statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.MODIFY, typeClass);
            context.getRule().getConsequenceMetaData().addStatement(statement);
            if (isPropertyReactive) {
                modificationMask = AsmUtil.getModificationMask(consequence, obj, (BitMask)modificationMask, typeDeclaration, settableProperties, statement, true);
            }
        }
        AsmUtil.appendUpdateStatement(consequence, declr, obj, (BitMask)modificationMask, typeClass);
    }

    private static BitMask getModificationMask(StringBuilder consequence, String obj, BitMask modificationMask, TypeDeclaration typeDeclaration, List<String> settableProperties, ConsequenceMetaData.Statement statement, boolean isUpdate) {
        boolean parsedExprOnce = false;
        for (String expr : StringUtils.splitStatements((CharSequence)consequence)) {
            String updateExpr = expr.replaceFirst("^\\Q" + obj + "\\E\\s*\\.", "");
            if (updateExpr.equals(expr)) continue;
            parsedExprOnce = true;
            if ((modificationMask = AsmUtil.parseModifiedProperties(statement, settableProperties, typeDeclaration, true, modificationMask, updateExpr)) != PropertySpecificUtil.allSetButTraitBitMask()) continue;
            break;
        }
        if (isUpdate && !parsedExprOnce) {
            modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
        }
        return modificationMask;
    }

    private static void appendUpdateStatement(StringBuilder consequence, Declaration declr, String obj, BitMask modificationMask, Class<?> typeClass) {
        boolean isInternalFact = declr == null || declr.isInternalFact();
        consequence.append("drools.update( ").append(obj).append(isInternalFact ? "__Handle2__, " : "__Handle__, ").append(modificationMask.getInstancingStatement()).append(", ").append(typeClass != null ? typeClass.getCanonicalName() : "java.lang.Object").append(".class").append(" ); }");
    }

    private static BitMask parseModifiedProperties(ConsequenceMetaData.Statement statement, List<String> settableProperties, TypeDeclaration typeDeclaration, boolean propertyReactive, BitMask modificationMask, String exprStr) {
        int endMethodName = exprStr.indexOf(40);
        if (endMethodName >= 0) {
            List modifiedProps;
            String methodName = exprStr.substring(0, endMethodName).trim();
            String propertyName = ClassUtils.setter2property((String)methodName);
            int endMethodArgs = StringUtils.findEndOfMethodArgsIndex((CharSequence)exprStr, (int)endMethodName);
            String methodParams = exprStr.substring(endMethodName + 1, endMethodArgs).trim();
            List args = StringUtils.splitArgumentsList((CharSequence)methodParams);
            int argsNr = args.size();
            if (propertyName == null && exprStr.length() > endMethodArgs + 1 && exprStr.substring(endMethodArgs + 1).trim().startsWith(".")) {
                propertyName = ClassUtils.getter2property((String)methodName);
            }
            if (propertyName != null) {
                modificationMask = AsmUtil.updateModificationMask(settableProperties, propertyReactive, modificationMask, propertyName);
                statement.addField(propertyName, argsNr > 0 ? (String)args.get(0) : null);
            }
            if ((modifiedProps = typeDeclaration.getTypeClassDef().getModifiedPropsByMethod(methodName, argsNr)) != null) {
                for (String modifiedProp : modifiedProps) {
                    modificationMask = AsmUtil.updateModificationMask(settableProperties, propertyReactive, modificationMask, modifiedProp);
                    statement.addField(modifiedProp, argsNr > 0 ? (String)args.get(0) : null);
                }
            }
            if (propertyReactive && propertyName == null && modifiedProps == null) {
                modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
            }
        } else {
            String propertyName = StringUtils.extractFirstIdentifier((String)exprStr, (int)0);
            modificationMask = AsmUtil.updateModificationMask(settableProperties, propertyReactive, modificationMask, propertyName);
            int equalPos = exprStr.indexOf(61);
            if (equalPos >= 0) {
                String value = exprStr.substring(equalPos + 1).trim();
                statement.addField(propertyName, value);
            }
        }
        return modificationMask;
    }

    private static BitMask updateModificationMask(List<String> settableProperties, boolean propertyReactive, BitMask modificationMask, String propertyName) {
        int index;
        if (propertyReactive && (index = settableProperties.indexOf(propertyName)) >= 0) {
            modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)modificationMask, (int)index);
        }
        return modificationMask;
    }

    private static void rewriteDeleteDescr(RuleBuildContext context, JavaBlockDescr d, StringBuilder consequence, Declaration declr, String obj) {
        Class<?> typeClass = AsmUtil.findModifiedClass(context, d, declr);
        if (typeClass != null) {
            ConsequenceMetaData.Statement statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.RETRACT, typeClass);
            context.getRule().getConsequenceMetaData().addStatement(statement);
        }
        if (declr != null && !declr.isInternalFact()) {
            consequence.append("drools.delete( ").append(obj).append("__Handle__ ); }");
        } else {
            consequence.append("drools.delete( ").append(obj).append("__Handle2__ ); }");
        }
    }

    private static void addLineBreaks(StringBuilder consequence, String chunk) {
        Matcher m = LINE_BREAK_FINDER.matcher(chunk);
        while (m.find()) {
            consequence.append("\n");
        }
    }

    private static Class<?> findModifiedClass(RuleBuildContext context, JavaBlockDescr d, Declaration declr) {
        int endCast;
        if (declr != null) {
            return declr.getDeclarationClass();
        }
        String targetId = d.getTargetExpression().trim();
        while (targetId.charAt(0) == '(' && targetId.charAt(targetId.length() - 1) == ')') {
            targetId = targetId.substring(1, targetId.length() - 1).trim();
        }
        if (targetId.charAt(0) == '(' && (endCast = targetId.indexOf(41)) > 0) {
            String castName = targetId.substring(1, endCast).trim();
            Class cast = DialectUtil.findClassByName((RuleBuildContext)context, (String)castName);
            if (cast != null) {
                return cast;
            }
            targetId = targetId.substring(endCast + 1).trim();
        }
        return targetId.contains("(") ? AsmUtil.findFunctionReturnedClass(context, targetId) : AsmUtil.findDeclarationClass(context, d, targetId);
    }

    private static Class<?> findDeclarationClass(RuleBuildContext context, JavaBlockDescr d, String statement) {
        Class inputClass;
        Class clazz = inputClass = d.getInputs() == null ? null : (Class)d.getInputs().get(statement);
        if (inputClass != null) {
            return inputClass;
        }
        List localDeclarationDescrs = d.getInScopeLocalVars();
        if (localDeclarationDescrs == null) {
            return null;
        }
        String className = null;
        for (JavaLocalDeclarationDescr localDeclr : localDeclarationDescrs) {
            for (JavaLocalDeclarationDescr.IdentifierDescr idDescr : localDeclr.getIdentifiers()) {
                if (!statement.equals(idDescr.getIdentifier())) continue;
                className = localDeclr.getType();
                break;
            }
            if (className == null) continue;
            break;
        }
        return DialectUtil.findClassByName((RuleBuildContext)context, className);
    }

    private static Class<?> findFunctionReturnedClass(RuleBuildContext context, String statement) {
        String functionName = statement.substring(0, statement.indexOf(40));
        FunctionDescr function = AsmUtil.lookupFunction(context, functionName);
        return function == null ? null : DialectUtil.findClassByName((RuleBuildContext)context, (String)function.getReturnType());
    }

    private static FunctionDescr lookupFunction(RuleBuildContext context, String functionName) {
        String packageName = context.getRule().getPackageName();
        List pkgDescrs = context.getKnowledgeBuilder().getPackageDescrs(packageName);
        for (PackageDescr pkgDescr : pkgDescrs) {
            for (FunctionDescr function : pkgDescr.getFunctions()) {
                if (!function.getName().equals(functionName)) continue;
                return function;
            }
        }
        return null;
    }

    public static void copyErrorLocation(Exception e, BaseDescr descr) {
        if (e instanceof CompileException) {
            CompileException compileException = (CompileException)e;
            compileException.setLineNumber(descr.getLine());
            compileException.setColumn(descr.getColumn());
        }
    }

    public static int returnType(String type) {
        if ("byte".equals(type)) {
            return 172;
        }
        if ("char".equals(type)) {
            return 172;
        }
        if ("double".equals(type)) {
            return 175;
        }
        if ("float".equals(type)) {
            return 174;
        }
        if ("int".equals(type)) {
            return 172;
        }
        if ("long".equals(type)) {
            return 173;
        }
        if ("short".equals(type)) {
            return 172;
        }
        if ("boolean".equals(type)) {
            return 172;
        }
        if ("void".equals(type)) {
            return 177;
        }
        return 176;
    }

    public static int varType(String type) {
        if ("byte".equals(type)) {
            return 21;
        }
        if ("char".equals(type)) {
            return 21;
        }
        if ("double".equals(type)) {
            return 24;
        }
        if ("float".equals(type)) {
            return 23;
        }
        if ("int".equals(type)) {
            return 21;
        }
        if ("long".equals(type)) {
            return 22;
        }
        if ("short".equals(type)) {
            return 21;
        }
        if ("boolean".equals(type)) {
            return 21;
        }
        return 25;
    }

    public static int storeType(String type) {
        if ("byte".equals(type)) {
            return 54;
        }
        if ("char".equals(type)) {
            return 54;
        }
        if ("double".equals(type)) {
            return 57;
        }
        if ("float".equals(type)) {
            return 56;
        }
        if ("int".equals(type)) {
            return 54;
        }
        if ("long".equals(type)) {
            return 55;
        }
        if ("short".equals(type)) {
            return 54;
        }
        if ("boolean".equals(type)) {
            return 54;
        }
        return 58;
    }

    public static int zero(String type) {
        if ("byte".equals(type)) {
            return 3;
        }
        if ("char".equals(type)) {
            return 3;
        }
        if ("double".equals(type)) {
            return 14;
        }
        if ("float".equals(type)) {
            return 11;
        }
        if ("int".equals(type)) {
            return 3;
        }
        if ("long".equals(type)) {
            return 9;
        }
        if ("short".equals(type)) {
            return 3;
        }
        if ("boolean".equals(type)) {
            return 3;
        }
        return 1;
    }

    public static void pushInt(MethodVisitor mv, int j) {
        switch (j) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                mv.visitIntInsn(16, j);
            }
        }
    }
}

