/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorCache;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;

public class MatchesEvaluatorsDefinition
implements EvaluatorDefinition {
    protected static final String matchesOp = Operator.BuiltInOperator.MATCHES.getSymbol();
    public static final Operator MATCHES = Operator.determineOperator((String)matchesOp, (boolean)false);
    public static final Operator NOT_MATCHES = Operator.determineOperator((String)matchesOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{matchesOp};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 510L;
        {
            this.addEvaluator(ValueType.STRING_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
        }
    };

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator((String)operatorId, (boolean)isNegated));
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    public static class StringNotMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMatchesEvaluator();

        public StringNotMatchesEvaluator() {
            super(ValueType.STRING_TYPE, NOT_MATCHES);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            String value1 = (String)extractor.getValue(reteEvaluator, handle1.getObject());
            String value2 = (String)fieldValue.getValue();
            if (value1 == null) {
                return false;
            }
            return !value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return !value.matches((String)context.declaration.getExtractor().getValue(reteEvaluator, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            String value = (String)context.extractor.getValue(reteEvaluator, right.getObject());
            if (value == null) {
                return false;
            }
            return !value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value1 = extractor1.getValue(reteEvaluator, handle1.getObject());
            Object value2 = extractor2.getValue(reteEvaluator, handle2.getObject());
            if (value1 == null) {
                return false;
            }
            return !((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String not matches";
        }
    }

    public static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        public StringMatchesEvaluator() {
            super(ValueType.STRING_TYPE, MATCHES);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            String value1 = (String)extractor.getValue(reteEvaluator, handle1.getObject());
            String value2 = (String)fieldValue.getValue();
            if (value1 == null) {
                return false;
            }
            return value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return value.matches((String)context.declaration.getExtractor().getValue(reteEvaluator, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            String value = (String)context.extractor.getValue(reteEvaluator, right.getObject());
            if (value == null) {
                return false;
            }
            return value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value1 = extractor1.getValue(reteEvaluator, handle1.getObject());
            Object value2 = extractor2.getValue(reteEvaluator, handle2.getObject());
            if (value1 == null) {
                return false;
            }
            return ((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String matches";
        }
    }
}

