/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.AccessorKeySupplier;
import org.drools.core.base.FieldNameSupplier;
import org.drools.core.base.ValueType;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;

public class ClassFieldReader
implements Externalizable,
InternalReadAccessor,
FieldNameSupplier,
AccessorKeySupplier {
    private static final long serialVersionUID = 510L;
    private String className;
    private String fieldName;
    private transient InternalReadAccessor reader;

    public ClassFieldReader() {
    }

    public ClassFieldReader(String className, String fieldName) {
        this.className = className;
        this.fieldName = StringUtils.lcFirstForBean((String)fieldName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.fieldName);
    }

    @Override
    public void readExternal(ObjectInput is) throws ClassNotFoundException, IOException {
        this.className = (String)is.readObject();
        this.fieldName = (String)is.readObject();
    }

    public void setReadAccessor(InternalReadAccessor reader) {
        this.reader = reader;
    }

    public int getIndex() {
        return this.reader.getIndex();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean hasReadAccessor() {
        return this.reader != null;
    }

    public Object getValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getValue(reteEvaluator, object);
    }

    public ValueType getValueType() {
        return this.reader.getValueType();
    }

    public Class<?> getExtractToClass() {
        return this.reader != null ? this.reader.getExtractToClass() : null;
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName((Class)this.reader.getExtractToClass());
    }

    public String toString() {
        return "[ClassFieldExtractor class=" + this.className + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassFieldReader)) {
            return false;
        }
        ClassFieldReader other = (ClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    public boolean getBooleanValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getBooleanValue(reteEvaluator, object);
    }

    public byte getByteValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getByteValue(reteEvaluator, object);
    }

    public char getCharValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getCharValue(reteEvaluator, object);
    }

    public double getDoubleValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getDoubleValue(reteEvaluator, object);
    }

    public float getFloatValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getFloatValue(reteEvaluator, object);
    }

    public int getIntValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getIntValue(reteEvaluator, object);
    }

    public long getLongValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getLongValue(reteEvaluator, object);
    }

    public short getShortValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getShortValue(reteEvaluator, object);
    }

    public boolean isNullValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.isNullValue(reteEvaluator, object);
    }

    public Method getNativeReadMethod() {
        return this.reader.getNativeReadMethod();
    }

    public String getNativeReadMethodName() {
        return this.reader.getNativeReadMethod().getName();
    }

    public int getHashCode(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getHashCode(reteEvaluator, object);
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isSelfReference() {
        return "this".equals(this.fieldName);
    }

    public int getHashCode(Object object) {
        return this.reader.getHashCode(object);
    }

    public Object getValue(Object object) {
        return this.reader.getValue(object);
    }

    public boolean isNullValue(Object object) {
        return this.reader.isNullValue(object);
    }

    public AccessorKey getAccessorKey() {
        return new AccessorKey(this.className, this.fieldName, AccessorKey.AccessorType.FieldAccessor);
    }
}

