/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.core.base.ValueType;
import org.drools.core.spi.WriteAccessor;

public class ClassFieldWriter
implements WriteAccessor {
    private static final long serialVersionUID = 510L;
    private String className;
    private String fieldName;
    private transient WriteAccessor writer;

    public ClassFieldWriter() {
    }

    public ClassFieldWriter(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.fieldName);
    }

    public void readExternal(ObjectInput is) throws ClassNotFoundException, IOException {
        this.className = (String)is.readObject();
        this.fieldName = (String)is.readObject();
    }

    public void setWriteAccessor(WriteAccessor writer) {
        this.writer = writer;
    }

    public int getIndex() {
        return this.writer.getIndex();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "[ClassFieldWriter class=" + this.className + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        return this.getValueType().hashCode() * 17 + this.getIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ClassFieldWriter)) {
            return false;
        }
        ClassFieldWriter other = (ClassFieldWriter)object;
        return this.writer.getValueType() == other.getValueType() && this.writer.getIndex() == other.getIndex();
    }

    public Class<?> getFieldType() {
        return this.writer.getFieldType();
    }

    public Method getNativeWriteMethod() {
        return this.writer.getNativeWriteMethod();
    }

    public ValueType getValueType() {
        return this.writer.getValueType();
    }

    public void setBooleanValue(Object bean, boolean value) {
        this.writer.setBooleanValue(bean, value);
    }

    public void setByteValue(Object bean, byte value) {
        this.writer.setByteValue(bean, value);
    }

    public void setCharValue(Object bean, char value) {
        this.writer.setCharValue(bean, value);
    }

    public void setDoubleValue(Object bean, double value) {
        this.writer.setDoubleValue(bean, value);
    }

    public void setFloatValue(Object bean, float value) {
        this.writer.setFloatValue(bean, value);
    }

    public void setIntValue(Object bean, int value) {
        this.writer.setIntValue(bean, value);
    }

    public void setLongValue(Object bean, long value) {
        this.writer.setLongValue(bean, value);
    }

    public void setShortValue(Object bean, short value) {
        this.writer.setShortValue(bean, value);
    }

    public void setValue(Object bean, Object value) {
        this.writer.setValue(bean, value);
    }
}

