/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.accessor.Evaluator;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.EvaluatorCache;
import org.drools.mvel.evaluators.VariableRestriction;

public class SoundslikeEvaluatorsDefinition
implements EvaluatorDefinition {
    protected static final String soundsLikeOp = Operator.BuiltInOperator.SOUNDSLIKE.getSymbol();
    public static final Operator SOUNDSLIKE = Operator.determineOperator((String)soundsLikeOp, (boolean)false);
    public static final Operator NOT_SOUNDSLIKE = Operator.determineOperator((String)soundsLikeOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{soundsLikeOp};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 510L;
        {
            this.addEvaluator(ValueType.STRING_TYPE, SOUNDSLIKE, StringSoundsLikeEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, NOT_SOUNDSLIKE, StringNotSoundsLikeEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, SOUNDSLIKE, StringSoundsLikeEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_SOUNDSLIKE, StringNotSoundsLikeEvaluator.INSTANCE);
        }
    };

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator((String)operatorId, (boolean)isNegated));
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    private static boolean soundslike(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        String soundex1 = CoreComponentsBuilder.get().getMVELExecutor().soundex(value1);
        String soundex2 = CoreComponentsBuilder.get().getMVELExecutor().soundex(value2);
        if (soundex1 == null) {
            return false;
        }
        return soundex1.equals(soundex2);
    }

    public static class StringNotSoundsLikeEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new StringNotSoundsLikeEvaluator();

        public StringNotSoundsLikeEvaluator() {
            super(ValueType.STRING_TYPE, NOT_SOUNDSLIKE);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, ReadAccessor extractor, InternalFactHandle handle1, FieldValue object2) {
            String value2;
            String value1 = (String)extractor.getValue(reteEvaluator, handle1.getObject());
            return !SoundslikeEvaluatorsDefinition.soundslike(value1, value2 = (String)object2.getValue());
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return !SoundslikeEvaluatorsDefinition.soundslike(value, (String)context.declaration.getExtractor().getValue(reteEvaluator, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            String value = (String)context.extractor.getValue(reteEvaluator, right.getObject());
            return !SoundslikeEvaluatorsDefinition.soundslike(value, (String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, ReadAccessor extractor1, InternalFactHandle handl1, ReadAccessor extractor2, InternalFactHandle handl2) {
            Object value2;
            Object value1 = extractor1.getValue(reteEvaluator, handl1.getObject());
            return !SoundslikeEvaluatorsDefinition.soundslike((String)value1, (String)(value2 = extractor2.getValue(reteEvaluator, handl2.getObject())));
        }

        @Override
        public String toString() {
            return "Strings not sound alike";
        }
    }

    public static class StringSoundsLikeEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new StringSoundsLikeEvaluator();

        public StringSoundsLikeEvaluator() {
            super(ValueType.STRING_TYPE, SOUNDSLIKE);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, ReadAccessor extractor, InternalFactHandle handle1, FieldValue handle2) {
            String value1 = (String)extractor.getValue(reteEvaluator, handle1.getObject());
            String value2 = (String)handle2.getValue();
            return SoundslikeEvaluatorsDefinition.soundslike(value1, value2);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return SoundslikeEvaluatorsDefinition.soundslike(value, (String)context.declaration.getExtractor().getValue(reteEvaluator, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle rightHandle) {
            String value = (String)context.extractor.getValue(reteEvaluator, rightHandle.getObject());
            return SoundslikeEvaluatorsDefinition.soundslike(value, (String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, ReadAccessor extractor1, InternalFactHandle handle1, ReadAccessor extractor2, InternalFactHandle handle2) {
            Object value1 = extractor1.getValue(reteEvaluator, handle1.getObject());
            Object value2 = extractor2.getValue(reteEvaluator, handle2.getObject());
            return SoundslikeEvaluatorsDefinition.soundslike((String)value1, (String)value2);
        }

        @Override
        public String toString() {
            return "Strings sound alike";
        }
    }
}

