/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.drools.WorkingMemory;
import org.drools.process.command.Command;
import org.drools.process.command.CommandService;
import org.drools.process.command.SignalEventCommand;
import org.drools.process.instance.event.DefaultSignalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPASignalManager
extends DefaultSignalManager {
    private CommandService commandService;

    public JPASignalManager(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public void signalEvent(String type, Object event) {
        for (long id : this.getProcessInstancesForEvent(type)) {
            this.getWorkingMemory().getProcessInstance(id);
        }
        super.signalEvent(type, event);
    }

    public void signalEvent(long processInstanceId, String type, Object event) {
        SignalEventCommand command = new SignalEventCommand();
        command.setProcessInstanceId(processInstanceId);
        command.setEventType(type);
        command.setEvent(event);
        this.commandService.execute((Command)command);
    }

    private List<Long> getProcessInstancesForEvent(String type) {
        EntityManager em = (EntityManager)this.getWorkingMemory().getEnvironment().get("drools.persistence.jpa.EntityManager");
        Query processInstancesForEvent = em.createNamedQuery("ProcessInstancesWaitingForEvent");
        processInstancesForEvent.setParameter("type", (Object)type);
        List list = processInstancesForEvent.getResultList();
        return list;
    }
}

